//
// this file is automatically generated
//
package org.marketcetera.strategy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.marketcetera.admin.User;
import org.marketcetera.admin.dao.UserDao;
import org.marketcetera.admin.user.PersistentUser;
import org.marketcetera.cluster.ClusterData;
import org.marketcetera.cluster.service.ClusterService;
import org.marketcetera.core.BatchQueueProcessor;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.core.Preserve;
import org.marketcetera.core.file.DirectoryWatcherImpl;
import org.marketcetera.core.file.DirectoryWatcherSubscriber;
import org.marketcetera.core.notifications.INotification.Severity;
import org.marketcetera.eventbus.EventBusService;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.strategy.dao.PersistentStrategyInstance;
import org.marketcetera.strategy.dao.PersistentStrategyMessage;
import org.marketcetera.strategy.dao.QPersistentStrategyMessage;
import org.marketcetera.strategy.dao.StrategyInstanceDao;
import org.marketcetera.strategy.dao.StrategyMessageDao;
import org.marketcetera.strategy.events.SimpleStrategyMessageEvent;
import org.marketcetera.strategy.events.SimpleStrategyStartFailedEvent;
import org.marketcetera.strategy.events.SimpleStrategyStartedEvent;
import org.marketcetera.strategy.events.SimpleStrategyStatusChangedEvent;
import org.marketcetera.strategy.events.SimpleStrategyStoppedEvent;
import org.marketcetera.strategy.events.SimpleStrategyUnloadedEvent;
import org.marketcetera.strategy.events.SimpleStrategyUploadFailedEvent;
import org.marketcetera.strategy.events.SimpleStrategyUploadSucceededEvent;
import org.marketcetera.strategy.events.StrategyEvent;
import org.marketcetera.trade.client.DirectTradeClient;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import com.querydsl.core.BooleanBuilder;

/* $License$ */

/**
 * Provides StrategyServiceImpl services.
 *
 * @author <a href="mailto:colin@marketcetera.com">Colin DuPlantis</a>
 * @version $Id$
 * @since $Release$
 */
@Preserve
@Component
@AutoConfiguration
public class StrategyServiceImpl
        implements StrategyService,DirectoryWatcherSubscriber
{
    /**
     * Validate and start the object.
     *
     * @throws IOException if an error occurs managing strategy and provisioning directories 
     */
    @PostConstruct
    @Transactional(readOnly=false,propagation=Propagation.REQUIRED)
    public void start()
            throws IOException
    {
        serviceName = PlatformServices.getServiceName(getClass());
        SLF4JLoggerProxy.info(this,
                              "{} starting",
                              serviceName);
        strategyMessageQueueProcessor = new StrategyMessageQueueProcessor();
        strategyMessageQueueProcessor.start();
        clusterData = clusterService.getInstanceData();
        strategyIncomingDirectoryName = strategyIncomingDirectoryName + clusterData.getInstanceNumber();
        incomingStrategyDirectoryPath = Paths.get(strategyIncomingDirectoryName);
        // intentionally not modified with the cluster instance number; it's ok if multiple instances use these directories
        storageStrategyDirectoryPath = Paths.get(strategyStorageDirectoryName);
        temporaryStrategyDirectoryPath = Paths.get(strategyTemporaryDirectoryName);
        FileUtils.createParentDirectories(storageStrategyDirectoryPath.toFile());
        SLF4JLoggerProxy.info(this,
                              "{} monitoring {} for uploaded strategies, storing strategies in {}",
                              serviceName,
                              strategyIncomingDirectoryName,
                              strategyStorageDirectoryName);
        strategyWatcher = new DirectoryWatcherImpl();
        strategyWatcher.setCreateDirectoriesOnStart(true);
        strategyWatcher.setDirectoriesToWatch(Lists.newArrayList(new File(strategyIncomingDirectoryName)));
        strategyWatcher.setPollingInterval(pollingInterval);
        strategyWatcher.addWatcher(this);
        strategyWatcher.start();
        eventBusService.register(this);
        // verify all existing strategies
        for(PersistentStrategyInstance existingStrategyInstance : strategyInstanceDao.findAll()) {
            Path fullStrategyPath = storageStrategyDirectoryPath.resolve(existingStrategyInstance.getFilename());
            if(!fullStrategyPath.toFile().canRead()) {
                SLF4JLoggerProxy.warn(this,
                                      "{} is unreadable, unloading",
                                      fullStrategyPath);
                BooleanBuilder where = new BooleanBuilder();
                where = where.and(QPersistentStrategyMessage.persistentStrategyMessage.strategyInstance.eq(existingStrategyInstance));
                strategyMessageDao.deleteAll(strategyMessageDao.findAll(where));
                strategyInstanceDao.delete(existingStrategyInstance);
            }
        }
    }
    /**
     * Stop the object.
     */
    @PreDestroy
    public void stop()
    {
        strategyMessageQueueProcessor.stop();
        eventBusService.unregister(this);
        if(strategyWatcher != null) {
            try {
                strategyWatcher.stop();
            } catch (Exception ignored) {
            } finally {
                strategyWatcher = null;
            }
        }
        SLF4JLoggerProxy.info(this,
                              "{} stopped",
                              serviceName);
    }
    /**
     * Requests loaded strategy instances.
     *
     * @return a <code>Collection&lt;StrategyInstance&gt;</code> value
     */
    @Override
    @Transactional(readOnly=true,propagation=Propagation.REQUIRED)
    public Collection<? extends StrategyInstance> getStrategyInstances(String inCurrentUserName)
    {
        // TODO need to filter by current user
        // TODO probably need to factor in supervisor permissions for "read"
        return strategyInstanceDao.findAll();
    }
    /**
     * Requests strategy messages.
     *
     * @param inStrategyName a <code>String</code> value
     * @param inSeverity a <code>Severity</code> value
     * @param inPageRequest a <code>PageRequest</code> value
     * @return a <code>CollectionPageResponse&lt;? extends StrategyMessage&gt;</code> value
     */
    @Override
    @Transactional(readOnly=true,propagation=Propagation.REQUIRED)
    public CollectionPageResponse<? extends StrategyMessage> getStrategyMessages(String inStrategyName,
                                                                                 Severity inSeverity,
                                                                                 org.marketcetera.persist.PageRequest inPageRequest)
    {
        Sort sort = buildSort(inPageRequest,
                              Sort.by(new Sort.Order(Sort.Direction.DESC,
                                                     QPersistentStrategyMessage.persistentStrategyMessage.messageTimestamp.getMetadata().getName()),
                                      new Sort.Order(Sort.Direction.DESC,
                                                     QPersistentStrategyMessage.persistentStrategyMessage.severity.getMetadata().getName())));
        SLF4JLoggerProxy.debug(this,
                               "getStrategyMessages sort order is {} renders: {} with strategy name {} and severity {}",
                               inPageRequest.getSortOrder(),
                               sort,
                               inStrategyName,
                               inSeverity);
        Pageable pageRequest = PageRequest.of(inPageRequest.getPageNumber(),
                                              inPageRequest.getPageSize(),
                                              sort);
        inStrategyName = StringUtils.trimToNull(inStrategyName);
        BooleanBuilder where = null;
        if(inStrategyName != null || inSeverity != null) {
            where = new BooleanBuilder();
            if(inStrategyName != null) {
                where = where.and(QPersistentStrategyMessage.persistentStrategyMessage.strategyInstance.name.eq(inStrategyName));
            }
            if(inSeverity != null) {
                BooleanBuilder severityBuilder = new BooleanBuilder();
                switch(inSeverity) {
                    case DEBUG:
                        severityBuilder = severityBuilder.or(QPersistentStrategyMessage.persistentStrategyMessage.severity.eq(Severity.DEBUG));
                    case INFO:
                        severityBuilder = severityBuilder.or(QPersistentStrategyMessage.persistentStrategyMessage.severity.eq(Severity.INFO));
                    case WARN:
                        severityBuilder = severityBuilder.or(QPersistentStrategyMessage.persistentStrategyMessage.severity.eq(Severity.WARN));
                    case ERROR:
                        severityBuilder = severityBuilder.or(QPersistentStrategyMessage.persistentStrategyMessage.severity.eq(Severity.ERROR));
                        break;
                    default:
                        throw new UnsupportedOperationException("Unexpected severity: " + inSeverity);
                }
                where = where.and(severityBuilder);
            }
        }
        Page<PersistentStrategyMessage> pageResponse;
        if(where == null) {
            pageResponse = strategyMessageDao.findAll(pageRequest);
        } else {
            SLF4JLoggerProxy.debug(this,
                                   "Selecting strategy messages with: {}",
                                   where);
            pageResponse = strategyMessageDao.findAll(where,
                                                      pageRequest);
        }
        return new CollectionPageResponse<>(pageResponse);
    }
    /**
     * Start a strategy instance.
     *
     * @param inStrategyInstanceName a <code>String</code> value
     */
    @Override
    @Transactional(readOnly=false,propagation=Propagation.REQUIRED)
    public void startStrategyInstance(String inStrategyInstanceName)
    {
        boolean success = true;
        String errorMessage = null;
        StrategyStatus newStatus = null;
        StrategyStatus oldStatus = null;
        PersistentStrategyInstance strategyInstance = null;
        try {
            Optional<PersistentStrategyInstance> strategyInstanceOption = strategyInstanceDao.findByName(inStrategyInstanceName);
            if(strategyInstanceOption.isEmpty()) {
                success = false;
                newStatus = StrategyStatus.ERROR;
            } else {
                strategyInstance = strategyInstanceOption.get();
                oldStatus = strategyInstance.getStatus();
                if(strategyInstance.getStatus().isRunnable()) {
                    Path strategySource = Paths.get(strategyStorageDirectoryName,
                                                    strategyInstance.getFilename());
                    if(strategySource.toFile().canRead()) {
                        // TODO need to re-verify hash
                        success = true;
                        // TODO somehow set the parameters for the strategy to read
                        RunningStrategy runningStrategy = new RunningStrategy(strategyInstance,
                                                                              strategySource.toFile());
                        runningStrategy.start();
                        strategyInstance.setStarted(new Date());
                        strategiesByName.put(strategyInstance.getName(),
                                             runningStrategy);
                        newStatus = StrategyStatus.RUNNING;
                    } else {
                        success = false;
                        errorMessage = "Unable to read cached strategy with name '" + inStrategyInstanceName + "'";
                        newStatus = StrategyStatus.ERROR;
                        SLF4JLoggerProxy.warn(this,
                                              "Unable to read cached strategy '{}' with filename {}",
                                              inStrategyInstanceName,
                                              strategySource);
                    }
                } else {
                    success = false;
                    errorMessage = "Strategy '" + inStrategyInstanceName + "' at status " + oldStatus.name() + " cannot be started";
                    newStatus = oldStatus;
                    SLF4JLoggerProxy.warn(this,
                                          "Unable to start strategy '{}' at status {}",
                                          inStrategyInstanceName,
                                          oldStatus);
                }
            }
        } catch (Throwable e) {
            errorMessage = PlatformServices.getMessage(e);
            SLF4JLoggerProxy.warn(this,
                                  e,
                                  "Unable to start strategy '{}': {}",
                                  inStrategyInstanceName,
                                  errorMessage);
            success = false;
            newStatus = StrategyStatus.ERROR;
        } finally {
            if(strategyInstance != null) {
                strategyInstance.setStatus(newStatus);
                strategyInstance = strategyInstanceDao.save(strategyInstance);
            }
            if(success) {
                eventBusService.post(new SimpleStrategyStartedEvent(strategyInstance));
            } else {
                eventBusService.post(new SimpleStrategyStartFailedEvent(strategyInstance,
                                                                        errorMessage));
                PersistentStrategyMessage errorMessageEvent = new PersistentStrategyMessage();
                errorMessageEvent.setMessage(errorMessage);
                errorMessageEvent.setMessageTimestamp(new Date());
                errorMessageEvent.setSeverity(Severity.ERROR);
                errorMessageEvent.setStrategyInstance(strategyInstance);
                strategyMessageDao.save(errorMessageEvent);
            }
            if(oldStatus != newStatus) {
                eventBusService.post(new SimpleStrategyStatusChangedEvent(strategyInstance,
                                                                          oldStatus,
                                                                          newStatus));
            }
        }
    }
    /**
     * Stop a strategy instance.
     *
     * @param inStrategyInstanceName a <code>String</code> value
     */
    @Override
    @Transactional(readOnly=false,propagation=Propagation.REQUIRED)
    public void stopStrategyInstance(String inStrategyInstanceName)
    {
        Optional<PersistentStrategyInstance> strategyInstanceOption = strategyInstanceDao.findByName(inStrategyInstanceName);
        Validate.isTrue(strategyInstanceOption.isPresent(),
                        "No strategy by name '" + inStrategyInstanceName + "'");
        PersistentStrategyInstance strategyInstance = strategyInstanceOption.get();
        Validate.isTrue(strategyInstance.getStatus().isRunning(),
                        "Strategy '" + inStrategyInstanceName + "' is not running");
        RunningStrategy runningStrategy = strategiesByName.getIfPresent(inStrategyInstanceName);
        StrategyStatus oldStatus = strategyInstance.getStatus();
        StrategyStatus newStatus = StrategyStatus.STOPPED;
        strategyInstance.setStarted(new Date(0));
        if(runningStrategy == null) {
            SLF4JLoggerProxy.warn(this,
                                  "No running strategy found for '{}'",
                                  inStrategyInstanceName);
        } else {
            strategiesByName.invalidate(inStrategyInstanceName);
            try {
                runningStrategy.stop();
            } catch (Exception e) {
                SLF4JLoggerProxy.warn(this,
                                      e);
            }
        }
        strategyInstance.setStatus(newStatus);
        strategyInstance = strategyInstanceDao.save(strategyInstance);
        eventBusService.post(new SimpleStrategyStoppedEvent(strategyInstance));
        if(oldStatus != newStatus) {
            eventBusService.post(new SimpleStrategyStatusChangedEvent(strategyInstance,
                                                                      oldStatus,
                                                                      newStatus));
        }
    }
    /**
     * Unload a strategy instance.
     *
     * @param inStrategyInstanceName a <code>String</code> value
     */
    @Override
    @Transactional(readOnly=false,propagation=Propagation.REQUIRED)
    public void unloadStrategyInstance(String inStrategyInstanceName)
    {
        Validate.notNull(inStrategyInstanceName,
                         "Strategy instance name required");
        Optional<PersistentStrategyInstance> strategyInstanceOption = strategyInstanceDao.findByName(inStrategyInstanceName);
        Validate.isTrue(strategyInstanceOption.isPresent(),
                        "No strategy instance by name '" + inStrategyInstanceName + "'");
        PersistentStrategyInstance strategyInstance = strategyInstanceOption.get();
        Validate.isTrue(strategyInstance.getStatus().isUnloadable(),
                        "Strategy '" + strategyInstance.getName() + "' cannot be unloaded at status '" + strategyInstance.getStatus() + "'");
        // TODO need to put the correct filename in here
        Path strategyTarget = Paths.get(strategyStorageDirectoryName,
                                        strategyInstance.getFilename());
        FileUtils.deleteQuietly(strategyTarget.toFile());
        deleteAllMessagesFor(strategyInstance);
        strategyInstanceDao.delete(strategyInstance);
        eventBusService.post(new SimpleStrategyUnloadedEvent(strategyInstance));
    }
    /* (non-Javadoc)
     * @see org.marketcetera.strategy.StrategyService#deleteStrategyMessage(long)
     */
    @Override
    @Transactional(readOnly=false,propagation=Propagation.REQUIRED)
    public void deleteStrategyMessage(long inStrategyMessageId)
    {
        SLF4JLoggerProxy.debug(this,
                               "Deleting strategy message with id {}",
                               inStrategyMessageId);
        Optional<PersistentStrategyMessage> strategyMessageOption = strategyMessageDao.findByStrategyMessageId(inStrategyMessageId);
        Validate.isTrue(strategyMessageOption.isPresent(),
                        "No strategy message with id '" + inStrategyMessageId + "'");
        strategyMessageDao.delete(strategyMessageOption.get());
    }
    /* (non-Javadoc)
     * @see org.marketcetera.strategy.StrategyService#deleteAllStrategyMessages(java.lang.String)
     */
    @Override
    @Transactional(readOnly=false,propagation=Propagation.REQUIRED)
    public void deleteAllStrategyMessages(String inStrategyInstanceName)
    {
        Validate.notNull(inStrategyInstanceName,
                         "Strategy instance name required");
        Optional<PersistentStrategyInstance> strategyInstanceOption = strategyInstanceDao.findByName(inStrategyInstanceName);
        Validate.isTrue(strategyInstanceOption.isPresent(),
                        "No strategy instance by name '" + inStrategyInstanceName + "'");
        PersistentStrategyInstance strategyInstance = strategyInstanceOption.get();
        deleteAllMessagesFor(strategyInstance);
    }
    /* (non-Javadoc)
     * @see StrategyService#getIncomingStrategyDirectory()
     */
    @Override
    public Path getIncomingStrategyDirectory()
    {
        return incomingStrategyDirectoryPath;
    }
    /* (non-Javadoc)
     * @see StrategyService#getTemporaryStrategyDirectory()
     */
    @Override
    public Path getTemporaryStrategyDirectory()
    {
        return temporaryStrategyDirectoryPath;
    }
    /**
     * Load a new strategy instances.
     *
     * @param inFile a <code>File</code> value
     * @param inOriginalFileName a <code>String</code> value
     */
    @Override
    @Transactional(readOnly=false,propagation=Propagation.REQUIRED)
    public void received(File inFile,
                         String inOriginalFileName)
    {
        SLF4JLoggerProxy.debug(this,
                               "Received incoming strategy file '{}'",
                               inOriginalFileName);
        // TODO match with strategy instance and update status to LOADED or ERROR
        // verify and move to provisioning directory
        // find the incoming upload
//        Optional<? extends StrategyInstance> strategyInstanceOption = strategyService.findByName(inName);
//        Validate.isTrue(strategyInstanceOption.isPresent(),
//                        "No strategy instance with name '" + inName + "' found");
//        StrategyInstance strategyInstance = strategyInstanceOption.get();
//        Validate.isTrue(inNonce.equals(strategyInstance.getNonce()),
//                        "Strategy upload nonce does not match");
//        String hash = PlatformServices.getFileChecksum(inStrategyFile.toFile());
//        Validate.isTrue(hash.equals(strategyInstance.getHash()),
//                        "Strategy upload hash does not match");
        PersistentStrategyInstance strategyInstance = null;
        try {
            String nonce = FilenameUtils.getBaseName(inOriginalFileName);
            Optional<PersistentStrategyInstance> strategyInstanceOption = strategyInstanceDao.findByNonce(nonce);
            SLF4JLoggerProxy.debug(this,
                                   "Received uploaded file with nonce: '{}' found: {}",
                                   nonce,
                                   strategyInstanceOption);
            Validate.isTrue(strategyInstanceOption.isPresent(),
                            "No strategy instance with nonce: '" + nonce + "'");
            strategyInstance = strategyInstanceOption.get();
            // TODO should use the file type uploaded
            String finalStrategyFilename = nonce + ".jar";
            strategyInstance.setFilename(finalStrategyFilename);
            Path strategyTarget = Paths.get(strategyStorageDirectoryName,
                                            finalStrategyFilename);
            FileUtils.moveFile(inFile,
                               strategyTarget.toFile());
            StrategyStatus oldStatus = strategyInstance.getStatus();
            strategyInstance.setStatus(StrategyStatus.STOPPED);
            strategyInstance = strategyInstanceDao.save(strategyInstance);
            eventBusService.post(new SimpleStrategyUploadSucceededEvent(strategyInstance));
            eventBusService.post(new SimpleStrategyStatusChangedEvent(strategyInstance,
                                                                      oldStatus,
                                                                      strategyInstance.getStatus()));
        } catch (Exception e) {
            SLF4JLoggerProxy.warn(this,
                                  e);
            if(strategyInstance != null) {
                strategyInstance.setStatus(StrategyStatus.ERROR);
                strategyInstance = strategyInstanceDao.save(strategyInstance);
            }
            eventBusService.post(new SimpleStrategyUploadFailedEvent(strategyInstance,
                                                                     PlatformServices.getMessage(e)));
        }
    }
    /**
     * Load a new strategy instances.
     *
     * @param inStrategyInstance an <code>StrategyInstance</code> value
     * @return a <code>StrategyStatus</code> value
     */
    @Override
    @Transactional(readOnly=false,propagation=Propagation.REQUIRED)
    public StrategyStatus loadStrategyInstance(StrategyInstance inStrategyInstance)
    {
        // create a new persistent strategy instance
        PersistentStrategyInstance pInstance;
        if(inStrategyInstance instanceof PersistentStrategyInstance) {
            pInstance = (PersistentStrategyInstance)inStrategyInstance;
        } else {
            throw new UnsupportedOperationException("Need to create persistent instance");
        }
        pInstance.setStatus(StrategyStatus.LOADING);
        PersistentUser user = userDao.findByName(inStrategyInstance.getUser().getName());
        Validate.notNull(user,
                         "No user for name '" + inStrategyInstance.getUser().getName() + "'");
        pInstance.setUser(user);
        pInstance = strategyInstanceDao.save(pInstance);
        return pInstance.getStatus();
    }
    /* (non-Javadoc)
     * @see org.marketcetera.strategy.StrategyService#createStrategyMessage(org.marketcetera.strategy.StrategyMessage)
     */
    @Override
    public StrategyMessage createStrategyMessage(StrategyMessage inStrategyMessage)
    {
        strategyMessageQueueProcessor.add(inStrategyMessage);
        return inStrategyMessage;
    }
    /**
     * Receive incoming strategy events.
     *
     * @param inEvent a <code>StrategyEvent</code> value
     */
    @Subscribe
    public void receiveStrategyEvent(StrategyEvent inEvent)
    {
        synchronized(strategyEventListeners) {
            for(StrategyEventListener listener : strategyEventListeners) {
                try {
                    listener.receiveStrategyEvent(inEvent);
                } catch (Exception e) {
                    SLF4JLoggerProxy.warn(this,
                                          e);
                    removeStrategyEventListener(listener);
                }
            }
        }
    }
    /* (non-Javadoc)
     * @see StrategyService#addStrategyEventListener(StrategyEventListener)
     */
    @Override
    public void addStrategyEventListener(StrategyEventListener inListener)
    {
        synchronized(strategyEventListeners) {
            strategyEventListeners.add(inListener);
        }
    }
    /* (non-Javadoc)
     * @see StrategyService#removeStrategyEventListener(StrategyEventListener)
     */
    @Override
    public void removeStrategyEventListener(StrategyEventListener inListener)
    {
        synchronized(strategyEventListeners) {
            strategyEventListeners.remove(inListener);
        }
    }
    /**
     * Finds the strategy instance with the given name.
     *
     * @param inName a <code>String</code> value
     * @return a <code>Optional&lt;? extends StrategyInstance&gt;</code> value
     */
    @Override
    @Transactional(readOnly=true,propagation=Propagation.REQUIRED)
    public Optional<? extends StrategyInstance> findByName(String inName)
    {
        return strategyInstanceDao.findByName(inName);
    }
    /**
     * Delete all {@link PersistentStrategyMessage} values owned by the given <code>PersistentStrategyInstance</code>.
     * 
     * <p>This method assumes a transaction set up by the caller.</p>
     *
     * @param inStrategyInstance a <code>PersistentStrategyInstance</code> value
     */
    private void deleteAllMessagesFor(PersistentStrategyInstance inStrategyInstance)
    {
        BooleanBuilder where = new BooleanBuilder();
        where = where.and(QPersistentStrategyMessage.persistentStrategyMessage.strategyInstance.eq(inStrategyInstance));
        strategyMessageDao.deleteAll(strategyMessageDao.findAll(where));
    }
    /**
     * Build the sort statement for a query using the given attributes.
     *
     * @param inPageRequest an <code>org.marketcetera.persist.PageRequest</code> value
     * @param inDefaultSort a <code>Sort</code> value
     * @return a <code>Sort</code> value
     */
    private Sort buildSort(org.marketcetera.persist.PageRequest inPageRequest,
                           Sort inDefaultSort)
    {
        if(inPageRequest.getSortOrder() == null || inPageRequest.getSortOrder().isEmpty()) {
            return inDefaultSort;
        } else {
            List<Sort.Order> specifiedSorts = Lists.newArrayList();
            for(org.marketcetera.persist.Sort requestedSort : inPageRequest.getSortOrder()) {
                String property = requestedSort.getProperty();
                specifiedSorts.add(new Sort.Order(requestedSort.getDirection().getSpringSortDirection(),
                                                  property));
            }
            return Sort.by(specifiedSorts);
        }
    }
    /**
     * Tracks a running strategy instance.
     *
     * @author <a href="mailto:colin@marketcetera.com">Colin DuPlantis</a>
     * @version $Id$
     * @since $Release$
     */
    private class RunningStrategy
    {
        /**
         * Start the strategy.
         *
         * @throws Throwable if an error occurs loading or starting the strategy.
         */
        private void start()
                throws Throwable
        {
            // prepare a new class loader based on the current one to load this class
            URL url = jarFile.toURI().toURL();
            // create a new class loader for this operation that will be closed at its conclusion
            newClassloader = new URLClassLoader(new URL[] { url },ClassLoader.getSystemClassLoader());
            String mainClass = getMainClassName(jarFile);
            SLF4JLoggerProxy.debug(StrategyServiceImpl.this,
                                   "Selected {} as the mainClass",
                                   mainClass);
            Validate.notNull(mainClass,
                             "No 'Main-Class' attribute in JAR");
            Class<?> provisioningClass = newClassloader.loadClass(mainClass);
            // create a new Spring context as a sandbox for the loaded code. this allows us to discard the loaded code when done
            newContext = new AnnotationConfigApplicationContext();
            // explicitly use the new class loader
            newContext.setClassLoader(newClassloader);
            // add the parent context to give the provisioning JAR access to all our resources
            newContext.setParent(applicationContext);
            // register the new class
            newContext.register(provisioningClass);
            ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)newContext).getBeanFactory();
            beanFactory.registerSingleton(StrategyInstanceHolder.class.getCanonicalName(),
                                          new StrategyInstanceHolder() {
                @Override
                public StrategyInstance getStrategyInstance()
                {
                    return strategyInstance;
                }}
            );
            String strategyUsername = strategyInstance.getUser().getName();
            // TODO this needs to be configurable - this could be a direct client for DARE or an RPC client for an SE
            DirectStrategyClient strategyClient = new DirectStrategyClient(newContext,
                                                                           strategyUsername);
            beanFactory.registerSingleton(StrategyClient.class.getCanonicalName(),
                                          strategyClient);
            // get the trade client that we expect to be defined in the parent context
            DirectTradeClient tradeClient = applicationContext.getBean(DirectTradeClient.class);
            // define the current user, which is the user that owns the strategy
            tradeClient.setCurrentUser(strategyInstance);
            // refresh the context, which allows it to prepare to use the strategy JAR
            newContext.refresh();
            // start the context
            newContext.start();
            // start the embedded strategy client
            strategyClient.start();
        }
        /**
         * Stop the running strategy.
         */
        private void stop()
        {
            try {
                newContext.stop();
                newContext.close();
            } catch (Exception e) {
                SLF4JLoggerProxy.warn(StrategyServiceImpl.this,
                                      e);
            }
            try {
                newClassloader.close();
            } catch (Exception e) {
                SLF4JLoggerProxy.warn(StrategyServiceImpl.this,
                                      e);
            }
        }
        /**
         * Determines the main class name from the given JAR.
         *
         * <p>The current implementation optimistically assumes the given File is a JAR and contains a <code>Main-Class</code> attribute.
         * 
         * @param inJarFile a <code>File</code> value
         * @return a <code>String</code> value or <code>null</code> if the appropriate attribute cannot be extracted from the given file
         * @throws FileNotFoundException if the file does not exist
         * @throws IOException if the file could otherwise not be read
         */
        private String getMainClassName(File inJarFile)
                throws FileNotFoundException, IOException
        {
            String mainClassName;
            try(JarInputStream jarStream = new JarInputStream(new FileInputStream(inJarFile))) {
                Manifest manifest = jarStream.getManifest();
                Attributes mainAttributes = manifest.getMainAttributes();
                mainClassName = mainAttributes.getValue("Main-Class");
            }
            return mainClassName;
        }
        /**
         * Create a new RunningStrategy instance.
         *
         * @param inStrategyInstance a <code>StrategyInstance</code> value
         * @param inStrategyJar a <code>File</code> value
         */
        private RunningStrategy(StrategyInstance inStrategyInstance,
                                File inStrategyJar)
        {
            strategyInstance = inStrategyInstance;
            jarFile = inStrategyJar;
        }
        /**
         * JAR file that contains the strategy to run
         */
        private final File jarFile;
        /**
         * strategy instance associated with the running strategy
         */
        private final StrategyInstance strategyInstance;
        /**
         * class loader used for the strategy
         */
        private URLClassLoader newClassloader;
        /**
         * new application context used for the strategy
         */
        private AnnotationConfigApplicationContext newContext;
    }
    /**
     * Processes <code>StrategyMessage</code> objects and stores them in bulk.
     *
     * @author <a href="mailto:colin@marketcetera.com">Colin DuPlantis</a>
     * @version $Id$
     * @since $Release$
     */
    private class StrategyMessageQueueProcessor
            extends BatchQueueProcessor<StrategyMessage>
    {
        /* (non-Javadoc)
         * @see org.marketcetera.core.BatchQueueProcessor#add(java.lang.Object)
         */
        @Override
        protected void add(StrategyMessage inData)
        {
            super.add(inData);
        }
        /* (non-Javadoc)
         * @see org.marketcetera.core.BatchQueueProcessor#processData(java.util.Deque)
         */
        @Override
        protected void processData(Deque<StrategyMessage> inData)
                throws Exception
        {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setName("strategyEventTransaction");
            def.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRED);
            def.setReadOnly(false);
            TransactionStatus status = txManager.getTransaction(def);
            try {
                persistentStrategyMessages.clear();
                for(StrategyMessage inStrategyMessage : inData) {
                    PersistentStrategyMessage strategyMessage;
                    if(inStrategyMessage instanceof PersistentStrategyMessage) {
                        strategyMessage = (PersistentStrategyMessage)inStrategyMessage;
                    } else {
                        throw new UnsupportedOperationException("Need to create persistent instance");
                    }
                    PersistentStrategyInstance strategyInstance = strategyInstancesByName.getUnchecked(strategyMessage.getStrategyInstance().getName());
                    if(strategyInstance == null) {
                        SLF4JLoggerProxy.warn(StrategyServiceImpl.this,
                                              "No strategy instance for name '{}', cannot save message '{}'",
                                              strategyMessage.getStrategyInstance().getName(),
                                              strategyMessage);
                    } else {
                        strategyMessage.setStrategyInstance(strategyInstance);
                        persistentStrategyMessages.add(strategyMessage);
                    }
                }
                strategyMessageDao.saveAll(persistentStrategyMessages);
                txManager.commit(status);
                for(StrategyMessage strategyMessage : persistentStrategyMessages) {
                    eventBusService.post(new SimpleStrategyMessageEvent(strategyMessage));
                }
            } catch (Exception e) {
                SLF4JLoggerProxy.warn(StrategyServiceImpl.this,
                                      e,
                                      "Unable to persistent strategy messages: {}",
                                      inData);
                txManager.rollback(status);
            }
        }
        /**
         * stores strategy instances by name
         */
        private final LoadingCache<String,PersistentStrategyInstance> strategyInstancesByName = CacheBuilder.newBuilder().expireAfterAccess(60,TimeUnit.SECONDS).build(new CacheLoader<String,PersistentStrategyInstance>() {
            @Override
            public PersistentStrategyInstance load(String inKey)
                    throws Exception
            {
                Optional<PersistentStrategyInstance> strategyInstanceOption = strategyInstanceDao.findByName(inKey);
                return strategyInstanceOption.orElse(null);
            }}
        );
        /**
         * temporarily holds strategy messages to persist
         */
        private final Collection<PersistentStrategyMessage> persistentStrategyMessages = Lists.newArrayList();
    }
    /**
     * processes batches of strategy messages
     */
    private StrategyMessageQueueProcessor strategyMessageQueueProcessor;
    /**
     * provides access to the {@link StrategyMessage} data store
     */
    @Autowired
    private StrategyMessageDao strategyMessageDao;
    /**
     * stores running strategies by name
     */
    private final Cache<String,RunningStrategy> strategiesByName = CacheBuilder.newBuilder().build();
    /**
     * directory which is monitored for incoming strategies
     */
    private Path incomingStrategyDirectoryPath;
    /**
     * directory which is used to store uploaded strategies before they are verified
     */
    private Path temporaryStrategyDirectoryPath;
    /**
     * directory which is used to store uploaded strategies after they are verified
     */
    private Path storageStrategyDirectoryPath;
    /**
     * main application context
     */
    @Autowired
    private ApplicationContext applicationContext;
    /**
     * interval at which to poll for provisioning files
     */
    @Value("${metc.strategy.incoming.directory.polling.intervalms:5000}")
    private long pollingInterval;
    /**
     * strategy storage directory base
     */
    @Value("${metc.strategy.storage.directory}")
    private String strategyStorageDirectoryName;
    /**
     * strategy incoming directory base
     */
    @Value("${metc.strategy.incoming.directory}")
    private String strategyIncomingDirectoryName;
    /**
     * strategy temporary directory base
     */
    @Value("${metc.strategy.temporary.directory}")
    private String strategyTemporaryDirectoryName;
    /**
     * name of this service
     */
    private String serviceName;
    /**
     * watches the incoming strategy directory
     */
    private DirectoryWatcherImpl strategyWatcher;
    /**
     * transaction manager value
     */
    @Autowired
    private JpaTransactionManager txManager;
    /**
     * provides access to cluster services
     */
    @Autowired
    private ClusterService clusterService;
    /**
     * provides access to event bus services
     */
    @Autowired
    private EventBusService eventBusService;
    /**
     * generated cluster data
     */
    private ClusterData clusterData;
    /**
     * provides access to the {@link User} data store
     */
    @Autowired
    private UserDao userDao;
    /**
     * provides access to the {@link StrategyInstance} data store
     */
    @Autowired
    private StrategyInstanceDao strategyInstanceDao;
    /**
     * holds event listener subscribers
     */
    private final Set<StrategyEventListener> strategyEventListeners = Sets.newConcurrentHashSet();
}
