/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;
import org.marketcetera.admin.User;
import org.marketcetera.admin.service.UserService;
import org.marketcetera.core.ClientStatusListener;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.core.notifications.INotification;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.strategy.FileUploadRequest;
import org.marketcetera.strategy.StrategyClient;
import org.marketcetera.strategy.StrategyEventListener;
import org.marketcetera.strategy.StrategyInstance;
import org.marketcetera.strategy.StrategyInstanceHolder;
import org.marketcetera.strategy.StrategyMessage;
import org.marketcetera.strategy.StrategyMessageFactory;
import org.marketcetera.strategy.StrategyService;
import org.marketcetera.strategy.StrategyStatus;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.context.ApplicationContext;

public class DirectStrategyClient
implements StrategyClient {
    private final ApplicationContext applicationContext;
    private final String username;
    private User user;
    private boolean isRunning = false;
    private UserService userService;
    private StrategyService strategyService;
    private final String clientId = PlatformServices.generateId();
    private StrategyInstanceHolder strategyInstanceHolder;
    private StrategyMessageFactory strategyMessageFactory;

    public void start() throws Exception {
        SLF4JLoggerProxy.info((Object)this, (String)"Starting direct strategy client");
        Validate.notNull((Object)this.applicationContext);
        this.userService = (UserService)this.applicationContext.getBean(UserService.class);
        this.strategyService = (StrategyService)this.applicationContext.getBean(StrategyService.class);
        SLF4JLoggerProxy.debug((Object)this, (String)"Direct strategy client {} owned by user {}", (Object[])new Object[]{this.clientId, this.username});
        this.user = this.userService.findByName(this.username);
        Validate.notNull((Object)this.user);
        this.isRunning = true;
    }

    public void stop() throws Exception {
        try {
            SLF4JLoggerProxy.info((Object)this, (String)"Stopping direct strategy client");
        }
        finally {
            this.isRunning = false;
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void addClientStatusListener(ClientStatusListener inListener) {
        throw new UnsupportedOperationException();
    }

    public void removeClientStatusListener(ClientStatusListener inListener) {
        throw new UnsupportedOperationException();
    }

    public Collection<? extends StrategyInstance> getStrategyInstances() {
        return this.strategyService.getStrategyInstances(this.username);
    }

    public StrategyStatus loadStrategyInstance(StrategyInstance inStrategyInstance) {
        return this.strategyService.loadStrategyInstance(inStrategyInstance);
    }

    public CollectionPageResponse<? extends StrategyMessage> getStrategyMessages(String inStrategyName, INotification.Severity inSeverity, PageRequest inPageRequest) {
        return this.strategyService.getStrategyMessages(inStrategyName, inSeverity, inPageRequest);
    }

    public Optional<? extends StrategyInstance> findByName(String inName) {
        return this.strategyService.findByName(inName);
    }

    public void uploadFile(FileUploadRequest inRequest) throws IOException, NoSuchAlgorithmException {
        throw new UnsupportedOperationException();
    }

    public void emitMessage(INotification.Severity inSeverity, String inMessage) {
        StrategyMessage strategyMessage = this.getStrategyMessageFactory().create();
        strategyMessage.setSeverity(inSeverity);
        strategyMessage.setMessage(inMessage);
        strategyMessage.setStrategyInstance(this.getStrategyInstanceHolder().getStrategyInstance());
        strategyMessage.setMessageTimestamp(new Date());
        this.getStrategyService().createStrategyMessage(strategyMessage);
    }

    public void startStrategyInstance(String inStrategyInstanceName) {
        this.strategyService.startStrategyInstance(inStrategyInstanceName);
    }

    public void stopStrategyInstance(String inStrategyInstanceName) {
        this.strategyService.stopStrategyInstance(inStrategyInstanceName);
    }

    public void unloadStrategyInstance(String inStrategyInstanceName) {
        this.strategyService.unloadStrategyInstance(inStrategyInstanceName);
    }

    public void addStrategyEventListener(StrategyEventListener inListener) {
        this.strategyService.addStrategyEventListener(inListener);
    }

    public void removeStrategyEventListener(StrategyEventListener inListener) {
        this.strategyService.removeStrategyEventListener(inListener);
    }

    public DirectStrategyClient(ApplicationContext inApplicationContext, String inUsername) {
        this.applicationContext = inApplicationContext;
        this.username = StringUtils.trimToNull((String)inUsername);
        Validate.notNull((Object)this.username);
    }

    public void deleteStrategyMessage(long inStrategyMessageId) {
        this.strategyService.deleteStrategyMessage(inStrategyMessageId);
    }

    public void deleteAllStrategyMessages(String inStrategyInstanceName) {
        this.strategyService.deleteAllStrategyMessages(inStrategyInstanceName);
    }

    private StrategyInstanceHolder getStrategyInstanceHolder() {
        if (this.strategyInstanceHolder == null) {
            this.strategyInstanceHolder = (StrategyInstanceHolder)this.applicationContext.getBean(StrategyInstanceHolder.class);
        }
        return this.strategyInstanceHolder;
    }

    private StrategyMessageFactory getStrategyMessageFactory() {
        if (this.strategyMessageFactory == null) {
            this.strategyMessageFactory = (StrategyMessageFactory)this.applicationContext.getBean(StrategyMessageFactory.class);
        }
        return this.strategyMessageFactory;
    }

    private StrategyService getStrategyService() {
        if (this.strategyService == null) {
            this.strategyService = (StrategyService)this.applicationContext.getBean(StrategyService.class);
        }
        return this.strategyService;
    }
}

