/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy.dao;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.marketcetera.core.Preserve;
import org.marketcetera.core.notifications.INotification;
import org.marketcetera.persist.EntityBase;
import org.marketcetera.strategy.HasStrategyInstance;
import org.marketcetera.strategy.StrategyInstance;
import org.marketcetera.strategy.StrategyMessage;
import org.marketcetera.strategy.dao.PersistentStrategyInstance;

@Entity(name="StrategyMessage")
@Table(name="metc_strategy_messages")
@Preserve
public class PersistentStrategyMessage
extends EntityBase
implements StrategyMessage,
HasStrategyInstance {
    private static final AtomicLong strategyMessageIdCounter = new AtomicLong(System.currentTimeMillis());
    @Column(name="strategy_message_id", nullable=false, unique=true)
    private long strategyMessageId;
    @ManyToOne
    @JoinColumn(name="strategy_instance_id", nullable=true)
    private PersistentStrategyInstance strategyInstance;
    @Column(name="message_timestamp", nullable=true, unique=false)
    private Date messageTimestamp;
    @Enumerated(value=EnumType.STRING)
    @Column(name="severity", nullable=true, unique=false)
    private INotification.Severity severity;
    @Column(name="message", nullable=true, unique=false)
    private String message;
    private static final long serialVersionUID = 1444495066L;

    public PersistentStrategyMessage() {
        this.setStrategyMessageId(strategyMessageIdCounter.incrementAndGet());
    }

    public PersistentStrategyMessage(StrategyMessage inStrategyMessage) {
        this.setStrategyInstance(inStrategyMessage.getStrategyInstance());
        this.setStrategyMessageId(inStrategyMessage.getStrategyMessageId());
        this.setMessageTimestamp(inStrategyMessage.getMessageTimestamp());
        this.setSeverity(inStrategyMessage.getSeverity());
        this.setMessage(inStrategyMessage.getMessage());
    }

    public StrategyInstance getStrategyInstance() {
        return this.strategyInstance;
    }

    public void setStrategyInstance(StrategyInstance inStrategyInstance) {
        this.strategyInstance = (PersistentStrategyInstance)inStrategyInstance;
    }

    public Date getMessageTimestamp() {
        return this.messageTimestamp;
    }

    public void setMessageTimestamp(Date inMessageTimestamp) {
        this.messageTimestamp = inMessageTimestamp;
    }

    public INotification.Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(INotification.Severity inSeverity) {
        this.severity = inSeverity;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String inMessage) {
        this.message = StringUtils.trimToNull((String)inMessage);
    }

    public long getStrategyMessageId() {
        return this.strategyMessageId;
    }

    public void setStrategyMessageId(long inStrategyMessageId) {
        this.strategyMessageId = inStrategyMessageId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StrategyMessage [").append("strategyMessageId=").append(this.getId()).append(", strategyInstance=").append((Object)this.strategyInstance).append(", messageTimestamp=").append(this.messageTimestamp).append(", severity=").append(this.severity).append(", message=").append(this.message).append("]");
        return builder.toString();
    }
}

