/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.marketcetera.client.ClientFactory;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.OrderValidationException;
import org.marketcetera.client.Validations;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.core.notifications.Notification;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.event.AskEvent;
import org.marketcetera.event.BidEvent;
import org.marketcetera.event.DividendEvent;
import org.marketcetera.event.Event;
import org.marketcetera.event.EventTestBase;
import org.marketcetera.event.LogEvent;
import org.marketcetera.event.MarketstatEvent;
import org.marketcetera.event.TradeEvent;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.strategy.AbstractRunningStrategy;
import org.marketcetera.strategy.Executor;
import org.marketcetera.strategy.Language;
import org.marketcetera.strategy.Messages;
import org.marketcetera.strategy.ServicesProvider;
import org.marketcetera.strategy.Status;
import org.marketcetera.strategy.Strategy;
import org.marketcetera.strategy.StrategyException;
import org.marketcetera.strategy.StrategyTestBase;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.Suggestion;
import org.marketcetera.trade.utils.OrderHistoryManagerTest;
import org.marketcetera.util.test.CollectionAssert;
import quickfix.Message;

public class AbstractRunningStrategyTest {
    private MockServicesProvider servicesProvider;
    private MockRunningStrategy strategy;
    private Factory factory;

    @BeforeClass
    public static void once() throws Exception {
        LoggerConfiguration.logSetup();
        try {
            ClientManager.setClientFactory((ClientFactory)new StrategyTestBase.MockClient.MockClientFactory());
            ClientManager.init(null);
        }
        catch (ClientInitException clientInitException) {
            // empty catch block
        }
        OrderHistoryManagerTest.once();
    }

    @Before
    public void before() throws Exception {
        this.strategy = new MockRunningStrategy();
        this.strategy.start();
        this.strategy.setStrategy(new MockStrategy());
        this.servicesProvider = new MockServicesProvider();
        this.factory = Factory.getInstance();
        this.reset();
    }

    @Test
    @Ignore
    public void testSend() throws Exception {
        Assert.assertTrue((boolean)this.strategy.send(this));
        this.verifySentObjects(new Object[]{this});
        this.reset();
        Assert.assertFalse((boolean)this.strategy.send(null));
        this.verifyLoggedEvents(new String[]{Messages.INVALID_DATA.getText((Object)String.valueOf((Object)this.strategy))});
        this.verifyOpenOrders(new OrderSingle[0]);
        this.verifySentObjects(new Object[0]);
        this.reset();
        OrderSingle order = this.factory.createOrderSingle();
        order.setOrderID(null);
        Assert.assertNull((Object)order.getOrderID());
        Assert.assertFalse((boolean)this.strategy.send(order));
        this.verifyLoggedEvents(new String[]{Messages.INVALID_ORDER.getText((Object)String.valueOf((Object)this.strategy))});
        this.verifyOpenOrders(new OrderSingle[0]);
        this.verifySentObjects(new Object[0]);
        this.reset();
        order = this.factory.createOrderSingle();
        try {
            Validations.validate((OrderSingle)order);
            Assert.fail((String)("Expected " + order + " to fail validation"));
        }
        catch (OrderValidationException orderValidationException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)order.getOrderID());
        Assert.assertFalse((boolean)this.strategy.send(order));
        this.verifyLoggedEvents(new String[]{Messages.ORDER_VALIDATION_FAILED.getText((Object)String.valueOf((Object)this.strategy))});
        this.verifyOpenOrders(new OrderSingle[0]);
        this.verifySentObjects(new Object[0]);
        this.reset();
        order = this.factory.createOrderSingle();
        order.setOrderType(OrderType.Market);
        order.setQuantity(EventTestBase.generateDecimalValue());
        order.setSide(Side.Buy);
        order.setInstrument((Instrument)new Equity("METC"));
        Validations.validate((OrderSingle)order);
        Assert.assertTrue((boolean)this.strategy.send(order));
        this.strategy.onExecutionReportRedirected(OrderHistoryManagerTest.generateExecutionReport((String)order.getOrderID().getValue(), null, (OrderStatus)OrderStatus.PartiallyFilled));
        this.verifyLoggedEvents(new String[0]);
        this.verifyOpenOrders(new OrderSingle[]{order});
        this.verifySentObjects(new Object[]{order});
    }

    @Test
    @Ignore
    public void testCancelOrder() throws Exception {
        Assert.assertNull((Object)this.strategy.cancelOrder(null, false));
        this.verifyLoggedEvents(new String[]{Messages.INVALID_CANCEL.getText((Object)String.valueOf((Object)this.strategy))});
        this.verifyOpenOrders(new OrderSingle[0]);
        this.verifySentObjects(new Object[0]);
        this.reset();
        OrderSingle order = this.factory.createOrderSingle();
        order = this.factory.createOrderSingle();
        order.setOrderType(OrderType.Market);
        order.setQuantity(EventTestBase.generateDecimalValue());
        order.setSide(Side.Buy);
        order.setInstrument((Instrument)new Equity("METC"));
        this.strategy.onExecutionReportRedirected(OrderHistoryManagerTest.generateExecutionReport((String)order.getOrderID().getValue(), null, (OrderStatus)OrderStatus.Filled));
        Assert.assertNull((Object)this.strategy.cancelOrder(order.getOrderID(), false));
        this.verifyLoggedEvents(new String[]{Messages.INVALID_ORDERID.getText((Object)String.valueOf((Object)this.strategy), (Object)order.getOrderID().getValue())});
        this.verifyOpenOrders(new OrderSingle[0]);
        this.verifySentObjects(new Object[0]);
        this.reset();
        order = this.factory.createOrderSingle();
        order.setOrderType(OrderType.Market);
        order.setQuantity(EventTestBase.generateDecimalValue());
        order.setSide(Side.Buy);
        order.setInstrument((Instrument)new Equity("METC"));
        this.strategy.send(order);
        this.strategy.onExecutionReportRedirected(OrderHistoryManagerTest.generateExecutionReport((String)order.getOrderID().getValue(), null, (OrderStatus)OrderStatus.PartiallyFilled));
        OrderCancel cancel = this.strategy.cancelOrder(order.getOrderID(), false);
        Assert.assertNotNull((Object)cancel);
        this.verifyLoggedEvents(new String[0]);
        this.verifyOpenOrders(new OrderSingle[]{order});
        this.verifySentObjects(new Object[]{order});
        Assert.assertEquals((Object)order.getOrderID(), (Object)cancel.getOriginalOrderID());
        Assert.assertFalse((boolean)order.getOrderID().equals((Object)cancel.getOrderID()));
        this.reset();
        cancel = this.strategy.cancelOrder(order.getOrderID(), true);
        Assert.assertNotNull((Object)cancel);
        this.verifyLoggedEvents(new String[0]);
        this.verifyOpenOrders(new OrderSingle[]{order});
        this.verifySentObjects(new Object[]{cancel});
        Assert.assertEquals((Object)order.getOrderID(), (Object)cancel.getOriginalOrderID());
        Assert.assertFalse((boolean)order.getOrderID().equals((Object)cancel.getOrderID()));
        this.reset();
        order = this.factory.createOrderSingle();
        order.setOrderType(OrderType.Market);
        order.setQuantity(EventTestBase.generateDecimalValue());
        order.setSide(Side.Buy);
        order.setInstrument((Instrument)new Equity("METC"));
        this.strategy.send(order);
        this.strategy.onExecutionReportRedirected(OrderHistoryManagerTest.generateExecutionReport((String)order.getOrderID().getValue(), null, (OrderStatus)OrderStatus.PartiallyFilled));
        this.reset();
        OrderSingle replaceOrder = this.factory.createOrderSingle();
        replaceOrder = this.factory.createOrderSingle();
        replaceOrder.setOrderType(OrderType.Market);
        replaceOrder.setQuantity(EventTestBase.generateDecimalValue());
        replaceOrder.setSide(Side.Buy);
        replaceOrder.setInstrument((Instrument)new Equity("METC"));
        OrderReplace replace = this.strategy.cancelReplace(order.getOrderID(), replaceOrder, true);
        this.strategy.onExecutionReportRedirected(OrderHistoryManagerTest.generateExecutionReport((String)replace.getOrderID().getValue(), (String)order.getOrderID().getValue(), (OrderStatus)OrderStatus.Replaced));
        this.verifyLoggedEvents(new String[0]);
        this.verifySentObjects(new Object[]{replace});
        Assert.assertTrue((boolean)this.strategy.getOpenOrderIDs().contains(replace.getOrderID()));
        Assert.assertFalse((boolean)this.strategy.getOpenOrderIDs().contains(order.getOrderID()));
        this.reset();
        cancel = this.strategy.cancelOrder(replace.getOrderID(), true);
        Assert.assertNotNull((Object)cancel);
        this.verifyLoggedEvents(new String[0]);
        this.verifySentObjects(new Object[]{cancel});
    }

    @Test
    @Ignore
    public void testCancelAllOrders() throws Exception {
        this.verifyLoggedEvents(new String[0]);
        this.verifyOpenOrders(new OrderSingle[0]);
        this.verifySentObjects(new Object[0]);
        Assert.assertEquals((long)0L, (long)this.strategy.cancelAllOrders());
        this.verifySentObjects(new Object[0]);
        OrderSingle order = this.factory.createOrderSingle();
        order.setOrderType(OrderType.Market);
        order.setQuantity(EventTestBase.generateDecimalValue());
        order.setSide(Side.Buy);
        order.setInstrument((Instrument)new Equity("METC"));
        Assert.assertTrue((boolean)this.strategy.send(order));
        this.strategy.onExecutionReportRedirected(OrderHistoryManagerTest.generateExecutionReport((String)order.getOrderID().getValue(), null, (OrderStatus)OrderStatus.PartiallyFilled));
        this.verifyLoggedEvents(new String[0]);
        this.verifyOpenOrders(new OrderSingle[]{order});
        this.verifySentObjects(new Object[]{order});
        this.strategy.onExecutionReportRedirected(OrderHistoryManagerTest.generateExecutionReport((String)order.getOrderID().getValue(), null, (OrderStatus)OrderStatus.Filled));
        this.verifyLoggedEvents(new String[0]);
        this.verifyOpenOrders(new OrderSingle[0]);
        this.verifySentObjects(new Object[]{order});
        this.reset();
        Assert.assertEquals((long)0L, (long)this.strategy.cancelAllOrders());
        this.verifySentObjects(new Object[0]);
        order = this.factory.createOrderSingle();
        order.setOrderType(OrderType.Market);
        order.setQuantity(EventTestBase.generateDecimalValue());
        order.setSide(Side.Buy);
        order.setInstrument((Instrument)new Equity("METC"));
        Assert.assertTrue((boolean)this.strategy.send(order));
        this.strategy.onExecutionReportRedirected(OrderHistoryManagerTest.generateExecutionReport((String)order.getOrderID().getValue(), null, (OrderStatus)OrderStatus.PartiallyFilled));
        this.verifyLoggedEvents(new String[0]);
        this.verifyOpenOrders(new OrderSingle[]{order});
        this.verifySentObjects(new Object[]{order});
        OrderSingle order2 = this.factory.createOrderSingle();
        order2.setOrderType(OrderType.Market);
        order2.setQuantity(EventTestBase.generateDecimalValue());
        order2.setSide(Side.Buy);
        order2.setInstrument((Instrument)new Equity("METC"));
        Assert.assertTrue((boolean)this.strategy.send(order2));
        this.strategy.onExecutionReportRedirected(OrderHistoryManagerTest.generateExecutionReport((String)order2.getOrderID().getValue(), null, (OrderStatus)OrderStatus.PartiallyFilled));
        this.verifyLoggedEvents(new String[0]);
        this.verifyOpenOrders(new OrderSingle[]{order, order2});
        this.verifySentObjects(new Object[]{order, order2});
        this.reset();
        Assert.assertEquals((long)2L, (long)this.strategy.cancelAllOrders());
        boolean order1Canceled = false;
        boolean order2Canceled = false;
        for (Object object : this.servicesProvider.sentObjects) {
            Assert.assertTrue((boolean)(object instanceof OrderCancel));
            OrderCancel cancel = (OrderCancel)object;
            if (cancel.getOriginalOrderID().equals((Object)order.getOrderID())) {
                order1Canceled = true;
            }
            if (!cancel.getOriginalOrderID().equals((Object)order2.getOrderID())) continue;
            order2Canceled = true;
        }
        Assert.assertTrue((boolean)order1Canceled);
        Assert.assertTrue((boolean)order2Canceled);
        this.reset();
    }

    @Test
    @Ignore
    public void testCancelReplace() throws Exception {
        OrderSingle order = this.factory.createOrderSingle();
        Assert.assertNull((Object)this.strategy.cancelReplace(null, order, false));
        this.verifyLoggedEvents(new String[]{Messages.INVALID_REPLACEMENT_ORDER.getText((Object)String.valueOf((Object)this.strategy))});
        this.verifyOpenOrders(new OrderSingle[0]);
        this.verifySentObjects(new Object[0]);
        this.reset();
        Assert.assertNull((Object)this.strategy.cancelReplace(order.getOrderID(), null, false));
        this.verifyLoggedEvents(new String[]{Messages.INVALID_REPLACEMENT_ORDER.getText((Object)String.valueOf((Object)this.strategy))});
        this.verifyOpenOrders(new OrderSingle[0]);
        this.verifySentObjects(new Object[0]);
        this.reset();
        order.setOrderType(OrderType.Market);
        order.setQuantity(EventTestBase.generateDecimalValue());
        order.setSide(Side.Buy);
        order.setInstrument((Instrument)new Equity("METC"));
        OrderSingle replaceModel = this.factory.createOrderSingle();
        replaceModel.setQuantity(order.getQuantity().add(BigDecimal.ONE));
        Assert.assertFalse((boolean)replaceModel.getQuantity().equals(order.getQuantity()));
        Assert.assertFalse((boolean)this.strategy.getOpenOrderIDs().contains(order.getOrderID()));
        Assert.assertNull((Object)this.strategy.cancelReplace(order.getOrderID(), replaceModel, false));
        this.verifyLoggedEvents(new String[]{Messages.INVALID_ORDERID.getText((Object)String.valueOf((Object)this.strategy), (Object)order.getOrderID().getValue())});
        this.verifyOpenOrders(new OrderSingle[0]);
        this.verifySentObjects(new Object[0]);
        this.reset();
        ExecutionReport report = OrderHistoryManagerTest.generateExecutionReport((String)order.getOrderID().getValue(), null, (OrderStatus)OrderStatus.PartiallyFilled);
        this.strategy.onExecutionReportRedirected(report);
        Assert.assertTrue((boolean)this.strategy.getOpenOrderIDs().contains(order.getOrderID()));
        replaceModel.setPrice(EventTestBase.generateDecimalValue());
        Assert.assertNotNull((Object)replaceModel.getPrice());
        OrderReplace replace = this.strategy.cancelReplace(order.getOrderID(), replaceModel, false);
        this.verifyLoggedEvents(new String[0]);
        this.verifyOpenOrders(new OrderSingle[]{order});
        this.verifySentObjects(new Object[0]);
        Assert.assertNotNull((Object)replace);
        Assert.assertNull((Object)replace.getBrokerOrderID());
        Assert.assertEquals((Object)replaceModel.getQuantity(), (Object)replace.getQuantity());
        Assert.assertEquals((Object)OrderType.Market, (Object)report.getOrderType());
        Assert.assertNull((Object)replace.getPrice());
        OrderHistoryManagerTest.orderType = OrderType.Limit;
        report = OrderHistoryManagerTest.generateExecutionReport((String)order.getOrderID().getValue(), null, (OrderStatus)OrderStatus.PartiallyFilled);
        this.strategy.onExecutionReportRedirected(report);
        Assert.assertEquals((Object)OrderType.Limit, (Object)report.getOrderType());
        Assert.assertNotNull((Object)report.getPrice());
        this.reset();
        replace = this.strategy.cancelReplace(order.getOrderID(), replaceModel, true);
        this.verifyLoggedEvents(new String[0]);
        this.verifyOpenOrders(new OrderSingle[]{order});
        this.verifySentObjects(new Object[]{replace});
        Assert.assertNotNull((Object)replace);
        Assert.assertNull((Object)replace.getBrokerOrderID());
        Assert.assertEquals((Object)replaceModel.getQuantity(), (Object)replace.getQuantity());
        Assert.assertEquals((Object)replaceModel.getPrice(), (Object)replace.getPrice());
        OrderHistoryManagerTest.orderType = OrderType.Market;
        this.reset();
        report = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + System.nanoTime()), (String)order.getOrderID().getValue(), (OrderStatus)OrderStatus.Replaced);
        this.strategy.onExecutionReportRedirected(report);
        this.verifyLoggedEvents(new String[0]);
        this.verifySentObjects(new Object[0]);
        Assert.assertTrue((boolean)this.strategy.getOpenOrderIDs().contains(report.getOrderID()));
        Assert.assertFalse((boolean)this.strategy.getOpenOrderIDs().contains(order.getOrderID()));
        replaceModel.setPrice(EventTestBase.generateDecimalValue());
        replace = this.strategy.cancelReplace(order.getOrderID(), replaceModel, false);
        Assert.assertNull((Object)replace);
        this.verifyLoggedEvents(new String[]{Messages.INVALID_ORDERID.getText((Object)String.valueOf((Object)this.strategy), (Object)order.getOrderID().getValue())});
        this.verifySentObjects(new Object[0]);
        this.reset();
        replace = this.strategy.cancelReplace(report.getOrderID(), replaceModel, true);
        this.verifyLoggedEvents(new String[0]);
        this.verifySentObjects(new Object[]{replace});
        Assert.assertNotNull((Object)replace);
        Assert.assertNull((Object)replace.getBrokerOrderID());
        Assert.assertEquals((Object)replaceModel.getQuantity(), (Object)replace.getQuantity());
    }

    @Test
    public void testGetOrderStatus() throws Exception {
        Assert.assertNull((Object)this.strategy.getOrderStatus(null));
        Assert.assertNull((Object)this.strategy.getOrderStatus(new OrderID("this-id-doesn't-exist-" + System.nanoTime())));
        OrderID orderID = new OrderID("order-" + System.nanoTime());
        ExecutionReport report1 = OrderHistoryManagerTest.generateExecutionReport((String)orderID.getValue(), null, (OrderStatus)OrderStatus.PartiallyFilled);
        this.strategy.onExecutionReportRedirected(report1);
        Assert.assertEquals((Object)OrderStatus.PartiallyFilled, (Object)this.strategy.getOrderStatus(orderID));
        ExecutionReport report2 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + System.nanoTime()), (String)orderID.getValue(), (OrderStatus)OrderStatus.Replaced);
        this.strategy.onExecutionReportRedirected(report2);
        Assert.assertEquals((Object)OrderStatus.Replaced, (Object)this.strategy.getOrderStatus(orderID));
        Assert.assertEquals((Object)OrderStatus.Replaced, (Object)this.strategy.getOrderStatus(report2.getOrderID()));
        ExecutionReport report3 = OrderHistoryManagerTest.generateExecutionReport((String)report2.getOrderID().getValue(), null, (OrderStatus)OrderStatus.Filled);
        this.strategy.onExecutionReportRedirected(report3);
        Assert.assertEquals((Object)OrderStatus.Filled, (Object)this.strategy.getOrderStatus(orderID));
        Assert.assertEquals((Object)OrderStatus.Filled, (Object)this.strategy.getOrderStatus(report2.getOrderID()));
        Assert.assertEquals((Object)OrderStatus.Filled, (Object)this.strategy.getOrderStatus(report3.getOrderID()));
        ExecutionReport report4 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + System.nanoTime()), (String)report3.getOrderID().getValue(), (OrderStatus)OrderStatus.Canceled);
        this.strategy.onExecutionReportRedirected(report4);
        Assert.assertEquals((Object)OrderStatus.Canceled, (Object)this.strategy.getOrderStatus(orderID));
        Assert.assertEquals((Object)OrderStatus.Canceled, (Object)this.strategy.getOrderStatus(report2.getOrderID()));
        Assert.assertEquals((Object)OrderStatus.Canceled, (Object)this.strategy.getOrderStatus(report3.getOrderID()));
        Assert.assertEquals((Object)OrderStatus.Canceled, (Object)this.strategy.getOrderStatus(report4.getOrderID()));
        OrderCancelReject report5 = OrderHistoryManagerTest.generateOrderCancelReject((String)("order-" + System.nanoTime()), (String)report4.getOrderID().getValue());
        this.strategy.onCancelRejectRedirected(report5);
        Assert.assertEquals((Object)OrderStatus.Rejected, (Object)this.strategy.getOrderStatus(orderID));
        Assert.assertEquals((Object)OrderStatus.Rejected, (Object)this.strategy.getOrderStatus(report2.getOrderID()));
        Assert.assertEquals((Object)OrderStatus.Rejected, (Object)this.strategy.getOrderStatus(report3.getOrderID()));
        Assert.assertEquals((Object)OrderStatus.Rejected, (Object)this.strategy.getOrderStatus(report4.getOrderID()));
        Assert.assertEquals((Object)OrderStatus.Rejected, (Object)this.strategy.getOrderStatus(report5.getOrderID()));
    }

    private void reset() throws Exception {
        this.servicesProvider.reset();
        this.strategy.initializeReportHistoryManager();
    }

    private void verifySentObjects(Object[] inExpectedObjects) throws Exception {
        Assert.assertTrue((boolean)Arrays.equals(inExpectedObjects, this.servicesProvider.sentObjects.toArray()));
    }

    private void verifyOpenOrders(OrderSingle[] inExpectedOrders) throws Exception {
        Object[] expectedOrderIDs = new OrderID[inExpectedOrders.length];
        int counter = 0;
        for (OrderSingle order : inExpectedOrders) {
            expectedOrderIDs[counter++] = order.getOrderID();
        }
        CollectionAssert.assertArrayPermutation((Object[])expectedOrderIDs, (Object[])this.strategy.getOpenOrderIDs().toArray(new OrderID[0]));
    }

    private void verifyLoggedEvents(String[] inExpectedMessageContents) throws Exception {
        Assert.assertEquals((long)inExpectedMessageContents.length, (long)this.servicesProvider.loggedEvents.size());
        int counter = 0;
        for (LogEvent event : this.servicesProvider.loggedEvents) {
            Assert.assertEquals((Object)inExpectedMessageContents[counter++], (Object)event.getMessage());
        }
    }

    private class MockRunningStrategy
    extends AbstractRunningStrategy {
        private final List<ExecutionReport> reports = new ArrayList<ExecutionReport>();
        private final List<OrderCancelReject> rejects = new ArrayList<OrderCancelReject>();

        private MockRunningStrategy() {
        }

        public void onTrade(TradeEvent inTrade) {
            throw new UnsupportedOperationException();
        }

        public void onBid(BidEvent inBid) {
            throw new UnsupportedOperationException();
        }

        public void onAsk(AskEvent inAsk) {
            throw new UnsupportedOperationException();
        }

        public void onMarketstat(MarketstatEvent inStatistics) {
            throw new UnsupportedOperationException();
        }

        public void onDividend(DividendEvent inDividend) {
            throw new UnsupportedOperationException();
        }

        public void onExecutionReport(ExecutionReport inExecutionReport) {
            this.reports.add(inExecutionReport);
        }

        public void onCancelReject(OrderCancelReject inCancelReject) {
            this.rejects.add(inCancelReject);
        }

        public void onOther(Object inEvent) {
            throw new UnsupportedOperationException();
        }

        public void onCallback(Object inData) {
            throw new UnsupportedOperationException();
        }

        public void onStart() {
            throw new UnsupportedOperationException();
        }

        public void onStop() {
            throw new UnsupportedOperationException();
        }
    }

    private class MockServicesProvider
    implements ServicesProvider {
        private final List<LogEvent> loggedEvents = new ArrayList<LogEvent>();
        private final List<Object> sentObjects = new ArrayList<Object>();

        private MockServicesProvider() {
        }

        public void send(Object inData) {
            this.sentObjects.add(inData);
        }

        public void cancelOrder(OrderCancel inCancel) {
            this.sentObjects.add(inCancel);
        }

        public void cancelReplace(OrderReplace inReplace) {
            this.sentObjects.add(inReplace);
        }

        public void sendSuggestion(Suggestion inSuggestion) {
            this.sentObjects.add(inSuggestion);
        }

        public void sendEvent(Event inEvent, String inProvider, String inNamespace) {
            throw new UnsupportedOperationException();
        }

        public void sendNotification(Notification inNotification) {
            throw new UnsupportedOperationException();
        }

        public void log(LogEvent inMessage) {
            this.loggedEvents.add(inMessage);
        }

        public int requestMarketData(MarketDataRequest inRequest) {
            throw new UnsupportedOperationException();
        }

        public int requestProcessedMarketData(MarketDataRequest inRequest, String[] inStatements, String inCEPSource, String inNamespace) {
            throw new UnsupportedOperationException();
        }

        public void cancelDataRequest(int inDataRequestID) {
            throw new UnsupportedOperationException();
        }

        public void cancelAllDataRequests() {
            throw new UnsupportedOperationException();
        }

        public int requestCEPData(String[] inStatements, String inSource, String inNamespace) {
            throw new UnsupportedOperationException();
        }

        public void sendMessage(Message inMessage, BrokerID inBroker) {
            throw new UnsupportedOperationException();
        }

        public void statusChanged(Status inOldStatus, Status inNewStatus) {
            throw new UnsupportedOperationException();
        }

        public DataFlowID createDataFlow(DataRequest[] inRequests, boolean inAppendDataSink) throws ModuleException {
            throw new UnsupportedOperationException();
        }

        public void cancelDataFlow(DataFlowID inDataFlowID) throws ModuleException {
            throw new UnsupportedOperationException();
        }

        public List<BrokerStatus> getBrokers() throws ConnectionException, ClientInitException {
            throw new UnsupportedOperationException();
        }

        public BigDecimal getPositionAsOf(Date inDate, Equity inEquity) throws ConnectionException, ClientInitException {
            throw new UnsupportedOperationException();
        }

        public Map<PositionKey<Equity>, BigDecimal> getAllPositionsAsOf(Date inDate) throws ConnectionException, ClientInitException {
            throw new UnsupportedOperationException();
        }

        public BigDecimal getFuturePositionAsOf(Date inDate, Future inFuture) throws ConnectionException, ClientInitException {
            throw new UnsupportedOperationException();
        }

        public Map<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(Date inDate) throws ConnectionException, ClientInitException {
            throw new UnsupportedOperationException();
        }

        public BigDecimal getOptionPositionAsOf(Date inDate, Option inOption) throws ConnectionException, ClientInitException {
            throw new UnsupportedOperationException();
        }

        public Map<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(Date inDate) throws ConnectionException, ClientInitException {
            throw new UnsupportedOperationException();
        }

        public Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(Date inDate, String ... inOptionRoots) throws ConnectionException, ClientInitException {
            throw new UnsupportedOperationException();
        }

        public String getUnderlying(String inOptionRoot) throws ConnectionException, ClientInitException {
            throw new UnsupportedOperationException();
        }

        public Collection<String> getOptionRoots(String inUnderlying) throws ConnectionException, ClientInitException {
            throw new UnsupportedOperationException();
        }

        public ModuleURN getURN() {
            throw new UnsupportedOperationException();
        }

        public Properties getUserData() throws ConnectionException, ClientInitException {
            throw new UnsupportedOperationException();
        }

        public void setUserData(Properties inData) throws ConnectionException, ClientInitException {
            throw new UnsupportedOperationException();
        }

        private void reset() {
            this.loggedEvents.clear();
            this.sentObjects.clear();
        }
    }

    private class MockStrategy
    implements Strategy {
        private MockStrategy() {
        }

        public void dataReceived(Object inData) {
            throw new UnsupportedOperationException();
        }

        public String getScript() {
            throw new UnsupportedOperationException();
        }

        public Language getLanguage() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            throw new UnsupportedOperationException();
        }

        public Properties getParameters() {
            throw new UnsupportedOperationException();
        }

        public void start() throws StrategyException {
            throw new UnsupportedOperationException();
        }

        public void stop() throws Exception {
            throw new UnsupportedOperationException();
        }

        public Status getStatus() {
            throw new UnsupportedOperationException();
        }

        public ServicesProvider getServicesProvider() {
            return AbstractRunningStrategyTest.this.servicesProvider;
        }

        public String getDefaultNamespace() {
            throw new UnsupportedOperationException();
        }

        public Executor getExecutor() {
            throw new UnsupportedOperationException();
        }
    }
}

