/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.client.Client;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.client.brokers.BrokersStatus;
import org.marketcetera.core.notifications.Notification;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.event.Event;
import org.marketcetera.event.EventTestBase;
import org.marketcetera.event.LogEvent;
import org.marketcetera.event.LogEventLevel;
import org.marketcetera.event.TradeEvent;
import org.marketcetera.marketdata.DateUtils;
import org.marketcetera.marketdata.MarketDataFeedTestBase;
import org.marketcetera.marketdata.MarketDataModuleTestBase;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.marketdata.MarketDataRequestBuilder;
import org.marketcetera.marketdata.bogus.BogusFeedModuleFactory;
import org.marketcetera.module.CopierModule;
import org.marketcetera.module.CopierModuleFactory;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.module.Messages;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleStateException;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.SinkDataListener;
import org.marketcetera.module.SinkModuleFactory;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.strategy.AbstractRunningStrategy;
import org.marketcetera.strategy.Language;
import org.marketcetera.strategy.OutputType;
import org.marketcetera.strategy.Status;
import org.marketcetera.strategy.StrategyImpl;
import org.marketcetera.strategy.StrategyMXBean;
import org.marketcetera.strategy.StrategyModule;
import org.marketcetera.strategy.StrategyModuleFactory;
import org.marketcetera.strategy.StrategyTestBase;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderSingleSuggestion;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.TimeInForce;
import org.marketcetera.trade.TypesTestBase;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.NamedThreadFactory;
import quickfix.Message;
import quickfix.UtcTimeStampField;
import quickfix.field.TransactTime;

public abstract class LanguageTestBase
extends StrategyTestBase {
    private final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("LanguageTestBase"));

    @Test
    public void compilesAndTestsCallbacks() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        ModuleURN strategyModule = this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null);
        this.verifyPropertyNonNull("onStart");
        this.doSuccessfulStartTest(strategyModule);
        this.stopStrategy(strategyModule);
        Assert.assertFalse((boolean)this.moduleManager.getModuleInfo(strategyModule).getState().isStarted());
        this.verifyPropertyNonNull("onStop");
    }

    @Test
    public void doesNotCompile() throws Exception {
        new ExpectedFailure<ModuleException>((I18NBoundMessage)FAILED_TO_START){

            protected void run() throws Exception {
                StrategyTestBase.StrategyCoordinates strategy = LanguageTestBase.this.getStrategyWillNotCompile();
                LanguageTestBase.this.verifyStrategyStartsAndStops(strategy.getName(), LanguageTestBase.this.getLanguage(), strategy.getFile(), null, null, null);
            }
        };
    }

    @Test
    public void wrongLanguage() throws Exception {
        final Language wrongLanguage = Language.values()[(this.getLanguage().ordinal() + 1) % Language.values().length];
        new ExpectedFailure<ModuleException>((I18NBoundMessage)FAILED_TO_START){

            protected void run() throws Exception {
                StrategyTestBase.StrategyCoordinates strategy = LanguageTestBase.this.getStrategyCompiles();
                LanguageTestBase.this.verifyStrategyStartsAndStops(strategy.getName(), wrongLanguage, strategy.getFile(), null, null, null);
            }
        };
    }

    @Test
    public void noStrategySubclass() throws Exception {
        new ExpectedFailure<ModuleException>((I18NBoundMessage)FAILED_TO_START){

            protected void run() throws Exception {
                StrategyTestBase.StrategyCoordinates strategy = LanguageTestBase.this.getStrategyWrongClass();
                LanguageTestBase.this.verifyStrategyStartsAndStops(strategy.getName(), LanguageTestBase.this.getLanguage(), strategy.getFile(), null, null, null);
            }
        };
    }

    @Test
    public void multipleClasses() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyMultipleClasses();
        this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null));
    }

    @Test
    public void noMatchingName() throws Exception {
        final StrategyTestBase.StrategyCoordinates strategy2 = this.getStrategyCompiles();
        new ExpectedFailure<ModuleException>((I18NBoundMessage)FAILED_TO_START){

            protected void run() throws Exception {
                LanguageTestBase.this.verifyStrategyStartsAndStops("SomeNameThatDoesNotMatch", LanguageTestBase.this.getLanguage(), strategy2.getFile(), null, null, null);
            }
        };
    }

    @Test
    public void almostEmptyStrategy() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getEmptyStrategy();
        ModuleURN strategyURN = this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null);
        this.verifyNullProperties();
        ModuleURN dataEmitterURN = this.createModule(StrategyTestBase.StrategyDataEmissionModule.Factory.PROVIDER_URN, new Object[0]);
        DataFlowID dataFlowID = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(dataEmitterURN, null), new DataRequest(strategyURN)}, false);
        this.moduleManager.cancel(dataFlowID);
        this.verifyPropertyNonNull("onAsk");
    }

    @Test
    public void parameterStrategy() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getParameterStrategy();
        Properties parameters = new Properties();
        parameters.setProperty("onAsk", "onAskValue");
        parameters.setProperty("onBid", "onBidValue");
        parameters.setProperty("onExecutionReport", "onExecutionReportValue");
        parameters.setProperty("onTrade", "onTradeValue");
        ModuleURN strategyURN = this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null);
        this.verifyNullProperties();
        ModuleURN dataEmitterURN = this.createModule(StrategyTestBase.StrategyDataEmissionModule.Factory.PROVIDER_URN, new Object[0]);
        DataFlowID dataFlowID = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(dataEmitterURN, null), new DataRequest(strategyURN)}, false);
        this.moduleManager.cancel(dataFlowID);
        this.verifyPropertyNonNull("onAsk");
        this.verifyPropertyNonNull("onBid");
        this.verifyPropertyNonNull("onTrade");
        this.verifyPropertyNonNull("onExecutionReport");
    }

    @Test
    public void runtimeError() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        parameters.setProperty("shouldFailOnStart", "true");
        final ModuleURN strategyURN = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{null, strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null});
        new ExpectedFailure<ModuleException>((I18NBoundMessage)FAILED_TO_START){

            protected void run() throws Exception {
                LanguageTestBase.this.moduleManager.start(strategyURN);
            }
        };
        this.verifyPropertyNull("onStart");
        this.verifyStrategyStatus(strategyURN, Status.FAILED);
        this.setPropertiesToNull();
        parameters.clear();
        AbstractRunningStrategy.setProperty((String)"shouldFailOnStop", (String)"true");
        ModuleURN strategyURN2 = this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null);
        this.doSuccessfulStartTest(strategyURN2);
        this.stopStrategy(strategyURN2);
        AbstractRunningStrategy.setProperty((String)"shouldFailOnStop", null);
        this.doCallbackFailsTest("shouldFailOnAsk", new String[]{"onBid", "onCancel", "onExecutionReport", "onTrade", "onOther", "onDividend"});
        this.doCallbackFailsTest("shouldFailOnBid", new String[]{"onAsk", "onCancel", "onExecutionReport", "onTrade", "onOther", "onDividend"});
        this.doCallbackFailsTest("shouldFailOnExecutionReport", new String[]{"onAsk", "onBid", "onCancel", "onTrade", "onOther", "onDividend"});
        this.doCallbackFailsTest("shouldFailOnTrade", new String[]{"onAsk", "onBid", "onCancel", "onExecutionReport", "onOther", "onDividend"});
        this.doCallbackFailsTest("shouldFailOnOther", new String[]{"onAsk", "onBid", "onCancel", "onExecutionReport", "onTrade", "onDividend"});
        this.doCallbackFailsTest("shouldFailOnDividend", new String[]{"onAsk", "onBid", "onCancel", "onExecutionReport", "onTrade", "onOther"});
    }

    @Test
    public void longRunningStart() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        parameters.setProperty("shouldLoopOnStart", "true");
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"loopDone"));
        final ModuleURN strategyURN = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{null, strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null});
        Future<ModuleURN> future = this.doAsynchronous(new Callable<ModuleURN>(){

            @Override
            public ModuleURN call() throws Exception {
                LanguageTestBase.this.moduleManager.start(strategyURN);
                return strategyURN;
            }
        });
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    return LanguageTestBase.this.getStatus(strategyURN).equals((Object)Status.STARTING);
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
        Thread.sleep(5000L);
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"loopDone"));
        this.verifyStrategyStatus(strategyURN, Status.STARTING);
        AbstractRunningStrategy.setProperty((String)"shouldStopLoop", (String)"true");
        future.get();
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return LanguageTestBase.this.getStatus(strategyURN).equals((Object)Status.RUNNING);
            }
        });
        Assert.assertNotNull((Object)AbstractRunningStrategy.getProperty((String)"loopDone"));
        this.moduleManager.stop(strategyURN);
    }

    @Test
    public void longRunningStop() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        parameters.setProperty("shouldLoopOnStop", "true");
        final ModuleURN strategyURN = this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null);
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"loopDone"));
        ArrayList thrownExceptions = new ArrayList();
        Future<ModuleURN> future = this.doAsynchronous(new Callable<ModuleURN>(){

            @Override
            public ModuleURN call() throws Exception {
                LanguageTestBase.this.moduleManager.stop(strategyURN);
                return strategyURN;
            }
        });
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return LanguageTestBase.this.getStatus(strategyURN).equals((Object)Status.STOPPING);
            }
        });
        Thread.sleep(5000L);
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"loopDone"));
        this.verifyStrategyStatus(strategyURN, Status.STOPPING);
        AbstractRunningStrategy.setProperty((String)"shouldStopLoop", (String)"true");
        future.get();
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return LanguageTestBase.this.getStatus(strategyURN).equals((Object)Status.STOPPED);
            }
        });
        Assert.assertNotNull((Object)AbstractRunningStrategy.getProperty((String)"loopDone"));
        Assert.assertTrue((boolean)thrownExceptions.isEmpty());
    }

    @Test
    public void restrictedActionsDuringStop() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        parameters.setProperty("shouldRequestDataOnStop", "bogus");
        parameters.setProperty("symbols", "METC");
        parameters.setProperty("shouldLoopOnStop", "true");
        final ModuleURN strategyURN = this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null);
        this.verifyNullProperties();
        this.verifyPropertyNull("requestID");
        this.verifyPropertyNull("loopDone");
        Future<ModuleURN> future = this.doAsynchronous(new Callable<ModuleURN>(){

            @Override
            public ModuleURN call() throws Exception {
                LanguageTestBase.this.moduleManager.stop(strategyURN);
                return strategyURN;
            }
        });
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return LanguageTestBase.this.getStatus(strategyURN).equals((Object)Status.STOPPING);
            }
        });
        Thread.sleep(5000L);
        AbstractRunningStrategy.setProperty((String)"shouldStopLoop", (String)"true");
        future.get();
        this.verifyStrategyStopped(strategyURN);
        this.verifyPropertyNonNull("loopDone");
        this.verifyNullProperties();
        Assert.assertEquals((Object)"0", (Object)this.verifyPropertyNonNull("requestID"));
    }

    @Test
    public void marketDataRequests() throws Exception {
        for (int apiStringCounter = 0; apiStringCounter <= 0; ++apiStringCounter) {
            this.getMarketData("bogus", "GOOG,YHOO,MSFT,METC", apiStringCounter == 0, new Properties());
            Thread.sleep(2500L);
            this.verifyPropertyNonNull("onAsk");
            this.verifyPropertyNonNull("onBid");
            this.verifyPropertyNonNull("onTrade");
            this.setPropertiesToNull();
        }
    }

    @Test
    public void marketDataRequestFromNonexistentSource() throws Exception {
        for (int apiStringCounter = 0; apiStringCounter <= 0; ++apiStringCounter) {
            this.verifyNullProperties();
            this.getMarketData("provider-does-not-exist", "GOOG,YHOO,MSFT,METC", apiStringCounter == 0, new Properties());
            Thread.sleep(2500L);
            this.verifyNullProperties();
        }
    }

    @Test
    public void marketDataRequestFromUnstartedSource() throws Exception {
        for (int apiStringCounter = 0; apiStringCounter <= 0; ++apiStringCounter) {
            Assert.assertTrue((boolean)this.moduleManager.getModuleInfo(BogusFeedModuleFactory.INSTANCE_URN).getState().isStarted());
            this.moduleManager.stop(BogusFeedModuleFactory.INSTANCE_URN);
            Assert.assertFalse((boolean)this.moduleManager.getModuleInfo(BogusFeedModuleFactory.INSTANCE_URN).getState().isStarted());
            this.getMarketData("bogus", "GOOG,YHOO,MSFT,METC", apiStringCounter == 0, new Properties());
            Thread.sleep(2500L);
            this.verifyNullProperties();
            this.moduleManager.start(BogusFeedModuleFactory.INSTANCE_URN);
            Assert.assertTrue((boolean)this.moduleManager.getModuleInfo(BogusFeedModuleFactory.INSTANCE_URN).getState().isStarted());
        }
    }

    @Test
    public void cancelMarketDataRequest() throws Exception {
        for (int apiStringCounter = 0; apiStringCounter <= 0; ++apiStringCounter) {
            ModuleURN strategyURN = this.getMarketData("bogus", "GOOG,YHOO,MSFT,METC", apiStringCounter == 0, new Properties());
            Thread.sleep(5000L);
            this.verifyPropertyNonNull("onAsk");
            this.verifyPropertyNonNull("onBid");
            this.verifyPropertyNonNull("onTrade");
            this.verifyPropertyNonNull("requestID");
            Properties properties = AbstractRunningStrategy.getProperties();
            long id = Long.parseLong(properties.getProperty("requestID"));
            this.setPropertiesToNull();
            properties.setProperty("shouldCancel", "true");
            properties.setProperty("requestID", Long.toString(id));
            this.getRunningStrategy(strategyURN).getRunningStrategy().onCallback((Object)this);
            Thread.sleep(2500L);
            this.setPropertiesToNull();
            Thread.sleep(2500L);
            this.verifyPropertyNull("onAsk");
            this.verifyPropertyNull("onBid");
        }
    }

    @Test
    public void cancelNonExistentMarketDataRequest() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        ModuleURN strategyURN = this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null);
        this.verifyNullProperties();
        Properties properties = new Properties();
        properties.setProperty("shouldCancel", "true");
        properties.setProperty("requestID", Long.toString(System.currentTimeMillis()));
        this.getRunningStrategy(strategyURN).getRunningStrategy().onCallback((Object)this);
        this.doSuccessfulStartTest(strategyURN);
    }

    @Test
    public void callbackAfter() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        parameters.setProperty("shouldRequestCallbackAfter", "1000");
        this.verifyPropertyNull("onCallback");
        this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null));
        Thread.sleep(2000L);
        this.verifyPropertyNonNull("onCallback");
    }

    @Test
    public void callbackEvery() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        parameters.setProperty("shouldRequestCallbackEvery", "1000,2000");
        this.verifyPropertyNull("onCallback");
        this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null));
        Thread.sleep(4000L);
        String numberOfCalls = this.verifyPropertyNonNull("onCallback");
        Assert.assertEquals((Object)"2", (Object)numberOfCalls);
    }

    @Test
    public void callbackAt() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        Date callbackAt = new Date(System.currentTimeMillis() + 2000L);
        parameters.setProperty("shouldRequestCallbackAt", Long.toString(callbackAt.getTime()));
        this.verifyPropertyNull("onCallback");
        this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null));
        Thread.sleep(2000L);
        this.verifyPropertyNonNull("onCallback");
    }

    @Test
    public void callbackAfterEarlier() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        parameters.setProperty("shouldRequestCallbackAfter", "-1000");
        this.verifyPropertyNull("onCallback");
        this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null));
        Thread.sleep(1000L);
        String numberOfCalls = this.verifyPropertyNonNull("onCallback");
        Assert.assertEquals((Object)"1", (Object)numberOfCalls);
    }

    @Test
    public void callbackEveryEarlier() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        parameters.setProperty("shouldRequestCallbackEvery", "-1000,2000");
        this.verifyPropertyNull("onCallback");
        this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null));
        Thread.sleep(3000L);
        String numberOfCalls = this.verifyPropertyNonNull("onCallback");
        Assert.assertEquals((Object)"2", (Object)numberOfCalls);
    }

    @Test
    public void callbackAtEarlier() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        Date callbackAt = new Date(System.currentTimeMillis() - 2000L);
        parameters.setProperty("shouldRequestCallbackAt", Long.toString(callbackAt.getTime()));
        this.verifyPropertyNull("onCallback");
        this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null));
        Thread.sleep(1000L);
        String callbackTime = this.verifyPropertyNonNull("onCallback");
        Assert.assertTrue((Long.parseLong(callbackTime) < System.currentTimeMillis() ? 1 : 0) != 0);
    }

    @Test
    public void callbackAfterZero() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        parameters.setProperty("shouldRequestCallbackAfter", "0");
        this.verifyPropertyNull("onCallback");
        this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null));
        Thread.sleep(1000L);
        String numberOfCalls = this.verifyPropertyNonNull("onCallback");
        Assert.assertEquals((Object)"1", (Object)numberOfCalls);
    }

    @Test
    public void callbackEveryZero() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        parameters.setProperty("shouldRequestCallbackEvery", "0,2000");
        this.verifyPropertyNull("onCallback");
        this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null));
        Thread.sleep(3000L);
        String numberOfCalls = this.verifyPropertyNonNull("onCallback");
        Assert.assertEquals((Object)"2", (Object)numberOfCalls);
    }

    @Test
    public void callbackAtZero() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        Date callbackAt = new Date();
        parameters.setProperty("shouldRequestCallbackAt", Long.toString(callbackAt.getTime()));
        this.verifyPropertyNull("onCallback");
        this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null));
        Thread.sleep(1000L);
        String numberOfCalls = this.verifyPropertyNonNull("onCallback");
        Assert.assertEquals((Object)"1", (Object)numberOfCalls);
    }

    @Test
    public void callbackEveryNegativeInterval() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        parameters.setProperty("shouldRequestCallbackEvery", "1000,-2000");
        this.verifyPropertyNull("onCallback");
        this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null));
        Thread.sleep(3000L);
        this.verifyPropertyNonNull("callbackEveryException");
        this.verifyPropertyNull("onCallback");
    }

    @Test
    public void callbackFails() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        parameters.setProperty("shouldFailOnCallback", "true");
        parameters.setProperty("shouldRequestCallbackAfter", "0");
        this.verifyPropertyNull("onCallback");
        ModuleURN strategyURN = this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null);
        this.doSuccessfulStartTest(strategyURN);
        Thread.sleep(1000L);
        this.verifyPropertyNull("onCallback");
        this.setPropertiesToNull();
        this.doSuccessfulStartTestNoVerification(strategyURN);
        this.verifyNonNullProperties();
    }

    @Test
    public void callbackAtWithNullPayload() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        Date callbackAt = new Date();
        parameters.setProperty("shouldRequestCallbackAt", Long.toString(callbackAt.getTime()));
        parameters.setProperty("callbackDataIsNull", "true");
        this.verifyPropertyNull("onCallback");
        this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null));
        Thread.sleep(1000L);
        String numberOfCalls = this.verifyPropertyNonNull("onCallback");
        Assert.assertEquals((Object)"1", (Object)numberOfCalls);
    }

    @Test
    public void simultaneousCallbacks() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        Date callbackAt = new Date(System.currentTimeMillis());
        parameters.setProperty("shouldRequestCallbackAt", Long.toString(callbackAt.getTime()));
        parameters.setProperty("shouldDoubleCallbacks", "true");
        this.verifyPropertyNull("onCallback");
        this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null));
        Thread.sleep(2000L);
        Assert.assertEquals((Object)"2", (Object)this.verifyPropertyNonNull("onCallback"));
    }

    @Test
    public void callbacksAfterStop() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        Date callbackAt = new Date(System.currentTimeMillis() + 6000L);
        parameters.setProperty("shouldRequestCallbackAt", Long.toString(callbackAt.getTime()));
        this.verifyPropertyNull("onCallback");
        ModuleURN strategyURN = this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null);
        this.doSuccessfulStartTest(strategyURN);
        this.stopStrategy(strategyURN);
        Assert.assertTrue((String)"The strategy should have been stopped before the callback - increase the callback delay", (System.currentTimeMillis() < callbackAt.getTime() ? 1 : 0) != 0);
        Thread.sleep(7500L);
        Assert.assertTrue((System.currentTimeMillis() > callbackAt.getTime() ? 1 : 0) != 0);
        this.verifyPropertyNull("onCallback");
    }

    @Test
    public void sequentialCallbacks() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        Date callbackAt = new Date(System.currentTimeMillis() + 1000L);
        parameters.setProperty("shouldRequestCallbackAt", Long.toString(callbackAt.getTime()));
        parameters.setProperty("shouldDoubleCallbacks", "true");
        Date callback2At = new Date(System.currentTimeMillis() + 1500L);
        AbstractRunningStrategy.getProperties().setProperty("shouldRequestCallbackAt", Long.toString(callback2At.getTime()));
        this.verifyPropertyNull("onCallback");
        this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null));
        Thread.sleep(2000L);
        Assert.assertEquals((Object)"4", (Object)this.verifyPropertyNonNull("onCallback"));
    }

    @Test
    public void suggestions() throws Exception {
        Properties parameters = new Properties();
        parameters.setProperty("orderShouldBeNull", "true");
        this.doSuggestionTest(parameters, new OrderSingleSuggestion[0]);
        parameters.clear();
        this.doSuggestionTest(parameters, new OrderSingleSuggestion[0]);
        parameters.setProperty("score", "1");
        this.doSuggestionTest(parameters, new OrderSingleSuggestion[0]);
        parameters.setProperty("identifier", "");
        this.doSuggestionTest(parameters, new OrderSingleSuggestion[0]);
        parameters.setProperty("identifier", "some identifier");
        OrderSingleSuggestion expectedSuggestion = Factory.getInstance().createOrderSingleSuggestion();
        expectedSuggestion.setScore(new BigDecimal("1"));
        expectedSuggestion.setIdentifier("some identifier");
        OrderSingle suggestedOrder = Factory.getInstance().createOrderSingle();
        expectedSuggestion.setOrder(suggestedOrder);
        this.doSuggestionTest(parameters, new OrderSingleSuggestion[]{expectedSuggestion});
        parameters.setProperty("account", "some account");
        suggestedOrder.setAccount("some account");
        expectedSuggestion.setOrder(suggestedOrder);
        this.doSuggestionTest(parameters, new OrderSingleSuggestion[]{expectedSuggestion});
        parameters.setProperty("orderType", OrderType.Market.name());
        suggestedOrder.setOrderType(OrderType.Market);
        expectedSuggestion.setOrder(suggestedOrder);
        this.doSuggestionTest(parameters, new OrderSingleSuggestion[]{expectedSuggestion});
        parameters.setProperty("price", "100.23");
        suggestedOrder.setPrice(new BigDecimal("100.23"));
        expectedSuggestion.setOrder(suggestedOrder);
        this.doSuggestionTest(parameters, new OrderSingleSuggestion[]{expectedSuggestion});
        parameters.setProperty("quantity", "10000");
        suggestedOrder.setQuantity(new BigDecimal("10000"));
        expectedSuggestion.setOrder(suggestedOrder);
        this.doSuggestionTest(parameters, new OrderSingleSuggestion[]{expectedSuggestion});
        parameters.setProperty("side", Side.Buy.name());
        suggestedOrder.setSide(Side.Buy);
        expectedSuggestion.setOrder(suggestedOrder);
        this.doSuggestionTest(parameters, new OrderSingleSuggestion[]{expectedSuggestion});
        parameters.setProperty("symbol", "METC");
        suggestedOrder.setInstrument((Instrument)new Equity("METC"));
        expectedSuggestion.setOrder(suggestedOrder);
        this.doSuggestionTest(parameters, new OrderSingleSuggestion[]{expectedSuggestion});
    }

    @Test
    public void sendMessages() throws Exception {
        Properties parameters = new Properties();
        Date messageDate = new Date();
        parameters.setProperty("date", Long.toString(messageDate.getTime()));
        parameters.setProperty("nullMessage", "true");
        this.doMessageTest(parameters, new FIXOrder[0]);
        parameters.clear();
        parameters.setProperty("date", Long.toString(messageDate.getTime()));
        parameters.setProperty("nullBroker", "true");
        this.doMessageTest(parameters, new FIXOrder[0]);
        parameters.clear();
        parameters.setProperty("date", Long.toString(messageDate.getTime()));
        Message msg = FIXVersion.FIX_SYSTEM.getMessageFactory().newBasicOrder();
        msg.setField((UtcTimeStampField)new TransactTime(messageDate));
        this.doMessageTest(parameters, new FIXOrder[]{Factory.getInstance().createOrder(msg, new BrokerID("some-broker"))});
    }

    @PerformanceTest
    public void startStop() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        ModuleURN strategyModule = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{"MyStrategy", strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null});
        int index = 0;
        while (index++ < 500) {
            this.startStrategy(strategyModule);
            this.stopStrategy(strategyModule);
        }
    }

    @PerformanceTest
    public void manyStrategiesStartStop() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        int index = 0;
        while (index++ < 500) {
            ModuleURN strategyModule = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{"MyStrategy", strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null});
            this.startStrategy(strategyModule);
            this.stopStrategy(strategyModule);
            this.moduleManager.deleteModule(strategyModule);
        }
    }

    @PerformanceTest
    public void manyStrategiesStartWithoutStop() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        int index = 0;
        while (index++ < 500) {
            ModuleURN strategyModule = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{null, strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null});
            this.moduleManager.start(strategyModule);
        }
    }

    @Test
    public void mxBeanOperations() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getParameterStrategy();
        ModuleURN strategyURN = this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null);
        this.verifyNullProperties();
        StrategyTestBase.MockRecorderModule outputRecorder = StrategyTestBase.MockRecorderModule.Factory.recorders.get(this.outputURN);
        Assert.assertNotNull((String)"Must be able to find the recorder created", (Object)((Object)outputRecorder));
        Assert.assertTrue((boolean)outputRecorder.getDataReceived().isEmpty());
        this.doSuccessfulStartTestNoVerification(strategyURN);
        this.verifyNullProperties();
        Assert.assertTrue((boolean)outputRecorder.getDataReceived().isEmpty());
        StrategyMXBean strategyProxy = this.getMXProxy(strategyURN);
        strategyProxy.setParameters("onAsk=true:emitSuggestion=true:emitMessage=true");
        this.doSuccessfulStartTestNoVerification(strategyURN);
        this.verifyNullProperties();
        Assert.assertTrue((boolean)outputRecorder.getDataReceived().isEmpty());
        this.stopStrategy(strategyURN);
        this.startStrategy(strategyURN);
        this.doSuccessfulStartTestNoVerification(strategyURN);
        this.verifyPropertyNonNull("onAsk");
        Assert.assertTrue((boolean)outputRecorder.getDataReceived().isEmpty());
        this.setPropertiesToNull();
        strategyProxy.setOutputDestination(this.outputURN.getValue());
        this.doSuccessfulStartTestNoVerification(strategyURN);
        this.verifyPropertyNonNull("onAsk");
        Assert.assertTrue((boolean)outputRecorder.getDataReceived().isEmpty());
        this.setPropertiesToNull();
        this.stopStrategy(strategyURN);
        this.startStrategy(strategyURN);
        this.doSuccessfulStartTestNoVerification(strategyURN);
        this.verifyPropertyNonNull("onAsk");
        Assert.assertEquals((long)2L, (long)outputRecorder.getDataReceived().size());
        strategyProxy.setParameters(null);
        strategyProxy.setOutputDestination(null);
        this.setPropertiesToNull();
        outputRecorder.resetDataReceived();
        this.stopStrategy(strategyURN);
        this.startStrategy(strategyURN);
        this.doSuccessfulStartTestNoVerification(strategyURN);
        this.verifyNullProperties();
        Assert.assertTrue((boolean)outputRecorder.getDataReceived().isEmpty());
    }

    @Test
    public void distinguishingSubscribers() throws Exception {
        ModuleURN alternateURN = this.createModule(StrategyTestBase.MockRecorderModule.Factory.PROVIDER_URN, new Object[0]);
        StrategyTestBase.StrategyCoordinates strategy = this.getSuggestionStrategy();
        Properties parameters = new Properties();
        parameters.setProperty("score", "1");
        parameters.setProperty("identifier", "some identifier");
        this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, this.outputURN);
        this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, alternateURN);
        StrategyTestBase.MockRecorderModule strategy1Recorder = StrategyTestBase.MockRecorderModule.Factory.recorders.get(this.outputURN);
        StrategyTestBase.MockRecorderModule strategy2Recorder = StrategyTestBase.MockRecorderModule.Factory.recorders.get(alternateURN);
        Assert.assertEquals((long)1L, (long)strategy1Recorder.getDataReceived().size());
        Assert.assertEquals((long)1L, (long)strategy2Recorder.getDataReceived().size());
    }

    @Test
    public void helperRedefinition() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy1 = this.getPart1Strategy();
        this.doSuccessfulStartTestNoVerification(this.createStrategy(strategy1.getName(), this.getLanguage(), strategy1.getFile(), null, null, null));
        StrategyTestBase.StrategyCoordinates strategy2 = this.getPart2Strategy();
        this.doSuccessfulStartTestNoVerification(this.createStrategy(strategy2.getName(), this.getLanguage(), strategy2.getFile(), null, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void notifications() throws Exception {
        Level startingLevel = Logger.getLogger((String)"user.messages").getLevel();
        try {
            Logger.getLogger((String)"user.messages").setLevel(Level.ALL);
            StrategyTestBase.MockRecorderModule.shouldIgnoreLogMessages = false;
            final StrategyTestBase.MockRecorderModule notificationSubscriber = StrategyTestBase.MockRecorderModule.Factory.recorders.get(this.outputURN);
            Assert.assertTrue((boolean)notificationSubscriber.getDataReceived().isEmpty());
            StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
            Properties parameters = new Properties();
            parameters.setProperty("shouldNotify", "true");
            this.doSuccessfulStartTest(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, this.outputURN));
            StrategyImpl runningStrategy = this.getRunningStrategy(this.theStrategy);
            MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return notificationSubscriber.getDataReceived().size() == 19;
                }
            });
            Assert.assertEquals((Object)"low subject", (Object)((Notification)notificationSubscriber.getDataReceived().get(0).getData()).getSubject());
            Assert.assertEquals((Object)"medium subject", (Object)((Notification)notificationSubscriber.getDataReceived().get(1).getData()).getSubject());
            Assert.assertEquals((Object)"high subject", (Object)((Notification)notificationSubscriber.getDataReceived().get(2).getData()).getSubject());
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(3).getData(), LogEventLevel.WARN, null, (I18NMessage)INVALID_LOG, new Serializable[]{String.valueOf(runningStrategy)});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(4).getData(), LogEventLevel.DEBUG, null, (I18NMessage)MESSAGE_1P, new Serializable[]{""});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(5).getData(), LogEventLevel.DEBUG, null, (I18NMessage)MESSAGE_1P, new Serializable[]{"Some statement"});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(6).getData(), LogEventLevel.DEBUG, null, (I18NMessage)MESSAGE_1P, new Serializable[]{"\u0645\u0646\u0632\u0644"});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(7).getData(), LogEventLevel.WARN, null, (I18NMessage)INVALID_LOG, new Serializable[]{String.valueOf(runningStrategy)});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(8).getData(), LogEventLevel.INFO, null, (I18NMessage)MESSAGE_1P, new Serializable[]{""});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(9).getData(), LogEventLevel.INFO, null, (I18NMessage)MESSAGE_1P, new Serializable[]{"Some statement"});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(10).getData(), LogEventLevel.INFO, null, (I18NMessage)MESSAGE_1P, new Serializable[]{"\u0645\u0646\u0632\u0644"});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(11).getData(), LogEventLevel.WARN, null, (I18NMessage)INVALID_LOG, new Serializable[]{String.valueOf(runningStrategy)});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(12).getData(), LogEventLevel.WARN, null, (I18NMessage)MESSAGE_1P, new Serializable[]{""});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(13).getData(), LogEventLevel.WARN, null, (I18NMessage)MESSAGE_1P, new Serializable[]{"Some statement"});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(14).getData(), LogEventLevel.WARN, null, (I18NMessage)MESSAGE_1P, new Serializable[]{"\u0645\u0646\u0632\u0644"});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(15).getData(), LogEventLevel.WARN, null, (I18NMessage)INVALID_LOG, new Serializable[]{String.valueOf(runningStrategy)});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(16).getData(), LogEventLevel.ERROR, null, (I18NMessage)MESSAGE_1P, new Serializable[]{""});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(17).getData(), LogEventLevel.ERROR, null, (I18NMessage)MESSAGE_1P, new Serializable[]{"Some statement"});
            LanguageTestBase.verifyEvent((LogEvent)notificationSubscriber.getDataReceived().get(18).getData(), LogEventLevel.ERROR, null, (I18NMessage)MESSAGE_1P, new Serializable[]{"\u0645\u0646\u0632\u0644"});
        }
        finally {
            Logger.getLogger((String)"user.messages").setLevel(startingLevel);
            StrategyTestBase.MockRecorderModule.shouldIgnoreLogMessages = true;
        }
    }

    @Test
    public void brokers() throws Exception {
        StrategyTestBase.MockClient.getBrokersFails = true;
        this.doBrokerTest(new BrokerStatus[0]);
        StrategyTestBase.MockClient.getBrokersFails = false;
        this.doBrokerTest(brokers.getBrokers().toArray(new BrokerStatus[brokers.getBrokers().size()]));
        brokers = new BrokersStatus(new ArrayList());
        this.doBrokerTest(new BrokerStatus[0]);
    }

    @Test
    public void orders() throws Exception {
        ArrayList<OrderSingle> cumulativeOrders = new ArrayList<OrderSingle>();
        ModuleURN strategy = this.generateOrders(this.getOrdersStrategy(), this.outputURN);
        AbstractRunningStrategy.setProperty((String)"orderShouldBeNull", (String)"true");
        this.doOrderTest(strategy, new OrderSingle[0], cumulativeOrders);
        AbstractRunningStrategy.getProperties().clear();
        OrderSingle expectedOrder = Factory.getInstance().createOrderSingle();
        cumulativeOrders.add(expectedOrder);
        AbstractRunningStrategy.setProperty((String)"account", (String)"some account");
        expectedOrder.setAccount("some account");
        AbstractRunningStrategy.setProperty((String)"orderType", (String)OrderType.Market.name());
        expectedOrder.setOrderType(OrderType.Market);
        AbstractRunningStrategy.setProperty((String)"price", (String)"100.23");
        expectedOrder.setPrice(new BigDecimal("100.23"));
        AbstractRunningStrategy.setProperty((String)"quantity", (String)"10000");
        expectedOrder.setQuantity(new BigDecimal("10000"));
        AbstractRunningStrategy.setProperty((String)"side", (String)Side.Buy.name());
        expectedOrder.setSide(Side.Buy);
        AbstractRunningStrategy.setProperty((String)"symbol", (String)"METC");
        expectedOrder.setInstrument((Instrument)new Equity("METC"));
        this.doOrderTest(strategy, new OrderSingle[]{expectedOrder}, cumulativeOrders);
        OrderSingle expectedOrder2 = Factory.getInstance().createOrderSingle();
        AbstractRunningStrategy.getProperties().clear();
        AbstractRunningStrategy.setProperty((String)"orderType", (String)OrderType.Market.name());
        AbstractRunningStrategy.setProperty((String)"quantity", (String)"10000");
        AbstractRunningStrategy.setProperty((String)"account", (String)"some other account");
        expectedOrder2.setAccount("some other account");
        AbstractRunningStrategy.setProperty((String)"price", (String)"400.50");
        expectedOrder2.setPrice(new BigDecimal("400.50"));
        AbstractRunningStrategy.setProperty((String)"symbol", (String)"GOOG");
        expectedOrder2.setInstrument((Instrument)new Equity("GOOG"));
        AbstractRunningStrategy.setProperty((String)"side", (String)Side.SellShort.name());
        expectedOrder2.setSide(Side.SellShort);
        expectedOrder2.setOrderType(OrderType.Market);
        expectedOrder2.setQuantity(new BigDecimal("10000"));
        cumulativeOrders.add(expectedOrder2);
        this.doOrderTest(strategy, new OrderSingle[]{expectedOrder2}, cumulativeOrders);
        OrderSingle expectedOrder3 = Factory.getInstance().createOrderSingle();
        AbstractRunningStrategy.getProperties().clear();
        AbstractRunningStrategy.setProperty((String)"orderType", (String)OrderType.Market.name());
        AbstractRunningStrategy.setProperty((String)"quantity", (String)"10000");
        AbstractRunningStrategy.setProperty((String)"account", (String)"still another account");
        expectedOrder3.setAccount("still another account");
        AbstractRunningStrategy.setProperty((String)"price", (String)"10000.25");
        expectedOrder3.setPrice(new BigDecimal("10000.25"));
        AbstractRunningStrategy.setProperty((String)"symbol", (String)"JAVA");
        expectedOrder3.setInstrument((Instrument)new Equity("JAVA"));
        AbstractRunningStrategy.setProperty((String)"side", (String)Side.Sell.name());
        expectedOrder3.setSide(Side.Sell);
        expectedOrder3.setOrderType(OrderType.Market);
        expectedOrder3.setQuantity(new BigDecimal("10000"));
        cumulativeOrders.add(expectedOrder3);
        this.doOrderTest(strategy, new OrderSingle[]{expectedOrder3}, cumulativeOrders);
        AbstractRunningStrategy.setProperty((String)"orderShouldBeNull", (String)"true");
        this.stopStrategy(strategy);
        this.startStrategy(strategy);
        cumulativeOrders.clear();
        this.doOrderTest(strategy, new OrderSingle[0], cumulativeOrders);
        AbstractRunningStrategy.setProperty((String)"orderShouldBeNull", (String)"");
        AbstractRunningStrategy.setProperty((String)"sendResult", (String)"");
        this.stopStrategy(strategy);
        Assert.assertEquals((Object)"true", (Object)AbstractRunningStrategy.getProperty((String)"sendResult"));
    }

    @Test
    public void other() throws Exception {
        this.theStrategy = this.createStrategy(this.getOtherStrategy().getName(), this.getLanguage(), this.getOtherStrategy().getFile(), null, null, this.outputURN);
        this.setPropertiesToNull();
        this.doOtherTest(this.theStrategy, new Object[0]);
        Assert.assertTrue((String)("Expected properties to be empty, but was: " + AbstractRunningStrategy.getProperties().toString()), (boolean)AbstractRunningStrategy.getProperties().isEmpty());
        AbstractRunningStrategy.setProperty((String)"sendNull", (String)"true");
        this.doOtherTest(this.theStrategy, new Object[0]);
        Assert.assertEquals((long)1L, (long)AbstractRunningStrategy.getProperties().size());
        Assert.assertEquals((Object)AbstractRunningStrategy.getProperty((String)"sendNull"), (Object)"true");
        this.setPropertiesToNull();
        AbstractRunningStrategy.setProperty((String)"sendString", (String)"true");
        this.doOtherTest(this.theStrategy, new Object[]{"test string"});
        Assert.assertEquals((String)("Properties were " + AbstractRunningStrategy.getProperties()), (long)1L, (long)AbstractRunningStrategy.getProperties().size());
        Assert.assertEquals((Object)AbstractRunningStrategy.getProperty((String)"sendString"), (Object)"true");
        this.setPropertiesToNull();
        AbstractRunningStrategy.setProperty((String)"sendTwo", (String)"true");
        this.doOtherTest(this.theStrategy, new Object[]{BigDecimal.ONE, BigDecimal.TEN});
        Assert.assertEquals((String)("Properties was " + AbstractRunningStrategy.getProperties()), (long)1L, (long)AbstractRunningStrategy.getProperties().size());
        Assert.assertEquals((Object)AbstractRunningStrategy.getProperty((String)"sendTwo"), (Object)"true");
        this.setPropertiesToNull();
        this.theStrategy = this.createStrategy(this.getOtherStrategy().getName(), this.getLanguage(), this.getOtherStrategy().getFile(), null, true, this.outputURN);
        AbstractRunningStrategy.setProperty((String)"sendTwo", (String)"true");
        this.doOtherTest(this.theStrategy, new Object[]{BigDecimal.ONE, BigDecimal.TEN});
        Assert.assertEquals((String)("Properties was " + AbstractRunningStrategy.getProperties()), (long)1L, (long)AbstractRunningStrategy.getProperties().size());
        Assert.assertEquals((Object)AbstractRunningStrategy.getProperty((String)"sendTwo"), (Object)"true");
    }

    @Test
    public void executionReports() throws Exception {
        this.generateOrders(this.getOrdersStrategy(), this.outputURN);
        this.doExecutionReportTest(0, false);
        StrategyTestBase.MockRecorderModule.shouldSendExecutionReports = false;
        this.doExecutionReportTest(0, true);
        StrategyTestBase.MockRecorderModule.shouldSendExecutionReports = true;
        StrategyTestBase.MockRecorderModule.shouldFullyFillOrders = false;
        this.doExecutionReportTest(1, true);
        StrategyTestBase.executionReportMultiplicity = 4;
        this.doExecutionReportTest(4, true);
    }

    @Test
    public void cancelAllOrders() throws Exception {
        StrategyTestBase.MockRecorderModule.shouldFullyFillOrders = false;
        ModuleURN strategy = this.generateOrders(this.getOrdersStrategy(), this.outputURN);
        AbstractRunningStrategy runningStrategy = (AbstractRunningStrategy)this.getRunningStrategy(strategy).getRunningStrategy();
        runningStrategy.initializeReportHistoryManager();
        AbstractRunningStrategy.setProperty((String)"cancelAll", (String)"true");
        runningStrategy.onTrade(this.tradeEvent);
        Assert.assertEquals((Object)"0", (Object)AbstractRunningStrategy.getProperty((String)"ordersCanceled"));
        AbstractRunningStrategy.setProperty((String)"price", (String)"1000");
        AbstractRunningStrategy.setProperty((String)"quantity", (String)"500");
        AbstractRunningStrategy.setProperty((String)"side", (String)Side.Sell.toString());
        AbstractRunningStrategy.setProperty((String)"symbol", (String)"METC");
        AbstractRunningStrategy.setProperty((String)"orderType", (String)OrderType.Market.name());
        AbstractRunningStrategy.setProperty((String)"quantity", (String)"10000");
        runningStrategy.onAsk(this.askEvent);
        runningStrategy.onTrade(this.tradeEvent);
        runningStrategy.onAsk(this.askEvent);
        runningStrategy.onAsk(this.askEvent);
        runningStrategy.onTrade(this.tradeEvent);
        AbstractRunningStrategy.setProperty((String)"ordersCanceled", (String)"0");
        runningStrategy.onAsk(this.askEvent);
        AbstractRunningStrategy.setProperty((String)"allOrdersCanceled", (String)"");
        this.stopStrategy(strategy);
        this.startStrategy(strategy);
        runningStrategy = (AbstractRunningStrategy)this.getRunningStrategy(strategy).getRunningStrategy();
        runningStrategy.onTrade(this.tradeEvent);
    }

    @Test
    public void cancelSingleOrder() throws Exception {
        StrategyTestBase.MockRecorderModule recorder = StrategyTestBase.MockRecorderModule.Factory.recorders.get(this.outputURN);
        Assert.assertNotNull((String)"Must be able to find the recorder created", (Object)((Object)recorder));
        AbstractRunningStrategy.setProperty((String)"price", (String)"100.23");
        AbstractRunningStrategy.setProperty((String)"quantity", (String)"10000");
        AbstractRunningStrategy.setProperty((String)"side", (String)Side.Buy.name());
        AbstractRunningStrategy.setProperty((String)"symbol", (String)"METC");
        AbstractRunningStrategy.setProperty((String)"orderType", (String)OrderType.Market.name());
        AbstractRunningStrategy.setProperty((String)"account", (String)("account-" + System.nanoTime()));
        ModuleURN strategy = this.generateOrders(this.getOrdersStrategy(), this.outputURN);
        AbstractRunningStrategy runningStrategy = (AbstractRunningStrategy)this.getRunningStrategy(strategy).getRunningStrategy();
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"orderCanceled"));
        runningStrategy.onOther((Object)this);
        Assert.assertEquals((Object)"false", (Object)AbstractRunningStrategy.getProperty((String)"orderCanceled"));
        AbstractRunningStrategy.setProperty((String)"orderCanceled", (String)"");
        runningStrategy.onOther((Object)new OrderID("this-order-does-not-exist-" + System.nanoTime()));
        Assert.assertEquals((Object)"false", (Object)AbstractRunningStrategy.getProperty((String)"orderCanceled"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"orderID"));
        runningStrategy.onAsk(this.askEvent);
        String orderIDString = AbstractRunningStrategy.getProperty((String)"orderID");
        Assert.assertNotNull((Object)orderIDString);
        this.stopStrategy(strategy);
        this.startStrategy(strategy);
        Assert.assertEquals((long)1L, (long)StrategyImpl.getRunningStrategies().size());
        AbstractRunningStrategy.setProperty((String)"orderCanceled", (String)"");
        runningStrategy = (AbstractRunningStrategy)this.getRunningStrategy(strategy).getRunningStrategy();
        runningStrategy.onOther((Object)new OrderID(orderIDString));
        Assert.assertEquals((Object)"false", (Object)AbstractRunningStrategy.getProperty((String)"orderCanceled"));
        AbstractRunningStrategy.setProperty((String)"executionReportsReceived", (String)"0");
        AbstractRunningStrategy.setProperty((String)"orderCanceled", (String)"");
        StrategyTestBase.MockRecorderModule.shouldSendExecutionReports = true;
        StrategyTestBase.MockRecorderModule.shouldFullyFillOrders = false;
        StrategyTestBase.executionReportMultiplicity = 1;
        runningStrategy.onAsk(this.askEvent);
        Assert.assertEquals((Object)"1", (Object)AbstractRunningStrategy.getProperty((String)"executionReportsReceived"));
        orderIDString = AbstractRunningStrategy.getProperty((String)"orderID");
        Assert.assertNotNull((Object)orderIDString);
        runningStrategy.onOther((Object)new OrderID(orderIDString));
        Assert.assertEquals((Object)"true", (Object)AbstractRunningStrategy.getProperty((String)"orderCanceled"));
        recorder.resetDataReceived();
        AbstractRunningStrategy.setProperty((String)"executionReportsReceived", (String)"0");
        AbstractRunningStrategy.setProperty((String)"orderCanceled", null);
        runningStrategy.onAsk(this.askEvent);
        Assert.assertEquals((Object)"1", (Object)AbstractRunningStrategy.getProperty((String)"executionReportsReceived"));
        Assert.assertEquals((String)recorder.getDataReceived().toString(), (long)1L, (long)recorder.getDataReceived().size());
        Assert.assertTrue((boolean)(recorder.getDataReceived().get(0).getData() instanceof OrderSingle));
        recorder.resetDataReceived();
        AbstractRunningStrategy.setProperty((String)"skipSubmitOrders", (String)"true");
        orderIDString = AbstractRunningStrategy.getProperty((String)"orderID");
        Assert.assertNotNull((Object)orderIDString);
        runningStrategy.onOther((Object)new OrderID(orderIDString));
        Assert.assertEquals((Object)"true", (Object)AbstractRunningStrategy.getProperty((String)"orderCanceled"));
        Assert.assertTrue((boolean)recorder.getDataReceived().isEmpty());
        recorder.resetDataReceived();
        AbstractRunningStrategy.setProperty((String)"executionReportsReceived", (String)"0");
        AbstractRunningStrategy.setProperty((String)"orderCanceled", null);
        runningStrategy.onAsk(this.askEvent);
        Assert.assertEquals((Object)"1", (Object)AbstractRunningStrategy.getProperty((String)"executionReportsReceived"));
        Assert.assertEquals((String)recorder.getDataReceived().toString(), (long)1L, (long)recorder.getDataReceived().size());
        Assert.assertTrue((boolean)(recorder.getDataReceived().get(0).getData() instanceof OrderSingle));
        String modifiedAccountName = "modified account-" + System.nanoTime();
        Assert.assertFalse((boolean)((OrderSingle)recorder.getDataReceived().get(0).getData()).getAccount().equals(modifiedAccountName));
        recorder.resetDataReceived();
        AbstractRunningStrategy.setProperty((String)"delaySubmitOrders", (String)"true");
        AbstractRunningStrategy.setProperty((String)"newAccountName", (String)modifiedAccountName);
        orderIDString = AbstractRunningStrategy.getProperty((String)"orderID");
        Assert.assertNotNull((Object)orderIDString);
        runningStrategy.onOther((Object)new OrderID(orderIDString));
        Assert.assertEquals((Object)"true", (Object)AbstractRunningStrategy.getProperty((String)"orderCanceled"));
        Assert.assertEquals((String)recorder.getDataReceived().toString(), (long)1L, (long)recorder.getDataReceived().size());
        Assert.assertTrue((boolean)(recorder.getDataReceived().get(0).getData() instanceof OrderCancel));
        OrderCancel orderCancel = (OrderCancel)recorder.getDataReceived().get(0).getData();
        Assert.assertEquals((Object)modifiedAccountName, (Object)orderCancel.getAccount());
        Assert.assertNull((Object)orderCancel.getBrokerOrderID());
        AbstractRunningStrategy.setProperty((String)"skipSubmitOrders", null);
        AbstractRunningStrategy.setProperty((String)"delaySubmitOrders", null);
        AbstractRunningStrategy.setProperty((String)"executionReportsReceived", (String)"0");
        AbstractRunningStrategy.setProperty((String)"orderCanceled", (String)"");
        StrategyTestBase.executionReportMultiplicity = 10;
        runningStrategy.onAsk(this.askEvent);
        Assert.assertEquals((Object)"10", (Object)AbstractRunningStrategy.getProperty((String)"executionReportsReceived"));
        orderIDString = AbstractRunningStrategy.getProperty((String)"orderID");
        Assert.assertNotNull((Object)orderIDString);
        runningStrategy.onOther((Object)new OrderID(orderIDString));
        Assert.assertEquals((Object)"true", (Object)AbstractRunningStrategy.getProperty((String)"orderCanceled"));
        AbstractRunningStrategy.setProperty((String)"orderCancelNull", (String)"");
        this.stopStrategy(strategy);
        Assert.assertEquals((Object)"true", (Object)AbstractRunningStrategy.getProperty((String)"orderCancelNull"));
    }

    @Test
    public void cancelReplace() throws Exception {
        StrategyTestBase.MockRecorderModule recorder = StrategyTestBase.MockRecorderModule.Factory.recorders.get(this.outputURN);
        Assert.assertNotNull((String)"Must be able to find the recorder created", (Object)((Object)recorder));
        StrategyTestBase.MockRecorderModule.shouldSendExecutionReports = false;
        AbstractRunningStrategy.setProperty((String)"price", (String)"100.23");
        AbstractRunningStrategy.setProperty((String)"quantity", (String)"10000");
        AbstractRunningStrategy.setProperty((String)"side", (String)Side.Buy.name());
        AbstractRunningStrategy.setProperty((String)"symbol", (String)"METC");
        AbstractRunningStrategy.setProperty((String)"timeInForce", (String)TimeInForce.Day.toString());
        AbstractRunningStrategy.setProperty((String)"orderType", (String)OrderType.Market.name());
        ModuleURN strategy = this.generateOrders(this.getOrdersStrategy(), this.outputURN);
        AbstractRunningStrategy runningStrategy = (AbstractRunningStrategy)this.getRunningStrategy(strategy).getRunningStrategy();
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"orderID"));
        runningStrategy.onAsk(this.askEvent);
        String orderIDString = AbstractRunningStrategy.getProperty((String)"orderID");
        Assert.assertEquals((long)1L, (long)runningStrategy.getSubmittedOrders().size());
        Assert.assertEquals((Object)OrderType.Market, (Object)((OrderSingle)runningStrategy.getSubmittedOrders().iterator().next()).getOrderType());
        Assert.assertNotNull((Object)orderIDString);
        AbstractRunningStrategy.setProperty((String)"orderID", null);
        AbstractRunningStrategy.setProperty((String)"newOrderID", (String)"");
        OrderSingle newOrder = Factory.getInstance().createOrderSingle();
        Assert.assertNotNull((Object)AbstractRunningStrategy.getProperty((String)"newOrderID"));
        BigDecimal quantity = new BigDecimal("1000.50");
        newOrder.setQuantity(quantity);
        newOrder.setPrice(new BigDecimal("1"));
        newOrder.setTimeInForce(TimeInForce.GoodTillCancel);
        newOrder.setInstrument((Instrument)new Equity("METC"));
        runningStrategy.onOther((Object)newOrder);
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"newOrderID"));
        OrderID unsubmittedOrderID = new OrderID("this-order-id-does-not-exist-" + System.nanoTime());
        AbstractRunningStrategy.setProperty((String)"orderID", (String)unsubmittedOrderID.toString());
        AbstractRunningStrategy.setProperty((String)"newOrderID", (String)"");
        Assert.assertNotNull((Object)AbstractRunningStrategy.getProperty((String)"newOrderID"));
        runningStrategy.onOther((Object)newOrder);
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"newOrderID"));
        AbstractRunningStrategy.setProperty((String)"orderID", (String)orderIDString);
        AbstractRunningStrategy.setProperty((String)"newOrderID", (String)"");
        runningStrategy.onOther((Object)"");
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"newOrderID"));
        StrategyTestBase.MockRecorderModule.shouldSendExecutionReports = true;
        StrategyTestBase.MockRecorderModule.shouldFullyFillOrders = false;
        StrategyTestBase.executionReportMultiplicity = 1;
        newOrder.setOrderID(new OrderID(orderIDString));
        List<ExecutionReport> reports = LanguageTestBase.generateExecutionReports(newOrder);
        for (ExecutionReport report : reports) {
            runningStrategy.onExecutionReportRedirected(report);
        }
        runningStrategy.onOther((Object)newOrder);
        String replaceIDString = AbstractRunningStrategy.getProperty((String)"newOrderID");
        Assert.assertNotNull((Object)replaceIDString);
        Assert.assertFalse((boolean)replaceIDString.equals(newOrder.getOrderID().toString()));
        runningStrategy.onAsk(this.askEvent);
        orderIDString = AbstractRunningStrategy.getProperty((String)"orderID");
        Assert.assertNotNull((Object)orderIDString);
        AbstractRunningStrategy.setProperty((String)"orderID", (String)orderIDString);
        recorder.resetDataReceived();
        AbstractRunningStrategy.setProperty((String)"skipSubmitOrders", (String)"true");
        runningStrategy.onOther((Object)newOrder);
        Assert.assertNotNull((Object)replaceIDString);
        Assert.assertTrue((boolean)recorder.getDataReceived().isEmpty());
        runningStrategy.onAsk(this.askEvent);
        recorder.resetDataReceived();
        orderIDString = AbstractRunningStrategy.getProperty((String)"orderID");
        Assert.assertNotNull((Object)orderIDString);
        AbstractRunningStrategy.setProperty((String)"orderID", (String)orderIDString);
        AbstractRunningStrategy.setProperty((String)"delaySubmitOrders", (String)"true");
        newOrder.setOrderType(OrderType.Market);
        runningStrategy.onOther((Object)newOrder);
        Assert.assertNotNull((Object)replaceIDString);
        Assert.assertEquals((String)recorder.getDataReceived().toString(), (long)1L, (long)recorder.getDataReceived().size());
        Object receivedData = recorder.getDataReceived().get(0).getData();
        Assert.assertTrue((String)("Object is " + receivedData), (boolean)(receivedData instanceof OrderReplace));
        OrderReplace receivedOrder = (OrderReplace)receivedData;
        Assert.assertNull((Object)receivedOrder.getBrokerOrderID());
        Assert.assertEquals((Object)quantity.add(BigDecimal.ONE), (Object)receivedOrder.getQuantity());
        AbstractRunningStrategy.setProperty((String)"delaySubmitOrders", null);
        AbstractRunningStrategy.setProperty((String)"skipSubmitOrders", null);
        StrategyTestBase.MockRecorderModule.shouldSendExecutionReports = true;
        StrategyTestBase.MockRecorderModule.shouldFullyFillOrders = false;
        StrategyTestBase.executionReportMultiplicity = 20;
        runningStrategy.onAsk(this.askEvent);
        Assert.assertNotNull((Object)AbstractRunningStrategy.getProperty((String)"orderID"));
        Assert.assertFalse((boolean)orderIDString.equals(AbstractRunningStrategy.getProperty((String)"orderID")));
        AbstractRunningStrategy.setProperty((String)"newOrderID", null);
        runningStrategy.onOther((Object)newOrder);
        Assert.assertNotNull((Object)AbstractRunningStrategy.getProperty((String)"newOrderID"));
        AbstractRunningStrategy.setProperty((String)"orderID", null);
        runningStrategy.onAsk(this.askEvent);
        orderIDString = AbstractRunningStrategy.getProperty((String)"orderID");
        Assert.assertNotNull((Object)orderIDString);
        this.stopStrategy(strategy);
        this.startStrategy(strategy);
        runningStrategy = (AbstractRunningStrategy)this.getRunningStrategy(strategy).getRunningStrategy();
        AbstractRunningStrategy.setProperty((String)"newOrderID", null);
        runningStrategy.onOther((Object)newOrder);
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"newOrderID"));
        AbstractRunningStrategy.setProperty((String)"orderReplaceNull", (String)"");
        AbstractRunningStrategy.setProperty((String)"shouldReplace", (String)"true");
        this.stopStrategy(strategy);
        Assert.assertEquals((Object)"true", (Object)AbstractRunningStrategy.getProperty((String)"orderReplaceNull"));
        AbstractRunningStrategy.setProperty((String)"orderType", (String)OrderType.Limit.name());
        recorder.resetDataReceived();
        this.startStrategy(strategy);
        runningStrategy = (AbstractRunningStrategy)this.getRunningStrategy(strategy).getRunningStrategy();
        AbstractRunningStrategy.setProperty((String)"newOrderID", null);
        runningStrategy.onAsk(this.askEvent);
        orderIDString = AbstractRunningStrategy.getProperty((String)"orderID");
        Assert.assertNotNull((Object)orderIDString);
        Assert.assertEquals((long)1L, (long)runningStrategy.getSubmittedOrders().size());
        Assert.assertEquals((Object)OrderType.Limit, (Object)((OrderSingle)runningStrategy.getSubmittedOrders().iterator().next()).getOrderType());
        recorder.resetDataReceived();
        AbstractRunningStrategy.setProperty((String)"orderID", (String)orderIDString);
        AbstractRunningStrategy.setProperty((String)"newOrderID", (String)"");
        newOrder.setPrice(new BigDecimal("12345"));
        runningStrategy.onOther((Object)newOrder);
        receivedData = recorder.getDataReceived().get(0).getData();
        Assert.assertTrue((String)("Object is " + receivedData), (boolean)(receivedData instanceof OrderReplace));
        receivedOrder = (OrderReplace)receivedData;
        Assert.assertEquals((Object)new BigDecimal("12345"), (Object)receivedOrder.getPrice());
    }

    @Test
    public void positionAsOf() throws Exception {
        Instrument validEquity = null;
        for (Instrument instrument : positions.keySet()) {
            if (!(instrument instanceof Equity)) continue;
            validEquity = instrument;
            break;
        }
        Assert.assertNotNull(validEquity);
        StrategyTestBase.Position position = (StrategyTestBase.Position)positions.get(validEquity);
        Assert.assertNotNull((Object)position);
        String invalidSymbol = "there-is-no-position-for-this-symbol-" + System.nanoTime();
        Assert.assertFalse((boolean)positions.containsKey(new Equity(invalidSymbol)));
        this.doPositionAsOfTest(null, new Date(), null);
        this.doPositionAsOfTest(invalidSymbol, new Date(), null);
        this.doPositionAsOfTest(validEquity.getSymbol(), null, null);
        StrategyTestBase.MockClient.getPositionFails = true;
        this.doPositionAsOfTest(validEquity.getSymbol(), new Date(), null);
        StrategyTestBase.MockClient.getPositionFails = false;
        getClientFails = true;
        this.doPositionAsOfTest(validEquity.getSymbol(), new Date(), null);
        getClientFails = false;
        StrategyTestBase.Interval<BigDecimal> openingBalance = position.getPositionView().get(0);
        this.doPositionAsOfTest(validEquity.getSymbol(), new Date(openingBalance.getDate().getTime() - 1000L), BigDecimal.ZERO);
        List<StrategyTestBase.Interval<BigDecimal>> view = position.getPositionView();
        int median = view.size() / 2;
        Assert.assertTrue((String)("Position " + position + " contains no data!"), (median > 0 ? 1 : 0) != 0);
        StrategyTestBase.Interval<BigDecimal> dataPoint = position.getPositionView().get(median);
        Date date = dataPoint.getDate();
        BigDecimal expectedValue = position.getPositionAt(date);
        Assert.assertEquals((String)("value at " + date + ": " + position), (Object)dataPoint.getValue(), (Object)expectedValue);
        Assert.assertTrue((date.getTime() < System.currentTimeMillis() ? 1 : 0) != 0);
        this.doPositionAsOfTest(validEquity.getSymbol(), date, expectedValue);
        date = new Date();
        expectedValue = position.getPositionAt(date);
        dataPoint = view.get(view.size() - 1);
        Assert.assertEquals((String)("value at " + date + ": " + position), (Object)dataPoint.getValue(), (Object)expectedValue);
        this.doPositionAsOfTest(validEquity.getSymbol(), date, expectedValue);
        date = new Date(System.currentTimeMillis() + 1209600000L);
        expectedValue = position.getPositionAt(date);
        dataPoint = view.get(view.size() - 1);
        Assert.assertEquals((String)("value at " + date + ": " + position), (Object)dataPoint.getValue(), (Object)expectedValue);
        this.doPositionAsOfTest(validEquity.getSymbol(), date, expectedValue);
    }

    @Test
    public void allPositionsAsOf() throws Exception {
        this.doAllPositionsAsOfTest(null, null);
        StrategyTestBase.MockClient.getPositionFails = true;
        this.doAllPositionsAsOfTest(new Date(), null);
        StrategyTestBase.MockClient.getPositionFails = false;
        Date date = new Date();
        for (StrategyTestBase.Position position : positions.values()) {
            if (!(position.getInstrument() instanceof Equity)) continue;
            date = new Date(Math.min(date.getTime(), position.getPositionView().get(0).getDate().getTime()));
        }
        StrategyTestBase.MockClient client = new StrategyTestBase.MockClient();
        date = new Date(date.getTime() - 1000L);
        this.doAllPositionsAsOfTest(date, client.getAllEquityPositionsAsOf(date));
        date = new Date(date.getTime() + 2000L);
        Assert.assertTrue((date.getTime() < System.currentTimeMillis() ? 1 : 0) != 0);
        this.doAllPositionsAsOfTest(date, client.getAllEquityPositionsAsOf(date));
        date = new Date();
        this.doAllPositionsAsOfTest(date, client.getAllEquityPositionsAsOf(date));
        date = new Date(System.currentTimeMillis() + 1209600000L);
        this.doAllPositionsAsOfTest(date, client.getAllEquityPositionsAsOf(date));
    }

    @Test
    public void optionPositionAsOf() throws Exception {
        Option validOption = null;
        for (Instrument instrument : positions.keySet()) {
            if (!(instrument instanceof Option)) continue;
            validOption = (Option)instrument;
            break;
        }
        Assert.assertNotNull(validOption);
        StrategyTestBase.Position position = (StrategyTestBase.Position)positions.get(validOption);
        Assert.assertNotNull((Object)position);
        String invalidSymbol = "there-is-no-position-for-this-symbol-" + System.nanoTime();
        Option invalidOption = new Option(invalidSymbol, DateUtils.dateToString((Date)new Date(), (DateTimeFormatter)DateUtils.DAYS), EventTestBase.generateDecimalValue(), OptionType.Call);
        Assert.assertFalse((boolean)positions.containsKey(invalidOption));
        this.doOptionPositionAsOfTest(null, validOption.getExpiry(), validOption.getStrikePrice(), validOption.getType(), new Date(), null);
        this.doOptionPositionAsOfTest(validOption.getSymbol(), null, validOption.getStrikePrice(), validOption.getType(), new Date(), null);
        this.doOptionPositionAsOfTest(validOption.getSymbol(), validOption.getExpiry(), null, validOption.getType(), new Date(), null);
        this.doOptionPositionAsOfTest(validOption.getSymbol(), validOption.getExpiry(), validOption.getStrikePrice(), null, new Date(), null);
        this.doOptionPositionAsOfTest(validOption.getSymbol(), validOption.getExpiry(), validOption.getStrikePrice(), validOption.getType(), null, null);
        this.doOptionPositionAsOfTest(invalidOption.getSymbol(), invalidOption.getExpiry(), invalidOption.getStrikePrice(), invalidOption.getType(), new Date(), null);
        StrategyTestBase.MockClient.getPositionFails = true;
        this.doOptionPositionAsOfTest(validOption.getSymbol(), validOption.getExpiry(), validOption.getStrikePrice(), validOption.getType(), new Date(), null);
        StrategyTestBase.MockClient.getPositionFails = false;
        StrategyTestBase.Interval<BigDecimal> openingBalance = position.getPositionView().get(0);
        this.doOptionPositionAsOfTest(validOption.getSymbol(), validOption.getExpiry(), validOption.getStrikePrice(), validOption.getType(), new Date(openingBalance.getDate().getTime() - 1000L), BigDecimal.ZERO);
        List<StrategyTestBase.Interval<BigDecimal>> view = position.getPositionView();
        int median = view.size() / 2;
        Assert.assertTrue((String)("Position " + position + " contains no data!"), (median > 0 ? 1 : 0) != 0);
        StrategyTestBase.Interval<BigDecimal> dataPoint = position.getPositionView().get(median);
        Date date = dataPoint.getDate();
        BigDecimal expectedValue = position.getPositionAt(date);
        Assert.assertEquals((String)("value at " + date + ": " + position), (Object)dataPoint.getValue(), (Object)expectedValue);
        Assert.assertTrue((date.getTime() < System.currentTimeMillis() ? 1 : 0) != 0);
        this.doOptionPositionAsOfTest(validOption.getSymbol(), validOption.getExpiry(), validOption.getStrikePrice(), validOption.getType(), date, expectedValue);
        date = new Date();
        expectedValue = position.getPositionAt(date);
        dataPoint = view.get(view.size() - 1);
        Assert.assertEquals((String)("value at " + date + ": " + position), (Object)dataPoint.getValue(), (Object)expectedValue);
        this.doOptionPositionAsOfTest(validOption.getSymbol(), validOption.getExpiry(), validOption.getStrikePrice(), validOption.getType(), date, expectedValue);
        date = new Date(System.currentTimeMillis() + 1209600000L);
        expectedValue = position.getPositionAt(date);
        dataPoint = view.get(view.size() - 1);
        Assert.assertEquals((String)("value at " + date + ": " + position), (Object)dataPoint.getValue(), (Object)expectedValue);
        this.doOptionPositionAsOfTest(validOption.getSymbol(), validOption.getExpiry(), validOption.getStrikePrice(), validOption.getType(), date, expectedValue);
    }

    @Test
    public void allOptionPositionsAsOf() throws Exception {
        this.doAllOptionPositionsAsOfTest(null, null);
        StrategyTestBase.MockClient.getPositionFails = true;
        this.doAllOptionPositionsAsOfTest(new Date(), null);
        StrategyTestBase.MockClient.getPositionFails = false;
        Date date = new Date();
        for (StrategyTestBase.Position position : positions.values()) {
            if (!(position.getInstrument() instanceof Option)) continue;
            date = new Date(Math.min(date.getTime(), position.getPositionView().get(0).getDate().getTime()));
        }
        StrategyTestBase.MockClient client = new StrategyTestBase.MockClient();
        date = new Date(date.getTime() - 1000L);
        this.doAllOptionPositionsAsOfTest(date, client.getAllOptionPositionsAsOf(date));
        date = new Date(date.getTime() + 2000L);
        Assert.assertTrue((date.getTime() < System.currentTimeMillis() ? 1 : 0) != 0);
        this.doAllOptionPositionsAsOfTest(date, client.getAllOptionPositionsAsOf(date));
        date = new Date();
        this.doAllOptionPositionsAsOfTest(date, client.getAllOptionPositionsAsOf(date));
        date = new Date(System.currentTimeMillis() + 1209600000L);
        this.doAllOptionPositionsAsOfTest(date, client.getAllOptionPositionsAsOf(date));
    }

    @Test
    public void optionPositionsAsOf() throws Exception {
        StrategyTestBase.MockClient client = new StrategyTestBase.MockClient();
        Option validOption1 = null;
        Option validOption2 = null;
        for (Instrument instrument : positions.keySet()) {
            if (instrument instanceof Option && validOption1 == null) {
                validOption1 = (Option)instrument;
                continue;
            }
            if (!(instrument instanceof Option) || validOption2 != null) continue;
            validOption2 = (Option)instrument;
        }
        Assert.assertNotNull(validOption1);
        Assert.assertNotNull(validOption2);
        StrategyTestBase.Position position1 = (StrategyTestBase.Position)positions.get(validOption1);
        StrategyTestBase.Position position2 = (StrategyTestBase.Position)positions.get(validOption2);
        Assert.assertNotNull((Object)position1);
        Assert.assertNotNull((Object)position2);
        String invalidSymbol = "there-is-no-position-for-this-symbol-" + System.nanoTime();
        Option invalidOption = new Option(invalidSymbol, DateUtils.dateToString((Date)new Date(), (DateTimeFormatter)DateUtils.DAYS), EventTestBase.generateDecimalValue(), OptionType.Call);
        Assert.assertFalse((boolean)positions.containsKey(invalidOption));
        this.doOptionPositionsAsOfTest(null, new Date(), null, null);
        this.doOptionPositionsAsOfTest(new String[0], new Date(), null, null);
        String[] optionRoots = new String[]{validOption1.getSymbol(), invalidOption.getSymbol(), null};
        Date date = new Date();
        this.doOptionPositionsAsOfTest(optionRoots, date, null, client.getOptionPositionsAsOf(date, optionRoots));
        this.doOptionPositionsAsOfTest(new String[]{validOption1.getSymbol()}, null, null, null);
        optionRoots = new String[]{invalidOption.getSymbol()};
        date = new Date();
        this.doOptionPositionsAsOfTest(optionRoots, date, null, client.getOptionPositionsAsOf(date, optionRoots));
        StrategyTestBase.MockClient.getPositionFails = true;
        this.doOptionPositionsAsOfTest(new String[]{validOption1.getSymbol()}, new Date(), null, null);
        StrategyTestBase.MockClient.getPositionFails = false;
        optionRoots = new String[]{validOption1.getSymbol(), validOption2.getSymbol()};
        StrategyTestBase.Interval<BigDecimal> openingBalance1 = position1.getPositionView().get(0);
        StrategyTestBase.Interval<BigDecimal> openingBalance2 = position2.getPositionView().get(0);
        date = new Date(Math.min(openingBalance1.getDate().getTime(), openingBalance2.getDate().getTime()) - 1000L);
        this.doOptionPositionsAsOfTest(optionRoots, date, null, client.getOptionPositionsAsOf(date, optionRoots));
        List<StrategyTestBase.Interval<BigDecimal>> view = position1.getPositionView();
        int median = view.size() / 2;
        Assert.assertTrue((String)("Position " + position1 + " contains no data!"), (median > 0 ? 1 : 0) != 0);
        StrategyTestBase.Interval<BigDecimal> dataPoint = position1.getPositionView().get(median);
        date = dataPoint.getDate();
        Assert.assertTrue((date.getTime() < System.currentTimeMillis() ? 1 : 0) != 0);
        this.doOptionPositionsAsOfTest(optionRoots, date, null, client.getOptionPositionsAsOf(date, optionRoots));
        date = new Date();
        this.doOptionPositionsAsOfTest(optionRoots, date, null, client.getOptionPositionsAsOf(date, optionRoots));
        date = new Date(System.currentTimeMillis() + 1209600000L);
        this.doOptionPositionsAsOfTest(optionRoots, date, null, client.getOptionPositionsAsOf(date, optionRoots));
        Properties parameters = new Properties();
        parameters.setProperty("nullOptionRoot", "true");
        this.doOptionPositionsAsOfTest(new String[]{validOption1.getSymbol()}, date, parameters, null);
        parameters.clear();
        parameters.setProperty("emptyOptionRoot", "true");
        this.doOptionPositionsAsOfTest(new String[]{validOption1.getSymbol()}, date, parameters, null);
    }

    @Test
    public void underlying() throws Exception {
        StrategyTestBase.MockClient client = new StrategyTestBase.MockClient();
        Option validOption = null;
        for (Instrument instrument : positions.keySet()) {
            if (!(instrument instanceof Option)) continue;
            validOption = (Option)instrument;
            break;
        }
        Assert.assertNotNull(validOption);
        Assert.assertTrue((boolean)underlyings.containsKey(validOption.getSymbol()));
        String invalidSymbol = "there-is-no-underlying-for-this-symbol-" + System.nanoTime();
        Assert.assertFalse((boolean)underlyings.containsKey(invalidSymbol));
        this.doUnderlyingTest(null, null);
        this.doUnderlyingTest("", null);
        this.doUnderlyingTest(invalidSymbol, null);
        StrategyTestBase.MockClient.getPositionFails = true;
        this.doUnderlyingTest(validOption.getSymbol(), null);
        StrategyTestBase.MockClient.getPositionFails = false;
        this.doUnderlyingTest(validOption.getSymbol(), client.getUnderlying(validOption.getSymbol()));
    }

    @Test
    public void optionRoots() throws Exception {
        StrategyTestBase.MockClient client = new StrategyTestBase.MockClient();
        String underlyingSymbol = (String)roots.keySet().iterator().next();
        Assert.assertNotNull((Object)underlyingSymbol);
        String invalidUnderlyingSymbol = "not-an-underlying-symbol";
        Assert.assertFalse((boolean)roots.keySet().contains(invalidUnderlyingSymbol));
        this.doOptionRootsTest(null, null);
        this.doOptionRootsTest("", null);
        this.doOptionRootsTest(invalidUnderlyingSymbol, client.getOptionRoots(invalidUnderlyingSymbol));
        StrategyTestBase.MockClient.getPositionFails = true;
        this.doOptionRootsTest(underlyingSymbol, null);
        StrategyTestBase.MockClient.getPositionFails = false;
        this.doOptionRootsTest(underlyingSymbol, client.getOptionRoots(underlyingSymbol));
    }

    @Test
    public void strategiesOfSameClass() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy1 = this.getPart1Strategy();
        ModuleURN strategy1URN = this.createStrategy(strategy1.getName(), this.getLanguage(), strategy1.getFile(), null, null, null);
        ModuleURN strategy2URN = this.createStrategy(strategy1.getName(), this.getLanguage(), strategy1.getFile(), null, null, null);
        this.doSuccessfulStartTestNoVerification(strategy1URN);
        this.doSuccessfulStartTestNoVerification(strategy2URN);
        Set runningStrategies = StrategyImpl.getRunningStrategies();
        Assert.assertEquals((long)2L, (long)runningStrategies.size());
        for (StrategyImpl runningStrategy : runningStrategies) {
            runningStrategy.getRunningStrategy().onCallback(null);
        }
        Assert.assertEquals((Object)"2", (Object)AbstractRunningStrategy.getProperty((String)"onCallback"));
        String strategyName1 = AbstractRunningStrategy.getProperty((String)"callback1");
        String strategyName2 = AbstractRunningStrategy.getProperty((String)"callback2");
        Assert.assertFalse((boolean)strategyName1.equals(strategyName2));
    }

    @Test
    public void redefinedStrategy() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy1 = this.getPart1Strategy();
        StrategyTestBase.StrategyCoordinates strategy2 = this.getPart1RedefinedStrategy();
        ModuleURN strategy1URN = this.createStrategy(strategy1.getName(), this.getLanguage(), strategy1.getFile(), null, null, null);
        ModuleURN strategy2URN = this.createStrategy(strategy2.getName(), this.getLanguage(), strategy2.getFile(), null, null, null);
        this.doSuccessfulStartTestNoVerification(strategy1URN);
        this.doSuccessfulStartTestNoVerification(strategy2URN);
        this.setPropertiesToNull();
        Set runningStrategies = StrategyImpl.getRunningStrategies();
        Assert.assertEquals((long)2L, (long)runningStrategies.size());
        for (StrategyImpl runningStrategy : runningStrategies) {
            runningStrategy.getRunningStrategy().onAsk(this.askEvent);
        }
        Properties properties = AbstractRunningStrategy.getProperties();
        int askCounter = 0;
        for (Object key : properties.keySet()) {
            String keyString = (String)key;
            if (!keyString.startsWith("ask")) continue;
            ++askCounter;
            Assert.assertTrue((boolean)properties.getProperty(keyString).startsWith("part1"));
        }
        Assert.assertEquals((long)2L, (long)askCounter);
    }

    @Test
    public void cep() throws Exception {
        String validEsperStatement1 = "select * from trade where instrumentAsString='METC'";
        String validEsperStatement2 = "select * from ask where instrumentAsString='ORCL'";
        String validSystemStatement1 = "select * from trade";
        String validSystemStatement2 = "select * from ask";
        String invalidStatement = "this statement is not syntactically valid";
        Event[] events = new Event[]{EventTestBase.generateEquityTradeEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("METC"), (String)"Q", (BigDecimal)new BigDecimal("1"), (BigDecimal)new BigDecimal("100")), EventTestBase.generateEquityTradeEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("ORCL"), (String)"Q", (BigDecimal)new BigDecimal("2"), (BigDecimal)new BigDecimal("200")), EventTestBase.generateEquityAskEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("METC"), (String)"Q", (BigDecimal)new BigDecimal("3"), (BigDecimal)new BigDecimal("300")), EventTestBase.generateEquityAskEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("ORCL"), (String)"Q", (BigDecimal)new BigDecimal("4"), (BigDecimal)new BigDecimal("400")), EventTestBase.generateEquityBidEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("METC"), (String)"Q", (BigDecimal)new BigDecimal("5"), (BigDecimal)new BigDecimal("500")), EventTestBase.generateEquityBidEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("ORCL"), (String)"Q", (BigDecimal)new BigDecimal("6"), (BigDecimal)new BigDecimal("600"))};
        String[] sources = new String[]{null, "esper", "system"};
        String[][] statements = new String[][]{{null}, new String[0], {invalidStatement}, {validSystemStatement1, validSystemStatement2}, {validSystemStatement1}, {validEsperStatement1}, {validEsperStatement1, validEsperStatement2}};
        for (int sourceCounter = 0; sourceCounter < sources.length; ++sourceCounter) {
            block24: for (int statementCounter = 0; statementCounter < statements.length; ++statementCounter) {
                SLF4JLoggerProxy.debug(LanguageTestBase.class, (String)"{}:{}", (Object[])new Object[]{sourceCounter, statementCounter});
                List<OrderSingleSuggestion> suggestions = this.doCEPTest(sources[sourceCounter], statements[statementCounter], events, true);
                switch (sourceCounter) {
                    case 0: {
                        Assert.assertTrue((boolean)suggestions.isEmpty());
                        continue block24;
                    }
                    case 1: {
                        switch (statementCounter) {
                            case 0: {
                                Assert.assertTrue((boolean)suggestions.isEmpty());
                                continue block24;
                            }
                            case 1: {
                                Assert.assertTrue((boolean)suggestions.isEmpty());
                                continue block24;
                            }
                            case 2: {
                                Assert.assertTrue((boolean)suggestions.isEmpty());
                                continue block24;
                            }
                            case 3: {
                                Assert.assertEquals((long)2L, (long)suggestions.size());
                                this.verifyCEPSuggestion("METC", new BigDecimal("3"), new BigDecimal("300"), suggestions.get(0));
                                this.verifyCEPSuggestion("ORCL", new BigDecimal("4"), new BigDecimal("400"), suggestions.get(1));
                                continue block24;
                            }
                            case 4: {
                                Assert.assertEquals((long)2L, (long)suggestions.size());
                                this.verifyCEPSuggestion("METC", new BigDecimal("1"), new BigDecimal("100"), suggestions.get(0));
                                this.verifyCEPSuggestion("ORCL", new BigDecimal("2"), new BigDecimal("200"), suggestions.get(1));
                                continue block24;
                            }
                            case 5: {
                                Assert.assertEquals((long)1L, (long)suggestions.size());
                                this.verifyCEPSuggestion("METC", new BigDecimal("1"), new BigDecimal("100"), suggestions.get(0));
                                continue block24;
                            }
                            case 6: {
                                Assert.assertEquals((long)1L, (long)suggestions.size());
                                this.verifyCEPSuggestion("ORCL", new BigDecimal("4"), new BigDecimal("400"), suggestions.get(0));
                                continue block24;
                            }
                        }
                        Assert.fail((String)"Unexpected statement");
                        continue block24;
                    }
                    case 2: {
                        switch (statementCounter) {
                            case 0: {
                                Assert.assertTrue((boolean)suggestions.isEmpty());
                                continue block24;
                            }
                            case 1: {
                                Assert.assertTrue((boolean)suggestions.isEmpty());
                                continue block24;
                            }
                            case 2: {
                                Assert.assertTrue((boolean)suggestions.isEmpty());
                                continue block24;
                            }
                            case 3: {
                                Assert.assertEquals((long)2L, (long)suggestions.size());
                                this.verifyCEPSuggestion("METC", new BigDecimal("1"), new BigDecimal("100"), suggestions.get(0));
                                this.verifyCEPSuggestion("ORCL", new BigDecimal("2"), new BigDecimal("200"), suggestions.get(1));
                                continue block24;
                            }
                            case 4: {
                                Assert.assertEquals((long)2L, (long)suggestions.size());
                                this.verifyCEPSuggestion("METC", new BigDecimal("1"), new BigDecimal("100"), suggestions.get(0));
                                this.verifyCEPSuggestion("ORCL", new BigDecimal("2"), new BigDecimal("200"), suggestions.get(1));
                                continue block24;
                            }
                            case 5: {
                                Assert.assertTrue((boolean)suggestions.isEmpty());
                                continue block24;
                            }
                            case 6: {
                                Assert.assertTrue((boolean)suggestions.isEmpty());
                                continue block24;
                            }
                        }
                        Assert.fail((String)"Unexpected statement");
                    }
                    default: {
                        Assert.fail((String)"Unexpected source");
                    }
                }
            }
        }
    }

    @Test
    public void cancelSingleCep() throws Exception {
        Event[] events = new Event[]{EventTestBase.generateEquityTradeEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("METC"), (String)"Q", (BigDecimal)new BigDecimal("1"), (BigDecimal)new BigDecimal("100")), EventTestBase.generateEquityTradeEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("ORCL"), (String)"Q", (BigDecimal)new BigDecimal("2"), (BigDecimal)new BigDecimal("200")), EventTestBase.generateEquityAskEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("METC"), (String)"Q", (BigDecimal)new BigDecimal("3"), (BigDecimal)new BigDecimal("300")), EventTestBase.generateEquityAskEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("ORCL"), (String)"Q", (BigDecimal)new BigDecimal("4"), (BigDecimal)new BigDecimal("400")), EventTestBase.generateEquityBidEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("METC"), (String)"Q", (BigDecimal)new BigDecimal("5"), (BigDecimal)new BigDecimal("500")), EventTestBase.generateEquityBidEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("ORCL"), (String)"Q", (BigDecimal)new BigDecimal("6"), (BigDecimal)new BigDecimal("600"))};
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"requestID"));
        List<OrderSingleSuggestion> suggestions = this.doCEPTest("esper", new String[]{"select * from trade"}, events, false);
        Assert.assertEquals((long)2L, (long)suggestions.size());
        String requestIDString = AbstractRunningStrategy.getProperty((String)"requestID");
        Assert.assertNotNull((Object)requestIDString);
        int badID = 10500;
        Assert.assertFalse((Integer.parseInt(requestIDString) == badID ? 1 : 0) != 0);
        AbstractRunningStrategy.setProperty((String)"shouldCancelCEPData", (String)"true");
        AbstractRunningStrategy.setProperty((String)"requestID", (String)Integer.toString(badID));
        StrategyImpl strategy = this.getRunningStrategy(this.theStrategy);
        strategy.getRunningStrategy().onOther((Object)this);
        ModuleURN cepModuleURN = new ModuleURN("metc:cep:esper:" + strategy.getDefaultNamespace());
        Assert.assertEquals((long)0L, (long)this.getReceivedSuggestions(this.outputURN).size());
        this.feedEventsToCEP(events, cepModuleURN);
        Assert.assertEquals((long)2L, (long)this.getReceivedSuggestions(this.outputURN).size());
        AbstractRunningStrategy.setProperty((String)"requestID", (String)requestIDString);
        Assert.assertEquals((long)0L, (long)this.getReceivedSuggestions(this.outputURN).size());
        strategy.getRunningStrategy().onOther((Object)this);
        this.feedEventsToCEP(events, cepModuleURN);
        Assert.assertEquals((long)0L, (long)this.getReceivedSuggestions(this.outputURN).size());
    }

    @Test
    public void cancelAllCep() throws Exception {
        Event[] events = new Event[]{EventTestBase.generateEquityTradeEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("METC"), (String)"Q", (BigDecimal)new BigDecimal("1"), (BigDecimal)new BigDecimal("100")), EventTestBase.generateEquityTradeEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("ORCL"), (String)"Q", (BigDecimal)new BigDecimal("2"), (BigDecimal)new BigDecimal("200")), EventTestBase.generateEquityAskEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("METC"), (String)"Q", (BigDecimal)new BigDecimal("3"), (BigDecimal)new BigDecimal("300")), EventTestBase.generateEquityAskEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("ORCL"), (String)"Q", (BigDecimal)new BigDecimal("4"), (BigDecimal)new BigDecimal("400")), EventTestBase.generateEquityBidEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("METC"), (String)"Q", (BigDecimal)new BigDecimal("5"), (BigDecimal)new BigDecimal("500")), EventTestBase.generateEquityBidEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("ORCL"), (String)"Q", (BigDecimal)new BigDecimal("6"), (BigDecimal)new BigDecimal("600"))};
        Assert.assertEquals((long)2L, (long)this.doCEPTest("esper", new String[]{"select * from trade"}, events, false).size());
        StrategyImpl strategy = this.getRunningStrategy(this.theStrategy);
        strategy.getRunningStrategy().onCallback((Object)this);
        ModuleURN cepModuleURN = new ModuleURN("metc:cep:esper:" + strategy.getDefaultNamespace());
        this.feedEventsToCEP(events, cepModuleURN);
        Assert.assertEquals((long)0L, (long)this.getReceivedSuggestions(this.outputURN).size());
        strategy.getRunningStrategy().onCallback((Object)this);
        this.feedEventsToCEP(events, cepModuleURN);
        Assert.assertEquals((long)0L, (long)this.getReceivedSuggestions(this.outputURN).size());
    }

    @Test
    public void sendEventToCEP() throws Exception {
        StrategyTestBase.StrategyCoordinates strategyFile = this.getEventStrategy();
        this.theStrategy = this.createStrategy(strategyFile.getName(), this.getLanguage(), strategyFile.getFile(), null, null, null);
        AbstractRunningStrategy.setProperty((String)"source", (String)"esper");
        StrategyImpl strategy = this.getRunningStrategy(this.theStrategy);
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"ask"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"askCount"));
        AbstractRunningStrategy.setProperty((String)"nilSource", (String)"true");
        strategy.getRunningStrategy().onOther((Object)this.askEvent);
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"ask"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"askCount"));
        AbstractRunningStrategy.setProperty((String)"nilSource", null);
        AbstractRunningStrategy.setProperty((String)"nilEvent", (String)"true");
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"ask"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"askCount"));
        strategy.getRunningStrategy().onOther((Object)this.askEvent);
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"ask"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"askCount"));
        AbstractRunningStrategy.setProperty((String)"nilEvent", null);
        AbstractRunningStrategy.setProperty((String)"source", (String)"");
        strategy.getRunningStrategy().onOther((Object)this.askEvent);
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"ask"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"askCount"));
        AbstractRunningStrategy.setProperty((String)"source", (String)"this-cep-provider-does-not-exist");
        strategy.getRunningStrategy().onOther((Object)this.askEvent);
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"ask"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"askCount"));
        AbstractRunningStrategy.setProperty((String)"source", (String)"esper");
        strategy.getRunningStrategy().onOther((Object)this.askEvent);
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"ask"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"askCount"));
        AbstractRunningStrategy.setProperty((String)"shouldRequestCEPData", (String)"true");
        String[] statements = new String[]{"select * from ask"};
        AbstractRunningStrategy.setProperty((String)"statements", (String)this.createConsolidatedCEPStatement(statements));
        strategy.getRunningStrategy().onCallback((Object)this);
        strategy.getRunningStrategy().onOther((Object)this.askEvent);
        Assert.assertEquals((Object)"1", (Object)AbstractRunningStrategy.getProperty((String)"askCount"));
        Assert.assertEquals((Object)this.askEvent.toString(), (Object)AbstractRunningStrategy.getProperty((String)"ask"));
        MarketDataModuleTestBase.DataSink dataSink = new MarketDataModuleTestBase.DataSink();
        this.moduleManager.addSinkListener((SinkDataListener)dataSink);
        this.stopStrategy(this.theStrategy);
        Map sinkData = dataSink.getAllData();
        Assert.assertEquals((long)1L, (long)sinkData.keySet().size());
        DataFlowID dataFlowID = (DataFlowID)sinkData.keySet().iterator().next();
        Assert.assertNotNull((Object)dataFlowID);
        List data = (List)sinkData.get(dataFlowID);
        Assert.assertEquals((long)1L, (long)data.size());
        Assert.assertTrue((String)("Expected " + data.get(0) + " to be a TradeEvent"), (boolean)(data.get(0) instanceof TradeEvent));
    }

    @Test
    public void sendEvent() throws Exception {
        ModuleURN alternateURN = this.createModule(StrategyTestBase.MockRecorderModule.Factory.PROVIDER_URN, new Object[0]);
        StrategyTestBase.MockRecorderModule eventSubscriber = StrategyTestBase.MockRecorderModule.Factory.recorders.get(this.outputURN);
        StrategyTestBase.MockRecorderModule allSubscriber = StrategyTestBase.MockRecorderModule.Factory.recorders.get(alternateURN);
        StrategyTestBase.StrategyCoordinates strategyFile = this.getEventStrategy();
        this.theStrategy = this.createStrategy(strategyFile.getName(), this.getLanguage(), strategyFile.getFile(), null, null, null);
        StrategyImpl strategy = this.getRunningStrategy(this.theStrategy);
        Assert.assertTrue((boolean)eventSubscriber.getDataReceived().isEmpty());
        Assert.assertTrue((boolean)allSubscriber.getDataReceived().isEmpty());
        AbstractRunningStrategy.setProperty((String)"eventOnlyTest", (String)"true");
        AbstractRunningStrategy.setProperty((String)"nilEvent", (String)"true");
        strategy.getRunningStrategy().onOther((Object)this.askEvent);
        Assert.assertTrue((boolean)eventSubscriber.getDataReceived().isEmpty());
        Assert.assertTrue((boolean)allSubscriber.getDataReceived().isEmpty());
        AbstractRunningStrategy.setProperty((String)"nilEvent", null);
        strategy.getRunningStrategy().onOther((Object)this.askEvent);
        Assert.assertTrue((boolean)eventSubscriber.getDataReceived().isEmpty());
        Assert.assertTrue((boolean)allSubscriber.getDataReceived().isEmpty());
        DataFlowID eventSubscription = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(this.theStrategy, (Object)OutputType.EVENTS), new DataRequest(this.outputURN)}, false);
        DataFlowID allSubscription = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(this.theStrategy, (Object)OutputType.ALL), new DataRequest(alternateURN)}, false);
        strategy.getRunningStrategy().onOther((Object)this.askEvent);
        Assert.assertEquals((long)1L, (long)eventSubscriber.getDataReceived().size());
        Assert.assertEquals((long)1L, (long)allSubscriber.getDataReceived().size());
        Assert.assertEquals((Object)this.askEvent, (Object)eventSubscriber.getDataReceived().get(0).getData());
        Assert.assertEquals((Object)this.askEvent, (Object)allSubscriber.getDataReceived().get(0).getData());
        eventSubscriber.resetDataReceived();
        this.moduleManager.cancel(eventSubscription);
        this.moduleManager.cancel(allSubscription);
        MarketDataModuleTestBase.DataSink dataSink = new MarketDataModuleTestBase.DataSink();
        this.moduleManager.addSinkListener((SinkDataListener)dataSink);
        this.stopStrategy(this.theStrategy);
        Map sinkData = dataSink.getAllData();
        Assert.assertEquals((long)1L, (long)sinkData.keySet().size());
        DataFlowID dataFlowID = (DataFlowID)sinkData.keySet().iterator().next();
        Assert.assertNotNull((Object)dataFlowID);
        List data = (List)sinkData.get(dataFlowID);
        Assert.assertEquals((long)1L, (long)data.size());
        Assert.assertTrue((String)("Expected " + data.get(0) + " to be a TradeEvent"), (boolean)(data.get(0) instanceof TradeEvent));
    }

    @Test
    public void processedMarketDataRequests() throws Exception {
        for (int apiCounter = 0; apiCounter <= 1; ++apiCounter) {
            boolean useStringAPI = apiCounter == 1;
            AbstractRunningStrategy.getProperties().clear();
            if (useStringAPI) {
                AbstractRunningStrategy.setProperty((String)"useStringAPI", (String)"true");
            }
            String symbols = "METC,ORCL,GOOG,YHOO";
            String marketDataSource = "bogus";
            String compressedStatements = this.createConsolidatedCEPStatement(new String[]{"select * from ask where instrumentAsString='METC'"});
            String cepSource = "esper";
            AbstractRunningStrategy.setProperty((String)"symbols", (String)symbols);
            AbstractRunningStrategy.setProperty((String)"marketDataSource", (String)marketDataSource);
            AbstractRunningStrategy.setProperty((String)"statements", (String)compressedStatements);
            AbstractRunningStrategy.setProperty((String)"cepSource", (String)cepSource);
            this.doProcessedMarketDataRequestVerification(false);
            AbstractRunningStrategy.setProperty((String)"symbols", null);
            this.executeProcessedMarketDataRequest(false, false);
            AbstractRunningStrategy.setProperty((String)"symbols", (String)"");
            this.executeProcessedMarketDataRequest(false, false);
            AbstractRunningStrategy.setProperty((String)"symbols", (String)symbols);
            AbstractRunningStrategy.setProperty((String)"marketDataSource", null);
            this.executeProcessedMarketDataRequest(false, true);
            AbstractRunningStrategy.setProperty((String)"marketDataSource", (String)"");
            this.executeProcessedMarketDataRequest(false, true);
            AbstractRunningStrategy.setProperty((String)"marketDataSource", (String)marketDataSource);
            AbstractRunningStrategy.setProperty((String)"statements", null);
            this.executeProcessedMarketDataRequest(false, true);
            AbstractRunningStrategy.setProperty((String)"statements", (String)this.createConsolidatedCEPStatement(new String[0]));
            this.executeProcessedMarketDataRequest(false, true);
            AbstractRunningStrategy.setProperty((String)"statements", (String)compressedStatements);
            AbstractRunningStrategy.setProperty((String)"cepSource", null);
            this.executeProcessedMarketDataRequest(false, true);
            AbstractRunningStrategy.setProperty((String)"cepSource", (String)"");
            this.executeProcessedMarketDataRequest(false, true);
            AbstractRunningStrategy.setProperty((String)"cepSource", (String)cepSource);
            this.moduleManager.stop(this.bogusDataFeedURN);
            this.executeProcessedMarketDataRequest(false, true);
            this.moduleManager.start(this.bogusDataFeedURN);
            this.executeProcessedMarketDataRequest(true, true);
            AbstractRunningStrategy.setProperty((String)"cancelCep", (String)"true");
            this.theStrategy = this.createStrategy(this.getCombinedStrategy().getName(), this.getLanguage(), this.getCombinedStrategy().getFile(), null, null, null);
            AbstractRunningStrategy runningStrategy = (AbstractRunningStrategy)this.getRunningStrategy(this.theStrategy).getRunningStrategy();
            runningStrategy.onCallback((Object)this);
        }
    }

    @Test
    public void stateChanges() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        parameters.setProperty("shouldLoopOnStart", "true");
        parameters.setProperty("shouldLoopOnStop", "true");
        this.verifyPropertyNull("loopDone");
        this.verifyPropertyNull("onStartBegins");
        final ModuleURN strategyURN = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{null, strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null});
        final ArrayList thrownExceptions = new ArrayList();
        Thread helperThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LanguageTestBase.this.moduleManager.start(strategyURN);
                }
                catch (ModuleException e) {
                    thrownExceptions.add(e);
                }
            }
        });
        helperThread.start();
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    return LanguageTestBase.this.getStatus(strategyURN).equals((Object)Status.STARTING) && AbstractRunningStrategy.getProperty((String)"onStartBegins") != null;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
        AbstractRunningStrategy.setProperty((String)"onStartBegins", null);
        new ExpectedFailure<ModuleStateException>((I18NMessage)Messages.MODULE_NOT_STARTED_STATE_INCORRECT, new Object[]{strategyURN.toString(), ExpectedFailure.IGNORE, ExpectedFailure.IGNORE}){

            protected void run() throws Exception {
                LanguageTestBase.this.moduleManager.start(strategyURN);
            }
        };
        this.verifyStrategyStatus(strategyURN, Status.STARTING);
        new ExpectedFailure<ModuleStateException>((I18NMessage)Messages.MODULE_NOT_STOPPED_STATE_INCORRECT, new Object[]{strategyURN.toString(), ExpectedFailure.IGNORE, ExpectedFailure.IGNORE}){

            protected void run() throws Exception {
                LanguageTestBase.this.moduleManager.stop(strategyURN);
            }
        };
        AbstractRunningStrategy.setProperty((String)"shouldStopLoop", (String)"true");
        helperThread.join();
        this.verifyStrategyReady(strategyURN);
        this.verifyStrategyStatus(strategyURN, Status.RUNNING);
        new ExpectedFailure<ModuleStateException>((I18NMessage)Messages.MODULE_NOT_STARTED_STATE_INCORRECT, new Object[]{strategyURN.toString(), ExpectedFailure.IGNORE, ExpectedFailure.IGNORE}){

            protected void run() throws Exception {
                LanguageTestBase.this.moduleManager.start(strategyURN);
            }
        };
        this.setPropertiesToNull();
        helperThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LanguageTestBase.this.moduleManager.stop(strategyURN);
                }
                catch (ModuleException e) {
                    thrownExceptions.add(e);
                }
            }
        });
        helperThread.start();
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return LanguageTestBase.this.getStatus(strategyURN).equals((Object)Status.STOPPING) && AbstractRunningStrategy.getProperty((String)"onStopBegins") != null;
            }
        });
        AbstractRunningStrategy.setProperty((String)"onStopBegins", null);
        Assert.assertFalse((boolean)this.moduleManager.getModuleInfo(strategyURN).getState().isStarted());
        new ExpectedFailure<ModuleStateException>((I18NMessage)Messages.MODULE_NOT_STOPPED_STATE_INCORRECT, new Object[]{strategyURN.toString(), ExpectedFailure.IGNORE, ExpectedFailure.IGNORE}){

            protected void run() throws Exception {
                LanguageTestBase.this.moduleManager.stop(strategyURN);
            }
        };
        new ExpectedFailure<ModuleStateException>((I18NMessage)Messages.MODULE_NOT_STARTED_STATE_INCORRECT, new Object[]{strategyURN.toString(), ExpectedFailure.IGNORE, ExpectedFailure.IGNORE}){

            protected void run() throws Exception {
                LanguageTestBase.this.moduleManager.start(strategyURN);
            }
        };
        AbstractRunningStrategy.setProperty((String)"shouldStopLoop", (String)"true");
        helperThread.join();
        this.verifyStrategyStopped(strategyURN);
        this.verifyStrategyStatus(strategyURN, Status.STOPPED);
        Assert.assertFalse((boolean)this.moduleManager.getModuleInfo(strategyURN).getState().isStarted());
        new ExpectedFailure<ModuleStateException>((I18NMessage)Messages.MODULE_NOT_STOPPED_STATE_INCORRECT, new Object[]{strategyURN.toString(), ExpectedFailure.IGNORE, ExpectedFailure.IGNORE}){

            protected void run() throws Exception {
                LanguageTestBase.this.moduleManager.stop(strategyURN);
            }
        };
        this.moduleManager.start(strategyURN);
        this.verifyStrategyReady(strategyURN);
        this.verifyStrategyStatus(strategyURN, Status.RUNNING);
        AbstractRunningStrategy.setProperty((String)"shouldFailOnStop", (String)"true");
        this.stopStrategy(strategyURN);
        this.verifyStrategyStatus(strategyURN, Status.FAILED);
        AbstractRunningStrategy.setProperty((String)"shouldFailOnStop", null);
        new ExpectedFailure<ModuleStateException>((I18NMessage)Messages.MODULE_NOT_STOPPED_STATE_INCORRECT, new Object[]{strategyURN.toString(), ExpectedFailure.IGNORE, ExpectedFailure.IGNORE}){

            protected void run() throws Exception {
                LanguageTestBase.this.moduleManager.stop(strategyURN);
            }
        };
        this.moduleManager.start(strategyURN);
        this.verifyStrategyReady(strategyURN);
        this.moduleManager.stop(strategyURN);
    }

    @Test
    public void statistics() throws Exception {
        this.verifyPropertyNull("onStatistics");
        Properties parameters = new Properties();
        parameters.setProperty("content", "MARKET_STAT");
        this.getMarketData("bogus", "GOOG,YHOO,MSFT,METC", false, parameters);
        this.verifyPropertyNonNull("onStatistics");
    }

    @Test
    public void createDataFlows() throws Exception {
        ModuleURN invalidURN = new ModuleURN("metc:something:something");
        ModuleURN validUnstartedURN = this.moduleManager.createModule(StrategyTestBase.MockRecorderModule.Factory.PROVIDER_URN, new Object[0]);
        ModuleURN validURNNotEmitter = SinkModuleFactory.INSTANCE_URN;
        ModuleURN validURNNotReceiver = BogusFeedModuleFactory.INSTANCE_URN;
        Assert.assertFalse((boolean)this.moduleManager.getModuleInfo(SinkModuleFactory.INSTANCE_URN).isEmitter());
        ModuleURN dataEmitterURN = this.createModule(StrategyTestBase.StrategyDataEmissionModule.Factory.PROVIDER_URN, new Object[0]);
        Properties parameters = new Properties();
        this.doDataFlowTest(parameters, false);
        parameters.setProperty("urns", dataEmitterURN.getValue());
        this.doDataFlowTest(parameters, false);
        parameters.setProperty("urns", validUnstartedURN.getValue());
        parameters.setProperty("useStrategyURN", "true");
        this.doDataFlowTest(parameters, false);
        parameters.setProperty("urns", invalidURN.getValue());
        this.doDataFlowTest(parameters, false);
        parameters.setProperty("urns", validURNNotEmitter.getValue());
        this.doDataFlowTest(parameters, false);
        parameters.setProperty("urns", dataEmitterURN.getValue() + "," + validURNNotReceiver.getValue());
        this.doDataFlowTest(parameters, false);
        parameters.setProperty("urns", dataEmitterURN.getValue());
        this.doDataFlowTest(parameters, true);
        parameters.setProperty("shouldCancelDataFlow", "true");
        this.doDataFlowTest(parameters, true);
        parameters.remove("shouldCancelDataFlow");
        parameters.setProperty("urns", dataEmitterURN.getValue());
        parameters.setProperty("shouldSkipCancel", "true");
        this.doDataFlowTest(parameters, true);
        parameters.remove("shouldSkipCancel");
        parameters.setProperty("routeToSink", "true");
        this.doDataFlowTest(parameters, true);
        parameters.remove("useStrategyURN");
        parameters.remove("routeToSink");
        parameters.setProperty("urns", dataEmitterURN.getValue() + "," + StrategyTestBase.MockRecorderModule.Factory.recorders.get(this.outputURN).getURN());
        this.doDataFlowTest(parameters, true);
        parameters.setProperty("urns", dataEmitterURN.getValue());
        parameters.setProperty("useStrategyURN", "true");
        parameters.setProperty("shouldMakeNewRequest", "true");
        this.doDataFlowTest(parameters, true);
    }

    @Test
    public void userdata() throws Exception {
        Client testClient = StrategyModule.clientFactory.getClient();
        Assert.assertNull((Object)testClient.getUserData());
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        ModuleURN strategyModule = this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null);
        this.verifyPropertyNonNull("onStart");
        this.doSuccessfulStartTest(strategyModule);
        Properties userdata = testClient.getUserData();
        Assert.assertNotNull((Object)userdata);
        Assert.assertNotNull((Object)userdata.getProperty("onStart"));
    }

    protected abstract Language getLanguage();

    protected abstract StrategyTestBase.StrategyCoordinates getStrategyWillNotCompile();

    protected abstract StrategyTestBase.StrategyCoordinates getStrategyCompiles();

    protected abstract StrategyTestBase.StrategyCoordinates getStrategyWrongClass();

    protected abstract StrategyTestBase.StrategyCoordinates getStrategyMultipleClasses();

    protected abstract StrategyTestBase.StrategyCoordinates getEmptyStrategy();

    protected abstract StrategyTestBase.StrategyCoordinates getParameterStrategy();

    protected abstract StrategyTestBase.StrategyCoordinates getSuggestionStrategy();

    protected abstract StrategyTestBase.StrategyCoordinates getMessageStrategy();

    protected abstract StrategyTestBase.StrategyCoordinates getOrdersStrategy();

    protected abstract StrategyTestBase.StrategyCoordinates getOtherStrategy();

    protected abstract StrategyTestBase.StrategyCoordinates getPart1Strategy();

    protected abstract StrategyTestBase.StrategyCoordinates getPart1RedefinedStrategy();

    protected abstract StrategyTestBase.StrategyCoordinates getPart2Strategy();

    protected abstract StrategyTestBase.StrategyCoordinates getEventStrategy();

    protected abstract StrategyTestBase.StrategyCoordinates getCombinedStrategy();

    protected abstract StrategyTestBase.StrategyCoordinates getDataFlowStrategy();

    protected abstract StrategyTestBase.StrategyCoordinates getOrderRetentionStrategy();

    protected abstract StrategyTestBase.StrategyCoordinates getPositionsStrategy();

    protected int getExpectedCompilationWarningsFor(StrategyTestBase.StrategyCoordinates inStrategy) {
        return 0;
    }

    private void executeProcessedMarketDataRequest(boolean inSucceeds, boolean inCanConstructRequest) throws Exception {
        this.theStrategy = this.createStrategy(this.getCombinedStrategy().getName(), this.getLanguage(), this.getCombinedStrategy().getFile(), null, null, null);
        AbstractRunningStrategy strategy = (AbstractRunningStrategy)this.getRunningStrategy(this.theStrategy).getRunningStrategy();
        AbstractRunningStrategy.setProperty((String)"finished", null);
        HashSet<Object> keys = new HashSet<Object>(AbstractRunningStrategy.getProperties().keySet());
        for (Object e : keys) {
            String key = (String)e;
            if (!key.startsWith("ask") && !key.startsWith("bid")) continue;
            AbstractRunningStrategy.getProperties().remove(e);
        }
        AbstractRunningStrategy.setProperty((String)"bid", null);
        AbstractRunningStrategy.setProperty((String)"ask", null);
        strategy.onOther((Object)this);
        String requestIDString = AbstractRunningStrategy.getProperty((String)"requestID");
        if (inCanConstructRequest) {
            Assert.assertNotNull((String)"The request should have returned a value, either zero or non-zero, but null means the request didn't even happen", (Object)requestIDString);
        } else {
            Assert.assertNull((Object)requestIDString);
        }
        if (inSucceeds) {
            Assert.assertTrue((Integer.parseInt(requestIDString) > 0 ? 1 : 0) != 0);
            MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return AbstractRunningStrategy.getProperty((String)"finished") != null;
                }
            });
        } else if (inCanConstructRequest) {
            Assert.assertEquals((Object)"0", (Object)requestIDString);
        } else {
            Assert.assertNull((Object)requestIDString);
        }
        this.doProcessedMarketDataRequestVerification(inSucceeds);
        this.stopStrategy(this.theStrategy);
    }

    private void doProcessedMarketDataRequestVerification(boolean inSucceeds) throws Exception {
        Properties storedProperties = AbstractRunningStrategy.getProperties();
        for (Object rawKey : storedProperties.keySet()) {
            String key = (String)rawKey;
            if (key.contains("bid")) {
                Assert.fail((String)"Should not have received any bids");
            }
            if (!key.contains("ask")) continue;
            String value = storedProperties.getProperty(key);
            Assert.assertEquals((String)(inSucceeds ? "Received an ask for a symbol other than 'METC': " + key : "Wasn't expecting any asks"), (Object)inSucceeds, (Object)key.contains("METC"));
            Assert.assertTrue((String)"Expected more than 0 asks for 'METC'", (Integer.parseInt(value) > 0 ? 1 : 0) != 0);
        }
    }

    private void verifyCEPSuggestion(String inSymbol, BigDecimal inPrice, BigDecimal inQuantity, OrderSingleSuggestion inSuggestion) throws Exception {
        Assert.assertEquals((Object)inSymbol, (Object)inSuggestion.getOrder().getInstrument().getSymbol());
        Assert.assertEquals((Object)inPrice, (Object)inSuggestion.getOrder().getPrice());
        Assert.assertEquals((Object)inQuantity, (Object)inSuggestion.getOrder().getQuantity());
    }

    private List<OrderSingleSuggestion> getReceivedSuggestions(ModuleURN inRecorder) {
        StrategyTestBase.MockRecorderModule recorder = StrategyTestBase.MockRecorderModule.Factory.recorders.get(inRecorder);
        ArrayList<OrderSingleSuggestion> suggestions = new ArrayList<OrderSingleSuggestion>();
        for (StrategyTestBase.MockRecorderModule.DataReceived datum : recorder.getDataReceived()) {
            suggestions.add((OrderSingleSuggestion)datum.getData());
        }
        recorder.resetDataReceived();
        return suggestions;
    }

    private DataFlowID feedEventsToCEP(Event[] inEvents, ModuleURN inCEPModule) throws Exception {
        CopierModule.SynchronousRequest request = new CopierModule.SynchronousRequest((Object)inEvents);
        request.semaphore.acquire();
        DataFlowID dataFlowID = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)request), new DataRequest(inCEPModule)}, false);
        request.semaphore.acquire();
        return dataFlowID;
    }

    private String createConsolidatedCEPStatement(String[] inStatements) {
        StringBuilder statements = new StringBuilder();
        boolean separatorNeeded = false;
        for (String statement : inStatements) {
            if (separatorNeeded) {
                statements.append("#");
            } else {
                separatorNeeded = true;
            }
            statements.append(statement);
        }
        return statements.toString();
    }

    private List<OrderSingleSuggestion> doCEPTest(String inProvider, String[] inStatements, Event[] inEvents, boolean inCleanup) throws Exception {
        this.setPropertiesToNull();
        StrategyTestBase.MockRecorderModule recorder = StrategyTestBase.MockRecorderModule.Factory.recorders.get(this.outputURN);
        recorder.resetDataReceived();
        Properties parameters = new Properties();
        parameters.setProperty("shouldRequestCEPData", "true");
        if (inProvider != null) {
            parameters.setProperty("source", inProvider);
        }
        if (inStatements != null) {
            parameters.setProperty("statements", this.createConsolidatedCEPStatement(inStatements));
        }
        StrategyTestBase.StrategyCoordinates strategyFile = this.getStrategyCompiles();
        this.theStrategy = this.createStrategy(strategyFile.getName(), this.getLanguage(), strategyFile.getFile(), parameters, null, this.outputURN);
        StrategyImpl strategy = this.getRunningStrategy(this.theStrategy);
        ModuleURN cepModuleURN = new ModuleURN("metc:cep:" + inProvider + ":" + strategy.getDefaultNamespace());
        long requestID = 0L;
        if (AbstractRunningStrategy.getProperty((String)"requestID") != null) {
            requestID = Long.parseLong(AbstractRunningStrategy.getProperty((String)"requestID"));
        }
        if (requestID != 0L) {
            this.feedEventsToCEP(inEvents, cepModuleURN);
        }
        List<OrderSingleSuggestion> suggestions = this.getReceivedSuggestions(this.outputURN);
        if (inCleanup) {
            this.stopStrategy(this.theStrategy);
        }
        return suggestions;
    }

    private void doBrokerTest(BrokerStatus[] inExpectedBrokers) throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        AbstractRunningStrategy.getProperties().clear();
        AbstractRunningStrategy.setProperty((String)"askForBrokers", (String)"true");
        this.verifyStrategyStartsAndStops(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null);
        int counter = 0;
        for (BrokerStatus broker : inExpectedBrokers) {
            Assert.assertEquals((Object)broker.toString(), (Object)AbstractRunningStrategy.getProperty((String)("" + counter++)));
        }
        Assert.assertNull((String)("Property " + inExpectedBrokers.length + " was non-null"), (Object)AbstractRunningStrategy.getProperty((String)("" + inExpectedBrokers.length)));
    }

    private void doMessageTest(Properties inParameters, FIXOrder[] inExpectedOrders) throws Exception {
        ModuleURN suggestionReceiver = this.generateOrders(this.getMessageStrategy(), inParameters);
        StrategyTestBase.MockRecorderModule recorder = StrategyTestBase.MockRecorderModule.Factory.recorders.get(suggestionReceiver);
        Assert.assertNotNull((String)"Must be able to find the recorder created", (Object)((Object)recorder));
        this.validateMessages(recorder, inExpectedOrders);
        this.stopStrategy(this.theStrategy);
        this.validateMessages(recorder, inExpectedOrders);
    }

    private void validateMessages(StrategyTestBase.MockRecorderModule inRecorder, FIXOrder[] inExpectedOrders) {
        List<StrategyTestBase.MockRecorderModule.DataReceived> messages = inRecorder.getDataReceived();
        Assert.assertEquals((String)"The number of expected messages does not match the number of actual messages", (long)inExpectedOrders.length, (long)messages.size());
        int index = 0;
        for (StrategyTestBase.MockRecorderModule.DataReceived datum : messages) {
            TypesTestBase.assertOrderFIXEquals((FIXOrder)inExpectedOrders[index++], (FIXOrder)((FIXOrder)datum.getData()), (boolean)true);
        }
        inRecorder.resetDataReceived();
    }

    private ModuleURN generateOrders(StrategyTestBase.StrategyCoordinates inStrategy, Properties inParameters) throws Exception {
        this.createStrategy(null, inStrategy.getName(), this.getLanguage(), inStrategy.getFile(), inParameters, false, this.outputURN);
        return this.outputURN;
    }

    private void doSuggestionTest(Properties inParameters, OrderSingleSuggestion[] inExpectedSuggestions) throws Exception {
        ModuleURN suggestionReceiver = this.generateSuggestions(this.getSuggestionStrategy(), inParameters, this.outputURN);
        this.verifySuggestions(inExpectedSuggestions, suggestionReceiver);
        this.stopStrategy(this.theStrategy);
        this.verifySuggestions(inExpectedSuggestions, suggestionReceiver);
    }

    private void verifySuggestions(OrderSingleSuggestion[] inExpectedSuggestions, ModuleURN inSuggestionReceiver) {
        StrategyTestBase.MockRecorderModule recorder = StrategyTestBase.MockRecorderModule.Factory.recorders.get(inSuggestionReceiver);
        Assert.assertNotNull((String)"Must be able to find the recorder created", (Object)((Object)recorder));
        List<StrategyTestBase.MockRecorderModule.DataReceived> suggestions = recorder.getDataReceived();
        Assert.assertEquals((String)"The number of expected suggestions does not match the number of actual suggestions", (long)inExpectedSuggestions.length, (long)suggestions.size());
        int index = 0;
        for (StrategyTestBase.MockRecorderModule.DataReceived datum : suggestions) {
            TypesTestBase.assertOrderSuggestionEquals((OrderSingleSuggestion)inExpectedSuggestions[index++], (OrderSingleSuggestion)((OrderSingleSuggestion)datum.getData()), (boolean)true);
        }
        recorder.resetDataReceived();
    }

    private void doExecutionReportTest(int inExecutionReportCount, boolean inSendOrders) throws Exception {
        AbstractRunningStrategy.setProperty((String)"executionReportCount", (String)"0");
        AbstractRunningStrategy.setProperty((String)"price", (String)"1000");
        AbstractRunningStrategy.setProperty((String)"quantity", (String)"500");
        AbstractRunningStrategy.setProperty((String)"side", (String)Side.Sell.toString());
        AbstractRunningStrategy.setProperty((String)"symbol", (String)"METC");
        AbstractRunningStrategy.setProperty((String)"orderType", (String)OrderType.Market.name());
        AbstractRunningStrategy.setProperty((String)"quantity", (String)"10000");
        ArrayList<ExecutionReport> expectedExecutionReports = new ArrayList<ExecutionReport>();
        StrategyImpl runningStrategy = this.getRunningStrategy(this.theStrategy);
        OrderID orderID = null;
        if (inSendOrders) {
            runningStrategy.dataReceived((Object)this.askEvent);
            OrderSingle expectedOrder = Factory.getInstance().createOrderSingle();
            expectedOrder.setPrice(new BigDecimal("1000"));
            expectedOrder.setQuantity(new BigDecimal("500"));
            expectedOrder.setSide(Side.Sell);
            expectedOrder.setInstrument((Instrument)new Equity("METC"));
            expectedOrder.setOrderType(OrderType.Market);
            expectedOrder.setQuantity(new BigDecimal(10000));
            String orderIDString = AbstractRunningStrategy.getProperty((String)"orderID");
            if (orderIDString != null) {
                orderID = new OrderID(orderIDString);
                expectedOrder.setOrderID(new OrderID(orderIDString));
            }
            if (StrategyTestBase.MockRecorderModule.shouldSendExecutionReports) {
                expectedExecutionReports.addAll(LanguageTestBase.generateExecutionReports(expectedOrder));
            }
        }
        runningStrategy.dataReceived((Object)EventTestBase.generateEquityBidEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("METC"), (String)"Q", (BigDecimal)new BigDecimal("100.00"), (BigDecimal)new BigDecimal("10000")));
        Assert.assertEquals((long)inExecutionReportCount, (long)Integer.parseInt(AbstractRunningStrategy.getProperty((String)"executionReportCount")));
        Deque actualExecutionReports = ((AbstractRunningStrategy)runningStrategy.getRunningStrategy()).getExecutionReports(orderID);
        Assert.assertEquals((long)expectedExecutionReports.size(), (long)actualExecutionReports.size());
        int index = 0;
        Collections.reverse(expectedExecutionReports);
        for (ReportBase actualExecutionReport : actualExecutionReports) {
            TypesTestBase.assertExecReportEquals((ExecutionReport)((ExecutionReport)expectedExecutionReports.get(index++)), (ExecutionReport)((ExecutionReport)actualExecutionReport));
        }
        AbstractRunningStrategy.getProperties().clear();
        StrategyTestBase.MockRecorderModule.ordersReceived = 0;
    }

    private void doOrderTest(ModuleURN inStrategy, OrderSingle[] inExpectedOrders, List<OrderSingle> inExpectedCumulativeOrders) throws Exception {
        StrategyTestBase.MockRecorderModule recorder = StrategyTestBase.MockRecorderModule.Factory.recorders.get(this.outputURN);
        Assert.assertNotNull((String)"Must be able to find the recorder created", (Object)((Object)recorder));
        recorder.resetDataReceived();
        StrategyTestBase.MockRecorderModule.shouldSendExecutionReports = false;
        this.doSuccessfulStartTestNoVerification(inStrategy);
        List<StrategyTestBase.MockRecorderModule.DataReceived> orders = recorder.getDataReceived();
        Assert.assertEquals((String)"The number of expected orders does not match the number of actual orders", (long)inExpectedOrders.length, (long)orders.size());
        int index = 0;
        for (StrategyTestBase.MockRecorderModule.DataReceived datum : orders) {
            TypesTestBase.assertOrderSingleEquals((OrderSingle)inExpectedOrders[index++], (OrderSingle)((OrderSingle)datum.getData()), (boolean)true);
        }
        StrategyImpl runningStrategy = this.getRunningStrategy(inStrategy);
        Set actualCumulativeOrders = ((AbstractRunningStrategy)runningStrategy.getRunningStrategy()).getSubmittedOrders();
        Assert.assertEquals((long)inExpectedCumulativeOrders.size(), (long)actualCumulativeOrders.size());
        index = 0;
        for (OrderSingle actualOrder : actualCumulativeOrders) {
            TypesTestBase.assertOrderSingleEquals((OrderSingle)inExpectedCumulativeOrders.get(index++), (OrderSingle)actualOrder, (boolean)true);
        }
    }

    private void doOtherTest(ModuleURN inStrategy, Object[] inExpectedObjects) throws Exception {
        StrategyTestBase.MockRecorderModule recorder = StrategyTestBase.MockRecorderModule.Factory.recorders.get(this.outputURN);
        Assert.assertNotNull((String)"Must be able to find the recorder created", (Object)((Object)recorder));
        recorder.resetDataReceived();
        AbstractRunningStrategy runningStrategy = (AbstractRunningStrategy)this.getRunningStrategy(inStrategy).getRunningStrategy();
        runningStrategy.onAsk(this.askEvent);
        List<StrategyTestBase.MockRecorderModule.DataReceived> objects = recorder.getDataReceived();
        int index = 0;
        for (StrategyTestBase.MockRecorderModule.DataReceived datum : objects) {
            Assert.assertEquals((Object)inExpectedObjects[index++], (Object)datum.getData());
        }
    }

    private void doDataFlowTest(Properties inParameters, boolean inDataExpected) throws Exception {
        DataFlowID dataFlowID;
        StrategyTestBase.MockRecorderModule recorder = StrategyTestBase.MockRecorderModule.Factory.recorders.get(this.outputURN);
        MarketDataModuleTestBase.DataSink dataSink = new MarketDataModuleTestBase.DataSink();
        this.moduleManager.addSinkListener((SinkDataListener)dataSink);
        Assert.assertNotNull((String)"Must be able to find the recorder created", (Object)((Object)recorder));
        recorder.resetDataReceived();
        this.setPropertiesToNull();
        StrategyTestBase.StrategyCoordinates strategy = this.getDataFlowStrategy();
        this.theStrategy = this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), inParameters, null, this.outputURN);
        ArrayList<Object> inExpectedData = new ArrayList<Object>();
        if (inDataExpected) {
            inExpectedData.addAll(StrategyTestBase.StrategyDataEmissionModule.getDataToSend());
            Assert.assertNotNull((Object)AbstractRunningStrategy.getProperty((String)"dataFlowID"));
        }
        List<StrategyTestBase.MockRecorderModule.DataReceived> dataReceived = recorder.getDataReceived();
        Assert.assertEquals((String)("Expected " + inExpectedData + " but got " + dataReceived), (long)inExpectedData.size(), (long)dataReceived.size());
        int index = 0;
        for (StrategyTestBase.MockRecorderModule.DataReceived datum : dataReceived) {
            Assert.assertEquals((String)("Expected " + inExpectedData.get(index) + " but got " + datum), inExpectedData.get(index++), (Object)datum.getData());
        }
        if (inParameters.getProperty("routeToSink") == "true") {
            Map sinkData = dataSink.getAllData();
            Assert.assertEquals((long)1L, (long)sinkData.keySet().size());
            dataFlowID = (DataFlowID)sinkData.keySet().iterator().next();
            Assert.assertTrue((String)("Expected " + inExpectedData + " but got " + sinkData.get(dataFlowID)), (boolean)Arrays.equals(inExpectedData.toArray(), ((List)sinkData.get(dataFlowID)).toArray()));
        } else {
            Assert.assertTrue((boolean)dataSink.getAllData().isEmpty());
        }
        String rawDataFlowID = AbstractRunningStrategy.getProperty((String)"dataFlowID");
        Assert.assertEquals((Object)inDataExpected, (Object)(rawDataFlowID != null ? 1 : 0));
        if (inParameters.getProperty("shouldCancelDataFlow") == "true" && inDataExpected) {
            dataFlowID = new DataFlowID(rawDataFlowID);
            Assert.assertTrue((boolean)this.moduleManager.getDataFlows(true).contains(dataFlowID));
            this.getRunningStrategy(this.theStrategy).getRunningStrategy().onCallback((Object)dataFlowID);
            Assert.assertNotNull((Object)AbstractRunningStrategy.getProperty((String)"localDataFlowStopped"));
            Assert.assertFalse((boolean)this.moduleManager.getDataFlows(true).contains(dataFlowID));
            AbstractRunningStrategy.setProperty((String)"localDataFlowStopped", null);
            dataFlowID = new DataFlowID("not-a-data-flow-id");
            this.getRunningStrategy(this.theStrategy).getRunningStrategy().onCallback((Object)dataFlowID);
            Assert.assertNotNull((Object)AbstractRunningStrategy.getProperty((String)"localDataFlowStopped"));
            Assert.assertFalse((boolean)this.moduleManager.getDataFlows(true).contains(dataFlowID));
            AbstractRunningStrategy.setProperty((String)"localDataFlowStopped", null);
            MarketDataRequest inRequest = MarketDataRequestBuilder.newRequest().withProvider("bogus").withSymbols("METC").create();
            dataFlowID = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(new ModuleURN(String.format("metc:mdata:%s", inRequest.getProvider())), (Object)inRequest)}, true);
            Assert.assertNotNull((Object)dataFlowID);
            Assert.assertTrue((boolean)this.moduleManager.getDataFlows(true).contains(dataFlowID));
            this.getRunningStrategy(this.theStrategy).getRunningStrategy().onCallback((Object)dataFlowID);
            Assert.assertNotNull((Object)AbstractRunningStrategy.getProperty((String)"localDataFlowStopped"));
            Assert.assertFalse((boolean)this.moduleManager.getDataFlows(true).contains(dataFlowID));
        }
        this.stopStrategy(this.theStrategy);
        if (inDataExpected) {
            dataFlowID = new DataFlowID(rawDataFlowID);
            Assert.assertFalse((boolean)this.moduleManager.getDataFlows(true).contains(dataFlowID));
            if (inParameters.getProperty("shouldSkipCancel") != null) {
                Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"dataFlowStopped"));
            } else {
                Assert.assertNotNull((Object)AbstractRunningStrategy.getProperty((String)"dataFlowStopped"));
            }
        }
        if (inParameters.getProperty("shouldMakeNewRequest") == "true") {
            Assert.assertEquals((Object)"true", (Object)AbstractRunningStrategy.getProperty((String)"newDataFlowAttempt"));
            Assert.assertEquals((Object)"null", (Object)AbstractRunningStrategy.getProperty((String)"newDataFlowID"));
        }
    }

    private ModuleURN generateSuggestions(StrategyTestBase.StrategyCoordinates inStrategy, Properties inParameters, ModuleURN inOutputURN) throws Exception {
        this.createStrategy(inStrategy.getName(), this.getLanguage(), inStrategy.getFile(), inParameters, null, inOutputURN);
        return inOutputURN;
    }

    private ModuleURN generateOrders(StrategyTestBase.StrategyCoordinates inStrategy, ModuleURN inOrdersURN) throws Exception {
        this.theStrategy = this.createStrategy(inStrategy.getName(), this.getLanguage(), inStrategy.getFile(), null, null, inOrdersURN);
        this.setupMockORSConnection(this.theStrategy);
        return this.theStrategy;
    }

    private ModuleURN getMarketData(String inProvider, String inSymbols, boolean inUseStringAPI, Properties inParameters) throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        inParameters.setProperty("shouldRequestData", inProvider);
        inParameters.setProperty("symbols", inSymbols);
        if (inUseStringAPI) {
            inParameters.setProperty("useStringAPI", "true");
        }
        return this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), inParameters, null, null);
    }

    private void doSuccessfulStartTest(ModuleURN inStrategy) throws Exception {
        this.doSuccessfulStartTestNoVerification(inStrategy);
        this.verifyNonNullProperties();
    }

    protected void doSuccessfulStartTestNoVerification(ModuleURN inStrategy) throws Exception {
        this.verifyStrategyReady(inStrategy);
        ModuleURN dataEmitterURN = this.createModule(StrategyTestBase.StrategyDataEmissionModule.Factory.PROVIDER_URN, new Object[0]);
        DataFlowID dataFlowID = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(dataEmitterURN, null), new DataRequest(inStrategy)}, false);
        this.moduleManager.cancel(dataFlowID);
    }

    private void doCallbackFailsTest(String inParameterThatCausesACallbackToFail, String[] inCallbacksThatShouldHaveSucceeded) throws Exception {
        this.setPropertiesToNull();
        StrategyTestBase.StrategyCoordinates strategy = this.getStrategyCompiles();
        Properties parameters = new Properties();
        parameters.setProperty(inParameterThatCausesACallbackToFail, "true");
        this.doSuccessfulStartTestNoVerification(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, null));
        HashSet<String> allCallbacks = new HashSet<String>(Arrays.asList("onAsk", "onBid", "onCancel", "onExecutionReport", "onTrade", "onOther", "onDividend"));
        for (String callback : inCallbacksThatShouldHaveSucceeded) {
            this.verifyPropertyNonNull(callback);
            allCallbacks.remove(callback);
        }
        for (String callbackShouldBeNull : allCallbacks) {
            this.verifyPropertyNull(callbackShouldBeNull);
        }
    }

    private void doPositionAsOfTest(String inSymbol, Date inDate, BigDecimal inExpectedPosition) throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getPositionsStrategy();
        this.setPropertiesToNull();
        AbstractRunningStrategy.setProperty((String)"positionAsOfDuringStop", (String)"not-empty");
        if (inSymbol != null) {
            AbstractRunningStrategy.setProperty((String)"symbol", (String)inSymbol);
        }
        if (inDate != null) {
            AbstractRunningStrategy.setProperty((String)"date", (String)Long.toString(inDate.getTime()));
        }
        this.verifyStrategyStartsAndStops(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null);
        Assert.assertEquals((Object)(inExpectedPosition == null ? null : inExpectedPosition.toString()), (Object)AbstractRunningStrategy.getProperty((String)"positionAsOf"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"positionAsOfDuringStop"));
    }

    private void doAllPositionsAsOfTest(Date inDate, Map<PositionKey<Equity>, BigDecimal> inExpectedPositions) throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getPositionsStrategy();
        this.setPropertiesToNull();
        AbstractRunningStrategy.setProperty((String)"allPositionsAsOfDuringStop", (String)"not-empty");
        if (inDate != null) {
            AbstractRunningStrategy.setProperty((String)"date", (String)Long.toString(inDate.getTime()));
        }
        this.verifyStrategyStartsAndStops(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null);
        Assert.assertEquals((Object)(inExpectedPositions == null ? null : inExpectedPositions.toString()), (Object)AbstractRunningStrategy.getProperty((String)"allPositionsAsOf"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"allPositionsAsOfDuringStop"));
    }

    private void doOptionPositionAsOfTest(String inOptionRoot, String inExpiry, BigDecimal inStrikePrice, OptionType inOptionType, Date inDate, BigDecimal inExpectedPosition) throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getPositionsStrategy();
        this.setPropertiesToNull();
        AbstractRunningStrategy.setProperty((String)"optionPositionAsOfDuringStop", (String)"not-empty");
        if (inOptionRoot != null) {
            AbstractRunningStrategy.setProperty((String)"optionRoot", (String)inOptionRoot);
        }
        if (inExpiry != null) {
            AbstractRunningStrategy.setProperty((String)"expiry", (String)inExpiry);
        }
        if (inStrikePrice != null) {
            AbstractRunningStrategy.setProperty((String)"strikePrice", (String)inStrikePrice.toPlainString());
        }
        if (inOptionType != null) {
            AbstractRunningStrategy.setProperty((String)"optionType", (String)inOptionType.toString());
        }
        if (inDate != null) {
            AbstractRunningStrategy.setProperty((String)"date", (String)Long.toString(inDate.getTime()));
        }
        this.verifyStrategyStartsAndStops(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null);
        Assert.assertEquals((Object)(inExpectedPosition == null ? null : inExpectedPosition.toString()), (Object)AbstractRunningStrategy.getProperty((String)"optionPositionAsOf"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"optionPositionAsOfDuringStop"));
    }

    private void doAllOptionPositionsAsOfTest(Date inDate, Map<PositionKey<Option>, BigDecimal> inExpectedPositions) throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getPositionsStrategy();
        this.setPropertiesToNull();
        AbstractRunningStrategy.setProperty((String)"allOptionPositionsAsOfDuringStop", (String)"not-empty");
        if (inDate != null) {
            AbstractRunningStrategy.setProperty((String)"date", (String)Long.toString(inDate.getTime()));
        }
        this.verifyStrategyStartsAndStops(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null);
        Assert.assertEquals((Object)(inExpectedPositions == null ? null : inExpectedPositions.toString()), (Object)AbstractRunningStrategy.getProperty((String)"allOptionPositionsAsOf"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"allOptionPositionsAsOfDuringStop"));
    }

    private void doOptionPositionsAsOfTest(String[] inOptionRoots, Date inDate, Properties inParameters, Map<PositionKey<Option>, BigDecimal> inExpectedPositions) throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getPositionsStrategy();
        this.setPropertiesToNull();
        AbstractRunningStrategy.setProperty((String)"optionPositionsAsOfDuringStop", (String)"not-empty");
        if (inOptionRoots != null && inOptionRoots.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (String optionRoot : inOptionRoots) {
                builder.append(optionRoot).append(',');
            }
            AbstractRunningStrategy.setProperty((String)"optionRoots", (String)builder.toString());
        }
        if (inDate != null) {
            AbstractRunningStrategy.setProperty((String)"date", (String)Long.toString(inDate.getTime()));
        }
        this.verifyStrategyStartsAndStops(strategy.getName(), this.getLanguage(), strategy.getFile(), inParameters, null, null);
        Assert.assertEquals((Object)(inExpectedPositions == null ? null : inExpectedPositions.toString()), (Object)AbstractRunningStrategy.getProperty((String)"optionPositionsAsOf"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"optionPositionsAsOfDuringStop"));
    }

    private void doUnderlyingTest(String inOptionRoot, String inExpectedUnderlyingSymbol) throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getPositionsStrategy();
        this.setPropertiesToNull();
        AbstractRunningStrategy.setProperty((String)"underlyingDuringStop", (String)"not-empty");
        if (inOptionRoot != null) {
            AbstractRunningStrategy.setProperty((String)"optionRoot", (String)inOptionRoot);
        }
        this.verifyStrategyStartsAndStops(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null);
        Assert.assertEquals((Object)(inExpectedUnderlyingSymbol == null ? null : inExpectedUnderlyingSymbol), (Object)AbstractRunningStrategy.getProperty((String)"underlying"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"underlyingDuringStop"));
    }

    private void doOptionRootsTest(String inUnderlyingSymbol, Collection<String> inExpectedOptionRoots) throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getPositionsStrategy();
        this.setPropertiesToNull();
        AbstractRunningStrategy.setProperty((String)"optionRootsDuringStop", (String)"not-empty");
        if (inUnderlyingSymbol != null) {
            AbstractRunningStrategy.setProperty((String)"underlyingSymbol", (String)inUnderlyingSymbol);
        }
        this.verifyStrategyStartsAndStops(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null);
        Assert.assertEquals((Object)(inExpectedOptionRoots == null ? null : inExpectedOptionRoots.toString()), (Object)AbstractRunningStrategy.getProperty((String)"optionRoots"));
        Assert.assertNull((Object)AbstractRunningStrategy.getProperty((String)"optionRootsDuringStop"));
    }

    private <T> Future<T> doAsynchronous(Callable<T> inBlock) throws InterruptedException, ExecutionException {
        return this.executor.submit(inBlock);
    }

    public static @interface PerformanceTest {
        public boolean value() default true;
    }
}

