/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.Test;
import org.marketcetera.event.LogEvent;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.SinkDataListener;
import org.marketcetera.module.SinkModuleFactory;
import org.marketcetera.strategy.AbstractRunningStrategy;
import org.marketcetera.strategy.Language;
import org.marketcetera.strategy.LanguageTestBase;
import org.marketcetera.strategy.Status;
import org.marketcetera.strategy.StrategyModuleFactory;
import org.marketcetera.strategy.StrategyTestBase;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.test.SerializableAssert;

public class RubyLanguageTest
extends LanguageTestBase {
    public static final File STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "RubyStrategy.rb");
    public static final String STRATEGY_NAME = "RubyStrategy";
    public static final File BAD_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "BadRubyStrategy.rb");
    public static final String BAD_STRATEGY_NAME = "BadRubyStrategy";
    public static final File WRONG_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "WrongClass.rb");
    public static final String WRONG_STRATEGY_NAME = "WrongClass";
    public static final File MULTIPLE_CLASS_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "StrategyWithHelpers.rb");
    public static final String MULTIPLE_CLASS_STRATEGY_NAME = "StrategyWithHelpers";
    public static final File EMPTY_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "EmptyStrategy.rb");
    public static final String EMPTY_STRATEGY_NAME = "EmptyStrategy";
    public static final File PARAMETER_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "ParameterStrategy.rb");
    public static final String PARAMETER_STRATEGY_NAME = "ParameterStrategy";
    public static final File SUGGESTION_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "suggest_trades.rb");
    public static final String SUGGESTION_STRATEGY_NAME = "SuggestTrades";
    public static final File ORDER_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "orders.rb");
    public static final String ORDER_STRATEGY_NAME = "Orders";
    public static final File OTHER_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "send_other.rb");
    public static final String OTHER_STRATEGY_NAME = "SendOther";
    public static final File MESSAGE_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "send_message.rb");
    public static final String MESSAGE_STRATEGY_NAME = "SendMessage";
    public static final File PART1_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "part1.rb");
    public static final String PART1_STRATEGY_NAME = "Part1";
    public static final File PART1_REDEFINED_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "part1_redefined.rb");
    public static final File PART2_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "part2.rb");
    public static final String PART2_STRATEGY_NAME = "Part2";
    public static final File EVENT_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "send_event.rb");
    public static final String EVENT_STRATEGY_NAME = "SendEvent";
    public static final File COMBINED_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "combined_request.rb");
    public static final String COMBINED_STRATEGY_NAME = "CombinedRequest";
    public static final File REQUIRES_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "require.rb");
    public static final String REQUIRES_STRATEGY_NAME = "Require";
    public static final File BAD_ON_START_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "bad_on_start.rb");
    public static final String BAD_ON_START_STRATEGY_NAME = "BadOnStart";
    public static final File BAD_ON_STOP_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "bad_on_stop.rb");
    public static final String BAD_ON_STOP_STRATEGY_NAME = "BadOnStop";
    public static final File DATA_FLOW_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "data_flow.rb");
    public static final String DATA_FLOW_STRATEGY_NAME = "DataFlow";
    public static final File ORDER_RETENTION_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "order_retention.rb");
    public static final String ORDER_RETENTION_STRATEGY_NAME = "OrderRetention";
    public static final File POSITIONS_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "positions.rb");
    public static final String POSITIONS_STRATEGY_NAME = "Positions";
    private final String UNSERIALIZABLE_LOG_EVENT = "An unserializable LogEvent was emitted in on_start or on_stop.  See log for details.";

    @Test
    public void requires() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getRequiresStrategy();
        this.verifyNullProperties();
        ModuleURN strategyURN = this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null);
        this.doSuccessfulStartTestNoVerification(strategyURN);
        this.verifyPropertyNonNull("onStart");
        this.stopStrategy(strategyURN);
        this.verifyPropertyNonNull("onStop");
    }

    @Test
    public void serializableError() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getBadOnStartStrategy();
        Properties parameters = new Properties();
        parameters.setProperty("shouldFailOnStart", "true");
        final ArrayList logEventList = new ArrayList();
        this.moduleManager.addSinkListener(new SinkDataListener(){

            public void receivedData(DataFlowID inFlowID, Object inData) {
                if (inData instanceof LogEvent) {
                    logEventList.add((LogEvent)inData);
                }
            }
        });
        final ModuleURN strategyURN = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{null, strategy.getName(), this.getLanguage(), strategy.getFile(), parameters, null, SinkModuleFactory.INSTANCE_URN});
        new ExpectedFailure<ModuleException>((I18NBoundMessage)FAILED_TO_START){

            protected void run() throws Exception {
                RubyLanguageTest.this.moduleManager.start(strategyURN);
            }
        };
        this.verifyPropertyNull("onStart");
        this.verifyStrategyStatus(strategyURN, Status.FAILED);
        this.setPropertiesToNull();
        parameters.clear();
        AbstractRunningStrategy.setProperty((String)"shouldFailOnStop", (String)"true");
        StrategyTestBase.StrategyCoordinates strategy2 = this.getBadOnStopStrategy();
        ModuleURN strategyURN2 = this.createStrategy(strategy2.getName(), this.getLanguage(), strategy2.getFile(), parameters, null, SinkModuleFactory.INSTANCE_URN);
        this.doSuccessfulStartTestNoVerification(strategyURN2);
        this.stopStrategy(strategyURN2);
        AbstractRunningStrategy.setProperty((String)"shouldFailOnStop", null);
        for (LogEvent l : logEventList) {
            SerializableAssert.assertSerializable((String)"An unserializable LogEvent was emitted in on_start or on_stop.  See log for details.", (Serializable)l);
        }
    }

    @Override
    protected Language getLanguage() {
        return Language.RUBY;
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getStrategyWillNotCompile() {
        return StrategyTestBase.StrategyCoordinates.get(BAD_STRATEGY, BAD_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getStrategyCompiles() {
        return StrategyTestBase.StrategyCoordinates.get(STRATEGY, STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getStrategyWrongClass() {
        return StrategyTestBase.StrategyCoordinates.get(WRONG_STRATEGY, WRONG_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getStrategyMultipleClasses() {
        return StrategyTestBase.StrategyCoordinates.get(MULTIPLE_CLASS_STRATEGY, MULTIPLE_CLASS_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getEmptyStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(EMPTY_STRATEGY, EMPTY_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getParameterStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(PARAMETER_STRATEGY, PARAMETER_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getSuggestionStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(SUGGESTION_STRATEGY, SUGGESTION_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getMessageStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(MESSAGE_STRATEGY, MESSAGE_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getPart1Strategy() {
        return StrategyTestBase.StrategyCoordinates.get(PART1_STRATEGY, PART1_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getPart2Strategy() {
        return StrategyTestBase.StrategyCoordinates.get(PART2_STRATEGY, PART2_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getPart1RedefinedStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(PART1_REDEFINED_STRATEGY, PART1_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getOrdersStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(ORDER_STRATEGY, ORDER_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getEventStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(EVENT_STRATEGY, EVENT_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getCombinedStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(COMBINED_STRATEGY, COMBINED_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getOtherStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(OTHER_STRATEGY, OTHER_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getOrderRetentionStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(ORDER_RETENTION_STRATEGY, ORDER_RETENTION_STRATEGY_NAME);
    }

    private StrategyTestBase.StrategyCoordinates getRequiresStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(REQUIRES_STRATEGY, REQUIRES_STRATEGY_NAME);
    }

    private StrategyTestBase.StrategyCoordinates getBadOnStartStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(BAD_ON_START_STRATEGY, BAD_ON_START_STRATEGY_NAME);
    }

    private StrategyTestBase.StrategyCoordinates getBadOnStopStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(BAD_ON_STOP_STRATEGY, BAD_ON_STOP_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getDataFlowStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(DATA_FLOW_STRATEGY, DATA_FLOW_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getPositionsStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(POSITIONS_STRATEGY, POSITIONS_STRATEGY_NAME);
    }
}

