/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.beans.ExceptionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Manifest;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.SystemUtils;
import org.joda.time.format.DateTimeFormatter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.marketcetera.client.BrokerStatusListener;
import org.marketcetera.client.Client;
import org.marketcetera.client.ClientFactory;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.OrderValidationException;
import org.marketcetera.client.ReportListener;
import org.marketcetera.client.ServerStatusListener;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.client.brokers.BrokersStatus;
import org.marketcetera.client.users.UserInfo;
import org.marketcetera.core.BigDecimalUtils;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.event.AskEvent;
import org.marketcetera.event.EventTestBase;
import org.marketcetera.event.LogEvent;
import org.marketcetera.event.LogEventLevel;
import org.marketcetera.event.TradeEvent;
import org.marketcetera.marketdata.DateUtils;
import org.marketcetera.marketdata.MarketDataFeedTestBase;
import org.marketcetera.marketdata.TestMessages;
import org.marketcetera.marketdata.bogus.BogusFeedModuleFactory;
import org.marketcetera.module.DataEmitter;
import org.marketcetera.module.DataEmitterSupport;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataReceiver;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.IllegalRequestParameterValue;
import org.marketcetera.module.Module;
import org.marketcetera.module.ModuleCreationException;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleFactory;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.module.ModuleTestBase;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.RequestDataException;
import org.marketcetera.module.RequestID;
import org.marketcetera.module.StopDataFlowException;
import org.marketcetera.module.UnsupportedDataTypeException;
import org.marketcetera.module.UnsupportedRequestParameterType;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.strategy.AbstractRunningStrategy;
import org.marketcetera.strategy.Messages;
import org.marketcetera.strategy.Status;
import org.marketcetera.strategy.StrategyImpl;
import org.marketcetera.strategy.StrategyMXBean;
import org.marketcetera.strategy.StrategyModule;
import org.marketcetera.strategy.StrategyModuleFactory;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.Originator;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NMessage;
import quickfix.Message;
import quickfix.UtcTimeStampField;
import quickfix.field.TransactTime;

public class StrategyTestBase
extends ModuleTestBase
implements Messages {
    public static final File SAMPLE_STRATEGY_DIR = new File("src" + File.separator + "test" + File.separator + "sample_data", "inputs");
    public static final Random random = new Random(System.nanoTime());
    protected static boolean getClientFails;
    protected ModuleManager moduleManager;
    protected ModuleFactory factory;
    protected ModuleURN outputURN;
    protected final List<ModuleURN> runningModules = new ArrayList<ModuleURN>();
    private final Map<ModuleURN, List<DataFlowID>> dataFlowsByStrategy = new HashMap<ModuleURN, List<DataFlowID>>();
    protected final ModuleURN bogusDataFeedURN = BogusFeedModuleFactory.INSTANCE_URN;
    protected TradeEvent tradeEvent;
    protected AskEvent askEvent;
    protected ModuleURN theStrategy;
    protected static final Map<Instrument, Position> positions;
    protected static final Multimap<String, String> roots;
    protected static final Map<String, String> underlyings;
    protected static BrokersStatus brokers;
    protected static int executionReportMultiplicity;
    protected static MockClient client;

    public static final BrokersStatus generateBrokersStatus() {
        ArrayList<BrokerStatus> brokers = new ArrayList<BrokerStatus>();
        for (int counter = 0; counter < 9; ++counter) {
            brokers.add(new BrokerStatus("Broker-" + System.nanoTime(), new BrokerID("broker-" + ++counter), random.nextBoolean()));
        }
        brokers.add(new BrokerStatus("Broker-" + System.nanoTime(), new BrokerID("broker-10"), true));
        return new BrokersStatus(brokers);
    }

    public static final Map<Instrument, Position> generatePositions(List<Instrument> inInstruments) {
        HashMap<Instrument, Position> positions = new HashMap<Instrument, Position>();
        for (Instrument instrument : inInstruments) {
            positions.put(instrument, new Position(instrument));
        }
        return positions;
    }

    public static void verifyEvent(LogEvent inActualEvent, LogEventLevel inExpectedLevel, Throwable inException, I18NMessage inExpectedMessage, Serializable ... inExpectedParameters) throws Exception {
        Assert.assertEquals((Object)inExpectedLevel, (Object)inActualEvent.getLevel());
        Assert.assertEquals((Object)inException, (Object)inActualEvent.getException());
        String messageText = inExpectedMessage.getMessageProvider().getText(inExpectedMessage, (Object[])inExpectedParameters);
        Assert.assertEquals((Object)messageText, (Object)inActualEvent.getMessage());
        LogEvent serializedEvent = (LogEvent)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)inActualEvent));
        Assert.assertEquals((Object)inExpectedLevel, (Object)serializedEvent.getLevel());
        if (inException == null) {
            Assert.assertNull((Object)serializedEvent.getException());
        } else {
            Assert.assertEquals((Object)inException.getMessage(), (Object)serializedEvent.getException().getMessage());
        }
        Assert.assertEquals((Object)messageText, (Object)serializedEvent.getMessage());
    }

    @BeforeClass
    public static void once() throws Exception {
        LoggerConfiguration.logSetup();
        try {
            ClientManager.setClientFactory((ClientFactory)new MockClient.MockClientFactory());
            ClientManager.init(null);
        }
        catch (ClientInitException ignored) {
            // empty catch block
        }
        client = (MockClient)ClientManager.getInstance();
        System.setProperty("strategy.classpath", SAMPLE_STRATEGY_DIR.getCanonicalPath());
        ArrayList<Instrument> testInstruments = new ArrayList<Instrument>();
        testInstruments.add((Instrument)new Equity("METC"));
        testInstruments.add((Instrument)new Equity("GOOG"));
        testInstruments.add((Instrument)new Equity("YHOO"));
        testInstruments.add((Instrument)new Equity("ORCL"));
        testInstruments.add((Instrument)new Equity("AAPL"));
        testInstruments.add((Instrument)new Equity("JAVA"));
        testInstruments.add((Instrument)new Equity("MSFT"));
        testInstruments.add((Instrument)new Option("METC1", DateUtils.dateToString((Date)new Date(), (DateTimeFormatter)DateUtils.DAYS), EventTestBase.generateDecimalValue(), OptionType.Call));
        testInstruments.add((Instrument)new Option("METC2", DateUtils.dateToString((Date)new Date(), (DateTimeFormatter)DateUtils.DAYS), EventTestBase.generateDecimalValue(), OptionType.Put));
        testInstruments.add((Instrument)new Option("METC3", DateUtils.dateToString((Date)new Date(), (DateTimeFormatter)DateUtils.DAYS), EventTestBase.generateDecimalValue(), OptionType.Call));
        testInstruments.add((Instrument)new Option("METC4", DateUtils.dateToString((Date)new Date(), (DateTimeFormatter)DateUtils.DAYS), EventTestBase.generateDecimalValue(), OptionType.Put));
        roots.putAll((Object)"METC", Arrays.asList("METC1", "METC2", "METC3", "METC4"));
        underlyings.put("METC1", "METC");
        underlyings.put("METC2", "METC");
        underlyings.put("METC3", "METC");
        underlyings.put("METC4", "METC");
        testInstruments.add((Instrument)new Option("MSFT1", DateUtils.dateToString((Date)new Date(), (DateTimeFormatter)DateUtils.DAYS), EventTestBase.generateDecimalValue(), OptionType.Call));
        testInstruments.add((Instrument)new Option("MSFT2", DateUtils.dateToString((Date)new Date(), (DateTimeFormatter)DateUtils.DAYS), EventTestBase.generateDecimalValue(), OptionType.Put));
        testInstruments.add((Instrument)new Option("MSFT3", DateUtils.dateToString((Date)new Date(), (DateTimeFormatter)DateUtils.DAYS), EventTestBase.generateDecimalValue(), OptionType.Call));
        testInstruments.add((Instrument)new Option("MSFT4", DateUtils.dateToString((Date)new Date(), (DateTimeFormatter)DateUtils.DAYS), EventTestBase.generateDecimalValue(), OptionType.Put));
        roots.putAll((Object)"MSFT", Arrays.asList("MSFT1", "MSFT2", "MSFT3", "MSFT4"));
        underlyings.put("MSFT1", "MSFT");
        underlyings.put("MSFT2", "MSFT");
        underlyings.put("MSFT3", "MSFT");
        underlyings.put("MSFT4", "MSFT");
        positions.putAll(StrategyTestBase.generatePositions(testInstruments));
    }

    @Before
    public void setup() throws Exception {
        StringBuilder classpath = new StringBuilder();
        for (String path : this.getClassPath()) {
            classpath.append(path).append(File.pathSeparator);
        }
        System.setProperty("metc.java.class.path", classpath.toString());
        brokers = StrategyTestBase.generateBrokersStatus();
        MockClient.getBrokersFails = false;
        MockClient.getPositionFails = false;
        executionReportMultiplicity = 1;
        MockRecorderModule.shouldSendExecutionReports = true;
        MockRecorderModule.shouldFullyFillOrders = true;
        MockRecorderModule.shouldIgnoreLogMessages = true;
        MockRecorderModule.ordersReceived = 0;
        getClientFails = false;
        final MockClient testClient = new MockClient();
        StrategyModule.clientFactory = new StrategyModule.ClientFactory(){

            public Client getClient() throws ClientInitException {
                if (getClientFails) {
                    throw new ClientInitException((I18NBoundMessage)TestMessages.EXPECTED_EXCEPTION);
                }
                return testClient;
            }
        };
        this.moduleManager = new ModuleManager();
        this.moduleManager.init();
        this.outputURN = this.moduleManager.createModule(MockRecorderModule.Factory.PROVIDER_URN, new Object[0]);
        this.moduleManager.start(this.outputURN);
        this.moduleManager.start(this.bogusDataFeedURN);
        this.factory = new StrategyModuleFactory();
        this.runningModules.clear();
        this.runningModules.add(this.outputURN);
        this.runningModules.add(this.bogusDataFeedURN);
        this.setPropertiesToNull();
        this.tradeEvent = EventTestBase.generateEquityTradeEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("METC"), (String)"Q", (BigDecimal)new BigDecimal("1000.25"), (BigDecimal)new BigDecimal("1000"));
        this.askEvent = EventTestBase.generateEquityAskEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("METC"), (String)"Q", (BigDecimal)new BigDecimal("100.00"), (BigDecimal)new BigDecimal("10000"));
        StrategyDataEmissionModule.setDataToSendToDefaults();
    }

    @After
    public void cleanup() throws Exception {
        this.cancelDataFlows(null);
        for (ModuleURN strategy : this.runningModules) {
            try {
                this.moduleManager.stop(strategy);
            }
            catch (Exception exception) {}
        }
        try {
            this.moduleManager.stop(this.outputURN);
        }
        catch (ModuleException moduleException) {
            // empty catch block
        }
        this.moduleManager.deleteModule(this.outputURN);
        this.moduleManager.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void cancelDataFlows(ModuleURN inStrategyURN) {
        Map<ModuleURN, List<DataFlowID>> map = this.dataFlowsByStrategy;
        synchronized (map) {
            Collection<List<DataFlowID>> flowsToCancel;
            if (inStrategyURN == null) {
                flowsToCancel = this.dataFlowsByStrategy.values();
            } else {
                List<DataFlowID> singleList = this.dataFlowsByStrategy.get(inStrategyURN);
                if (singleList == null) {
                    return;
                }
                flowsToCancel = new ArrayList<List<DataFlowID>>();
                flowsToCancel.add(singleList);
            }
            for (List<DataFlowID> flows : flowsToCancel) {
                for (DataFlowID dataFlow : flows) {
                    try {
                        this.moduleManager.cancel(dataFlow);
                    }
                    catch (Exception e) {}
                }
            }
            this.dataFlowsByStrategy.clear();
        }
    }

    protected final void startStrategy(ModuleURN inStrategyURN) throws Exception {
        this.moduleManager.start(inStrategyURN);
        this.setupMockORSConnection(inStrategyURN);
        this.verifyStrategyReady(inStrategyURN);
    }

    protected final void stopStrategy(ModuleURN inStrategyURN) throws Exception {
        this.cancelDataFlows(null);
        this.moduleManager.stop(inStrategyURN);
        this.verifyStrategyStopped(inStrategyURN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final DataFlowID setupMockORSConnection(ModuleURN inStrategyURN) throws Exception {
        DataFlowID flowID = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(this.outputURN), new DataRequest(inStrategyURN)}, false);
        Map<ModuleURN, List<DataFlowID>> map = this.dataFlowsByStrategy;
        synchronized (map) {
            List<DataFlowID> flows = this.dataFlowsByStrategy.get(inStrategyURN);
            if (flows == null) {
                flows = new ArrayList<DataFlowID>();
                this.dataFlowsByStrategy.put(inStrategyURN, flows);
            }
            flows.add(flowID);
        }
        return flowID;
    }

    protected static List<ExecutionReport> generateExecutionReports(OrderSingle inOrder) throws Exception {
        ArrayList<ExecutionReport> reports = new ArrayList<ExecutionReport>();
        for (Message rawExeReport : StrategyTestBase.generateFixExecutionReports(inOrder)) {
            reports.add(Factory.getInstance().createExecutionReport(rawExeReport, inOrder.getBrokerID(), Originator.Broker, null, null));
        }
        return reports;
    }

    protected static List<Message> generateFixExecutionReports(OrderSingle inOrder) throws Exception {
        int multiplicity = executionReportMultiplicity;
        ArrayList<Message> reports = new ArrayList<Message>();
        if (inOrder.getQuantity() != null) {
            BigDecimal totalQuantity = new BigDecimal(inOrder.getQuantity().toString());
            BigDecimal lastQuantity = BigDecimal.ZERO;
            for (int iteration = 0; iteration < multiplicity - 1; ++iteration) {
                BigDecimal thisQuantity = totalQuantity.subtract(totalQuantity.divide(new BigDecimal(Integer.toString(multiplicity))));
                totalQuantity = totalQuantity.subtract(thisQuantity);
                Message rawExeReport = StrategyTestBase.generateFixExecutionReport(inOrder, '1', thisQuantity, lastQuantity, FIXVersion.FIX44);
                reports.add(rawExeReport);
                lastQuantity = thisQuantity;
            }
            Message rawExeReport = StrategyTestBase.generateFixExecutionReport(inOrder, MockRecorderModule.shouldFullyFillOrders ? (char)'2' : '1', totalQuantity, lastQuantity, FIXVersion.FIX44);
            reports.add(rawExeReport);
        }
        return reports;
    }

    protected static Message generateFixExecutionReport(OrderSingle inOrder, char inOrderStatus, BigDecimal inQuantity, BigDecimal inLastQuantity, FIXVersion inFIXVersion) throws Exception {
        Message exeReport = inFIXVersion.getMessageFactory().newExecutionReport(inOrder.getOrderID().toString(), inOrder.getOrderID().toString(), "execID", inOrderStatus, '1', inQuantity, inOrder.getPrice(), inLastQuantity, inOrder.getPrice(), inOrder.getQuantity(), inOrder.getPrice(), inOrder.getInstrument(), inOrder.getAccount(), inOrder.getText());
        exeReport.setField((UtcTimeStampField)new TransactTime(StrategyTestBase.extractTransactTimeFromRunningStrategy()));
        return exeReport;
    }

    protected static OrderSingle createOrderWithID(OrderID inOrderID) {
        OrderSingle order = Factory.getInstance().createOrderSingle();
        order.setOrderType(OrderType.Limit);
        order.setPrice(new BigDecimal("100.23"));
        order.setQuantity(new BigDecimal("10000"));
        order.setSide(Side.Buy);
        order.setInstrument((Instrument)new Equity("METC"));
        if (inOrderID != null) {
            order.setOrderID(inOrderID);
        }
        return order;
    }

    protected static Date extractTransactTimeFromRunningStrategy() {
        String transactTimeString = AbstractRunningStrategy.getProperty((String)"transactTime");
        Date transactTime = new Date();
        if (transactTimeString != null) {
            transactTime = new Date(Long.parseLong(transactTimeString));
        }
        return transactTime;
    }

    protected void verifyStrategyStartsAndStops(Object ... inParameters) throws Exception {
        ModuleURN urn = this.createStrategy(inParameters);
        this.moduleManager.stop(urn);
        Assert.assertFalse((boolean)this.moduleManager.getModuleInfo(urn).getState().isStarted());
        this.moduleManager.deleteModule(urn);
    }

    protected void verifyStrategyReady(final ModuleURN inStrategyURN) throws Exception {
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Status status = StrategyTestBase.this.getStatus(inStrategyURN);
                return status.equals((Object)Status.RUNNING) || status.equals((Object)Status.FAILED);
            }
        });
    }

    protected void verifyStrategyStopped(final ModuleURN inStrategyURN) throws Exception {
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Status status = StrategyTestBase.this.getStatus(inStrategyURN);
                return status.equals((Object)Status.STOPPED) || status.equals((Object)Status.FAILED);
            }
        });
    }

    protected void verifyStrategyStatus(ModuleURN inStrategy, Status inStatus) throws Exception {
        Assert.assertEquals((Object)inStatus, (Object)this.getStatus(inStrategy));
    }

    protected Status getStatus(ModuleURN inStrategy) throws Exception {
        return Status.valueOf((String)this.getMXProxy(inStrategy).getStatus());
    }

    protected void verifyNullProperties() {
        this.verifyPropertyNull("onAsk");
        this.verifyPropertyNull("onBid");
        this.verifyPropertyNull("onCancel");
        this.verifyPropertyNull("onDividend");
        this.verifyPropertyNull("onExecutionReport");
        this.verifyPropertyNull("onOther");
        this.verifyPropertyNull("onTrade");
    }

    protected void verifyNonNullProperties() throws Exception {
        this.verifyPropertyNonNull("onAsk");
        this.verifyPropertyNonNull("onBid");
        this.verifyPropertyNonNull("onCancel");
        this.verifyPropertyNonNull("onDividend");
        this.verifyPropertyNonNull("onExecutionReport");
        this.verifyPropertyNonNull("onOther");
        this.verifyPropertyNonNull("onTrade");
    }

    protected void setPropertiesToNull() {
        Properties properties = AbstractRunningStrategy.getProperties();
        properties.clear();
        this.verifyNullProperties();
    }

    protected String verifyPropertyNonNull(final String inKey) throws Exception {
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return AbstractRunningStrategy.getProperty((String)inKey) != null;
            }
        });
        return AbstractRunningStrategy.getProperty((String)inKey);
    }

    protected void verifyPropertyNull(String inKey) {
        Properties properties = AbstractRunningStrategy.getProperties();
        Assert.assertNull((String)(inKey + " is supposed to be null"), (Object)properties.getProperty(inKey));
    }

    protected ModuleURN createStrategy(Object ... inParameters) throws Exception {
        ModuleURN strategyURN;
        this.verifyNullProperties();
        LinkedList<Object> actualParameters = new LinkedList<Object>(Arrays.asList(inParameters));
        if (inParameters.length <= 6) {
            actualParameters.addFirst(null);
        }
        this.theStrategy = strategyURN = this.createModule(StrategyModuleFactory.PROVIDER_URN, actualParameters.toArray());
        this.verifyStrategyReady(strategyURN);
        return strategyURN;
    }

    protected ModuleURN createModule(ModuleURN inProvider, Object ... inParameters) throws Exception {
        ModuleURN urn = this.moduleManager.createModule(inProvider, inParameters);
        Assert.assertFalse((boolean)this.moduleManager.getModuleInfo(urn).getState().isStarted());
        this.moduleManager.start(urn);
        Assert.assertTrue((boolean)this.moduleManager.getModuleInfo(urn).getState().isStarted());
        this.runningModules.add(urn);
        return urn;
    }

    protected StrategyMXBean getMXProxy(ModuleURN inModuleURN) throws Exception {
        ObjectName objectName = inModuleURN.toObjectName();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        return JMX.newMXBeanProxy(server, objectName, StrategyMXBean.class, true);
    }

    protected final StrategyImpl getRunningStrategy(ModuleURN inStrategyURN) {
        Set runningStrategies = StrategyImpl.getRunningStrategies();
        for (StrategyImpl runningStrategy : runningStrategies) {
            if (!runningStrategy.getDefaultNamespace().equals(inStrategyURN.instanceName())) continue;
            return runningStrategy;
        }
        Assert.fail((String)(inStrategyURN + " not currently running"));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getClassPath() {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        try {
            Enumeration<URL> resourceEnumeration = classLoader.getResources("META-INF/MANIFEST.MF");
            while (resourceEnumeration.hasMoreElements()) {
                URL resourceURL = resourceEnumeration.nextElement();
                InputStream is = null;
                try {
                    is = resourceURL.openStream();
                    Manifest manifest = new Manifest(is);
                    String theClasspath = manifest.getMainAttributes().getValue("Class-Path");
                    if (theClasspath == null || theClasspath.trim().isEmpty()) continue;
                    for (String path : theClasspath.split(" ")) {
                        try {
                            URL pathURL = new URL(path);
                            paths.add(pathURL.toURI().getPath());
                        }
                        catch (MalformedURLException ignore) {
                        }
                        catch (URISyntaxException ignore) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException ignore) {}
                continue;
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return paths;
    }

    static {
        positions = new LinkedHashMap<Instrument, Position>();
        roots = LinkedHashMultimap.create();
        underlyings = new LinkedHashMap<String, String>();
        executionReportMultiplicity = 1;
    }

    public static class Position {
        private final SortedSet<Interval<BigDecimal>> position = new TreeSet<Interval<BigDecimal>>();
        private final Instrument instrument;

        public Position(Instrument inInstrument) {
            this(inInstrument, Position.generateRandomPosition());
        }

        public Position(Instrument inInstrument, List<Interval<BigDecimal>> inStartingPosition) {
            assert (inInstrument != null);
            assert (inStartingPosition != null);
            this.instrument = inInstrument;
            this.position.addAll(inStartingPosition);
        }

        public void add(Date inDate, BigDecimal inQuantity) {
            this.position.add(new Interval<BigDecimal>(inDate, inQuantity));
        }

        public List<Interval<BigDecimal>> getPositionView() {
            return Collections.unmodifiableList(new ArrayList<Interval<BigDecimal>>(this.position));
        }

        public BigDecimal getPositionAt(Date inDate) {
            Date dataPoint = new Date(inDate.getTime() + 1L);
            Interval<BigDecimal> point = new Interval<BigDecimal>(dataPoint, BigDecimal.ZERO);
            if (this.position.isEmpty() || this.position.first().compareTo(point) > 0) {
                return BigDecimal.ZERO;
            }
            SortedSet<Interval<BigDecimal>> earlierIntervals = this.position.headSet(point);
            if (earlierIntervals.isEmpty()) {
                return new BigDecimal(this.position.last().getValue().toString());
            }
            return new BigDecimal(earlierIntervals.last().getValue().toString());
        }

        public Instrument getInstrument() {
            return this.instrument;
        }

        public static final List<Interval<BigDecimal>> generateRandomPosition() {
            BigDecimal MINUS_ONE = new BigDecimal("-1");
            long currentMillis = System.currentTimeMillis();
            int seedWeek = random.nextInt(52) + 1;
            long difference = (long)seedWeek * 1000L * 60L * 60L * 24L * 7L;
            ArrayList<Interval<BigDecimal>> position = new ArrayList<Interval<BigDecimal>>();
            for (long seedMillis = currentMillis - difference; seedMillis < currentMillis; seedMillis += (long)((random.nextInt(7200) + 1) * 1000 * 60)) {
                position.add(new Interval<BigDecimal>(new Date(seedMillis), BigDecimalUtils.multiply((BigDecimal)BigDecimalUtils.multiply((BigDecimal)new BigDecimal(10000), (double)random.nextDouble()).setScale(0, RoundingMode.HALF_UP), (BigDecimal)(random.nextBoolean() ? MINUS_ONE : BigDecimal.ONE))));
            }
            return position;
        }

        public String toString() {
            StringBuffer output = new StringBuffer();
            output.append("Position for ").append(this.getInstrument()).append(SystemUtils.LINE_SEPARATOR);
            for (Interval interval : this.position) {
                output.append(interval).append(",");
            }
            return output.toString();
        }
    }

    public static class Interval<T>
    implements Comparable<Interval<T>> {
        private final Date date;
        private final T value;

        public Interval(Date inDate, T inValue) {
            assert (inDate != null);
            this.date = inDate;
            this.value = inValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Interval other = (Interval)obj;
            return !(this.date == null ? other.date != null : !this.date.equals(other.date));
        }

        public final Date getDate() {
            return this.date;
        }

        public final T getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Interval<T> inOther) {
            return this.getDate().compareTo(inOther.getDate());
        }

        public String toString() {
            return String.format("[%s:%s]", this.getDate(), this.getValue());
        }
    }

    private static enum ReportSendingTimeComparator implements Comparator<ReportBase>
    {
        INSTANCE;


        @Override
        public int compare(ReportBase inO1, ReportBase inO2) {
            return inO1.getSendingTime().compareTo(inO2.getSendingTime());
        }
    }

    public static class MockClient
    implements Client {
        public static boolean getBrokersFails = false;
        public static boolean getPositionFails = false;
        public Properties userdata;
        private final Set<ReportBase> reports = new TreeSet<ReportBase>(ReportSendingTimeComparator.INSTANCE);
        private volatile ConnectionException getReportsSinceThrows;

        public void addExceptionListener(ExceptionListener inArg0) {
            throw new UnsupportedOperationException();
        }

        public void addReportListener(ReportListener inArg0) {
            throw new UnsupportedOperationException();
        }

        public void addBrokerStatusListener(BrokerStatusListener inArg0) {
            throw new UnsupportedOperationException();
        }

        public void addServerStatusListener(ServerStatusListener inArg0) {
            throw new UnsupportedOperationException();
        }

        public void close() {
            throw new UnsupportedOperationException();
        }

        public BrokersStatus getBrokersStatus() throws ConnectionException {
            if (getBrokersFails) {
                throw new NullPointerException("This exception is expected");
            }
            return brokers;
        }

        public UserInfo getUserInfo(UserID id, boolean useCache) throws ConnectionException {
            throw new UnsupportedOperationException();
        }

        public Date getLastConnectTime() {
            throw new UnsupportedOperationException();
        }

        public ClientParameters getParameters() {
            throw new UnsupportedOperationException();
        }

        public BigDecimal getEquityPositionAsOf(Date inDate, Equity inEquity) throws ConnectionException {
            if (getPositionFails) {
                throw new NullPointerException("This exception is expected");
            }
            Position position = positions.get(inEquity);
            if (position == null) {
                return null;
            }
            return position.getPositionAt(inDate);
        }

        public Map<PositionKey<Equity>, BigDecimal> getAllEquityPositionsAsOf(Date inDate) throws ConnectionException {
            if (getPositionFails) {
                throw new NullPointerException("This exception is expected");
            }
            LinkedHashMap<PositionKey<Equity>, BigDecimal> result = new LinkedHashMap<PositionKey<Equity>, BigDecimal>();
            for (Map.Entry<Instrument, Position> entry : positions.entrySet()) {
                Equity equity;
                BigDecimal value;
                if (!(entry.getKey() instanceof Equity) || (value = this.getEquityPositionAsOf(inDate, equity = (Equity)entry.getKey())) == null) continue;
                PositionKey<Equity> key = new PositionKey<Equity>(){

                    public String getAccount() {
                        return null;
                    }

                    public String toString() {
                        return this.getInstrument().getSymbol();
                    }

                    public Equity getInstrument() {
                        return equity;
                    }

                    public String getTraderId() {
                        return null;
                    }
                };
                result.put(key, value);
            }
            return result;
        }

        public Map<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(Date inDate) throws ConnectionException {
            if (getPositionFails) {
                throw new NullPointerException("This exception is expected");
            }
            LinkedHashMap<PositionKey<Option>, BigDecimal> result = new LinkedHashMap<PositionKey<Option>, BigDecimal>();
            for (Map.Entry<Instrument, Position> entry : positions.entrySet()) {
                Option option;
                BigDecimal value;
                if (!(entry.getKey() instanceof Option) || (value = this.getOptionPositionAsOf(inDate, option = (Option)entry.getKey())) == null) continue;
                PositionKey<Option> key = new PositionKey<Option>(){

                    public String toString() {
                        return this.getInstrument().getSymbol();
                    }

                    public String getAccount() {
                        return null;
                    }

                    public Option getInstrument() {
                        return option;
                    }

                    public String getTraderId() {
                        return null;
                    }
                };
                result.put(key, value);
            }
            return result;
        }

        public BigDecimal getOptionPositionAsOf(Date inDate, Option inOption) throws ConnectionException {
            if (getPositionFails) {
                throw new NullPointerException("This exception is expected");
            }
            Position position = positions.get(inOption);
            if (position == null) {
                return null;
            }
            return position.getPositionAt(inDate);
        }

        public Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(Date inDate, String ... inRootSymbols) throws ConnectionException {
            if (getPositionFails) {
                throw new NullPointerException("This exception is expected");
            }
            HashSet<String> rootSymbols = new HashSet<String>(Arrays.asList(inRootSymbols));
            Map<PositionKey<Option>, BigDecimal> allOptionPositions = this.getAllOptionPositionsAsOf(inDate);
            LinkedHashMap<PositionKey<Option>, BigDecimal> result = new LinkedHashMap<PositionKey<Option>, BigDecimal>();
            for (Map.Entry<PositionKey<Option>, BigDecimal> position : allOptionPositions.entrySet()) {
                if (!rootSymbols.contains(((Option)position.getKey().getInstrument()).getSymbol())) continue;
                result.put(position.getKey(), position.getValue());
            }
            return result;
        }

        public Map<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(Date inDate) throws ConnectionException {
            throw new UnsupportedOperationException();
        }

        public BigDecimal getFuturePositionAsOf(Date inDate, Future inEquity) throws ConnectionException {
            throw new UnsupportedOperationException();
        }

        public Collection<String> getOptionRoots(String inUnderlying) throws ConnectionException {
            if (getPositionFails) {
                throw new NullPointerException("This exception is expected");
            }
            return roots.get((Object)inUnderlying);
        }

        public String getUnderlying(String inOptionRoot) throws ConnectionException {
            if (getPositionFails) {
                throw new NullPointerException("This exception is expected");
            }
            return underlyings.get(inOptionRoot);
        }

        public ReportBase[] getReportsSince(Date inDate) throws ConnectionException {
            if (this.getReportsSinceThrows != null) {
                throw this.getReportsSinceThrows;
            }
            ArrayList<ReportBase> reportsToReturn = new ArrayList<ReportBase>();
            for (ReportBase report : this.reports) {
                if (report.getSendingTime().compareTo(inDate) == -1) continue;
                reportsToReturn.add(report);
            }
            return reportsToReturn.toArray(new ReportBase[reportsToReturn.size()]);
        }

        public void reconnect() throws ConnectionException {
            throw new UnsupportedOperationException();
        }

        public void reconnect(ClientParameters inArg0) throws ConnectionException {
            throw new UnsupportedOperationException();
        }

        public void removeExceptionListener(ExceptionListener inArg0) {
            throw new UnsupportedOperationException();
        }

        public void removeReportListener(ReportListener inArg0) {
            throw new UnsupportedOperationException();
        }

        public void removeBrokerStatusListener(BrokerStatusListener inArg0) {
            throw new UnsupportedOperationException();
        }

        public void removeServerStatusListener(ServerStatusListener inArg0) {
            throw new UnsupportedOperationException();
        }

        public void sendOrder(OrderSingle inArg0) throws ConnectionException, OrderValidationException {
            throw new UnsupportedOperationException();
        }

        public void sendOrder(OrderReplace inArg0) throws ConnectionException, OrderValidationException {
            throw new UnsupportedOperationException();
        }

        public void sendOrder(OrderCancel inArg0) throws ConnectionException, OrderValidationException {
            throw new UnsupportedOperationException();
        }

        public void sendOrderRaw(FIXOrder inArg0) throws ConnectionException, OrderValidationException {
            throw new UnsupportedOperationException();
        }

        public boolean isCredentialsMatch(String inUsername, char[] inPassword) {
            throw new UnsupportedOperationException();
        }

        public boolean isServerAlive() {
            throw new UnsupportedOperationException();
        }

        public Properties getUserData() throws ConnectionException {
            return this.userdata;
        }

        public void setUserData(Properties inProperties) throws ConnectionException {
            this.userdata = inProperties;
        }

        public static class MockClientFactory
        implements ClientFactory {
            public Client getClient(ClientParameters inClientParameters) throws ClientInitException, ConnectionException {
                return new MockClient();
            }
        }
    }

    public static class StrategyDataEmissionModule
    extends Module
    implements DataEmitter {
        private static final List<Object> dataToSend = new ArrayList<Object>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static List<Object> getDataToSend() {
            List<Object> list = dataToSend;
            synchronized (list) {
                return dataToSend;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setDataToSendToDefaults() throws Exception {
            List<Object> list = dataToSend;
            synchronized (list) {
                dataToSend.clear();
                dataToSend.add(EventTestBase.generateEquityTradeEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("GOOG"), (String)"Exchange", (BigDecimal)new BigDecimal("100"), (BigDecimal)new BigDecimal("10000")));
                dataToSend.add(EventTestBase.generateEquityBidEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("GOOG"), (String)"Exchange", (BigDecimal)new BigDecimal("200"), (BigDecimal)new BigDecimal("20000")));
                dataToSend.add(EventTestBase.generateEquityAskEvent((long)System.nanoTime(), (long)System.currentTimeMillis(), (Equity)new Equity("GOOG"), (String)"Exchange", (BigDecimal)new BigDecimal("200"), (BigDecimal)new BigDecimal("20000")));
                dataToSend.add(EventTestBase.generateDividendEvent());
                Message orderCancelReject = FIXVersion.FIX44.getMessageFactory().newOrderCancelReject();
                OrderCancelReject cancel = org.marketcetera.trade.Factory.getInstance().createOrderCancelReject(orderCancelReject, null, Originator.Server, null, null);
                dataToSend.add(cancel);
                Message executionReport = FIXVersion.FIX44.getMessageFactory().newExecutionReport("orderid", "clOrderID", "execID", '2', '1', new BigDecimal(100), new BigDecimal(200), new BigDecimal(300), new BigDecimal(400), new BigDecimal(500), new BigDecimal(600), (Instrument)new Equity("Symbol"), "account", "text");
                dataToSend.add(org.marketcetera.trade.Factory.getInstance().createExecutionReport(executionReport, new BrokerID("some-broker"), Originator.Server, null, null));
                dataToSend.add(new Date());
            }
        }

        protected StrategyDataEmissionModule(ModuleURN inURN) {
            super(inURN, false);
        }

        protected void preStart() throws ModuleException {
        }

        protected void preStop() throws ModuleException {
        }

        public void cancel(DataFlowID inFlowID, RequestID inRequestID) {
        }

        public void requestData(DataRequest inRequest, DataEmitterSupport inSupport) throws UnsupportedRequestParameterType, IllegalRequestParameterValue {
            try {
                this.sendDataTypes(inSupport);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalRequestParameterValue(null, (Object)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendDataTypes(DataEmitterSupport inSupport) throws Exception {
            List<Object> list = dataToSend;
            synchronized (list) {
                for (Object o : dataToSend) {
                    inSupport.send(o);
                }
            }
        }

        public static class Factory
        extends ModuleFactory {
            private static final AtomicLong instanceCounter = new AtomicLong();
            public static final ModuleURN PROVIDER_URN = new ModuleURN("metc:emitter:system");

            public Factory() {
                super(PROVIDER_URN, (I18NBoundMessage)org.marketcetera.module.TestMessages.FLOW_REQUESTER_PROVIDER, true, false, new Class[0]);
            }

            public Module create(Object ... inParameters) throws ModuleCreationException {
                return new StrategyDataEmissionModule(new ModuleURN(PROVIDER_URN, "strategyDataEmissionModule" + instanceCounter.incrementAndGet()));
            }
        }
    }

    public static class MockRecorderModule
    extends Module
    implements DataReceiver,
    DataEmitter {
        public static boolean shouldSendExecutionReports = true;
        public static boolean shouldFullyFillOrders = true;
        public static boolean shouldIgnoreLogMessages = true;
        public static int ordersReceived = 0;
        private final Map<RequestID, DataEmitterSupport> subscribers = new HashMap<RequestID, DataEmitterSupport>();
        private final List<DataReceived> data = new ArrayList<DataReceived>();

        protected MockRecorderModule(ModuleURN inURN) {
            super(inURN, false);
        }

        protected void preStart() throws ModuleException {
        }

        protected void preStop() throws ModuleException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveData(DataFlowID inFlowID, Object inData) throws UnsupportedDataTypeException, StopDataFlowException {
            if (inData instanceof LogEvent && shouldIgnoreLogMessages) {
                return;
            }
            List<DataReceived> list = this.data;
            synchronized (list) {
                this.data.add(new DataReceived(inFlowID, inData));
            }
            if (inData instanceof OrderSingle) {
                if (shouldSendExecutionReports) {
                    OrderSingle order = (OrderSingle)inData;
                    try {
                        List<ExecutionReport> executionReports = StrategyTestBase.generateExecutionReports(order);
                        Map<RequestID, DataEmitterSupport> map = this.subscribers;
                        synchronized (map) {
                            for (ExecutionReport executionReport : executionReports) {
                                for (DataEmitterSupport subscriber : this.subscribers.values()) {
                                    subscriber.send((Object)executionReport);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new StopDataFlowException((Throwable)e, null);
                    }
                }
                ++ordersReceived;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(DataFlowID inFlowID, RequestID inRequestID) {
            Map<RequestID, DataEmitterSupport> map = this.subscribers;
            synchronized (map) {
                this.subscribers.remove(inRequestID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestData(DataRequest inRequest, DataEmitterSupport inRequester) throws RequestDataException {
            Map<RequestID, DataEmitterSupport> map = this.subscribers;
            synchronized (map) {
                this.subscribers.put(inRequester.getRequestID(), inRequester);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetDataReceived() {
            List<DataReceived> list = this.data;
            synchronized (list) {
                this.data.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<DataReceived> getDataReceived() {
            List<DataReceived> list = this.data;
            synchronized (list) {
                return new ArrayList<DataReceived>(this.data);
            }
        }

        public static class DataReceived {
            private final DataFlowID dataFlowID;
            private final Object data;

            private DataReceived(DataFlowID inDataFlowID, Object inData) {
                this.dataFlowID = inDataFlowID;
                this.data = inData;
            }

            public DataFlowID getDataFlowID() {
                return this.dataFlowID;
            }

            public String toString() {
                return this.data == null ? "null data" : this.data.toString();
            }

            public Object getData() {
                return this.data;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                DataReceived other = (DataReceived)obj;
                return !(this.data == null ? other.data != null : !this.data.equals(other.data));
            }
        }

        public static class Factory
        extends ModuleFactory {
            private static final AtomicLong instanceCounter = new AtomicLong();
            public static final ModuleURN PROVIDER_URN = new ModuleURN("metc:receiver:system");
            public static final Map<ModuleURN, MockRecorderModule> recorders = new HashMap<ModuleURN, MockRecorderModule>();

            public Factory() {
                super(PROVIDER_URN, (I18NBoundMessage)org.marketcetera.module.TestMessages.FLOW_REQUESTER_PROVIDER, true, false, new Class[0]);
            }

            public Module create(Object ... inParameters) throws ModuleCreationException {
                MockRecorderModule module = new MockRecorderModule(new ModuleURN(PROVIDER_URN, "mockRecorderModule" + instanceCounter.incrementAndGet()));
                recorders.put(module.getURN(), module);
                return module;
            }
        }
    }

    public static class StrategyCoordinates {
        private final File file;
        private final String name;

        public static StrategyCoordinates get(File inFile, String inName) {
            return new StrategyCoordinates(inFile, inName);
        }

        private StrategyCoordinates(File inFile, String inName) {
            this.file = inFile;
            this.name = inName;
        }

        public final File getFile() {
            return this.file;
        }

        public final String getName() {
            return this.name;
        }
    }
}

