/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import java.io.Serializable;
import java.util.Vector;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.jruby.exceptions.RaiseException;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.event.LogEvent;
import org.marketcetera.event.impl.LogEventBuilder;
import org.marketcetera.strategy.CompilationFailed;
import org.marketcetera.strategy.ExecutionEngine;
import org.marketcetera.strategy.Language;
import org.marketcetera.strategy.Messages;
import org.marketcetera.strategy.RubyExecutor;
import org.marketcetera.strategy.Strategy;
import org.marketcetera.strategy.StrategyException;
import org.marketcetera.strategy.StrategyModule;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.SLF4JLoggerProxy;

@ClassVersion(value="$Id: BeanScriptingFrameworkEngine.java 16154 2012-07-14 16:34:05Z colin $")
class BeanScriptingFrameworkEngine
implements ExecutionEngine {
    private static final BSFManager scriptManager = new BSFManager();
    private static BSFEngine scriptEngine;
    private Strategy strategy;
    private String processedScript;

    BeanScriptingFrameworkEngine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(Strategy inStrategy, String inProcessedScript) throws StrategyException {
        this.strategy = inStrategy;
        this.processedScript = inProcessedScript;
        SLF4JLoggerProxy.debug((Object)this, (String)"Preparing {}", (Object[])new Object[]{inStrategy});
        BeanScriptingFrameworkEngine.registerScriptEngines();
        String languageString = inStrategy.getLanguage().name();
        try {
            BSFManager bSFManager = scriptManager;
            synchronized (bSFManager) {
                if (scriptEngine == null) {
                    String classpath = System.getProperty("strategy.classpath");
                    SLF4JLoggerProxy.debug((Object)this, (String)"Setting classpath to {}", (Object[])new Object[]{classpath});
                    scriptManager.setClassPath(classpath);
                    scriptEngine = scriptManager.loadScriptingEngine(languageString);
                    SLF4JLoggerProxy.debug((Object)this, (String)"Initializing engine...");
                    scriptEngine.initialize(scriptManager, languageString, new Vector());
                } else {
                    SLF4JLoggerProxy.debug((Object)this, (String)"Reusing intialized engine...");
                }
            }
        }
        catch (BSFException e) {
            StrategyModule.log((LogEvent)LogEventBuilder.error().withMessage(Messages.NO_SUPPORT_FOR_LANGUAGE, (Serializable)((Object)languageString)).withException((Throwable)e).create(), this.strategy);
            throw new StrategyException(e, (I18NBoundMessage)new I18NBoundMessage1P(Messages.NO_SUPPORT_FOR_LANGUAGE, (Serializable)((Object)languageString)));
        }
    }

    @Override
    public Object start() throws StrategyException {
        try {
            return scriptEngine.eval(this.strategy.getLanguage().name(), 0, 0, (Object)this.processedScript);
        }
        catch (BSFException e) {
            CompilationFailed failed = new CompilationFailed(this.strategy);
            if (e.getTargetException() instanceof RaiseException) {
                failed.addDiagnostic(CompilationFailed.Diagnostic.error(RubyExecutor.exceptionAsString((Exception)((Object)e))));
            }
            StrategyModule.log((LogEvent)LogEventBuilder.error().withMessage(Messages.COMPILATION_FAILED, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)failed.toString())).withException((Throwable)((Object)failed)).create(), this.strategy);
            throw failed;
        }
    }

    @Override
    public void stop() throws StrategyException {
    }

    private static void registerScriptEngines() {
        if (!BSFManager.isLanguageRegistered((String)Language.RUBY.name())) {
            BSFManager.registerScriptingEngine((String)Language.RUBY.name(), (String)"org.jruby.javasupport.bsf.JRubyEngine", (String[])new String[]{"rb"});
        }
    }
}

