/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.event.LogEvent;
import org.marketcetera.event.impl.LogEventBuilder;
import org.marketcetera.strategy.CompilationFailed;
import org.marketcetera.strategy.ExecutionEngine;
import org.marketcetera.strategy.Messages;
import org.marketcetera.strategy.Strategy;
import org.marketcetera.strategy.StrategyException;
import org.marketcetera.strategy.StrategyModule;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.SLF4JLoggerProxy;

@ClassVersion(value="$Id: JavaCompilerExecutionEngine.java 16154 2012-07-14 16:34:05Z colin $")
public class JavaCompilerExecutionEngine
implements ExecutionEngine,
Messages {
    public static final String CLASSPATH_KEY = "metc.java.class.path";
    private Strategy strategy;
    private String processedScript;
    private Map<String, String> fullyQualifiedClassnames = new HashMap<String, String>();

    @Override
    public void prepare(Strategy inStrategy, String inProcessedScript) throws StrategyException {
        this.strategy = inStrategy;
        this.processedScript = inProcessedScript;
    }

    @Override
    public Object start() throws StrategyException {
        String strategyPath;
        SourceJavaFileObject sourceObject;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new StrategyException((I18NBoundMessage)MISSING_JAVA_COMPILER);
        }
        HashMap output = new HashMap();
        InMemoryClassLoader loader = new InMemoryClassLoader(output, StrategyModule.class.getClassLoader());
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(diagnostics, null, null);
        InMemoryFileManager specializedFileManager = new InMemoryFileManager(standardFileManager, output, loader);
        try {
            sourceObject = new SourceJavaFileObject(this.strategy.getName(), this.processedScript);
        }
        catch (URISyntaxException e) {
            throw new StrategyException(e, (I18NBoundMessage)new I18NBoundMessage1P(INVALID_STRATEGY_NAME, (Serializable)((Object)this.strategy.toString())));
        }
        LinkedHashSet<String> classpathEntries = new LinkedHashSet<String>();
        String systemPath = System.getProperty("java.class.path");
        if (systemPath != null) {
            String[] entries = systemPath.split(File.pathSeparator);
            classpathEntries.addAll(Arrays.asList(entries));
        }
        ClassLoader currentLoader = this.getClass().getClassLoader();
        do {
            if (!(currentLoader instanceof URLClassLoader)) continue;
            for (URL url : ((URLClassLoader)currentLoader).getURLs()) {
                try {
                    classpathEntries.add(url.toURI().getPath());
                }
                catch (URISyntaxException e) {
                    Messages.ERROR_CONVERTING_CLASSPATH_URL.warn((Object)this, (Throwable)e, (Object)url);
                }
            }
        } while ((currentLoader = currentLoader.getParent()) != null);
        String customPath = System.getProperty(CLASSPATH_KEY);
        if (customPath != null) {
            String[] entries = customPath.split(File.pathSeparator);
            classpathEntries.addAll(Arrays.asList(entries));
        }
        if ((strategyPath = System.getProperty("strategy.classpath")) != null) {
            String[] entries = strategyPath.split(File.pathSeparator);
            classpathEntries.addAll(Arrays.asList(entries));
        }
        ArrayList<String> options = new ArrayList<String>();
        options.add("-g");
        options.add("-cp");
        StringBuilder classpathString = new StringBuilder();
        for (String entry : classpathEntries) {
            classpathString.append(entry).append(File.pathSeparator);
        }
        options.add(classpathString.toString());
        SLF4JLoggerProxy.debug(JavaCompilerExecutionEngine.class, (String)"Java compiler compiling {} with options {} (classpath length: {})", (Object[])new Object[]{this.strategy.getName(), Arrays.toString(options.toArray()), classpathString.length()});
        JavaCompiler.CompilationTask compilationJob = compiler.getTask(null, specializedFileManager, diagnostics, options, null, Arrays.asList(sourceObject));
        if (!compilationJob.call().booleanValue()) {
            CompilationFailed failed = new CompilationFailed(this.strategy);
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                if (diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR)) {
                    failed.addDiagnostic(CompilationFailed.Diagnostic.error(diagnostic.toString()));
                    continue;
                }
                failed.addDiagnostic(CompilationFailed.Diagnostic.warning(diagnostic.toString()));
            }
            StrategyModule.log((LogEvent)LogEventBuilder.error().withMessage(COMPILATION_FAILED, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)failed.toString())).withException((Throwable)((Object)failed)).create(), this.strategy);
            throw failed;
        }
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(COMPILATION_FAILED_DIAGNOSTIC, (Serializable)((Object)String.valueOf((Object)diagnostic.getKind())), (Serializable)((Object)String.valueOf(diagnostic))).create(), this.strategy);
        }
        try {
            String fullyQualifiedClassname = this.fullyQualifiedClassnames.get(this.strategy.getName());
            SLF4JLoggerProxy.debug(JavaCompilerExecutionEngine.class, (String)"The fully-qualified name of {} is {}", (Object[])new Object[]{this.strategy.getName(), fullyQualifiedClassname});
            assert (fullyQualifiedClassname != null);
            Class<?> c = Class.forName(fullyQualifiedClassname, true, loader);
            return c.newInstance();
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.error().withMessage(COMPILATION_FAILED, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(e))).withException((Throwable)e).create(), this.strategy);
            throw new CompilationFailed((Throwable)e, this.strategy);
        }
    }

    @Override
    public void stop() throws StrategyException {
    }

    @ClassVersion(value="$Id: JavaCompilerExecutionEngine.java 16154 2012-07-14 16:34:05Z colin $")
    private static class InMemoryJavaFileObject
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream bytes;

        private InMemoryJavaFileObject(String name, JavaFileObject.Kind kind) throws URISyntaxException {
            super(new URI(name), kind);
        }

        @Override
        public OutputStream openOutputStream() {
            this.bytes = new ByteArrayOutputStream();
            return this.bytes;
        }

        private byte[] getBytes() {
            return this.bytes.toByteArray();
        }
    }

    @ClassVersion(value="$Id: JavaCompilerExecutionEngine.java 16154 2012-07-14 16:34:05Z colin $")
    private class InMemoryFileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        private final Map<String, InMemoryJavaFileObject> output;
        private final ClassLoader loader;

        private InMemoryFileManager(StandardJavaFileManager inFileManager, Map<String, InMemoryJavaFileObject> inOutput, ClassLoader inClassLoader) {
            super(inFileManager);
            this.output = inOutput;
            this.loader = inClassLoader;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location inLocation, String inFullyQualifiedClassname, JavaFileObject.Kind inKind, FileObject inSibling) throws IOException {
            InMemoryJavaFileObject javaFileObject;
            try {
                javaFileObject = new InMemoryJavaFileObject(inFullyQualifiedClassname, inKind);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            String cannonicalClassname = this.getCannonicalClassname(inFullyQualifiedClassname);
            JavaCompilerExecutionEngine.this.fullyQualifiedClassnames.put(cannonicalClassname, inFullyQualifiedClassname);
            this.output.put(inFullyQualifiedClassname, javaFileObject);
            return javaFileObject;
        }

        private String getCannonicalClassname(String inFullyQualifiedClassname) {
            String[] nameSegments = inFullyQualifiedClassname.split("\\.");
            return nameSegments.length > 0 ? nameSegments[nameSegments.length - 1] : inFullyQualifiedClassname;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location inLocation) {
            return this.loader;
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location inLocation, JavaFileObject inJavaFileObject) {
            String result = inLocation == StandardLocation.CLASS_PATH && inJavaFileObject instanceof InMemoryJavaFileObject ? inJavaFileObject.getName() : super.inferBinaryName(inLocation, inJavaFileObject);
            return result;
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location inLocation, String inPackageName, Set<JavaFileObject.Kind> inKinds, boolean inShouldRecurse) throws IOException {
            Iterable<JavaFileObject> result = super.list(inLocation, inPackageName, inKinds, inShouldRecurse);
            if (inLocation == StandardLocation.CLASS_PATH && inPackageName.equals("just.generated") && inKinds.contains((Object)JavaFileObject.Kind.CLASS)) {
                ArrayList<JavaFileObject> temp = new ArrayList<JavaFileObject>();
                for (JavaFileObject javaFileObject : result) {
                    temp.add(javaFileObject);
                }
                for (Map.Entry entry : this.output.entrySet()) {
                    temp.add((JavaFileObject)entry.getValue());
                }
                result = temp;
            }
            return result;
        }
    }

    @ClassVersion(value="$Id: JavaCompilerExecutionEngine.java 16154 2012-07-14 16:34:05Z colin $")
    private static class InMemoryClassLoader
    extends ClassLoader {
        private final Map<String, InMemoryJavaFileObject> cache;

        private InMemoryClassLoader(Map<String, InMemoryJavaFileObject> inOutput, ClassLoader inParent) {
            super(inParent);
            this.cache = inOutput;
        }

        @Override
        protected Class<?> findClass(String inName) throws ClassNotFoundException {
            InMemoryJavaFileObject fileObject = this.cache.get(inName);
            if (fileObject != null) {
                byte[] bytes = fileObject.getBytes();
                return this.defineClass(inName, bytes, 0, bytes.length);
            }
            return super.findClass(inName);
        }
    }

    @ClassVersion(value="$Id: JavaCompilerExecutionEngine.java 16154 2012-07-14 16:34:05Z colin $")
    private static class SourceJavaFileObject
    extends SimpleJavaFileObject {
        private static final String JAVA_EXTENSION = ".java";
        private final String source;

        private SourceJavaFileObject(String inClassName, String inClassSource) throws URISyntaxException {
            super(new URI(String.format("%s%s", inClassName, JAVA_EXTENSION)), JavaFileObject.Kind.SOURCE);
            this.source = inClassSource;
        }

        @Override
        public CharSequence getCharContent(boolean inIgnoreEncodingErrors) {
            return this.source;
        }
    }
}

