/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.marketcetera.client.Client;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ClientModuleFactory;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.core.Util;
import org.marketcetera.core.notifications.Notification;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.core.publisher.ISubscriber;
import org.marketcetera.core.publisher.PublisherEngine;
import org.marketcetera.event.Event;
import org.marketcetera.event.LogEvent;
import org.marketcetera.event.LogEventLevel;
import org.marketcetera.event.impl.LogEventBuilder;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.metrics.ThreadedMetric;
import org.marketcetera.module.DataEmitter;
import org.marketcetera.module.DataEmitterSupport;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataFlowRequester;
import org.marketcetera.module.DataFlowSupport;
import org.marketcetera.module.DataReceiver;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.IllegalRequestParameterValue;
import org.marketcetera.module.Module;
import org.marketcetera.module.ModuleCreationException;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.RequestID;
import org.marketcetera.module.StopDataFlowException;
import org.marketcetera.module.UnsupportedDataTypeException;
import org.marketcetera.module.UnsupportedRequestParameterType;
import org.marketcetera.strategy.Language;
import org.marketcetera.strategy.Messages;
import org.marketcetera.strategy.OutputType;
import org.marketcetera.strategy.ServicesProvider;
import org.marketcetera.strategy.Status;
import org.marketcetera.strategy.Strategy;
import org.marketcetera.strategy.StrategyImpl;
import org.marketcetera.strategy.StrategyMXBean;
import org.marketcetera.strategy.StrategyModuleFactory;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.Suggestion;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.I18NBoundMessage3P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import quickfix.Message;

@ClassVersion(value="$Id: StrategyModule.java 16154 2012-07-14 16:34:05Z colin $")
final class StrategyModule
extends Module
implements DataEmitter,
DataFlowRequester,
DataReceiver,
ServicesProvider,
StrategyMXBean,
NotificationEmitter {
    private final String name;
    private final Language type;
    private final File source;
    private boolean routeOrdersToORS;
    private Properties parameters;
    private ModuleURN outputDestination;
    private final PublisherEngine ordersPublisher = new PublisherEngine(true);
    private final PublisherEngine suggestionsPublisher = new PublisherEngine(true);
    private final PublisherEngine eventsPublisher = new PublisherEngine(true);
    private final PublisherEngine notificationsPublisher = new PublisherEngine(true);
    private final PublisherEngine logPublisher = new PublisherEngine(true);
    private final PublisherEngine allPublisher = new PublisherEngine(true);
    private final Map<RequestID, DataRequester> subscribers = new HashMap<RequestID, DataRequester>();
    private StrategyImpl strategy;
    private DataFlowSupport dataFlowSupport;
    private DataFlowID orsFlow;
    static volatile ClientFactory clientFactory = new ClientFactory(){

        @Override
        public Client getClient() throws ClientInitException {
            return ClientManager.getInstance();
        }
    };
    private static final AtomicInteger counter = new AtomicInteger();
    private final BiMap<DataFlowID, Integer> dataFlows = HashBiMap.create();
    private final Map<ModuleURN, DataEmitterSupport> internalDataFlows = new HashMap<ModuleURN, DataEmitterSupport>();
    private final NotificationBroadcasterSupport notificationDelegate;
    private final AtomicLong jmxNotificationCounter = new AtomicLong();

    public void cancel(DataFlowID inFlowID, RequestID inRequestID) {
        this.unsubscribe(inRequestID);
    }

    public void requestData(DataRequest inRequest, DataEmitterSupport inSupport) throws UnsupportedRequestParameterType, IllegalRequestParameterValue {
        OutputType request;
        Object requestPayload = inRequest.getData();
        if (requestPayload == null) {
            throw new IllegalRequestParameterValue(this.getURN(), null);
        }
        if (requestPayload instanceof String) {
            try {
                request = OutputType.valueOf(((String)requestPayload).toUpperCase());
            }
            catch (Exception e) {
                throw new IllegalRequestParameterValue(this.getURN(), requestPayload);
            }
        } else if (requestPayload instanceof OutputType) {
            request = (OutputType)((Object)requestPayload);
        } else {
            if (requestPayload instanceof InternalRequest) {
                InternalRequest internalRequest = (InternalRequest)requestPayload;
                SLF4JLoggerProxy.debug(StrategyModule.class, (String)"{} received a request to set up a specialized data flow to {}", (Object[])new Object[]{this.strategy, internalRequest.originalRequester});
                this.internalDataFlows.put(internalRequest.originalRequester, inSupport);
                return;
            }
            throw new UnsupportedRequestParameterType(this.getURN(), requestPayload);
        }
        this.subscribe(request, inSupport);
    }

    public void setFlowSupport(DataFlowSupport inSupport) {
        this.dataFlowSupport = inSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveData(DataFlowID inFlowID, Object inData) throws UnsupportedDataTypeException, StopDataFlowException {
        ThreadedMetric.event((String)"strategy-IN", (Object[])new Object[0]);
        this.assertStateForReceiveData();
        SLF4JLoggerProxy.trace(StrategyModule.class, (String)"{} received {}", (Object[])new Object[]{this.strategy, inData});
        if (inData instanceof Event) {
            Event event = (Event)inData;
            BiMap<DataFlowID, Integer> biMap = this.dataFlows;
            synchronized (biMap) {
                event.setSource(this.dataFlows.get((Object)inFlowID));
            }
        }
        this.strategy.dataReceived(inData);
    }

    @Override
    public void cancelOrder(OrderCancel inCancel) {
        this.publish(inCancel);
    }

    @Override
    public void cancelReplace(OrderReplace inReplace) {
        this.publish(inReplace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int requestMarketData(MarketDataRequest inRequest) {
        if (inRequest == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_MARKET_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inRequest).create(), this.strategy);
            return 0;
        }
        int requestID = counter.incrementAndGet();
        try {
            ModuleURN marketDataURN = StrategyModule.constructMarketDataUrn(inRequest.getProvider());
            SLF4JLoggerProxy.debug(StrategyModule.class, (String)"{} received a market data request {} for data from {}", (Object[])new Object[]{this.strategy, inRequest, marketDataURN});
            DataFlowID dataFlowID = this.dataFlowSupport.createDataFlow(new DataRequest[]{new DataRequest(marketDataURN, (Object)inRequest), new DataRequest(this.getURN())}, false);
            BiMap<DataFlowID, Integer> biMap = this.dataFlows;
            synchronized (biMap) {
                this.dataFlows.put((Object)dataFlowID, (Object)requestID);
            }
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.MARKET_DATA_REQUEST_FAILED, (Serializable)inRequest).withException((Throwable)e).create(), this.strategy);
            return 0;
        }
        return requestID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int requestProcessedMarketData(MarketDataRequest inRequest, String[] inStatements, String inCEPSource, String inNamespace) {
        if (inRequest == null || inStatements == null || inStatements.length == 0 || inCEPSource == null || inCEPSource.isEmpty() || inNamespace == null || inNamespace.isEmpty()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_COMBINED_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inRequest, (Serializable)((Object)Arrays.toString(inStatements)), (Serializable)((Object)inCEPSource), (Serializable)((Object)inNamespace)).create(), this.strategy);
            return 0;
        }
        int requestID = counter.incrementAndGet();
        try {
            ModuleURN marketDataURN = StrategyModule.constructMarketDataUrn(inRequest.getProvider());
            ModuleURN cepDataURN = StrategyModule.constructCepUrn(inCEPSource, inNamespace);
            SLF4JLoggerProxy.debug(StrategyModule.class, (String)"{} received a processed market data request {} for market data from {} via {}", (Object[])new Object[]{this.strategy, inRequest, marketDataURN, cepDataURN});
            DataFlowID dataFlowID = this.dataFlowSupport.createDataFlow(new DataRequest[]{new DataRequest(marketDataURN, (Object)inRequest), new DataRequest(cepDataURN, StrategyModule.determineCepStatements(inCEPSource, inStatements)), new DataRequest(this.getURN())}, false);
            BiMap<DataFlowID, Integer> biMap = this.dataFlows;
            synchronized (biMap) {
                this.dataFlows.put((Object)dataFlowID, (Object)requestID);
            }
            return requestID;
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.COMBINED_DATA_REQUEST_FAILED, (Serializable)inRequest, (Serializable)((Object)Arrays.toString(inStatements)), (Serializable)((Object)inCEPSource), (Serializable)((Object)inNamespace)).withException((Throwable)e).create(), this.strategy);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAllDataRequests() {
        BiMap<DataFlowID, Integer> biMap = this.dataFlows;
        synchronized (biMap) {
            ArrayList activeRequests = new ArrayList(this.dataFlows.inverse().keySet());
            Iterator i$ = activeRequests.iterator();
            while (i$.hasNext()) {
                int request = (Integer)i$.next();
                try {
                    this.cancelDataRequest(request);
                }
                catch (Exception e) {
                    StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.UNABLE_TO_CANCEL_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)Integer.valueOf(request)).withException((Throwable)e).create(), this.strategy);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelDataRequest(int inDataRequestID) {
        BiMap<DataFlowID, Integer> biMap = this.dataFlows;
        synchronized (biMap) {
            if (!this.dataFlows.inverse().containsKey((Object)inDataRequestID)) {
                StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.NO_DATA_HANDLE, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)Integer.valueOf(inDataRequestID)).create(), this.strategy);
                return;
            }
            try {
                this.doCancelDataRequest(inDataRequestID);
            }
            catch (Exception e) {
                StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.UNABLE_TO_CANCEL_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)Integer.valueOf(inDataRequestID)).withException((Throwable)e).create(), this.strategy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int requestCEPData(String[] inStatements, String inSource, String inNamespace) {
        if (inStatements == null || inStatements.length == 0) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_CEP_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)Arrays.toString(inStatements)), (Serializable)((Object)String.valueOf(inSource)), (Serializable)((Object)String.valueOf(inNamespace))).create(), this.strategy);
            return 0;
        }
        int requestID = counter.incrementAndGet();
        ModuleURN providerURN = StrategyModule.constructCepUrn(inSource, inNamespace);
        try {
            BiMap<DataFlowID, Integer> biMap = this.dataFlows;
            synchronized (biMap) {
                DataFlowID flowID = this.dataFlowSupport.createDataFlow(new DataRequest[]{new DataRequest(providerURN, StrategyModule.determineCepStatements(inSource, inStatements)), new DataRequest(this.getURN())}, false);
                this.dataFlows.put((Object)flowID, (Object)requestID);
            }
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CEP_REQUEST_FAILED, (Serializable)((Object)Arrays.toString(inStatements)), (Serializable)((Object)inSource)).withException((Throwable)e).create(), this.strategy);
            return 0;
        }
        return requestID;
    }

    @Override
    public void setOutputDestination(String inDestination) {
        if (inDestination == null || inDestination.isEmpty()) {
            this.outputDestination = null;
            SLF4JLoggerProxy.debug(StrategyModule.class, (String)"Setting output destination to null");
            return;
        }
        this.outputDestination = new ModuleURN(inDestination);
        SLF4JLoggerProxy.debug(StrategyModule.class, (String)"Setting output destination to {}", (Object[])new Object[]{this.outputDestination});
    }

    @Override
    public void setParameters(String inParameters) {
        if (inParameters == null || inParameters.isEmpty()) {
            this.parameters = null;
            SLF4JLoggerProxy.debug(StrategyModule.class, (String)"Setting parameters to null");
            return;
        }
        if (this.parameters != null) {
            this.parameters.clear();
        }
        this.parameters = Util.propertiesFromString((String)inParameters);
        SLF4JLoggerProxy.debug(StrategyModule.class, (String)"Setting parameters to {}", (Object[])new Object[]{this.parameters});
    }

    @Override
    public String getOutputDestination() {
        if (this.outputDestination == null) {
            return null;
        }
        return this.outputDestination.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRoutingOrdersToORS() {
        StrategyModule strategyModule = this;
        synchronized (strategyModule) {
            return this.routeOrdersToORS;
        }
    }

    @Override
    public void setRoutingOrdersToORS(boolean inValue) {
        try {
            if (this.routeOrdersToORS != inValue && this.getState().isStarted()) {
                if (inValue) {
                    this.establishORSRouting();
                } else {
                    this.disconnectORSRouting();
                }
            }
            this.routeOrdersToORS = inValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Language getLanguage() {
        return this.type;
    }

    @Override
    public String getParameters() {
        if (this.parameters == null) {
            return null;
        }
        return Util.propertiesToString((Properties)this.parameters);
    }

    @Override
    public void sendMessage(Message inMessage, BrokerID inBroker) {
        if (inMessage == null || inBroker == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_MESSAGE, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        try {
            this.publish(Factory.getInstance().createOrder(inMessage, inBroker));
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.SEND_MESSAGE_FAILED, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inMessage, (Serializable)inBroker).withException((Throwable)e).create(), this.strategy);
        }
    }

    @Override
    public void send(Object inData) {
        if (inData == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_DATA, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        this.publish(inData);
    }

    @Override
    public void sendSuggestion(Suggestion inSuggestion) {
        if (inSuggestion == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_TRADE_SUGGESTION, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        this.publish(inSuggestion);
    }

    @Override
    public void sendEvent(Event inEvent, String inProvider, String inNamespace) {
        if (inEvent == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_EVENT, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        if (inProvider != null && !inProvider.isEmpty() && inNamespace != null && !inNamespace.isEmpty()) {
            ModuleURN cepModuleURN = StrategyModule.constructCepUrn(inProvider, inNamespace);
            try {
                this.sendEventToCEP(cepModuleURN, inEvent);
            }
            catch (Exception e) {
                StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_SEND_EVENT_TO_CEP, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inEvent, (Serializable)cepModuleURN).create(), this.strategy);
            }
        }
        this.publish(inEvent);
    }

    @Override
    public void sendNotification(Notification inNotification) {
        if (inNotification == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_NOTIFICATION, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        this.publish(inNotification);
    }

    @Override
    public void log(LogEvent inEvent) {
        if (inEvent == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_LOG, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        if (StrategyModule.shouldLog(inEvent)) {
            this.publish(inEvent);
        }
    }

    @Override
    public List<BrokerStatus> getBrokers() throws ConnectionException, ClientInitException {
        return clientFactory.getClient().getBrokersStatus().getBrokers();
    }

    @Override
    public BigDecimal getPositionAsOf(Date inDate, Equity inEquity) throws ConnectionException, ClientInitException {
        return clientFactory.getClient().getEquityPositionAsOf(inDate, inEquity);
    }

    @Override
    public Map<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(Date inDate) throws ConnectionException, ClientInitException {
        return clientFactory.getClient().getAllOptionPositionsAsOf(inDate);
    }

    @Override
    public Map<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(Date inDate) throws ConnectionException, ClientInitException {
        return clientFactory.getClient().getAllFuturePositionsAsOf(inDate);
    }

    @Override
    public BigDecimal getFuturePositionAsOf(Date inDate, Future inFuture) throws ConnectionException, ClientInitException {
        return clientFactory.getClient().getFuturePositionAsOf(inDate, inFuture);
    }

    @Override
    public BigDecimal getOptionPositionAsOf(Date inDate, Option inOption) throws ConnectionException, ClientInitException {
        return clientFactory.getClient().getOptionPositionAsOf(inDate, inOption);
    }

    @Override
    public Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(Date inDate, String ... inOptionRoots) throws ConnectionException, ClientInitException {
        return clientFactory.getClient().getOptionPositionsAsOf(inDate, inOptionRoots);
    }

    @Override
    public Collection<String> getOptionRoots(String inUnderlying) throws ConnectionException, ClientInitException {
        return clientFactory.getClient().getOptionRoots(inUnderlying);
    }

    @Override
    public Map<PositionKey<Equity>, BigDecimal> getAllPositionsAsOf(Date inDate) throws ConnectionException, ClientInitException {
        return clientFactory.getClient().getAllEquityPositionsAsOf(inDate);
    }

    @Override
    public String getUnderlying(String inOptionRoot) throws ConnectionException, ClientInitException {
        return clientFactory.getClient().getUnderlying(inOptionRoot);
    }

    @Override
    public String getStatus() {
        return this.strategy.getStatus().toString();
    }

    @Override
    public void statusChanged(Status inOldStatus, Status inNewStatus) {
        this.notificationDelegate.sendNotification(new AttributeChangeNotification(this, this.jmxNotificationCounter.getAndIncrement(), System.currentTimeMillis(), Messages.STATUS_CHANGED.getText(), "Status", "String", (Object)inOldStatus, (Object)inNewStatus));
    }

    @Override
    public void removeNotificationListener(NotificationListener inListener, NotificationFilter inFilter, Object inHandback) throws ListenerNotFoundException {
        this.notificationDelegate.removeNotificationListener(inListener, inFilter, inHandback);
    }

    @Override
    public void addNotificationListener(NotificationListener inListener, NotificationFilter inFilter, Object inHandback) throws IllegalArgumentException {
        this.notificationDelegate.addNotificationListener(inListener, inFilter, inHandback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.notificationDelegate.getNotificationInfo();
    }

    @Override
    public void removeNotificationListener(NotificationListener inListener) throws ListenerNotFoundException {
        this.notificationDelegate.removeNotificationListener(inListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelDataFlow(DataFlowID inDataFlowID) throws ModuleException {
        BiMap<DataFlowID, Integer> biMap = this.dataFlows;
        synchronized (biMap) {
            this.dataFlowSupport.cancel(inDataFlowID);
            this.dataFlows.remove((Object)inDataFlowID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataFlowID createDataFlow(DataRequest[] inRequests, boolean inAppendDataSink) throws ModuleException {
        BiMap<DataFlowID, Integer> biMap = this.dataFlows;
        synchronized (biMap) {
            DataFlowID dataFlowID = this.dataFlowSupport.createDataFlow(inRequests, inAppendDataSink);
            this.dataFlows.put((Object)dataFlowID, (Object)counter.incrementAndGet());
            return dataFlowID;
        }
    }

    @Override
    public Properties getUserData() throws ConnectionException, ClientInitException {
        Properties data = clientFactory.getClient().getUserData();
        return data == null ? new Properties() : data;
    }

    @Override
    public void setUserData(Properties inData) throws ConnectionException, ClientInitException {
        clientFactory.getClient().setUserData(inData);
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append((Object)this.type).append(" strategy ").append(this.name);
        return output.toString();
    }

    static void log(LogEvent inEvent, Strategy inStrategy) {
        if (StrategyModule.shouldLog(inEvent)) {
            StrategyModule.doLogger(inEvent);
            inStrategy.getServicesProvider().log(inEvent);
        }
    }

    private static boolean shouldLog(LogEvent inEvent) {
        return LogEventLevel.shouldLog((LogEvent)inEvent, (String)"user.messages");
    }

    private static void doLogger(LogEvent inEvent) {
        Throwable exception = inEvent.getException();
        String message = inEvent.getMessage();
        if (LogEventLevel.DEBUG.equals((Object)inEvent.getLevel())) {
            if (exception == null) {
                Messages.MESSAGE_1P.debug((Object)"user.messages", (Object)message);
            } else {
                Messages.MESSAGE_1P.debug((Object)"user.messages", exception, (Object)message);
            }
        } else if (LogEventLevel.INFO.equals((Object)inEvent.getLevel())) {
            if (exception == null) {
                Messages.MESSAGE_1P.info((Object)"user.messages", (Object)message);
            } else {
                Messages.MESSAGE_1P.info((Object)"user.messages", exception, (Object)message);
            }
        } else if (LogEventLevel.WARN.equals((Object)inEvent.getLevel())) {
            if (exception == null) {
                Messages.MESSAGE_1P.warn((Object)"user.messages", (Object)message);
            } else {
                Messages.MESSAGE_1P.warn((Object)"user.messages", exception, (Object)message);
            }
        } else if (LogEventLevel.ERROR.equals((Object)inEvent.getLevel())) {
            if (exception == null) {
                Messages.MESSAGE_1P.error((Object)"user.messages", (Object)message);
            } else {
                Messages.MESSAGE_1P.error((Object)"user.messages", exception, (Object)message);
            }
        }
    }

    static StrategyModule getStrategyModule(Object ... inParameters) throws ModuleCreationException {
        File source;
        if (inParameters == null || inParameters.length != 7) {
            throw new ModuleCreationException((I18NBoundMessage)Messages.PARAMETER_COUNT_ERROR);
        }
        String instanceName = null;
        if (inParameters[0] != null) {
            if (inParameters[0] instanceof String) {
                if (((String)inParameters[0]).isEmpty()) {
                    throw new ModuleCreationException((I18NBoundMessage)Messages.EMPTY_INSTANCE_ERROR);
                }
                instanceName = (String)inParameters[0];
            } else {
                throw new ModuleCreationException((I18NBoundMessage)new I18NBoundMessage3P(Messages.PARAMETER_TYPE_ERROR, (Serializable)Integer.valueOf(1), (Serializable)((Object)String.class.getName()), (Serializable)((Object)inParameters[0].getClass().getName())));
            }
        }
        if (inParameters[1] == null) {
            throw new ModuleCreationException((I18NBoundMessage)new I18NBoundMessage2P(Messages.NULL_PARAMETER_ERROR, (Serializable)Integer.valueOf(2), (Serializable)((Object)String.class.getName())));
        }
        if (inParameters[1] instanceof String) {
            if (((String)inParameters[1]).isEmpty()) {
                throw new ModuleCreationException((I18NBoundMessage)Messages.EMPTY_NAME_ERROR);
            }
        } else {
            throw new ModuleCreationException((I18NBoundMessage)new I18NBoundMessage3P(Messages.PARAMETER_TYPE_ERROR, (Serializable)Integer.valueOf(2), (Serializable)((Object)String.class.getName()), (Serializable)((Object)inParameters[1].getClass().getName())));
        }
        String name = (String)inParameters[1];
        Language type = null;
        if (inParameters[2] == null) {
            throw new ModuleCreationException((I18NBoundMessage)new I18NBoundMessage2P(Messages.NULL_PARAMETER_ERROR, (Serializable)Integer.valueOf(3), (Serializable)((Object)Language.class.getName())));
        }
        if (inParameters[2] instanceof Language) {
            type = (Language)((Object)inParameters[2]);
        } else if (inParameters[2] instanceof String) {
            try {
                type = Language.valueOf(((String)inParameters[2]).toUpperCase());
            }
            catch (Exception e) {
                throw new ModuleCreationException((I18NBoundMessage)new I18NBoundMessage1P(Messages.INVALID_LANGUAGE_ERROR, (Serializable)((Object)inParameters[2].toString())));
            }
        } else {
            throw new ModuleCreationException((I18NBoundMessage)new I18NBoundMessage3P(Messages.PARAMETER_TYPE_ERROR, (Serializable)Integer.valueOf(3), (Serializable)((Object)Language.class.getName()), (Serializable)((Object)inParameters[2].getClass().getName())));
        }
        if (inParameters[3] == null) {
            throw new ModuleCreationException((I18NBoundMessage)new I18NBoundMessage2P(Messages.NULL_PARAMETER_ERROR, (Serializable)Integer.valueOf(4), (Serializable)((Object)File.class.getName())));
        }
        if (inParameters[3] instanceof File) {
            source = (File)inParameters[3];
            if (!source.exists() && !source.canRead()) {
                throw new ModuleCreationException((I18NBoundMessage)new I18NBoundMessage1P(Messages.FILE_DOES_NOT_EXIST_OR_IS_NOT_READABLE, (Serializable)((Object)source.getAbsolutePath())));
            }
        } else {
            throw new ModuleCreationException((I18NBoundMessage)new I18NBoundMessage3P(Messages.PARAMETER_TYPE_ERROR, (Serializable)Integer.valueOf(4), (Serializable)((Object)File.class.getName()), (Serializable)((Object)inParameters[3].getClass().getName())));
        }
        Properties parameters = null;
        if (inParameters[4] != null) {
            if (inParameters[4] instanceof Properties) {
                parameters = (Properties)inParameters[4];
            } else {
                throw new ModuleCreationException((I18NBoundMessage)new I18NBoundMessage3P(Messages.PARAMETER_TYPE_ERROR, (Serializable)Integer.valueOf(5), (Serializable)((Object)Properties.class.getName()), (Serializable)((Object)inParameters[4].getClass().getName())));
            }
        }
        boolean routeOrdersToORS = false;
        if (inParameters[5] != null) {
            if (inParameters[5] instanceof Boolean) {
                routeOrdersToORS = (Boolean)inParameters[5];
            } else {
                throw new ModuleCreationException((I18NBoundMessage)new I18NBoundMessage3P(Messages.PARAMETER_TYPE_ERROR, (Serializable)Integer.valueOf(6), (Serializable)((Object)Boolean.class.getName()), (Serializable)((Object)inParameters[5].getClass().getName())));
            }
        }
        ModuleURN outputInstance = null;
        if (inParameters[6] != null) {
            if (inParameters[6] instanceof ModuleURN) {
                outputInstance = (ModuleURN)inParameters[6];
            } else {
                throw new ModuleCreationException((I18NBoundMessage)new I18NBoundMessage3P(Messages.PARAMETER_TYPE_ERROR, (Serializable)Integer.valueOf(7), (Serializable)((Object)ModuleURN.class.getName()), (Serializable)((Object)inParameters[6].getClass().getName())));
            }
        }
        return new StrategyModule(instanceName == null ? StrategyModule.generateInstanceURN(name) : new ModuleURN(StrategyModuleFactory.PROVIDER_URN, instanceName), name, type, source, parameters, routeOrdersToORS, outputInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preStart() throws ModuleException {
        this.assertStateForPreStart();
        BiMap<DataFlowID, Integer> biMap = this.dataFlows;
        synchronized (biMap) {
            if (this.outputDestination != null) {
                this.createDataFlow(new DataRequest[]{new DataRequest(this.getURN(), (Object)OutputType.ALL), new DataRequest(this.outputDestination)}, false);
            }
            if (this.routeOrdersToORS) {
                this.establishORSRouting();
            } else {
                this.disconnectORSRouting();
            }
            try {
                this.dataFlows.put((Object)this.dataFlowSupport.createDataFlow(new DataRequest[]{new DataRequest(ClientModuleFactory.INSTANCE_URN), new DataRequest(this.getURN())}, false), (Object)counter.incrementAndGet());
            }
            catch (Exception e) {
                Messages.EXECUTION_REPORT_REQUEST_FAILED.warn(StrategyModule.class, (Object)this.name, (Object)ClientModuleFactory.INSTANCE_URN);
            }
        }
        try {
            this.strategy = new StrategyImpl(this.name, this.getURN().getValue(), this.type, this.source, this.parameters, this.getURN().instanceName(), this);
            this.strategy.start();
        }
        catch (Exception e) {
            throw new ModuleException((Throwable)e, (I18NBoundMessage)Messages.FAILED_TO_START);
        }
    }

    protected void preStop() throws ModuleException {
        try {
            this.strategy.stop();
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            Messages.STOP_ERROR.warn(StrategyModule.class, (Throwable)e, (Object)this.strategy);
        }
        this.cancelAllDataRequests();
        this.disconnectORSRouting();
    }

    private static final ModuleURN generateInstanceURN(String inName) {
        String sanitizedName = inName.replaceAll("[^A-Z|a-z|0-9]", "");
        return new ModuleURN(StrategyModuleFactory.PROVIDER_URN, String.format("strategy%s%s", sanitizedName, Integer.toHexString(counter.incrementAndGet())));
    }

    private static ModuleURN constructCepUrn(String inSource, String inNamespace) {
        assert (inSource != null);
        assert (inNamespace != null);
        return new ModuleURN(String.format("metc:cep:%s:%s", inSource, inNamespace));
    }

    private static Object determineCepStatements(String inSource, String[] inStatements) {
        if (inSource.equals("esper")) {
            return inStatements;
        }
        return inStatements[0];
    }

    private static ModuleURN constructMarketDataUrn(String inSource) {
        return new ModuleURN(String.format("metc:mdata:%s", inSource));
    }

    private StrategyModule(ModuleURN inURN, String inName, Language inType, File inSource, Properties inParameters, boolean inRouteOrdersToORS, ModuleURN inOutputInstance) throws ModuleCreationException {
        super(inURN, false);
        this.name = inName;
        this.type = inType;
        this.source = inSource;
        this.parameters = inParameters;
        this.routeOrdersToORS = inRouteOrdersToORS;
        this.outputDestination = inOutputInstance;
        MBeanNotificationInfo notifyInfo = new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), Messages.BEAN_ATTRIBUTE_CHANGED.getText());
        this.notificationDelegate = new NotificationBroadcasterSupport(notifyInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEventToCEP(ModuleURN inCEPModule, Event inEvent) throws ModuleException {
        assert (inCEPModule != null);
        assert (inEvent != null);
        DataEmitterSupport establishedConnection = this.internalDataFlows.get(inCEPModule);
        if (establishedConnection == null) {
            BiMap<DataFlowID, Integer> biMap = this.dataFlows;
            synchronized (biMap) {
                this.dataFlows.put((Object)this.dataFlowSupport.createDataFlow(new DataRequest[]{new DataRequest(this.getURN(), (Object)new InternalRequest(inCEPModule)), new DataRequest(inCEPModule)}, false), (Object)counter.incrementAndGet());
                establishedConnection = this.internalDataFlows.get(inCEPModule);
                if (establishedConnection == null) {
                    StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_CREATE_CONNECTION, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inCEPModule).create(), this.strategy);
                    return;
                }
            }
        }
        assert (establishedConnection != null);
        establishedConnection.send((Object)inEvent);
    }

    private void assertStateForPreStart() {
        assert (this.dataFlowSupport != null);
        assert (this.name != null);
        assert (!this.name.isEmpty());
        assert (this.type != null);
        assert (this.source != null);
        assert (this.source.exists());
        assert (this.source.canRead());
    }

    private void assertStateForReceiveData() {
        this.assertStateForPreStart();
        assert (this.strategy != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribe(RequestID inRequestID) {
        Map<RequestID, DataRequester> map = this.subscribers;
        synchronized (map) {
            DataRequester requester = this.subscribers.remove(inRequestID);
            if (requester != null) {
                requester.unsubscribe();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribe(OutputType inRequest, DataEmitterSupport inSupport) {
        Map<RequestID, DataRequester> map = this.subscribers;
        synchronized (map) {
            DataRequester requester = new DataRequester(inSupport, inRequest);
            requester.subscribe();
            this.subscribers.put(inSupport.getRequestID(), requester);
        }
    }

    private void publish(Object inObject) {
        assert (inObject != null);
        if (inObject instanceof FIXOrder || inObject instanceof OrderSingle || inObject instanceof OrderCancel || inObject instanceof OrderReplace) {
            ThreadedMetric.event((String)"strategy-OUT", (Object[])new Object[0]);
            this.ordersPublisher.publish(inObject);
        } else if (inObject instanceof Suggestion) {
            this.suggestionsPublisher.publish(inObject);
        } else if (inObject instanceof Event) {
            this.eventsPublisher.publish(inObject);
        } else if (inObject instanceof Notification) {
            this.notificationsPublisher.publish(inObject);
        } else if (inObject instanceof String) {
            this.logPublisher.publish(inObject);
        }
        this.allPublisher.publish(inObject);
    }

    private void doCancelDataRequest(int inRequest) throws ModuleException {
        DataFlowID dataFlowID = (DataFlowID)this.dataFlows.inverse().remove((Object)inRequest);
        if (dataFlowID != null) {
            this.dataFlowSupport.cancel(dataFlowID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectORSRouting() throws ModuleException {
        SLF4JLoggerProxy.debug((Object)this, (String)"Breaking connection to ORS");
        BiMap<DataFlowID, Integer> biMap = this.dataFlows;
        synchronized (biMap) {
            if (this.orsFlow != null) {
                try {
                    this.dataFlowSupport.cancel(this.orsFlow);
                }
                catch (Exception e) {
                    SLF4JLoggerProxy.debug(StrategyModule.class, (Throwable)e, (String)"Unable to cancel dataflow {} - continuing", (Object[])new Object[]{this.orsFlow});
                }
                this.dataFlows.remove((Object)this.orsFlow);
                this.orsFlow = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishORSRouting() throws ModuleException {
        SLF4JLoggerProxy.debug((Object)this, (String)"Establishing connection to ORS");
        BiMap<DataFlowID, Integer> biMap = this.dataFlows;
        synchronized (biMap) {
            if (this.orsFlow == null) {
                this.orsFlow = this.dataFlowSupport.createDataFlow(new DataRequest[]{new DataRequest(this.getURN(), (Object)OutputType.ORDERS), new DataRequest(ClientModuleFactory.INSTANCE_URN)}, false);
                this.dataFlows.put((Object)this.orsFlow, (Object)counter.incrementAndGet());
            }
        }
    }

    @ClassVersion(value="$Id: StrategyModule.java 16154 2012-07-14 16:34:05Z colin $")
    static interface ClientFactory {
        public Client getClient() throws ClientInitException;
    }

    @ClassVersion(value="$Id: StrategyModule.java 16154 2012-07-14 16:34:05Z colin $")
    private class DataRequester
    implements ISubscriber {
        private final DataEmitterSupport emitterSupport;
        private final OutputType requestType;

        private DataRequester(DataEmitterSupport inEmitterSupport, OutputType inRequestType) {
            assert (inEmitterSupport != null);
            assert (inEmitterSupport.getRequestID() != null);
            this.emitterSupport = inEmitterSupport;
            this.requestType = inRequestType;
        }

        private void subscribe() {
            if (this.requestType.equals((Object)OutputType.ORDERS)) {
                StrategyModule.this.ordersPublisher.subscribe((ISubscriber)this);
            } else if (this.requestType.equals((Object)OutputType.SUGGESTIONS)) {
                StrategyModule.this.suggestionsPublisher.subscribe((ISubscriber)this);
            } else if (this.requestType.equals((Object)OutputType.EVENTS)) {
                StrategyModule.this.eventsPublisher.subscribe((ISubscriber)this);
            } else if (this.requestType.equals((Object)OutputType.NOTIFICATIONS)) {
                StrategyModule.this.notificationsPublisher.subscribe((ISubscriber)this);
            } else if (this.requestType.equals((Object)OutputType.LOG)) {
                StrategyModule.this.logPublisher.subscribe((ISubscriber)this);
            } else if (this.requestType.equals((Object)OutputType.ALL)) {
                StrategyModule.this.allPublisher.subscribe((ISubscriber)this);
            } else {
                throw new IllegalArgumentException();
            }
        }

        public boolean isInteresting(Object inData) {
            return true;
        }

        public void publishTo(Object inData) {
            this.emitterSupport.send(inData);
        }

        private void unsubscribe() {
            if (this.requestType.equals((Object)OutputType.ORDERS)) {
                StrategyModule.this.ordersPublisher.unsubscribe((ISubscriber)this);
            } else if (this.requestType.equals((Object)OutputType.SUGGESTIONS)) {
                StrategyModule.this.suggestionsPublisher.unsubscribe((ISubscriber)this);
            } else if (this.requestType.equals((Object)OutputType.EVENTS)) {
                StrategyModule.this.eventsPublisher.unsubscribe((ISubscriber)this);
            } else if (this.requestType.equals((Object)OutputType.NOTIFICATIONS)) {
                StrategyModule.this.notificationsPublisher.unsubscribe((ISubscriber)this);
            } else if (this.requestType.equals((Object)OutputType.LOG)) {
                StrategyModule.this.logPublisher.unsubscribe((ISubscriber)this);
            } else if (this.requestType.equals((Object)OutputType.ALL)) {
                StrategyModule.this.allPublisher.unsubscribe((ISubscriber)this);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    @ClassVersion(value="$Id: StrategyModule.java 16154 2012-07-14 16:34:05Z colin $")
    private static class InternalRequest {
        private final ModuleURN originalRequester;

        private InternalRequest(ModuleURN inOriginalRequester) {
            this.originalRequester = inOriginalRequester;
        }
    }
}

