/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import java.io.Serializable;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.event.LogEvent;
import org.marketcetera.event.impl.LogEventBuilder;
import org.marketcetera.strategy.AbstractRunningStrategy;
import org.marketcetera.strategy.ExecutionEngine;
import org.marketcetera.strategy.Executor;
import org.marketcetera.strategy.Messages;
import org.marketcetera.strategy.RunningStrategy;
import org.marketcetera.strategy.Status;
import org.marketcetera.strategy.Strategy;
import org.marketcetera.strategy.StrategyException;
import org.marketcetera.strategy.StrategyImpl;
import org.marketcetera.strategy.StrategyModule;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.SLF4JLoggerProxy;

@ClassVersion(value="$Id: AbstractExecutor.java 16154 2012-07-14 16:34:05Z colin $")
abstract class AbstractExecutor
implements Executor,
Messages {
    private final Strategy strategy;
    private ExecutionEngine engine;
    private RunningStrategy runningStrategy;

    @Override
    public final synchronized RunningStrategy start() throws Exception {
        String script = this.getStrategy().getScript();
        String processedScript = this.preprocess(script);
        this.engine = this.getExecutionEngine();
        this.engine.prepare(this.getStrategy(), processedScript);
        Object objectReturned = this.engine.start();
        if (objectReturned == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.error().withMessage(STRATEGY_COMPILATION_NULL_RESULT, (Serializable)((Object)String.valueOf(this.getStrategy()))).create(), this.getStrategy());
            throw new StrategyException((I18NBoundMessage)new I18NBoundMessage1P(STRATEGY_COMPILATION_NULL_RESULT, (Serializable)((Object)this.getStrategy().toString())));
        }
        if (objectReturned instanceof RunningStrategy) {
            RunningStrategy runningStrategy = (RunningStrategy)objectReturned;
            assert (runningStrategy instanceof AbstractRunningStrategy);
            assert (this.getStrategy() instanceof StrategyImpl);
            AbstractRunningStrategy abstractRunningStrategy = (AbstractRunningStrategy)runningStrategy;
            StrategyImpl enclosingStrategy = (StrategyImpl)this.getStrategy();
            abstractRunningStrategy.setStrategy(this.getStrategy());
            this.runningStrategy = runningStrategy;
            enclosingStrategy.setRunningStrategy(runningStrategy);
            try {
                SLF4JLoggerProxy.debug(AbstractExecutor.class, (String)"{} start job beginning", (Object[])new Object[]{this.getStrategy()});
                enclosingStrategy.setStatus(Status.STARTING);
                abstractRunningStrategy.start();
                runningStrategy.onStart();
                enclosingStrategy.setStatus(Status.RUNNING);
                return runningStrategy;
            }
            catch (Exception e) {
                StrategyModule.log((LogEvent)LogEventBuilder.error().withMessage(RUNTIME_ERROR, (Serializable)((Object)this.getStrategy().toString()), (Serializable)((Object)this.translateMethodName("onStart")), (Serializable)((Object)this.interpretRuntimeException(e))).withException((Throwable)e).create(), this.getStrategy());
                throw e;
            }
        }
        StrategyModule.log((LogEvent)LogEventBuilder.error().withMessage(NO_STRATEGY_CLASS).create(), this.getStrategy());
        throw new StrategyException((I18NBoundMessage)NO_STRATEGY_CLASS);
    }

    @Override
    public final synchronized void stop() throws Exception {
        assert (this.runningStrategy != null);
        assert (this.runningStrategy instanceof AbstractRunningStrategy);
        assert (this.getStrategy() instanceof StrategyImpl);
        AbstractRunningStrategy abstractRunningStrategy = (AbstractRunningStrategy)this.runningStrategy;
        abstractRunningStrategy.stop();
        StrategyImpl enclosingStrategy = (StrategyImpl)this.getStrategy();
        try {
            SLF4JLoggerProxy.debug(AbstractExecutor.class, (String)"{} stop job beginning", (Object[])new Object[]{this.getStrategy()});
            this.runningStrategy.onStop();
            enclosingStrategy.setStatus(Status.STOPPED);
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.error().withMessage(RUNTIME_ERROR, (Serializable)((Object)String.valueOf(this.getStrategy())), (Serializable)((Object)this.translateMethodName("onStop")), (Serializable)((Object)this.interpretRuntimeException(e))).withException((Throwable)e).create(), this.getStrategy());
            throw e;
        }
        this.engine.stop();
    }

    final Strategy getStrategy() {
        return this.strategy;
    }

    protected abstract String preprocess(String var1) throws StrategyException;

    protected abstract ExecutionEngine getExecutionEngine() throws StrategyException;

    protected AbstractExecutor(Strategy inStrategy) {
        this.strategy = inStrategy;
    }
}

