/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy.util;

import java.math.BigDecimal;
import javax.annotation.concurrent.ThreadSafe;
import org.marketcetera.event.HasProviderSymbol;
import org.marketcetera.event.OptionEvent;
import org.marketcetera.strategy.util.OptionContract;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: OptionContractPair.java 16154 2012-07-14 16:34:05Z colin $")
@ThreadSafe
public final class OptionContractPair
implements Comparable<OptionContractPair> {
    private volatile OptionContract put;
    private volatile OptionContract call;
    private final OptionContractPairKey key;

    public OptionContract getPut() {
        return this.put;
    }

    public OptionContract getCall() {
        return this.call;
    }

    @Override
    public int compareTo(OptionContractPair inPair) {
        return this.getKey().compareTo(inPair.getKey());
    }

    public boolean equals(Object inOther) {
        if (inOther == null) {
            return false;
        }
        if (!(inOther instanceof OptionContractPair)) {
            return false;
        }
        return this.compareTo((OptionContractPair)inOther) == 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.getPut() == null && this.getCall() == null) {
            return 31 * result + 0;
        }
        Option option = this.getPut() == null ? this.getCall().getInstrument() : this.getPut().getInstrument();
        result = 31 * result + (option == null || option.getSymbol() == null ? 0 : option.getSymbol().hashCode());
        result = 31 * result + (option == null || option.getExpiry() == null ? 0 : option.getExpiry().hashCode());
        result = 31 * result + (option == null || option.getStrikePrice() == null ? 0 : option.getStrikePrice().hashCode());
        return result;
    }

    OptionContractPair(OptionEvent inOptionEvent) {
        this.key = OptionContractPair.getOptionContractPairKey(inOptionEvent.getInstrument());
        this.process(inOptionEvent);
    }

    synchronized boolean process(OptionEvent inOptionEvent) {
        if (inOptionEvent.getInstrument().getType() == OptionType.Call) {
            if (this.call == null) {
                this.call = new OptionContract(inOptionEvent.getUnderlyingInstrument(), inOptionEvent.getInstrument(), inOptionEvent.getInstrument().getType(), inOptionEvent.getExpirationType(), inOptionEvent.hasDeliverable(), inOptionEvent.getMultiplier(), inOptionEvent instanceof HasProviderSymbol ? inOptionEvent.getProviderSymbol() : null);
            }
            return this.call.process(inOptionEvent);
        }
        if (inOptionEvent.getInstrument().getType() == OptionType.Put) {
            if (this.put == null) {
                this.put = new OptionContract(inOptionEvent.getUnderlyingInstrument(), inOptionEvent.getInstrument(), inOptionEvent.getInstrument().getType(), inOptionEvent.getExpirationType(), inOptionEvent.hasDeliverable(), inOptionEvent.getMultiplier(), inOptionEvent instanceof HasProviderSymbol ? inOptionEvent.getProviderSymbol() : null);
            }
            return this.put.process(inOptionEvent);
        }
        throw new UnsupportedOperationException();
    }

    static OptionContractPairKey getOptionContractPairKey(Option inOption) {
        return new OptionContractPairKey(inOption.getSymbol(), inOption.getExpiry(), inOption.getStrikePrice());
    }

    private OptionContractPairKey getKey() {
        return this.key;
    }

    @ClassVersion(value="$Id: OptionContractPair.java 16154 2012-07-14 16:34:05Z colin $")
    static class OptionContractPairKey
    implements Comparable<OptionContractPairKey> {
        private final String symbol;
        private final String expiry;
        private final BigDecimal strike;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
            result = 31 * result + (this.expiry == null ? 0 : this.expiry.hashCode());
            result = 31 * result + (this.strike == null ? 0 : this.strike.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof OptionContractPairKey)) {
                return false;
            }
            OptionContractPairKey other = (OptionContractPairKey)obj;
            if (!this.symbol.equals(other.symbol)) {
                return false;
            }
            if (!this.expiry.equals(other.expiry)) {
                return false;
            }
            return this.strike.equals(other.strike);
        }

        @Override
        public int compareTo(OptionContractPairKey inOther) {
            int result = this.getSymbol().compareTo(inOther.getSymbol());
            if (result != 0) {
                return result;
            }
            result = this.getExpiry().compareTo(inOther.getExpiry());
            if (result != 0) {
                return result;
            }
            return this.getStrike().compareTo(inOther.getStrike());
        }

        private OptionContractPairKey(String inSymbol, String inExpiry, BigDecimal inStrike) {
            this.symbol = inSymbol;
            this.expiry = inExpiry;
            this.strike = inStrike;
        }

        private String getSymbol() {
            return this.symbol;
        }

        private String getExpiry() {
            return this.expiry;
        }

        private BigDecimal getStrike() {
            return this.strike;
        }
    }
}

