/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.marketcetera.strategy.Messages;
import org.marketcetera.strategy.Strategy;
import org.marketcetera.strategy.StrategyException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: CompilationFailed.java 16834 2014-02-13 20:40:53Z colin $")
public class CompilationFailed
extends StrategyException {
    private static final long serialVersionUID = -8620960760410053024L;
    private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    public CompilationFailed(Strategy inStrategy) {
        super((I18NBoundMessage)new I18NBoundMessage2P(Messages.COMPILATION_FAILED, (Serializable)((Object)inStrategy.toString()), (Serializable)((Object)"")));
    }

    public CompilationFailed(Throwable inNested, Strategy inStrategy) {
        super(inNested, (I18NBoundMessage)new I18NBoundMessage2P(Messages.COMPILATION_FAILED, (Serializable)((Object)inStrategy.toString()), (Serializable)((Object)"")));
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        for (Diagnostic diagnostic : this.getDiagnostics()) {
            output.append(diagnostic).append(System.getProperty("line.separator"));
        }
        return output.toString();
    }

    public List<Diagnostic> getDiagnostics() {
        return new ArrayList<Diagnostic>(this.diagnostics);
    }

    void addDiagnostic(Diagnostic inDiagnostic) {
        this.diagnostics.add(inDiagnostic);
    }

    @ClassVersion(value="$Id: CompilationFailed.java 16834 2014-02-13 20:40:53Z colin $")
    public static class Diagnostic
    implements Serializable {
        private final Type type;
        private final String message;
        private static final long serialVersionUID = 5069557290962979880L;

        public static Diagnostic warning(String inMessage) {
            return new Diagnostic(Type.WARNING, inMessage);
        }

        public static Diagnostic error(String inMessage) {
            return new Diagnostic(Type.ERROR, inMessage);
        }

        private Diagnostic(Type inType, String inMessage) {
            this.type = inType;
            this.message = inMessage;
        }

        public final Type getType() {
            return this.type;
        }

        public final String getMessage() {
            return this.message;
        }

        public String toString() {
            return String.format("%s: %s", new Object[]{this.type, this.message});
        }
    }

    @ClassVersion(value="$Id: CompilationFailed.java 16834 2014-02-13 20:40:53Z colin $")
    public static enum Type {
        WARNING,
        ERROR;

    }
}

