/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.core.notifications.Notification;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.event.Event;
import org.marketcetera.event.LogEvent;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.strategy.Status;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Currency;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.Suggestion;
import org.marketcetera.util.misc.ClassVersion;
import quickfix.Message;

@ClassVersion(value="$Id: ServicesProvider.java 16460 2013-01-21 21:55:10Z colin $")
interface ServicesProvider {
    public void send(Object var1);

    public void cancelOrder(OrderCancel var1);

    public void cancelReplace(OrderReplace var1);

    public void sendSuggestion(Suggestion var1);

    public void sendEvent(Event var1, String var2, String var3);

    public void sendNotification(Notification var1);

    public void log(LogEvent var1);

    public int requestMarketData(MarketDataRequest var1);

    public int requestProcessedMarketData(MarketDataRequest var1, String[] var2, String var3, String var4);

    public void cancelDataRequest(int var1);

    public void cancelAllDataRequests();

    public int requestCEPData(String[] var1, String var2, String var3);

    public void sendMessage(Message var1, BrokerID var2);

    public void statusChanged(Status var1, Status var2);

    public DataFlowID createDataFlow(DataRequest[] var1, boolean var2) throws ModuleException;

    public void cancelDataFlow(DataFlowID var1) throws ModuleException;

    public List<BrokerStatus> getBrokers() throws ConnectionException, ClientInitException;

    public BigDecimal getPositionAsOf(Date var1, Equity var2) throws ConnectionException, ClientInitException;

    public Map<PositionKey<Equity>, BigDecimal> getAllPositionsAsOf(Date var1) throws ConnectionException, ClientInitException;

    public BigDecimal getFuturePositionAsOf(Date var1, Future var2) throws ConnectionException, ClientInitException;

    public Map<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(Date var1) throws ConnectionException, ClientInitException;

    public BigDecimal getCurrencyPositionAsOf(Date var1, Currency var2) throws ConnectionException, ClientInitException;

    public Map<PositionKey<Currency>, BigDecimal> getAllCurrencyPositionsAsOf(Date var1) throws ConnectionException, ClientInitException;

    public BigDecimal getOptionPositionAsOf(Date var1, Option var2) throws ConnectionException, ClientInitException;

    public Map<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(Date var1) throws ConnectionException, ClientInitException;

    public Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(Date var1, String ... var2) throws ConnectionException, ClientInitException;

    public String getUnderlying(String var1) throws ConnectionException, ClientInitException;

    public Collection<String> getOptionRoots(String var1) throws ConnectionException, ClientInitException;

    public ModuleURN getURN();

    public Properties getUserData() throws ConnectionException, ClientInitException;

    public void setUserData(Properties var1) throws ConnectionException, ClientInitException;
}

