/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy.util;

import java.math.BigDecimal;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.marketcetera.event.AskEvent;
import org.marketcetera.event.BidEvent;
import org.marketcetera.event.MarketstatEvent;
import org.marketcetera.event.OptionEvent;
import org.marketcetera.event.TradeEvent;
import org.marketcetera.event.beans.OptionBean;
import org.marketcetera.event.util.MarketstatEventCache;
import org.marketcetera.options.ExpirationType;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: OptionContract.java 16154 2012-07-14 16:34:05Z colin $")
@ThreadSafe
public final class OptionContract {
    private final OptionBean option = new OptionBean();
    private volatile BidEvent latestBid = null;
    private volatile AskEvent latestAsk = null;
    private volatile TradeEvent latestTrade = null;
    private final MarketstatEventCache latestMarketstat;
    private final String providerSymbol;

    public Instrument getUnderlyingInstrument() {
        return this.option.getUnderlyingInstrument();
    }

    public Option getInstrument() {
        return this.option.getInstrument();
    }

    public ExpirationType getExpirationType() {
        return this.option.getExpirationType();
    }

    public BigDecimal getMultiplier() {
        return this.option.getMultiplier();
    }

    public boolean hasDeliverable() {
        return this.option.hasDeliverable();
    }

    public BidEvent getLatestBid() {
        return this.latestBid;
    }

    public AskEvent getLatestAsk() {
        return this.latestAsk;
    }

    public TradeEvent getLatestTrade() {
        return this.latestTrade;
    }

    public MarketstatEvent getLatestMarketstat() {
        return this.latestMarketstat.get();
    }

    public String getProviderSymbol() {
        return this.providerSymbol;
    }

    OptionContract(Instrument inUnderlyingInstrument, Option inInstrument, OptionType inType, ExpirationType inExpirationType, boolean inHasDeliverable, BigDecimal inMultiplier, String inProviderSymbol) {
        this.latestMarketstat = new MarketstatEventCache((Instrument)inInstrument);
        this.option.setInstrument(new Option(inInstrument.getSymbol(), inInstrument.getExpiry(), inInstrument.getStrikePrice(), inType));
        this.option.setUnderlyingInstrument(inUnderlyingInstrument);
        this.option.setExpirationType(inExpirationType);
        this.option.setHasDeliverable(inHasDeliverable);
        this.option.setMultiplier(inMultiplier);
        this.option.validate();
        this.providerSymbol = StringUtils.trimToNull((String)inProviderSymbol);
    }

    boolean process(OptionEvent inOptionEvent) {
        if (inOptionEvent instanceof BidEvent) {
            this.setLatestBid((BidEvent)inOptionEvent);
            return true;
        }
        if (inOptionEvent instanceof AskEvent) {
            this.setLatestAsk((AskEvent)inOptionEvent);
            return true;
        }
        if (inOptionEvent instanceof TradeEvent) {
            this.setLatestTrade((TradeEvent)inOptionEvent);
            return true;
        }
        if (inOptionEvent instanceof MarketstatEvent) {
            this.setLatestMarketstat((MarketstatEvent)inOptionEvent);
            return true;
        }
        return false;
    }

    private void setLatestBid(BidEvent inLatestBid) {
        this.latestBid = inLatestBid;
    }

    private void setLatestAsk(AskEvent inLatestAsk) {
        this.latestAsk = inLatestAsk;
    }

    private void setLatestTrade(TradeEvent inLatestTrade) {
        this.latestTrade = inLatestTrade;
    }

    private void setLatestMarketstat(MarketstatEvent inLatestMarketstat) {
        this.latestMarketstat.cache(inLatestMarketstat);
    }
}

