/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import java.io.File;
import org.junit.Test;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.module.ModuleException;
import org.marketcetera.strategy.Language;
import org.marketcetera.strategy.LanguageTestBase;
import org.marketcetera.strategy.StrategyTestBase;
import org.marketcetera.util.log.I18NBoundMessage;

public class JavaLanguageTest
extends LanguageTestBase {
    public static final File JAVA_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "JavaStrategy.java");
    public static final String JAVA_STRATEGY_NAME = "JavaStrategy";
    public static final File BAD_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "BadStrategy.java");
    public static final String BAD_STRATEGY_NAME = "BadStrategy";
    public static final File WRONG_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "WrongClass.java");
    public static final String WRONG_STRATEGY_NAME = "WrongClass";
    public static final File MULTIPLE_CLASS_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "StrategyWithHelpers.java");
    public static final String MULTIPLE_CLASS_STRATEGY_NAME = "StrategyWithHelpers";
    public static final File EMPTY_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "EmptyStrategy.java");
    public static final String EMPTY_STRATEGY_NAME = "EmptyStrategy";
    public static final File PARAMETER_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "ParameterStrategy.java");
    public static final String PARAMETER_STRATEGY_NAME = "ParameterStrategy";
    public static final File SUGGESTION_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "SuggestTrades.java");
    public static final String SUGGESTION_STRATEGY_NAME = "SuggestTrades";
    public static final File ORDER_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "Orders.java");
    public static final String ORDER_STRATEGY_NAME = "Orders";
    public static final File OTHER_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "SendOther.java");
    public static final String OTHER_STRATEGY_NAME = "SendOther";
    public static final File MESSAGE_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "SendMessage.java");
    public static final String MESSAGE_STRATEGY_NAME = "SendMessage";
    public static final File PART1_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "Part1.java");
    public static final String PART1_STRATEGY_NAME = "Part1";
    public static final File PART1_REDEFINED_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "redefined" + File.separator + "Part1.java");
    public static final File PART2_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "Part2.java");
    public static final String PART2_STRATEGY_NAME = "Part2";
    public static final File PACKAGE_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "PackageStrategy.java");
    public static final String PACKAGE_STRATEGY_NAME = "PackageStrategy";
    public static final File EVENT_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "SendEvent.java");
    public static final String EVENT_STRATEGY_NAME = "SendEvent";
    public static final File COMBINED_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "CombinedRequest.java");
    public static final String COMBINED_STRATEGY_NAME = "CombinedRequest";
    public static final File DATA_FLOW_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "DataFlow.java");
    public static final String DATA_FLOW_NAME = "DataFlow";
    public static final File ORDER_RETENTION_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "OrderRetention.java");
    public static final String ORDER_RETENTION_NAME = "OrderRetention";
    public static final File POSITIONS_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "Positions.java");
    public static final String POSITIONS_NAME = "Positions";
    public static final File DEPENDING_STRATEGY = new File(StrategyTestBase.SAMPLE_STRATEGY_DIR, "StrategyA.java");
    public static final String DEPENDING_NAME = "StrategyA";

    @Test
    public void nonDefaultPackage() throws Exception {
        StrategyTestBase.StrategyCoordinates strategy = this.getPackageStrategy();
        this.verifyNullProperties();
        this.doSuccessfulStartTestNoVerification(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null));
        this.verifyPropertyNonNull("onStart");
    }

    @Test
    public void strategyAgentClasspath() throws Exception {
        final StrategyTestBase.StrategyCoordinates strategy = StrategyTestBase.StrategyCoordinates.get(DEPENDING_STRATEGY, DEPENDING_NAME);
        this.verifyNullProperties();
        new ExpectedFailure<ModuleException>((I18NBoundMessage)FAILED_TO_START){

            protected void run() throws Exception {
                JavaLanguageTest.this.createStrategy(strategy.getName(), JavaLanguageTest.this.getLanguage(), strategy.getFile(), null, null, null);
            }
        };
        this.verifyPropertyNull("onStart");
        this.verifyNullProperties();
        System.setProperty("strategy.classpath", StrategyTestBase.SAMPLE_STRATEGY_DIR.getCanonicalPath() + File.separator + "subfolder");
        this.doSuccessfulStartTestNoVerification(this.createStrategy(strategy.getName(), this.getLanguage(), strategy.getFile(), null, null, null));
        this.verifyPropertyNonNull("onStart");
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getEmptyStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(EMPTY_STRATEGY, EMPTY_STRATEGY_NAME);
    }

    @Override
    protected Language getLanguage() {
        return Language.JAVA;
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getMessageStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(MESSAGE_STRATEGY, MESSAGE_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getParameterStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(PARAMETER_STRATEGY, PARAMETER_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getStrategyCompiles() {
        return StrategyTestBase.StrategyCoordinates.get(JAVA_STRATEGY, JAVA_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getStrategyMultipleClasses() {
        return StrategyTestBase.StrategyCoordinates.get(MULTIPLE_CLASS_STRATEGY, MULTIPLE_CLASS_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getStrategyWillNotCompile() {
        return StrategyTestBase.StrategyCoordinates.get(BAD_STRATEGY, BAD_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getStrategyWrongClass() {
        return StrategyTestBase.StrategyCoordinates.get(WRONG_STRATEGY, WRONG_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getSuggestionStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(SUGGESTION_STRATEGY, SUGGESTION_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getPart1Strategy() {
        return StrategyTestBase.StrategyCoordinates.get(PART1_STRATEGY, PART1_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getPart2Strategy() {
        return StrategyTestBase.StrategyCoordinates.get(PART2_STRATEGY, PART2_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getPart1RedefinedStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(PART1_REDEFINED_STRATEGY, PART1_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getOrdersStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(ORDER_STRATEGY, ORDER_STRATEGY_NAME);
    }

    private StrategyTestBase.StrategyCoordinates getPackageStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(PACKAGE_STRATEGY, PACKAGE_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getEventStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(EVENT_STRATEGY, EVENT_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getCombinedStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(COMBINED_STRATEGY, COMBINED_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getOtherStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(OTHER_STRATEGY, OTHER_STRATEGY_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getDataFlowStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(DATA_FLOW_STRATEGY, DATA_FLOW_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getPositionsStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(POSITIONS_STRATEGY, POSITIONS_NAME);
    }

    @Override
    protected StrategyTestBase.StrategyCoordinates getOrderRetentionStrategy() {
        return StrategyTestBase.StrategyCoordinates.get(ORDER_RETENTION_STRATEGY, ORDER_RETENTION_NAME);
    }

    @Override
    protected int getExpectedCompilationWarningsFor(StrategyTestBase.StrategyCoordinates inStrategy) {
        if (inStrategy.getName().equals(JAVA_STRATEGY_NAME)) {
            return 2;
        }
        return 0;
    }
}

