/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.core.Util;
import org.marketcetera.marketdata.MarketDataFeedTestBase;
import org.marketcetera.marketdata.MarketDataRequestBuilder;
import org.marketcetera.marketdata.bogus.BogusFeedModuleFactory;
import org.marketcetera.module.DataFlowException;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.module.IllegalRequestParameterValue;
import org.marketcetera.module.InvalidURNException;
import org.marketcetera.module.Messages;
import org.marketcetera.module.ModuleCreationException;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleNotFoundException;
import org.marketcetera.module.ModuleStateException;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.SinkModuleFactory;
import org.marketcetera.module.UnsupportedRequestParameterType;
import org.marketcetera.strategy.AbstractRunningStrategy;
import org.marketcetera.strategy.Language;
import org.marketcetera.strategy.OutputType;
import org.marketcetera.strategy.RubyLanguageTest;
import org.marketcetera.strategy.Status;
import org.marketcetera.strategy.StrategyMXBean;
import org.marketcetera.strategy.StrategyModuleFactory;
import org.marketcetera.strategy.StrategyTestBase;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.SLF4JLoggerProxy;

public class StrategyModuleTest
extends StrategyTestBase {
    private static final Class<?>[] expectedTypes = new Class[]{String.class, String.class, Language.class, File.class, Properties.class, Boolean.class, ModuleURN.class};

    @Test
    public void cancel() throws Exception {
    }

    @Test
    public void lifecycle() throws Exception {
        Assert.assertTrue((boolean)this.moduleManager.getModuleInstances(StrategyModuleFactory.PROVIDER_URN).isEmpty());
        ModuleURN strategy = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{"MyStategy", "RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, new Properties(), false, this.outputURN});
        Assert.assertEquals((long)1L, (long)this.moduleManager.getModuleInstances(StrategyModuleFactory.PROVIDER_URN).size());
        Assert.assertEquals((Object)strategy, this.moduleManager.getModuleInstances(StrategyModuleFactory.PROVIDER_URN).get(0));
        Assert.assertFalse((boolean)this.moduleManager.getModuleInfo(strategy).getState().isStarted());
        this.startStrategy(strategy);
        Assert.assertTrue((boolean)this.moduleManager.getModuleInfo(strategy).getState().isStarted());
        this.stopStrategy(strategy);
        Assert.assertEquals((long)1L, (long)this.moduleManager.getModuleInstances(StrategyModuleFactory.PROVIDER_URN).size());
        Assert.assertEquals((Object)strategy, this.moduleManager.getModuleInstances(StrategyModuleFactory.PROVIDER_URN).get(0));
        this.moduleManager.deleteModule(strategy);
        Assert.assertTrue((boolean)this.moduleManager.getModuleInstances(StrategyModuleFactory.PROVIDER_URN).isEmpty());
    }

    @Test
    public void uncompilingRoutedStrategy() throws Exception {
        String badStrategy = "require 'java'\njava_import org.marketcetera.strategy.ruby.Strategy\njava_import java.math.BigDecimal\nclass MyStrategy < Strategy\n  this just won't compile\nend\n";
        String goodStrategy = "require 'java'\njava_import org.marketcetera.strategy.ruby.Strategy\njava_import java.math.BigDecimal\nclass MyStrategy < Strategy\n  TEST = BigDecimal.new(\"1\")\nend\n";
        File strategyFile = File.createTempFile("strategy", ".rb");
        strategyFile.deleteOnExit();
        BufferedWriter writer = new BufferedWriter(new FileWriter(strategyFile));
        writer.write(badStrategy);
        writer.close();
        final ModuleURN strategyURN = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{"MyStategy", "MyStrategy", Language.RUBY, strategyFile, new Properties(), true, this.outputURN});
        new ExpectedFailure<ModuleException>(){

            protected void run() throws Exception {
                StrategyModuleTest.this.moduleManager.start(strategyURN);
            }
        };
        this.verifyStrategyReady(strategyURN);
        this.verifyStrategyStatus(strategyURN, Status.FAILED);
        writer = new BufferedWriter(new FileWriter(strategyFile));
        writer.write(goodStrategy);
        writer.close();
        this.moduleManager.start(strategyURN);
        this.verifyStrategyReady(strategyURN);
        this.verifyStrategyStatus(strategyURN, Status.RUNNING);
        this.moduleManager.stop(strategyURN);
        this.verifyStrategyStopped(strategyURN);
    }

    @Test
    public void create() throws Exception {
        this.doWrongParameterCountTest(null);
        this.doWrongParameterCountTest(new Object[0]);
        this.doWrongParameterCountTest("RubyStrategy");
        this.doWrongParameterCountTest("RubyStrategy", Language.RUBY);
        this.doWrongParameterCountTest("RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY);
        this.doWrongParameterCountTest("RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, new Properties());
        this.doWrongParameterCountTest("RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, new Properties(), "false");
        this.doWrongTypeParameterTest(0, new Object[]{this, "RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, new Properties(), false, this.outputURN});
        this.doWrongTypeParameterTest(1, new Object[]{"MyStrategyURN", this, Language.RUBY, RubyLanguageTest.STRATEGY, new Properties(), false, this.outputURN});
        this.doWrongTypeParameterTest(2, new Object[]{"MyStrategyURN", "RubyStrategy", this, RubyLanguageTest.STRATEGY, new Properties(), false, this.outputURN});
        this.doWrongTypeParameterTest(3, new Object[]{"MyStrategyURN", "RubyStrategy", Language.RUBY, this, new Properties(), false, this.outputURN});
        this.doWrongTypeParameterTest(4, new Object[]{"MyStrategyURN", "RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, this, false, this.outputURN});
        this.doWrongTypeParameterTest(5, new Object[]{"MyStrategyURN", "RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, new Properties(), this, this.outputURN});
        this.doWrongTypeParameterTest(6, new Object[]{"MyStrategyURN", "RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, new Properties(), false, this});
        ModuleURN strategy = this.createStrategy("RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, new Properties(), false, this.outputURN);
        Assert.assertEquals((long)1L, (long)this.moduleManager.getModuleInstances(StrategyModuleFactory.PROVIDER_URN).size());
        Assert.assertEquals((Object)strategy, this.moduleManager.getModuleInstances(StrategyModuleFactory.PROVIDER_URN).get(0));
    }

    @Test
    public void requestData() throws Exception {
        ModuleURN strategy = this.createStrategy("RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, new Properties(), false, this.outputURN);
        Assert.assertTrue((boolean)this.moduleManager.getModuleInfo(strategy).getState().isStarted());
        new ExpectedFailure<IllegalRequestParameterValue>((I18NMessage)Messages.ILLEGAL_REQ_PARM_VALUE, new Object[]{strategy.toString(), null}){

            protected void run() throws Exception {
                StrategyModuleTest.this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, null)});
            }
        };
        final String badPayload = "some stuff-" + System.nanoTime();
        new ExpectedFailure<IllegalRequestParameterValue>((I18NMessage)Messages.ILLEGAL_REQ_PARM_VALUE, new Object[]{strategy.toString(), badPayload}){

            protected void run() throws Exception {
                StrategyModuleTest.this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, (Object)badPayload)});
            }
        };
        new ExpectedFailure<UnsupportedRequestParameterType>((I18NMessage)Messages.UNSUPPORTED_REQ_PARM_TYPE, new Object[]{strategy.toString(), this.moduleManager.getClass().getName()}){

            protected void run() throws Exception {
                StrategyModuleTest.this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, (Object)StrategyModuleTest.this.moduleManager)});
            }
        };
        DataFlowID flowID1 = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, (Object)"OrDeRs")});
        DataFlowID flowID2 = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, (Object)"SuGgEsTiOnS")});
        DataFlowID flowID3 = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, (Object)"eVeNtS")});
        DataFlowID flowID4 = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, (Object)"NoTiFiCaTiOnS")});
        DataFlowID flowID5 = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, (Object)"LoG")});
        DataFlowID flowID6 = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, (Object)"AlL")});
        DataFlowID flowID7 = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, (Object)OutputType.ORDERS)});
        DataFlowID flowID8 = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, (Object)OutputType.SUGGESTIONS)});
        DataFlowID flowID9 = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, (Object)OutputType.EVENTS)});
        DataFlowID flowID10 = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, (Object)OutputType.NOTIFICATIONS)});
        DataFlowID flowID11 = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, (Object)OutputType.LOG)});
        DataFlowID flowID12 = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(StrategyModuleFactory.PROVIDER_URN, (Object)OutputType.ALL)});
        this.moduleManager.cancel(flowID1);
        this.moduleManager.cancel(flowID2);
        this.moduleManager.cancel(flowID3);
        this.moduleManager.cancel(flowID4);
        this.moduleManager.cancel(flowID5);
        this.moduleManager.cancel(flowID6);
        this.moduleManager.cancel(flowID7);
        this.moduleManager.cancel(flowID8);
        this.moduleManager.cancel(flowID9);
        this.moduleManager.cancel(flowID10);
        this.moduleManager.cancel(flowID11);
        this.moduleManager.cancel(flowID12);
    }

    @Test
    public void receiveData() throws Exception {
        ModuleURN strategy = this.createStrategy("RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, new Properties(), false, this.outputURN);
        DataFlowID dataFlowID = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(BogusFeedModuleFactory.PROVIDER_URN, (Object)MarketDataRequestBuilder.newRequest().withExchange("Exchange").withSymbols("GOOG").create()), new DataRequest(strategy)}, false);
        Thread.sleep(5000L);
        this.moduleManager.cancel(dataFlowID);
    }

    @Test
    public void nullParameterTest() throws Exception {
        final int[] index = new int[]{0};
        while (index[0] < 6) {
            if (index[0] == 0 || index[0] == 4 || index[0] == 5 || index[0] == 6) {
                this.verifyStrategyStartsAndStops(index[0] == 0 ? null : "MyStrategy", index[0] == 1 ? null : "RubyStrategy", index[0] == 2 ? null : Language.RUBY, index[0] == 3 ? null : RubyLanguageTest.STRATEGY, index[0] == 4 ? null : new Properties(), index[0] == 5 ? null : Boolean.valueOf(false), index[0] == 6 ? null : this.outputURN);
            } else {
                new ExpectedFailure<ModuleCreationException>((I18NMessage)NULL_PARAMETER_ERROR, new Object[]{index[0] + 1, expectedTypes[index[0]].getName()}){

                    protected void run() throws Exception {
                        StrategyModuleTest.this.verifyStrategyStartsAndStops(index[0] == 0 ? null : "MyStrategy", index[0] == 1 ? null : "RubyStrategy", index[0] == 2 ? null : Language.RUBY, index[0] == 3 ? null : RubyLanguageTest.STRATEGY, index[0] == 4 ? null : new Properties(), index[0] == 5 ? null : Boolean.valueOf(false), index[0] == 6 ? null : StrategyModuleTest.this.outputURN);
                    }
                };
            }
            index[0] = index[0] + 1;
        }
    }

    @Test
    public void instanceParameterTest() throws Exception {
        String emptyInstance = "";
        new ExpectedFailure<ModuleCreationException>((I18NBoundMessage)EMPTY_INSTANCE_ERROR){

            protected void run() throws Exception {
                StrategyModuleTest.this.verifyStrategyStartsAndStops("", "RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, null, null, null);
            }
        };
        this.verifyStrategyStartsAndStops("MyStrategyInstance", "RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, null, null, null);
    }

    @Test
    public void nameParameterTest() throws Exception {
        String emptyName = "";
        new ExpectedFailure<ModuleCreationException>((I18NBoundMessage)EMPTY_NAME_ERROR){

            protected void run() throws Exception {
                StrategyModuleTest.this.verifyStrategyStartsAndStops("", Language.RUBY, RubyLanguageTest.STRATEGY, null, null, null);
            }
        };
        this.verifyStrategyStartsAndStops("RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, null, null, null);
    }

    @Test
    public void languageParameterTest() throws Exception {
        final String invalidLanguage = "Language-" + System.currentTimeMillis();
        String validLanguage = Language.RUBY.toString();
        String validMixedCaseLanguage = "RuBy";
        new ExpectedFailure<ModuleCreationException>((I18NMessage)INVALID_LANGUAGE_ERROR, new Object[]{invalidLanguage}){

            protected void run() throws Exception {
                StrategyModuleTest.this.verifyStrategyStartsAndStops("RubyStrategy", invalidLanguage, RubyLanguageTest.STRATEGY, null, null, null);
            }
        };
        this.verifyStrategyStartsAndStops("RubyStrategy", validLanguage, RubyLanguageTest.STRATEGY, null, null, null);
        this.verifyStrategyStartsAndStops("RubyStrategy", validMixedCaseLanguage, RubyLanguageTest.STRATEGY, null, null, null);
    }

    @Test
    public void fileParameterTest() throws Exception {
        final File badFile = new File("this-file-really-should-not-exist-" + System.nanoTime());
        new ExpectedFailure<ModuleCreationException>((I18NMessage)FILE_DOES_NOT_EXIST_OR_IS_NOT_READABLE, new Object[]{badFile.getAbsolutePath()}){

            protected void run() throws Exception {
                StrategyModuleTest.this.verifyStrategyStartsAndStops("RubyStrategy", Language.RUBY, badFile, null, null, null);
            }
        };
    }

    @Test
    public void propertiesParameterTest() throws Exception {
        Properties properties = new Properties();
        this.verifyStrategyStartsAndStops("RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, properties, null, null);
        properties.setProperty("some-key", "some value " + System.nanoTime());
        this.verifyStrategyStartsAndStops("RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, properties, null, null);
    }

    @Test
    public void urnParameterTest() throws Exception {
        final ModuleURN invalidURN = new ModuleURN("metc:something:something");
        final ModuleURN validUnstartedURN = this.moduleManager.createModule(StrategyTestBase.MockRecorderModule.Factory.PROVIDER_URN, new Object[0]);
        final ModuleURN validURNNotReceiver = BogusFeedModuleFactory.INSTANCE_URN;
        Assert.assertFalse((boolean)this.moduleManager.getModuleInfo(BogusFeedModuleFactory.INSTANCE_URN).isReceiver());
        new ExpectedFailure<ModuleNotFoundException>((I18NMessage)Messages.MODULE_NOT_FOUND, new Object[]{invalidURN.toString()}){

            protected void run() throws Exception {
                StrategyModuleTest.this.verifyStrategyStartsAndStops("RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, null, null, invalidURN);
            }
        };
        new ExpectedFailure<ModuleStateException>((I18NMessage)Messages.DATAFLOW_FAILED_PCPT_MODULE_STATE_INCORRECT, new Object[]{validUnstartedURN.toString(), ExpectedFailure.IGNORE, ExpectedFailure.IGNORE}){

            protected void run() throws Exception {
                StrategyModuleTest.this.verifyStrategyStartsAndStops("RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, null, null, validUnstartedURN);
            }
        };
        new ExpectedFailure<DataFlowException>((I18NMessage)Messages.MODULE_NOT_RECEIVER, new Object[]{validURNNotReceiver.toString()}){

            protected void run() throws Exception {
                StrategyModuleTest.this.verifyStrategyStartsAndStops("RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, null, null, validURNNotReceiver);
            }
        };
    }

    @Test
    public void mxBean() throws Exception {
        ModuleURN stoppedURN = this.moduleManager.createModule(StrategyTestBase.MockRecorderModule.Factory.PROVIDER_URN, new Object[0]);
        Assert.assertFalse((boolean)this.moduleManager.getModuleInfo(stoppedURN).getState().isStarted());
        final String[] urnStrings = new String[]{null, "this is not a URN", stoppedURN.getValue(), "", this.outputURN.getValue()};
        final ModuleURN[] urns = new ModuleURN[]{null, this.outputURN};
        Properties emptyProperties = new Properties();
        Properties nonEmptyProperties = new Properties();
        nonEmptyProperties.setProperty("key1", "value1");
        Properties nonASCIIProperties = new Properties();
        nonASCIIProperties.setProperty("key1", "\u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5");
        final String[] parameterStrings = new String[]{null, "ab:c=d::ef:", Util.propertiesToString((Properties)emptyProperties), Util.propertiesToString((Properties)nonEmptyProperties), Util.propertiesToString((Properties)nonASCIIProperties)};
        final Properties[] parameters = new Properties[]{null, emptyProperties, nonEmptyProperties, nonASCIIProperties};
        for (int urnStringIndex = 0; urnStringIndex < urnStrings.length; ++urnStringIndex) {
            for (int urnIndex = 0; urnIndex < urns.length; ++urnIndex) {
                for (int parameterStringIndex = 0; parameterStringIndex < parameterStrings.length; ++parameterStringIndex) {
                    for (int parameterIndex = 0; parameterIndex < parameters.length; ++parameterIndex) {
                        for (int startRoutingIndex = 0; startRoutingIndex <= 1; ++startRoutingIndex) {
                            for (int changeRoutingIndex = 0; changeRoutingIndex <= 1; ++changeRoutingIndex) {
                                final int urnStringCounter = urnStringIndex;
                                final int urnCounter = urnIndex;
                                final int parmaterStringCounter = parameterStringIndex;
                                final int parameterCounter = parameterIndex;
                                final int startRoutingCounter = startRoutingIndex;
                                final int changeRoutingCounter = changeRoutingIndex;
                                SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Testing permutation: {} {} {} {} {} {}", (Object[])new Object[]{urnStringIndex, urnIndex, parameterStringIndex, parameterIndex, startRoutingIndex, changeRoutingIndex});
                                if (urnStringIndex == 1) {
                                    new ExpectedFailure<InvalidURNException>((I18NMessage)Messages.INVALID_URN_SCHEME, new Object[0]){

                                        protected void run() throws Exception {
                                            StrategyModuleTest.this.doOneMXInterfaceTest(urnStrings[urnStringCounter], urns[urnCounter], parameterStrings[parmaterStringCounter], parameters[parameterCounter], startRoutingCounter != 0, changeRoutingCounter != 0);
                                        }
                                    };
                                    continue;
                                }
                                if (urnStringIndex == 2) {
                                    new ExpectedFailure<ModuleStateException>((I18NMessage)Messages.DATAFLOW_FAILED_PCPT_MODULE_STATE_INCORRECT, new Object[0]){

                                        protected void run() throws Exception {
                                            StrategyModuleTest.this.doOneMXInterfaceTest(urnStrings[urnStringCounter], urns[urnCounter], parameterStrings[parmaterStringCounter], parameters[parameterCounter], startRoutingCounter != 0, changeRoutingCounter != 0);
                                        }
                                    };
                                    continue;
                                }
                                this.doOneMXInterfaceTest(urnStrings[urnStringIndex], urns[urnIndex], parameterStrings[parmaterStringCounter], parameters[parameterCounter], startRoutingCounter != 0, changeRoutingCounter != 0);
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void ordersNonEmitter() throws Exception {
        ModuleURN dataSink = SinkModuleFactory.INSTANCE_URN;
        Assert.assertTrue((boolean)this.moduleManager.getModuleInfo(dataSink).getState().isStarted());
        Assert.assertFalse((boolean)this.moduleManager.getModuleInfo(dataSink).isEmitter());
        ModuleURN strategy = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{"MyStrategy", "RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, null, null, dataSink});
        this.startStrategy(strategy);
        Assert.assertTrue((boolean)this.moduleManager.getModuleInfo(strategy).getState().isStarted());
        this.stopStrategy(strategy);
        this.moduleManager.deleteModule(strategy);
    }

    @Test
    public void duplicateInstanceNames() throws Exception {
        ModuleURN strategy1 = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{"MyNewStrategy", "RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, null, null, null});
        new ExpectedFailure<ModuleCreationException>((I18NMessage)Messages.DUPLICATE_MODULE_URN, new Object[]{"metc:strategy:system:MyNewStrategy"}){

            protected void run() throws Exception {
                StrategyModuleTest.this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{"MyNewStrategy", "RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, null, null, null});
            }
        };
        this.moduleManager.deleteModule(strategy1);
        strategy1 = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{"MyNewStrategy", "RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, null, null, null});
        this.moduleManager.deleteModule(strategy1);
    }

    @Test
    public void strategyStateChanges() throws Exception {
        Properties parameters = new Properties();
        parameters.setProperty("shouldLoopOnStart", "true");
        parameters.setProperty("shouldLoopOnStop", "true");
        this.verifyPropertyNull("loopDone");
        this.verifyPropertyNull("onStartBegins");
        final ModuleURN strategyURN = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{null, "RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, parameters, null, null});
        final ArrayList thrownExceptions = new ArrayList();
        Thread helperThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StrategyModuleTest.this.moduleManager.start(strategyURN);
                }
                catch (ModuleException e) {
                    thrownExceptions.add(e);
                }
            }
        });
        helperThread.start();
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    return StrategyModuleTest.this.getStatus(strategyURN).equals((Object)Status.STARTING) && AbstractRunningStrategy.getProperty((String)"onStartBegins") != null;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
        AbstractRunningStrategy.setProperty((String)"onStartBegins", null);
        new ExpectedFailure<ModuleStateException>((I18NMessage)Messages.MODULE_NOT_STARTED_STATE_INCORRECT, new Object[]{strategyURN.toString(), ExpectedFailure.IGNORE, ExpectedFailure.IGNORE}){

            protected void run() throws Exception {
                StrategyModuleTest.this.moduleManager.start(strategyURN);
            }
        };
        AbstractRunningStrategy.setProperty((String)"shouldStopLoop", (String)"true");
        helperThread.join();
        Assert.assertTrue((boolean)thrownExceptions.isEmpty());
        this.verifyStrategyReady(strategyURN);
        this.verifyStrategyStatus(strategyURN, Status.RUNNING);
        new ExpectedFailure<ModuleStateException>((I18NMessage)Messages.MODULE_NOT_STARTED_STATE_INCORRECT, new Object[]{strategyURN.toString(), ExpectedFailure.IGNORE, ExpectedFailure.IGNORE}){

            protected void run() throws Exception {
                StrategyModuleTest.this.moduleManager.start(strategyURN);
            }
        };
        this.setPropertiesToNull();
        helperThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StrategyModuleTest.this.moduleManager.stop(strategyURN);
                }
                catch (Exception e) {
                    thrownExceptions.add(e);
                }
            }
        });
        helperThread.start();
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return StrategyModuleTest.this.getStatus(strategyURN).equals((Object)Status.STOPPING) && AbstractRunningStrategy.getProperty((String)"onStopBegins") != null;
            }
        });
        AbstractRunningStrategy.setProperty((String)"onStopBegins", null);
        Assert.assertFalse((boolean)this.moduleManager.getModuleInfo(strategyURN).getState().isStarted());
        new ExpectedFailure<ModuleStateException>((I18NMessage)Messages.MODULE_NOT_STOPPED_STATE_INCORRECT, new Object[]{strategyURN.toString(), ExpectedFailure.IGNORE, ExpectedFailure.IGNORE}){

            protected void run() throws Exception {
                StrategyModuleTest.this.moduleManager.stop(strategyURN);
            }
        };
        new ExpectedFailure<ModuleStateException>((I18NMessage)Messages.MODULE_NOT_STARTED_STATE_INCORRECT, new Object[]{strategyURN.toString(), ExpectedFailure.IGNORE, ExpectedFailure.IGNORE}){

            protected void run() throws Exception {
                StrategyModuleTest.this.moduleManager.start(strategyURN);
            }
        };
        AbstractRunningStrategy.setProperty((String)"shouldStopLoop", (String)"true");
        helperThread.join();
        Assert.assertTrue((boolean)thrownExceptions.isEmpty());
        this.verifyStrategyStopped(strategyURN);
        this.verifyStrategyStatus(strategyURN, Status.STOPPED);
        this.moduleManager.start(strategyURN);
        this.verifyStrategyReady(strategyURN);
        this.moduleManager.stop(strategyURN);
    }

    @Test
    public void statusNotification() throws Exception {
        ModuleURN strategyURN = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{"MyStategy", "RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, null, null, null});
        Assert.assertFalse((boolean)this.moduleManager.getModuleInfo(strategyURN).getState().isStarted());
        StrategyMXBean strategyInterface = this.getMXProxy(strategyURN);
        final ArrayList statusChanges = new ArrayList();
        NotificationListener subscriber = new NotificationListener(){

            @Override
            public void handleNotification(Notification inNotification, Object inHandback) {
                if (inNotification instanceof AttributeChangeNotification) {
                    AttributeChangeNotification change = (AttributeChangeNotification)inNotification;
                    statusChanges.add(change.getOldValue() + "->" + change.getNewValue());
                }
            }
        };
        ((NotificationEmitter)strategyInterface).addNotificationListener(subscriber, null, null);
        Assert.assertTrue((boolean)statusChanges.isEmpty());
        this.moduleManager.start(strategyURN);
        this.verifyStrategyReady(strategyURN);
        Assert.assertEquals((long)3L, (long)statusChanges.size());
        Assert.assertEquals((Object)"UNSTARTED->COMPILING", statusChanges.get(0));
        Assert.assertEquals((Object)"COMPILING->STARTING", statusChanges.get(1));
        Assert.assertEquals((Object)"STARTING->RUNNING", statusChanges.get(2));
        ((NotificationEmitter)strategyInterface).removeNotificationListener(subscriber);
        statusChanges.clear();
        this.moduleManager.stop(strategyURN);
        Assert.assertTrue((boolean)statusChanges.isEmpty());
    }

    private ModuleURN doOneMXInterfaceTest(String inOutputDestination, ModuleURN inOutputStart, String inNewParameters, Properties inStartingParameters, boolean inStartingRouteToORS, boolean inNewRouting) throws Exception {
        Properties actualProperties;
        String propertiesString;
        ModuleURN strategy = this.createStrategy("RubyStrategy", Language.RUBY, RubyLanguageTest.STRATEGY, inStartingParameters, inStartingRouteToORS, inOutputStart);
        StrategyMXBean mxBeanInterface = this.getMXProxy(strategy);
        this.verifyStrategyStatus(strategy, Status.RUNNING);
        if (inOutputStart == null) {
            Assert.assertNull((Object)mxBeanInterface.getOutputDestination());
        } else {
            Assert.assertEquals((Object)inOutputStart.getValue(), (Object)mxBeanInterface.getOutputDestination());
        }
        if (inStartingParameters == null || inStartingParameters.isEmpty()) {
            Assert.assertNull((Object)mxBeanInterface.getParameters());
        } else {
            propertiesString = mxBeanInterface.getParameters();
            actualProperties = Util.propertiesFromString((String)propertiesString);
            Assert.assertEquals((Object)actualProperties, (Object)inStartingParameters);
        }
        Assert.assertEquals((Object)inStartingRouteToORS, (Object)mxBeanInterface.isRoutingOrdersToORS());
        Assert.assertEquals((Object)"RubyStrategy", (Object)mxBeanInterface.getName());
        Assert.assertEquals((Object)Language.RUBY, (Object)mxBeanInterface.getLanguage());
        mxBeanInterface.setOutputDestination(inOutputDestination);
        mxBeanInterface.setParameters(inNewParameters);
        mxBeanInterface.setRoutingOrdersToORS(inNewRouting);
        if (inOutputDestination == null || inOutputDestination.isEmpty()) {
            Assert.assertNull((Object)mxBeanInterface.getOutputDestination());
        } else {
            Assert.assertEquals((Object)inOutputDestination, (Object)mxBeanInterface.getOutputDestination());
        }
        if (inNewParameters == null || inNewParameters.isEmpty()) {
            Assert.assertNull((Object)mxBeanInterface.getParameters());
        } else {
            propertiesString = mxBeanInterface.getParameters();
            actualProperties = Util.propertiesFromString((String)propertiesString);
            Properties expectedProperties = Util.propertiesFromString((String)inNewParameters);
            Assert.assertEquals((Object)actualProperties, (Object)expectedProperties);
        }
        Assert.assertEquals((Object)inNewRouting, (Object)mxBeanInterface.isRoutingOrdersToORS());
        this.stopStrategy(strategy);
        this.verifyStrategyStatus(strategy, Status.STOPPED);
        this.startStrategy(strategy);
        this.verifyStrategyStatus(strategy, Status.RUNNING);
        return strategy;
    }

    private void doWrongTypeParameterTest(int badParameter, final Object ... inParameters) throws Exception {
        if (badParameter != 2) {
            new ExpectedFailure<ModuleCreationException>((I18NMessage)Messages.CANNOT_CREATE_MODULE_WRONG_PARAM_TYPE, new Object[]{StrategyModuleFactory.PROVIDER_URN.toString(), badParameter, expectedTypes[badParameter].getName(), inParameters[badParameter].getClass().getName()}){

                protected void run() throws Exception {
                    StrategyModuleTest.this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, inParameters);
                }
            };
        }
        new ExpectedFailure<ModuleCreationException>((I18NMessage)PARAMETER_TYPE_ERROR, new Object[]{badParameter + 1, expectedTypes[badParameter].getName(), inParameters[badParameter].getClass().getName()}){

            protected void run() throws Exception {
                StrategyModuleTest.this.factory.create(inParameters);
            }
        };
    }

    private void doWrongParameterCountTest(final Object ... inParameters) throws Exception {
        if (inParameters != null) {
            Assert.assertFalse((String)"This test is supposed to test an incorrect number of parameters", (inParameters.length == 7 ? 1 : 0) != 0);
        }
        new ExpectedFailure<ModuleCreationException>((I18NMessage)Messages.CANNOT_CREATE_MODULE_WRONG_PARAM_NUM, new Object[]{StrategyModuleFactory.PROVIDER_URN.toString(), 7, inParameters == null ? 0 : inParameters.length}){

            protected void run() throws Exception {
                StrategyModuleTest.this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, inParameters);
            }
        };
        new ExpectedFailure<ModuleCreationException>((I18NBoundMessage)PARAMETER_COUNT_ERROR){

            protected void run() throws Exception {
                StrategyModuleTest.this.factory.create(inParameters);
            }
        };
    }
}

