/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import java.util.HashMap;
import java.util.Map;
import org.apache.bsf.BSFException;
import org.jruby.exceptions.RaiseException;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.strategy.AbstractExecutor;
import org.marketcetera.strategy.BeanScriptingFrameworkEngine;
import org.marketcetera.strategy.ExecutionEngine;
import org.marketcetera.strategy.Strategy;
import org.marketcetera.strategy.StrategyException;

@ClassVersion(value="$Id: RubyExecutor.java 16154 2012-07-14 16:34:05Z colin $")
class RubyExecutor
extends AbstractExecutor {
    private static final Map<String, String> methodNames = new HashMap<String, String>();

    RubyExecutor(Strategy inStrategy) {
        super(inStrategy);
    }

    @Override
    public String interpretRuntimeException(Exception inE) {
        return RubyExecutor.exceptionAsString(inE);
    }

    @Override
    protected String preprocess(String inScript) throws StrategyException {
        StringBuilder fullScript = new StringBuilder();
        fullScript.append(inScript);
        fullScript.append("\n").append(this.getStrategy().getName()).append(".new\n");
        String processedScript = fullScript.toString();
        return processedScript;
    }

    @Override
    protected ExecutionEngine getExecutionEngine() throws StrategyException {
        return new BeanScriptingFrameworkEngine();
    }

    static String exceptionAsString(Exception inE) {
        RaiseException raiseException = null;
        if (inE instanceof RaiseException) {
            raiseException = (RaiseException)inE;
        } else if (inE instanceof BSFException && ((BSFException)((Object)inE)).getTargetException() instanceof RaiseException) {
            raiseException = (RaiseException)((BSFException)((Object)inE)).getTargetException();
        }
        if (raiseException != null) {
            return String.format("%s %s", raiseException.getException().toString(), raiseException.getException().backtrace().toString());
        }
        return inE.toString();
    }

    @Override
    public String translateMethodName(String inMethodName) {
        return methodNames.get(inMethodName);
    }

    static {
        methodNames.put("onAsk", "on_ask");
        methodNames.put("onBid", "on_bid");
        methodNames.put("onMarketstat", "on_marketstat");
        methodNames.put("onDividend", "on_dividend");
        methodNames.put("onCancelReject", "on_cancel_reject");
        methodNames.put("onExecutionReport", "on_execution_report");
        methodNames.put("onTrade", "on_trade");
        methodNames.put("onOther", "on_other");
        methodNames.put("onCallback", "on_callback");
        methodNames.put("onStart", "on_start");
        methodNames.put("onStop", "on_stop");
    }
}

