/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.event.AskEvent;
import org.marketcetera.event.BidEvent;
import org.marketcetera.event.DividendEvent;
import org.marketcetera.event.DividendFrequency;
import org.marketcetera.event.DividendStatus;
import org.marketcetera.event.DividendType;
import org.marketcetera.event.Event;
import org.marketcetera.event.EventTestBase;
import org.marketcetera.event.LogEvent;
import org.marketcetera.event.MarketstatEvent;
import org.marketcetera.event.OptionEvent;
import org.marketcetera.event.QuoteAction;
import org.marketcetera.event.TestMessages;
import org.marketcetera.event.TradeEvent;
import org.marketcetera.event.impl.DividendEventBuilder;
import org.marketcetera.event.impl.LogEventBuilder;
import org.marketcetera.event.impl.QuoteEventBuilder;
import org.marketcetera.event.impl.TradeEventBuilder;
import org.marketcetera.marketdata.DateUtils;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.options.ExpirationType;
import org.marketcetera.strategy.util.OptionChain;
import org.marketcetera.strategy.util.OptionContract;
import org.marketcetera.strategy.util.OptionContractPair;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.util.test.EqualityAssert;

public class OptionChainTest
implements TestMessages {
    private final Equity equity = new Equity("METC");
    private final Option callOption = new Option("MSFT", "20100319", BigDecimal.ONE, OptionType.Call);
    private final Option putOption = new Option("MSFT", "20100319", BigDecimal.ONE, OptionType.Put);

    @Test
    public void optionChainConstructor() throws Exception {
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                new OptionChain(null);
            }
        };
        new ExpectedFailure<UnsupportedOperationException>(){

            protected void run() throws Exception {
                Instrument other = EventTestBase.generateUnsupportedInstrument();
                OptionChainTest.verifyOptionChain(new OptionChain(other), other, null, null, null, null, new ArrayList(), new ArrayList());
            }
        };
        OptionChainTest.verifyOptionChain(new OptionChain((Instrument)this.equity), (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
        OptionChainTest.verifyOptionChain(new OptionChain((Instrument)this.callOption), (Instrument)this.callOption, null, null, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
    }

    @Test
    public void getOptionChain() throws Exception {
        OptionChain chain = new OptionChain((Instrument)this.equity);
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
        AskEvent callAsk = (AskEvent)QuoteEventBuilder.optionAskEvent().withUnderlyingInstrument((Instrument)this.equity).hasDeliverable(false).withExchange("B").withExpirationType(ExpirationType.AMERICAN).withInstrument((Instrument)this.callOption).withMultiplier(BigDecimal.ZERO).withPrice(EventTestBase.generateDecimalValue()).withQuoteDate(new Date()).withSize(EventTestBase.generateDecimalValue()).create();
        Assert.assertTrue((boolean)chain.process((Event)callAsk));
        OptionContractPair entry = new OptionContractPair((OptionEvent)callAsk);
        Assert.assertTrue((boolean)entry.process((OptionEvent)callAsk));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), Arrays.asList(entry));
        BidEvent callBid = (BidEvent)QuoteEventBuilder.optionBidEvent().withUnderlyingInstrument((Instrument)this.equity).withExchange("B").withExpirationType(ExpirationType.AMERICAN).withInstrument((Instrument)this.callOption).withPrice(EventTestBase.generateDecimalValue()).withQuoteDate(new Date()).withSize(EventTestBase.generateDecimalValue()).create();
        Assert.assertTrue((boolean)chain.process((Event)callBid));
        Assert.assertTrue((boolean)entry.process((OptionEvent)callBid));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), Arrays.asList(entry));
        AskEvent putAsk = (AskEvent)QuoteEventBuilder.optionAskEvent().withUnderlyingInstrument((Instrument)this.equity).hasDeliverable(false).withExchange("X").withExpirationType(ExpirationType.AMERICAN).withInstrument((Instrument)this.putOption).withMultiplier(BigDecimal.ZERO).withPrice(EventTestBase.generateDecimalValue()).withQuoteDate(new Date()).withSize(EventTestBase.generateDecimalValue()).create();
        Assert.assertTrue((boolean)chain.process((Event)putAsk));
        Assert.assertTrue((boolean)entry.process((OptionEvent)putAsk));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), Arrays.asList(entry));
        Collection optionChain = chain.getOptionChain();
        Assert.assertEquals((long)1L, (long)optionChain.size());
        Assert.assertEquals((Object)entry, optionChain.iterator().next());
        BidEvent putBid = (BidEvent)QuoteEventBuilder.optionBidEvent().withUnderlyingInstrument((Instrument)this.equity).withExchange("X").withExpirationType(ExpirationType.AMERICAN).withInstrument((Instrument)this.putOption).withPrice(EventTestBase.generateDecimalValue()).withQuoteDate(new Date()).withSize(EventTestBase.generateDecimalValue()).create();
        Assert.assertTrue((boolean)chain.process((Event)putBid));
        Assert.assertTrue((boolean)entry.process((OptionEvent)putBid));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), Arrays.asList(entry));
        Assert.assertEquals((long)1L, (long)optionChain.size());
        Assert.assertEquals((Object)entry, optionChain.iterator().next());
        TradeEvent putTrade = (TradeEvent)TradeEventBuilder.optionTradeEvent().withUnderlyingInstrument((Instrument)this.equity).withExchange("X").withExpirationType(ExpirationType.AMERICAN).withInstrument((Instrument)this.putOption).withPrice(EventTestBase.generateDecimalValue()).withTradeDate(new Date()).withSize(EventTestBase.generateDecimalValue()).create();
        Assert.assertTrue((boolean)chain.process((Event)putTrade));
        Assert.assertTrue((boolean)entry.process((OptionEvent)putTrade));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), Arrays.asList(entry));
        Assert.assertEquals((long)1L, (long)optionChain.size());
        Assert.assertEquals((Object)entry, optionChain.iterator().next());
        Option newCallOption = new Option(this.callOption.getSymbol(), this.callOption.getExpiry(), this.callOption.getStrikePrice().add(EventTestBase.generateDecimalValue()), OptionType.Call);
        callAsk = (AskEvent)QuoteEventBuilder.optionAskEvent().withUnderlyingInstrument((Instrument)this.equity).withExchange("Q").withExpirationType(ExpirationType.AMERICAN).withInstrument((Instrument)newCallOption).withPrice(EventTestBase.generateDecimalValue()).withQuoteDate(new Date()).withSize(EventTestBase.generateDecimalValue()).create();
        Assert.assertTrue((boolean)chain.process((Event)callAsk));
        Assert.assertNotNull((Object)optionChain.toString());
        Assert.assertEquals((long)2L, (long)optionChain.size());
        OptionContractPair newEntry = new OptionContractPair((OptionEvent)callAsk);
        Iterator iterator = optionChain.iterator();
        Assert.assertEquals((Object)entry, iterator.next());
        Assert.assertEquals((Object)newEntry, iterator.next());
        Option newerCallOption = new Option(newCallOption.getSymbol(), newCallOption.getExpiry(), newCallOption.getStrikePrice().add(EventTestBase.generateDecimalValue()), OptionType.Call);
        callBid = (BidEvent)QuoteEventBuilder.optionBidEvent().withUnderlyingInstrument((Instrument)this.equity).withExchange("Q").withExpirationType(ExpirationType.AMERICAN).withInstrument((Instrument)newerCallOption).withPrice(EventTestBase.generateDecimalValue()).withQuoteDate(new Date()).withSize(EventTestBase.generateDecimalValue()).create();
        Assert.assertTrue((boolean)chain.process((Event)callBid));
        Assert.assertNotNull((Object)chain.toString());
        TradeEvent callTrade = (TradeEvent)TradeEventBuilder.optionTradeEvent().withUnderlyingInstrument((Instrument)this.equity).withExchange("Q").withExpirationType(ExpirationType.AMERICAN).withInstrument((Instrument)newerCallOption).withPrice(EventTestBase.generateDecimalValue()).withTradeDate(new Date()).withSize(EventTestBase.generateDecimalValue()).create();
        Assert.assertTrue((boolean)chain.process((Event)callTrade));
        Assert.assertNotNull((Object)chain.toString());
        Assert.assertEquals((long)3L, (long)optionChain.size());
        OptionContractPair newerEntry = new OptionContractPair((OptionEvent)callTrade);
        iterator = optionChain.iterator();
        Assert.assertEquals((Object)entry, iterator.next());
        Assert.assertEquals((Object)newEntry, iterator.next());
        Assert.assertEquals((Object)newerEntry, iterator.next());
    }

    @Test
    public void getDividends() throws Exception {
        OptionChain chain = new OptionChain((Instrument)this.equity);
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
        Date date = new Date();
        DividendEventBuilder builder = DividendEventBuilder.dividend().withAmount(new BigDecimal("123.45")).withCurrency("US Dollars").withDeclareDate(DateUtils.dateToString((Date)date)).withEquity(this.equity).withExecutionDate(DateUtils.dateToString((Date)date)).withFrequency(DividendFrequency.ANNUALLY).withPaymentDate(DateUtils.dateToString((Date)date)).withRecordDate(DateUtils.dateToString((Date)date)).withStatus(DividendStatus.OFFICIAL).withType(DividendType.FUTURE);
        DividendEvent event = (DividendEvent)builder.create();
        Assert.assertTrue((boolean)chain.process((Event)event));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, Arrays.asList(event), new ArrayList<OptionContractPair>());
        builder.withAmount(new BigDecimal("2345.67"));
        DividendEvent event2 = (DividendEvent)builder.create();
        Assert.assertFalse((boolean)event.equals(event2));
        Assert.assertTrue((boolean)chain.process((Event)event2));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, Arrays.asList(event, event2), new ArrayList<OptionContractPair>());
    }

    @Test
    public void getLatestUnderlyingAsk() throws Exception {
        OptionChain chain = new OptionChain((Instrument)this.equity);
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
        AskEvent equityAsk = EventTestBase.generateEquityAskEvent((Equity)this.equity, (QuoteAction)QuoteAction.ADD);
        Assert.assertTrue((boolean)chain.process((Event)equityAsk));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, equityAsk, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
        AskEvent equityAsk2 = EventTestBase.generateEquityAskEvent((Equity)this.equity, (QuoteAction)QuoteAction.ADD);
        Assert.assertFalse((boolean)equityAsk.equals(equityAsk2));
        Assert.assertTrue((boolean)chain.process((Event)equityAsk2));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, equityAsk2, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
    }

    @Test
    public void getLatestUnderlyingBid() throws Exception {
        OptionChain chain = new OptionChain((Instrument)this.equity);
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
        BidEvent equityBid = EventTestBase.generateEquityBidEvent((Equity)this.equity, (QuoteAction)QuoteAction.ADD);
        Assert.assertTrue((boolean)chain.process((Event)equityBid));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, equityBid, null, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
        BidEvent equityBid2 = EventTestBase.generateEquityBidEvent((Equity)this.equity, (QuoteAction)QuoteAction.ADD);
        Assert.assertFalse((boolean)equityBid.equals(equityBid2));
        Assert.assertTrue((boolean)chain.process((Event)equityBid2));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, equityBid2, null, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
    }

    @Test
    public void getLatestUnderlyingTrade() throws Exception {
        OptionChain chain = new OptionChain((Instrument)this.equity);
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
        TradeEvent equityTrade = EventTestBase.generateEquityTradeEvent((Equity)this.equity);
        Assert.assertTrue((boolean)chain.process((Event)equityTrade));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, equityTrade, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
        TradeEvent equityTrade2 = EventTestBase.generateEquityTradeEvent((Equity)this.equity);
        Assert.assertFalse((boolean)equityTrade.equals(equityTrade2));
        Assert.assertTrue((boolean)chain.process((Event)equityTrade2));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, equityTrade2, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
    }

    @Test
    public void getLatestUnderlyingMarketstat() throws Exception {
        OptionChain chain = new OptionChain((Instrument)this.equity);
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
        MarketstatEvent equityMarketstat = EventTestBase.generateEquityMarketstatEvent((Equity)this.equity);
        Assert.assertTrue((boolean)chain.process((Event)equityMarketstat));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, equityMarketstat, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
        MarketstatEvent equityMarketstat2 = EventTestBase.generateEquityMarketstatEvent((Equity)this.equity);
        Assert.assertFalse((boolean)equityMarketstat.equals(equityMarketstat2));
        Assert.assertTrue((boolean)chain.process((Event)equityMarketstat2));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, equityMarketstat2, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
        MarketstatEvent optionMarketstat = EventTestBase.generateOptionMarketstatEvent((Option)this.putOption, (Instrument)this.equity);
        Assert.assertTrue((boolean)chain.process((Event)optionMarketstat));
        OptionContractPair entry = new OptionContractPair((OptionEvent)optionMarketstat);
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, equityMarketstat2, new ArrayList<DividendEvent>(), Arrays.asList(entry));
    }

    @Test
    public void process() throws Exception {
        final OptionChain chain = new OptionChain((Instrument)this.equity);
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                chain.process(null);
            }
        };
        AskEvent ask = EventTestBase.generateEquityAskEvent((Equity)this.equity, (QuoteAction)QuoteAction.ADD);
        BidEvent bid = EventTestBase.generateEquityBidEvent((Equity)this.equity, (QuoteAction)QuoteAction.ADD);
        TradeEvent trade = EventTestBase.generateEquityTradeEvent((Equity)this.equity);
        MarketstatEvent marketstat = EventTestBase.generateEquityMarketstatEvent((Equity)this.equity);
        DividendEvent dividend = EventTestBase.generateDividendEvent();
        LogEvent log = (LogEvent)LogEventBuilder.error().withMessage(MESSAGE_0P).create();
        Assert.assertTrue((boolean)chain.process((Event)ask));
        Assert.assertTrue((boolean)chain.process((Event)bid));
        Assert.assertTrue((boolean)chain.process((Event)trade));
        Assert.assertTrue((boolean)chain.process((Event)marketstat));
        Assert.assertTrue((boolean)chain.process((Event)dividend));
        Assert.assertFalse((boolean)chain.process((Event)log));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, bid, ask, trade, marketstat, Arrays.asList(dividend), new ArrayList<OptionContractPair>());
    }

    @Test
    public void processErrorCases() throws Exception {
        OptionChain chain = new OptionChain((Instrument)this.equity);
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
        Equity otherEquity = new Equity("GOOG");
        Assert.assertFalse((boolean)otherEquity.equals((Object)this.equity));
        AskEvent ask = EventTestBase.generateEquityAskEvent((Equity)otherEquity, (QuoteAction)QuoteAction.ADD);
        BidEvent bid = EventTestBase.generateEquityBidEvent((Equity)otherEquity, (QuoteAction)QuoteAction.ADD);
        TradeEvent trade = EventTestBase.generateEquityTradeEvent((Equity)otherEquity);
        MarketstatEvent marketstat = EventTestBase.generateEquityMarketstatEvent((Equity)otherEquity);
        DividendEvent dividend = EventTestBase.generateDividendEvent((Equity)otherEquity);
        Assert.assertFalse((boolean)chain.process((Event)ask));
        Assert.assertFalse((boolean)chain.process((Event)bid));
        Assert.assertFalse((boolean)chain.process((Event)trade));
        Assert.assertFalse((boolean)chain.process((Event)marketstat));
        Assert.assertFalse((boolean)chain.process((Event)dividend));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
        ask = EventTestBase.generateOptionAskEvent((Option)this.callOption, (QuoteAction)QuoteAction.ADD);
        bid = EventTestBase.generateOptionBidEvent((Option)this.callOption, (QuoteAction)QuoteAction.ADD);
        trade = EventTestBase.generateOptionTradeEvent((Option)this.callOption, (Instrument)otherEquity);
        marketstat = EventTestBase.generateOptionMarketstatEvent((Option)this.callOption, (Instrument)otherEquity);
        Assert.assertFalse((boolean)chain.process((Event)ask));
        Assert.assertFalse((boolean)chain.process((Event)bid));
        Assert.assertFalse((boolean)chain.process((Event)trade));
        Assert.assertFalse((boolean)chain.process((Event)marketstat));
        OptionChainTest.verifyOptionChain(chain, (Instrument)this.equity, null, null, null, null, new ArrayList<DividendEvent>(), new ArrayList<OptionContractPair>());
    }

    @Test
    public void optionChainPairProcessing() throws Exception {
        OptionChain chain = new OptionChain((Instrument)this.equity);
        Collection optionChain = chain.getOptionChain();
        OptionContract expectedCall = new OptionContract((Instrument)this.equity, this.callOption, OptionType.Call, ExpirationType.AMERICAN, true, BigDecimal.TEN, this.callOption.getSymbol());
        OptionContract expectedPut = new OptionContract((Instrument)this.equity, this.putOption, OptionType.Put, ExpirationType.AMERICAN, true, BigDecimal.TEN, null);
        Assert.assertTrue((boolean)optionChain.isEmpty());
        QuoteEventBuilder askBuilder = QuoteEventBuilder.optionAskEvent();
        QuoteEventBuilder bidBuilder = QuoteEventBuilder.optionBidEvent();
        AskEvent ask = (AskEvent)askBuilder.withExchange("Q").withExpirationType(ExpirationType.AMERICAN).withInstrument((Instrument)this.callOption).withMultiplier(BigDecimal.TEN).hasDeliverable(true).withPrice(EventTestBase.generateDecimalValue()).withQuoteDate(new Date()).withSize(EventTestBase.generateDecimalValue()).withProviderSymbol(this.callOption.getSymbol()).withUnderlyingInstrument((Instrument)this.equity).create();
        BidEvent bid = (BidEvent)bidBuilder.withExchange("X").withExpirationType(ExpirationType.AMERICAN).withInstrument((Instrument)this.callOption).withMultiplier(BigDecimal.TEN).hasDeliverable(true).withPrice(EventTestBase.generateDecimalValue()).withQuoteDate(new Date()).withSize(EventTestBase.generateDecimalValue()).withProviderSymbol(this.callOption.getSymbol()).withUnderlyingInstrument((Instrument)this.equity).create();
        TradeEvent trade = EventTestBase.generateOptionTradeEvent((Option)this.callOption, (Instrument)this.equity);
        MarketstatEvent marketstat = EventTestBase.generateOptionMarketstatEvent((Option)this.callOption, (Instrument)this.equity);
        Assert.assertTrue((boolean)chain.process((Event)ask));
        OptionContractPair pair = (OptionContractPair)optionChain.iterator().next();
        expectedCall.process((OptionEvent)ask);
        OptionChainTest.verifyOptionContractPair(pair, null, expectedCall);
        Assert.assertTrue((boolean)chain.process((Event)bid));
        expectedCall.process((OptionEvent)bid);
        OptionChainTest.verifyOptionContractPair(pair, null, expectedCall);
        Assert.assertTrue((boolean)chain.process((Event)trade));
        expectedCall.process((OptionEvent)trade);
        OptionChainTest.verifyOptionContractPair(pair, null, expectedCall);
        Assert.assertTrue((boolean)chain.process((Event)marketstat));
        expectedCall.process((OptionEvent)marketstat);
        OptionChainTest.verifyOptionContractPair(pair, null, expectedCall);
        Assert.assertEquals((long)1L, (long)optionChain.size());
        ask = (AskEvent)askBuilder.withExchange("Q").withExpirationType(ExpirationType.AMERICAN).withInstrument((Instrument)this.putOption).withMultiplier(BigDecimal.TEN).hasDeliverable(true).withPrice(EventTestBase.generateDecimalValue()).withQuoteDate(new Date()).withSize(EventTestBase.generateDecimalValue()).withProviderSymbol(this.putOption.getSymbol()).withUnderlyingInstrument((Instrument)this.equity).create();
        bid = (BidEvent)bidBuilder.withExchange("X").withExpirationType(ExpirationType.AMERICAN).withInstrument((Instrument)this.putOption).withMultiplier(BigDecimal.TEN).hasDeliverable(true).withPrice(EventTestBase.generateDecimalValue()).withQuoteDate(new Date()).withSize(EventTestBase.generateDecimalValue()).withProviderSymbol(this.putOption.getSymbol()).withUnderlyingInstrument((Instrument)this.equity).create();
        trade = EventTestBase.generateOptionTradeEvent((Option)this.putOption, (Instrument)this.equity);
        marketstat = EventTestBase.generateOptionMarketstatEvent((Option)this.putOption, (Instrument)this.equity);
        Assert.assertTrue((boolean)chain.process((Event)ask));
        expectedPut.process((OptionEvent)ask);
        OptionChainTest.verifyOptionContractPair(pair, expectedPut, expectedCall);
        Assert.assertTrue((boolean)chain.process((Event)bid));
        expectedPut.process((OptionEvent)bid);
        OptionChainTest.verifyOptionContractPair(pair, expectedPut, expectedCall);
        Assert.assertTrue((boolean)chain.process((Event)trade));
        expectedPut.process((OptionEvent)trade);
        OptionChainTest.verifyOptionContractPair(pair, expectedPut, expectedCall);
        Assert.assertTrue((boolean)chain.process((Event)marketstat));
        expectedPut.process((OptionEvent)marketstat);
        OptionChainTest.verifyOptionContractPair(pair, expectedPut, expectedCall);
        Assert.assertEquals((long)1L, (long)optionChain.size());
    }

    @Test
    public void optionContractOrder() throws Exception {
        OptionChain chain = new OptionChain((Instrument)this.equity);
        Collection optionChain = chain.getOptionChain();
        Assert.assertTrue((boolean)optionChain.isEmpty());
        Option o1 = new Option("ABC", "20100101", BigDecimal.ONE, OptionType.Put);
        Option o2 = new Option(o1.getSymbol(), o1.getExpiry(), o1.getStrikePrice().add(BigDecimal.ONE), OptionType.Put);
        Option o3 = new Option(o1.getSymbol(), "20110101", o1.getStrikePrice(), OptionType.Put);
        Option o4 = new Option("ABCD", o1.getExpiry(), o1.getStrikePrice(), OptionType.Put);
        Assert.assertTrue((o1.getStrikePrice().compareTo(o2.getStrikePrice()) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((o1.getExpiry().compareTo(o3.getExpiry()) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((o1.getSymbol().compareTo(o4.getSymbol()) == -1 ? 1 : 0) != 0);
        QuoteEventBuilder builder = QuoteEventBuilder.optionAskEvent();
        builder.withExchange("Q").withExpirationType(ExpirationType.AMERICAN).withPrice(EventTestBase.generateDecimalValue()).withSize(EventTestBase.generateDecimalValue()).withUnderlyingInstrument((Instrument)this.equity).withQuoteDate(new Date());
        Assert.assertTrue((boolean)chain.process(builder.withInstrument((Instrument)o2).create()));
        Assert.assertEquals((long)1L, (long)optionChain.size());
        Assert.assertEquals((Object)o2, (Object)((OptionContractPair)optionChain.iterator().next()).getPut().getInstrument());
        Assert.assertTrue((boolean)chain.process(builder.withInstrument((Instrument)o3).create()));
        Assert.assertEquals((long)2L, (long)optionChain.size());
        Iterator iterator = optionChain.iterator();
        Assert.assertEquals((Object)o2, (Object)((OptionContractPair)iterator.next()).getPut().getInstrument());
        Assert.assertEquals((Object)o3, (Object)((OptionContractPair)iterator.next()).getPut().getInstrument());
        Assert.assertTrue((boolean)chain.process(builder.withInstrument((Instrument)o1).create()));
        Assert.assertEquals((long)3L, (long)optionChain.size());
        iterator = optionChain.iterator();
        Assert.assertEquals((Object)o1, (Object)((OptionContractPair)iterator.next()).getPut().getInstrument());
        Assert.assertEquals((Object)o2, (Object)((OptionContractPair)iterator.next()).getPut().getInstrument());
        Assert.assertEquals((Object)o3, (Object)((OptionContractPair)iterator.next()).getPut().getInstrument());
        Assert.assertTrue((boolean)chain.process(builder.withInstrument((Instrument)o4).create()));
        Assert.assertEquals((long)4L, (long)optionChain.size());
        iterator = optionChain.iterator();
        Assert.assertEquals((Object)o1, (Object)((OptionContractPair)iterator.next()).getPut().getInstrument());
        Assert.assertEquals((Object)o2, (Object)((OptionContractPair)iterator.next()).getPut().getInstrument());
        Assert.assertEquals((Object)o3, (Object)((OptionContractPair)iterator.next()).getPut().getInstrument());
        Assert.assertEquals((Object)o4, (Object)((OptionContractPair)iterator.next()).getPut().getInstrument());
    }

    @Test
    public void optionContractPairEqualsHashCode() throws Exception {
        QuoteEventBuilder builder = QuoteEventBuilder.optionAskEvent();
        builder.withExchange("Q").withExpirationType(ExpirationType.AMERICAN).withPrice(EventTestBase.generateDecimalValue()).withQuoteDate(new Date()).withSize(EventTestBase.generateDecimalValue()).withUnderlyingInstrument((Instrument)this.equity);
        OptionContractPair pair = new OptionContractPair((OptionEvent)builder.withInstrument((Instrument)this.putOption).create());
        OptionContractPair equalPair = new OptionContractPair((OptionEvent)builder.create());
        OptionContractPair unequalPair = new OptionContractPair((OptionEvent)builder.withInstrument((Instrument)new Option(this.putOption.getSymbol(), this.putOption.getExpiry(), this.putOption.getStrikePrice().add(BigDecimal.ONE), OptionType.Put)).create());
        EqualityAssert.assertEquality((Object)pair, (Object)equalPair, (Object[])new Object[]{unequalPair, this, null});
    }

    @Test
    public void contractPairHashCodeAndEquals() throws Exception {
        Option otherOptionStrike = new Option(this.callOption.getSymbol(), this.callOption.getExpiry(), this.callOption.getStrikePrice().add(BigDecimal.ONE), OptionType.Call);
        Option otherOptionExpiry = new Option(this.callOption.getSymbol(), "20110319", this.callOption.getStrikePrice(), OptionType.Call);
        Option otherOptionSymbol = new Option("COLIN", this.callOption.getExpiry(), this.callOption.getStrikePrice(), OptionType.Call);
        Assert.assertFalse((boolean)this.callOption.getSymbol().equals(otherOptionSymbol.getSymbol()));
        Assert.assertFalse((boolean)this.callOption.getExpiry().equals(otherOptionExpiry.getExpiry()));
        Assert.assertFalse((boolean)this.callOption.getStrikePrice().equals(otherOptionStrike.getStrikePrice()));
        OptionContractPair.OptionContractPairKey key1 = OptionContractPair.getOptionContractPairKey((Option)this.callOption);
        OptionContractPair.OptionContractPairKey key2 = OptionContractPair.getOptionContractPairKey((Option)this.callOption);
        OptionContractPair.OptionContractPairKey key3 = OptionContractPair.getOptionContractPairKey((Option)otherOptionStrike);
        OptionContractPair.OptionContractPairKey key4 = OptionContractPair.getOptionContractPairKey((Option)otherOptionExpiry);
        OptionContractPair.OptionContractPairKey key5 = OptionContractPair.getOptionContractPairKey((Option)otherOptionSymbol);
        EqualityAssert.assertEquality((Object)key1, (Object)key2, (Object[])new Object[]{key3, key4, key5, this, null});
    }

    private static void verifyOptionContractPair(OptionContractPair inActualContractPair, OptionContract inExpectedPut, OptionContract inExpectedCall) throws Exception {
        Assert.assertNotNull((Object)inActualContractPair);
        if (inExpectedPut == null) {
            Assert.assertNull((Object)inActualContractPair.getPut());
        } else {
            OptionChainTest.verifyOptionContract(inActualContractPair.getPut(), inExpectedPut.getUnderlyingInstrument(), inExpectedPut.getInstrument(), inExpectedPut.getInstrument().getSymbol(), inExpectedPut.getExpirationType(), inExpectedPut.getMultiplier(), inExpectedPut.hasDeliverable(), inExpectedPut.getLatestBid(), inExpectedPut.getLatestAsk(), inExpectedPut.getLatestTrade(), inExpectedPut.getLatestMarketstat());
        }
        if (inExpectedCall == null) {
            Assert.assertNull((Object)inActualContractPair.getCall());
        } else {
            OptionChainTest.verifyOptionContract(inActualContractPair.getCall(), inExpectedCall.getUnderlyingInstrument(), inExpectedCall.getInstrument(), inExpectedCall.getInstrument().getSymbol(), inExpectedCall.getExpirationType(), inExpectedCall.getMultiplier(), inExpectedCall.hasDeliverable(), inExpectedCall.getLatestBid(), inExpectedCall.getLatestAsk(), inExpectedCall.getLatestTrade(), inExpectedCall.getLatestMarketstat());
        }
    }

    private static void verifyOptionContract(OptionContract inActualContract, Instrument inExpectedUnderlyingInstrument, Option inExpectedOption, String inExpectedProviderSymbol, ExpirationType inExpectedExpirationType, BigDecimal inExpectedMultiplier, boolean inExpectedHasDeliverable, BidEvent inExpectedLatestBid, AskEvent inExpectedLatestAsk, TradeEvent inExpectedLatestTrade, MarketstatEvent inExpectedLatestMarketstat) throws Exception {
        Assert.assertEquals((Object)inExpectedUnderlyingInstrument, (Object)inActualContract.getUnderlyingInstrument());
        Assert.assertEquals((Object)inExpectedOption, (Object)inActualContract.getInstrument());
        Assert.assertEquals((Object)inExpectedExpirationType, (Object)inActualContract.getExpirationType());
        Assert.assertEquals((Object)inExpectedMultiplier, (Object)inActualContract.getMultiplier());
        Assert.assertEquals((Object)inExpectedHasDeliverable, (Object)inActualContract.hasDeliverable());
        Assert.assertEquals((Object)inExpectedLatestBid, (Object)inActualContract.getLatestBid());
        Assert.assertEquals((Object)inExpectedLatestAsk, (Object)inActualContract.getLatestAsk());
        Assert.assertEquals((Object)inExpectedLatestTrade, (Object)inActualContract.getLatestTrade());
        Assert.assertEquals((Object)inExpectedLatestMarketstat, (Object)inActualContract.getLatestMarketstat());
        Assert.assertEquals((Object)inExpectedProviderSymbol, (Object)inActualContract.getProviderSymbol());
    }

    private static void verifyOptionChain(OptionChain inActualOptionChain, Instrument inExpectedUnderlyingInstrument, BidEvent inExpectedLatestBid, AskEvent inExpectedLatestAsk, TradeEvent inExpectedLatestTrade, MarketstatEvent inExpectedLatestMarketstat, List<DividendEvent> inExpectedDividends, Collection<OptionContractPair> inExpectedOptionChainContents) throws Exception {
        Assert.assertNotNull((Object)inActualOptionChain);
        Assert.assertNotNull((Object)inActualOptionChain.toString());
        Assert.assertEquals((Object)inExpectedUnderlyingInstrument, (Object)inActualOptionChain.getUnderlyingInstrument());
        Assert.assertEquals((Object)inExpectedLatestBid, (Object)inActualOptionChain.getLatestUnderlyingBid());
        Assert.assertEquals((Object)inExpectedLatestAsk, (Object)inActualOptionChain.getLatestUnderlyingAsk());
        Assert.assertEquals((Object)inExpectedLatestTrade, (Object)inActualOptionChain.getLatestUnderlyingTrade());
        Assert.assertEquals((Object)inExpectedLatestMarketstat, (Object)inActualOptionChain.getLatestUnderlyingMarketstat());
        Assert.assertTrue((boolean)Arrays.equals(inExpectedOptionChainContents.toArray(), inActualOptionChain.getOptionChain().toArray()));
        Assert.assertEquals(inExpectedDividends, (Object)inActualOptionChain.getDividends());
    }
}

