/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy.ruby;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.core.notifications.Notification;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.event.AskEvent;
import org.marketcetera.event.BidEvent;
import org.marketcetera.event.DividendEvent;
import org.marketcetera.event.Event;
import org.marketcetera.event.MarketstatEvent;
import org.marketcetera.event.TradeEvent;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.strategy.AbstractRunningStrategy;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Currency;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.FutureExpirationMonth;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.ReportBase;
import quickfix.Message;

@ClassVersion(value="$Id: Strategy.java 17857 2019-05-31 16:58:37Z colin $")
public class Strategy
extends AbstractRunningStrategy {
    @Override
    public final void onAsk(AskEvent inAsk) {
        this.on_ask(inAsk);
    }

    @Override
    public final void onBid(BidEvent inBid) {
        this.on_bid(inBid);
    }

    @Override
    public void onMarketstat(MarketstatEvent inStatistics) {
        this.on_marketstat(inStatistics);
    }

    @Override
    public void onDividend(DividendEvent inDividend) {
        this.on_dividend(inDividend);
    }

    @Override
    public final void onCallback(Object inData) {
        this.on_callback(inData);
    }

    @Override
    public final void onExecutionReport(ExecutionReport inExecutionReport) {
        this.on_execution_report(inExecutionReport);
    }

    @Override
    public final void onCancelReject(OrderCancelReject inCancel) {
        this.on_cancel_reject(inCancel);
    }

    @Override
    public void onReceiveBrokerStatus(BrokerStatus inStatus) {
        this.on_receive_status(inStatus);
    }

    @Override
    public final void onTrade(TradeEvent inTrade) {
        this.on_trade(inTrade);
    }

    @Override
    public final void onOther(Object inEvent) {
        this.on_other(inEvent);
    }

    @Override
    public final void onStart() {
        this.on_start();
    }

    @Override
    public final void onStop() {
        this.on_stop();
    }

    protected void on_ask(AskEvent inAsk) {
    }

    protected void on_bid(BidEvent inBid) {
    }

    protected void on_marketstat(MarketstatEvent inStatistics) {
    }

    protected void on_dividend(DividendEvent inStatistics) {
    }

    protected void on_execution_report(ExecutionReport inExecutionReport) {
    }

    protected void on_cancel_reject(OrderCancelReject inCancelReject) {
    }

    protected void on_receive_status(BrokerStatus inStatus) {
    }

    protected void on_trade(TradeEvent inTrade) {
    }

    protected void on_other(Object inEvent) {
    }

    protected void on_callback(Object inData) {
    }

    protected void on_start() {
    }

    protected void on_stop() {
    }

    public final void set_property(String inKey, String inValue) {
        Strategy.setProperty(inKey, inValue);
    }

    public final String get_parameter(String inName) {
        return this.getParameter(inName);
    }

    public final String get_property(String inName) {
        return Strategy.getProperty(inName);
    }

    public final void request_callback_after(long inDelay, Object inData) {
        this.requestCallbackAfter(inDelay, inData);
    }

    public final void request_callback_every(long inDelay, long inPeriod, Object inData) {
        this.requestCallbackEvery(inDelay, inPeriod, inData);
    }

    public final void request_callback_at(Date inDate, Object inData) {
        this.requestCallbackAt(inDate, inData);
    }

    public final int request_market_data(MarketDataRequest inRequest) {
        return this.requestMarketData(inRequest);
    }

    public final int request_market_data(String inRequest) {
        return this.requestMarketData(inRequest);
    }

    public final int request_processed_market_data(MarketDataRequest inRequest, String[] inStatements, String inCepSource) {
        return this.requestProcessedMarketData(inRequest, inStatements, inCepSource);
    }

    public final int request_processed_market_data(String inRequest, String[] inStatements, String inCepSource) {
        return this.requestProcessedMarketData(inRequest, inStatements, inCepSource);
    }

    public final void cancel_data_request(int inRequestID) {
        this.cancelDataRequest(inRequestID);
    }

    public final void cancel_all_data_requests() {
        this.cancelAllDataRequests();
    }

    public final int request_cep_data(String[] inStatements, String inSource) {
        return this.requestCEPData(inStatements, inSource);
    }

    public final void suggest_trade(OrderSingle inOrder, BigDecimal inScore, String inIdentifier) {
        this.suggestTrade(inOrder, inScore, inIdentifier);
    }

    public final void send_message(Message inMessage, BrokerID inBroker) {
        this.sendMessage(inMessage, inBroker);
    }

    public final void send_event_to_cep(Event inEvent, String inProvider) {
        this.sendEventToCEP(inEvent, inProvider);
    }

    public final void send_event(Event inEvent) {
        this.sendEvent(inEvent);
    }

    @Override
    public final boolean send(Object inData) {
        return super.send(inData);
    }

    public final OrderCancel cancel_order(OrderID inOrderID, boolean inSendOrder) {
        return this.cancelOrder(inOrderID, inSendOrder);
    }

    public final OrderReplace cancel_replace(OrderID inOrderID, OrderSingle inNewOrder, boolean inSendOrder) {
        return this.cancelReplace(inOrderID, inNewOrder, inSendOrder);
    }

    public final int cancel_all_orders() {
        return this.cancelAllOrders();
    }

    public final OrderStatus get_order_status(OrderID inOrderID) {
        return this.getOrderStatus(inOrderID);
    }

    public final Collection<ExecutionReport> get_open_orders() {
        return this.getOpenOrders();
    }

    public final Set<OrderID> get_submitted_order_ids() {
        return this.getSubmittedOrderIDs();
    }

    public final Set<OrderID> get_open_order_ids() {
        return this.getOpenOrderIDs();
    }

    public final DataFlowID create_data_flow(boolean inAppendDataSink, DataRequest[] inRequests) {
        return this.createDataFlow(inAppendDataSink, inRequests);
    }

    public final void cancel_data_flow(DataFlowID inDataFlowID) {
        this.cancelDataFlow(inDataFlowID);
    }

    public final Deque<ReportBase> get_execution_reports(OrderID inOrderID) {
        return this.getExecutionReports(inOrderID);
    }

    public final void notify_low(String inSubject, String inBody) {
        this.sendNotification(Notification.debug((String)inSubject, (String)inBody, (String)this.toString()));
    }

    public final void notify_medium(String inSubject, String inBody) {
        this.sendNotification(Notification.warn((String)inSubject, (String)inBody, (String)this.toString()));
    }

    public final void notify_high(String inSubject, String inBody) {
        this.sendNotification(Notification.error((String)inSubject, (String)inBody, (String)this.toString()));
    }

    @Override
    public final void debug(String inMessage) {
        super.debug(inMessage);
    }

    @Override
    public final void info(String inMessage) {
        super.info(inMessage);
    }

    @Override
    public final void warn(String inMessage) {
        super.warn(inMessage);
    }

    @Override
    public final void error(String inMessage) {
        super.error(inMessage);
    }

    public final BrokerStatus[] get_brokers() {
        return this.getBrokers();
    }

    public final BigDecimal get_position_as_of(Date inDate, String inSymbol) {
        return this.getPositionAsOf(inDate, inSymbol);
    }

    public final Map<PositionKey<Equity>, BigDecimal> get_all_positions_as_of(Date inDate) {
        return this.getAllPositionsAsOf(inDate);
    }

    public final BigDecimal get_option_position_as_of(Date inDate, String inOptionRoot, String inExpiry, BigDecimal inStrikePrice, OptionType inType) {
        return this.getOptionPositionAsOf(inDate, inOptionRoot, inExpiry, inStrikePrice, inType);
    }

    public final Map<PositionKey<Option>, BigDecimal> get_all_option_positions_as_of(Date inDate) {
        return this.getAllOptionPositionsAsOf(inDate);
    }

    public final Map<PositionKey<Option>, BigDecimal> get_option_positions_as_of(Date inDate, String[] inOptionRoots) {
        return this.getOptionPositionsAsOf(inDate, inOptionRoots);
    }

    public final String get_underlying(String inOptionRoot) {
        return this.getUnderlying(inOptionRoot);
    }

    public final Collection<String> get_option_roots(String inUnderlying) {
        return this.getOptionRoots(inUnderlying);
    }

    public final Map<PositionKey<Future>, BigDecimal> get_all_future_positions_as_of(Date inDate) {
        return this.getAllFuturePositionsAsOf(inDate);
    }

    public final BigDecimal get_future_position_as_of(Date inDate, String inUnderlyingSymbol, FutureExpirationMonth inExpirationMonth, int inExpirationYear) {
        return this.getFuturePositionAsOf(inDate, inUnderlyingSymbol, inExpirationMonth, inExpirationYear);
    }

    public final Map<PositionKey<Currency>, BigDecimal> get_all_currency_positions_as_of(Date inDate) {
        return this.getAllCurrencyPositionsAsOf(inDate);
    }

    public final BigDecimal get_currency_position_as_of(Date inDate, String inUnderlyingSymbol) {
        return this.getCurrencyPositionAsOf(inDate, inUnderlyingSymbol);
    }

    public final ModuleURN get_urn() {
        return this.getURN();
    }

    public final Properties get_user_data() {
        return this.getUserData();
    }

    public final void set_user_data(Properties inData) {
        this.setUserData(inData);
    }
}

