/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import org.junit.Test;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.strategy.ClasspathStrategy;
import org.marketcetera.strategy.Language;
import org.marketcetera.strategy.StrategyModuleFactory;
import org.marketcetera.strategy.StrategyTestBase;
import org.marketcetera.util.log.SLF4JLoggerProxy;

public class JavaClasspathExecutionEngineTest
extends StrategyTestBase {
    @Test
    public void testRunFromClassloader() throws Exception {
        this.doStart(ClasspathStrategy.class.getCanonicalName());
        new ExpectedFailure<ModuleException>(){

            protected void run() throws Exception {
                JavaClasspathExecutionEngineTest.this.doStart("this isn't a valid class");
            }
        };
        new ExpectedFailure<ModuleException>(){

            protected void run() throws Exception {
                JavaClasspathExecutionEngineTest.this.doStart(((Object)((Object)JavaClasspathExecutionEngineTest.this)).getClass().getCanonicalName());
            }
        };
        new ExpectedFailure<ModuleException>(){

            protected void run() throws Exception {
                JavaClasspathExecutionEngineTest.this.doStart(ClasspathStrategy.class.getSimpleName());
            }
        };
    }

    private void doStart(String inStrategyClassname) throws Exception {
        SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Starting strategy: {}", (Object[])new Object[]{inStrategyClassname});
        ModuleURN strategy = this.moduleManager.createModule(StrategyModuleFactory.PROVIDER_URN, new Object[]{"MyStategy", inStrategyClassname, Language.JAVA, null, null, false, null});
        this.moduleManager.start(strategy);
        this.moduleManager.stop(strategy);
        this.moduleManager.deleteModule(strategy);
    }
}

