/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.marketcetera.client.BrokerStatusListener;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.OrderValidationException;
import org.marketcetera.client.Validations;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.client.utils.LiveOrderHistoryManager;
import org.marketcetera.core.notifications.Notification;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.event.Event;
import org.marketcetera.event.LogEvent;
import org.marketcetera.event.impl.LogEventBuilder;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.marketdata.MarketDataRequestBuilder;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.strategy.Messages;
import org.marketcetera.strategy.RunningStrategy;
import org.marketcetera.strategy.Strategy;
import org.marketcetera.strategy.StrategyModule;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Currency;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.FutureExpirationMonth;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderSingleSuggestion;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.Suggestion;
import org.marketcetera.util.collections.UnmodifiableDeque;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.misc.NamedThreadFactory;
import quickfix.Message;

@ClassVersion(value="$Id$")
public abstract class AbstractRunningStrategy
implements RunningStrategy {
    private static final Properties properties = new Properties();
    private final ScheduledExecutorService callbackService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("StrategyCallback"));
    private final Set<OrderSingle> submittedOrders = new LinkedHashSet<OrderSingle>();
    private final Set<OrderID> submittedOrderIDs = new LinkedHashSet<OrderID>();
    private static volatile LiveOrderHistoryManager orderHistoryManager;
    private Strategy strategy;
    private static final Deque<ReportBase> EMPTY_REPORTS;

    public final String toString() {
        if (this.strategy == null) {
            return super.toString();
        }
        return this.strategy.toString();
    }

    static final Properties getProperties() {
        return properties;
    }

    final void setStrategy(Strategy inStrategy) {
        this.strategy = inStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void start() throws ClientInitException {
        Class<AbstractRunningStrategy> clazz = AbstractRunningStrategy.class;
        synchronized (AbstractRunningStrategy.class) {
            if (orderHistoryManager == null) {
                this.initializeReportHistoryManager();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ClientManager.getInstance().addBrokerStatusListener((BrokerStatusListener)this);
            return;
        }
    }

    final void stop() {
        this.callbackService.shutdown();
        this.callbackService.shutdownNow();
        try {
            ClientManager.getInstance().removeBrokerStatusListener((BrokerStatusListener)this);
        }
        catch (ClientInitException e) {
            throw new RuntimeException(e);
        }
    }

    final void onExecutionReportRedirected(ExecutionReport inExecutionReport) {
        orderHistoryManager.add((ReportBase)inExecutionReport);
        this.onExecutionReport(inExecutionReport);
    }

    final void onCancelRejectRedirected(OrderCancelReject inCancelReject) {
        orderHistoryManager.add((ReportBase)inCancelReject);
        this.onCancelReject(inCancelReject);
    }

    public void receiveBrokerStatus(BrokerStatus inStatus) {
        try {
            this.onReceiveBrokerStatus(inStatus);
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.BROKER_STATUS_PROCESS_FAILED, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(inStatus))).create(), this.strategy);
        }
    }

    final Set<OrderSingle> getSubmittedOrders() {
        return Collections.unmodifiableSet(this.submittedOrders);
    }

    protected final Set<OrderID> getSubmittedOrderIDs() {
        return Collections.unmodifiableSet(this.submittedOrderIDs);
    }

    protected final Set<OrderID> getOpenOrderIDs() {
        return orderHistoryManager.getOpenOrders().keySet();
    }

    protected final Collection<ExecutionReport> getOpenOrders() {
        return orderHistoryManager.getOpenOrders().values();
    }

    protected final OrderStatus getOrderStatus(OrderID inOrderID) {
        ReportBase latestReport = orderHistoryManager.getLatestReportFor(inOrderID);
        if (latestReport == null) {
            return null;
        }
        return latestReport.getOrderStatus();
    }

    protected static void setProperty(String inKey, String inValue) {
        if (inKey == null) {
            Messages.NULL_PROPERTY_KEY.warn(AbstractRunningStrategy.class);
            return;
        }
        if (inValue == null) {
            properties.remove(inKey);
            return;
        }
        properties.setProperty(inKey, inValue);
    }

    protected static String getProperty(String inKey) {
        if (inKey == null) {
            Messages.NULL_PROPERTY_KEY.warn(AbstractRunningStrategy.class);
            return null;
        }
        return properties.getProperty(inKey);
    }

    protected Date getReportHistoryOriginDate() {
        Calendar dateGenerator = Calendar.getInstance();
        dateGenerator.set(11, 0);
        dateGenerator.set(12, 0);
        dateGenerator.set(13, 0);
        dateGenerator.set(14, 0);
        Date originDate = dateGenerator.getTime();
        return originDate;
    }

    protected final String getParameter(String inName) {
        Properties parameters = this.strategy.getParameters();
        if (parameters == null) {
            Messages.NO_PARAMETERS.warn(AbstractRunningStrategy.class, (Object)this.strategy);
            return null;
        }
        return parameters.getProperty(inName);
    }

    protected final int requestMarketData(MarketDataRequest inRequest) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return 0;
        }
        if (inRequest == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_MARKET_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inRequest).create(), this.strategy);
            return 0;
        }
        try {
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.SUBMITTING_MARKET_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(inRequest))).create(), this.strategy);
            return this.strategy.getServicesProvider().requestMarketData(inRequest);
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_MARKET_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inRequest).withException((Throwable)e).create(), this.strategy);
            return 0;
        }
    }

    protected final int requestMarketData(String inRequest) {
        try {
            MarketDataRequest request = MarketDataRequestBuilder.newRequestFromString((String)inRequest);
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.SUBMITTING_MARKET_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)request).create(), this.strategy);
            return this.strategy.getServicesProvider().requestMarketData(request);
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_MARKET_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)inRequest)).withException((Throwable)e).create(), this.strategy);
            return 0;
        }
    }

    protected final int requestProcessedMarketData(MarketDataRequest inRequest, String[] inStatements, String inCepSource) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return 0;
        }
        if (inRequest == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_MARKET_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inRequest).create(), this.strategy);
            return 0;
        }
        if (inStatements == null || inStatements.length == 0 || inCepSource == null || inCepSource.isEmpty()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_CEP_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)Arrays.toString(inStatements)), (Serializable)((Object)inCepSource), (Serializable)((Object)this.strategy.getDefaultNamespace())).create(), this.strategy);
            return 0;
        }
        String namespace = this.strategy.getDefaultNamespace();
        try {
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.SUBMITTING_PROCESSED_MARKET_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(inRequest)), (Serializable)((Object)Arrays.toString(inStatements)), (Serializable)((Object)inCepSource), (Serializable)((Object)namespace)).create(), this.strategy);
            return this.strategy.getServicesProvider().requestProcessedMarketData(inRequest, inStatements, inCepSource, namespace);
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.COMBINED_DATA_REQUEST_FAILED, (Serializable)((Object)String.valueOf(inRequest)), (Serializable)((Object)Arrays.toString(inStatements)), (Serializable)((Object)inCepSource), (Serializable)((Object)namespace)).withException((Throwable)e).create(), this.strategy);
            return 0;
        }
    }

    protected final int requestProcessedMarketData(String inRequest, String[] inStatements, String inCepSource) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return 0;
        }
        if (inRequest == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_MARKET_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)inRequest)).create(), this.strategy);
            return 0;
        }
        if (inStatements == null || inStatements.length == 0 || inCepSource == null || inCepSource.isEmpty()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_CEP_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)Arrays.toString(inStatements)), (Serializable)((Object)inCepSource), (Serializable)((Object)this.strategy.getDefaultNamespace())).create(), this.strategy);
            return 0;
        }
        String namespace = this.strategy.getDefaultNamespace();
        try {
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.SUBMITTING_PROCESSED_MARKET_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(inRequest)), (Serializable)((Object)Arrays.toString(inStatements)), (Serializable)((Object)inCepSource), (Serializable)((Object)namespace)).create(), this.strategy);
            return this.strategy.getServicesProvider().requestProcessedMarketData(MarketDataRequestBuilder.newRequestFromString((String)inRequest), inStatements, inCepSource, namespace);
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.COMBINED_DATA_REQUEST_FAILED, (Serializable)((Object)String.valueOf(inRequest)), (Serializable)((Object)Arrays.toString(inStatements)), (Serializable)((Object)inCepSource), (Serializable)((Object)namespace)).withException((Throwable)e).create(), this.strategy);
            return 0;
        }
    }

    protected final void cancelDataRequest(int inRequestID) {
        StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.CANCELING_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(inRequestID))).create(), this.strategy);
        this.strategy.getServicesProvider().cancelDataRequest(inRequestID);
    }

    protected final void cancelAllDataRequests() {
        StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.CANCELING_ALL_DATA_REQUESTS, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
        this.strategy.getServicesProvider().cancelAllDataRequests();
    }

    protected final int requestCEPData(String[] inStatements, String inSource) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return 0;
        }
        if (inStatements == null || inStatements.length == 0 || inSource == null || inSource.isEmpty()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_CEP_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)Arrays.toString(inStatements)), (Serializable)((Object)inSource), (Serializable)((Object)this.strategy.getDefaultNamespace())).create(), this.strategy);
            return 0;
        }
        try {
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.SUBMITTING_CEP_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)Arrays.toString(inStatements)), (Serializable)((Object)inSource), (Serializable)((Object)this.strategy.getDefaultNamespace())).create(), this.strategy);
            return this.strategy.getServicesProvider().requestCEPData(inStatements, inSource, this.strategy.getDefaultNamespace());
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CEP_REQUEST_FAILED, (Serializable)((Object)Arrays.toString(inStatements)), (Serializable)((Object)inSource)).withException((Throwable)e).create(), this.strategy);
            return 0;
        }
    }

    protected final Deque<ReportBase> getExecutionReports(OrderID inOrderID) {
        if (inOrderID == null) {
            return EMPTY_REPORTS;
        }
        return orderHistoryManager.getReportHistoryFor(inOrderID);
    }

    protected final void suggestTrade(OrderSingle inOrder, BigDecimal inScore, String inIdentifier) {
        if (inOrder == null || inScore == null || inIdentifier == null || inIdentifier.isEmpty()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_TRADE_SUGGESTION, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        assert (this.strategy != null);
        OrderSingleSuggestion suggestion = Factory.getInstance().createOrderSingleSuggestion();
        suggestion.setOrder(inOrder);
        suggestion.setScore(inScore);
        suggestion.setIdentifier(inIdentifier);
        StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.SUBMITTING_TRADE_SUGGESTION, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)suggestion).create(), this.strategy);
        this.strategy.getServicesProvider().sendSuggestion((Suggestion)suggestion);
    }

    protected boolean send(Object inData) {
        if (inData == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_DATA, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return false;
        }
        if (inData instanceof OrderSingle) {
            OrderSingle order = (OrderSingle)inData;
            if (order.getOrderID() == null) {
                StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_ORDER, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
                return false;
            }
            try {
                Validations.validate((OrderSingle)order);
            }
            catch (OrderValidationException e) {
                StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.ORDER_VALIDATION_FAILED, (Serializable)((Object)String.valueOf(this.strategy))).withException((Throwable)e).create(), this.strategy);
                return false;
            }
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.SUBMITTING_ORDER, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)order, (Serializable)order.getOrderID()).create(), this.strategy);
            SLF4JLoggerProxy.debug(AbstractRunningStrategy.class, (String)"{} created {}", (Object[])new Object[]{this.strategy, order});
            this.submittedOrders.add(order);
        }
        this.strategy.getServicesProvider().send(inData);
        return true;
    }

    protected final OrderCancel cancelOrder(OrderID inOrderID, boolean inSendOrder) {
        if (inOrderID == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_CANCEL, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return null;
        }
        ExecutionReport report = (ExecutionReport)orderHistoryManager.getOpenOrders().get(inOrderID);
        if (report == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_ORDERID, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(inOrderID))).create(), this.strategy);
            return null;
        }
        OrderCancel cancelRequest = Factory.getInstance().createOrderCancel(report);
        cancelRequest.setBrokerOrderID(null);
        SLF4JLoggerProxy.debug(AbstractRunningStrategy.class, (String)"{} created {}", (Object[])new Object[]{this.strategy, cancelRequest});
        if (inSendOrder) {
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.SUBMITTING_CANCEL_ORDER_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(cancelRequest))).create(), this.strategy);
            this.strategy.getServicesProvider().cancelOrder(cancelRequest);
        }
        return cancelRequest;
    }

    protected final int cancelAllOrders() {
        StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.SUBMITTING_CANCEL_ALL_ORDERS_REQUEST, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
        HashSet openOrdersCopy = new HashSet(orderHistoryManager.getOpenOrders().keySet());
        SLF4JLoggerProxy.debug(AbstractRunningStrategy.class, (String)"Found {} open orders to cancel", (Object[])new Object[]{openOrdersCopy});
        int count = 0;
        for (OrderID orderId : openOrdersCopy) {
            try {
                if (this.cancelOrder(orderId, true) == null) continue;
                ++count;
            }
            catch (Exception e) {
                StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.ORDER_CANCEL_FAILED, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)orderId).withException((Throwable)e).create(), this.strategy);
            }
        }
        StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.CANCEL_REQUEST_SUBMITTED, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)Integer.valueOf(count)).create(), this.strategy);
        return count;
    }

    protected final OrderReplace cancelReplace(OrderID inOrderID, OrderSingle inNewOrder, boolean inSendOrder) {
        if (inOrderID == null || inNewOrder == null || inNewOrder.getOrderID() == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_REPLACEMENT_ORDER, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return null;
        }
        ExecutionReport executionReport = (ExecutionReport)orderHistoryManager.getOpenOrders().get(inOrderID);
        if (executionReport == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_ORDERID, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(inOrderID))).create(), this.strategy);
            return null;
        }
        OrderReplace replaceOrder = Factory.getInstance().createOrderReplace(executionReport);
        replaceOrder.setBrokerOrderID(null);
        replaceOrder.setQuantity(inNewOrder.getQuantity());
        replaceOrder.setDisplayQuantity(inNewOrder.getDisplayQuantity());
        if (OrderType.Market.equals((Object)executionReport.getOrderType())) {
            replaceOrder.setPrice(null);
        } else {
            replaceOrder.setPrice(inNewOrder.getPrice());
        }
        replaceOrder.setTimeInForce(inNewOrder.getTimeInForce());
        SLF4JLoggerProxy.debug(AbstractRunningStrategy.class, (String)"{} created {}", (Object[])new Object[]{this.strategy, replaceOrder});
        if (inSendOrder) {
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.SUBMITTING_CANCEL_REPLACE_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(replaceOrder))).create(), this.strategy);
            this.strategy.getServicesProvider().cancelReplace(replaceOrder);
        }
        return replaceOrder;
    }

    protected final void sendMessage(Message inMessage, BrokerID inBroker) {
        if (inMessage == null || inBroker == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_MESSAGE, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.SUBMITTING_FIX_MESSAGE, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inMessage, (Serializable)inBroker).create(), this.strategy);
        this.strategy.getServicesProvider().sendMessage(inMessage, inBroker);
    }

    protected final void sendEventToCEP(Event inEvent, String inProvider) {
        if (inEvent == null || inProvider == null || inProvider.isEmpty()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_EVENT_TO_CEP, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inEvent, (Serializable)((Object)inProvider)).create(), this.strategy);
            return;
        }
        String namespace = this.strategy.getDefaultNamespace();
        StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.SUBMITTING_EVENT_TO_CEP, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inEvent, (Serializable)((Object)inProvider), (Serializable)((Object)namespace)).create(), this.strategy);
        this.strategy.getServicesProvider().sendEvent(inEvent, inProvider, namespace);
    }

    protected final void sendEvent(Event inEvent) {
        if (inEvent == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_EVENT, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        this.strategy.getServicesProvider().sendEvent(inEvent, null, null);
    }

    protected final void sendNotification(Notification inNotification) {
        if (inNotification == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_NOTIFICATION, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        this.strategy.getServicesProvider().sendNotification(inNotification);
    }

    protected final void requestCallbackAfter(long inDelay, Object inData) {
        this.callbackService.schedule(new Callback(this, this.strategy, inData), inDelay, TimeUnit.MILLISECONDS);
    }

    protected final void requestCallbackEvery(long inDelay, long inPeriod, Object inData) {
        this.callbackService.scheduleAtFixedRate(new Callback(this, this.strategy, inData), inDelay, inPeriod, TimeUnit.MILLISECONDS);
    }

    protected final void requestCallbackAt(Date inDate, Object inData) {
        this.requestCallbackAfter(inDate.getTime() - System.currentTimeMillis(), inData);
    }

    protected final BrokerStatus[] getBrokers() {
        try {
            if (!this.canReceiveData()) {
                StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
                return new BrokerStatus[0];
            }
            List<BrokerStatus> brokers = this.strategy.getServicesProvider().getBrokers();
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.RECEIVED_BROKERS, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(brokers))).create(), this.strategy);
            return brokers.toArray(new BrokerStatus[brokers.size()]);
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_RETRIEVE_BROKERS, (Serializable)((Object)String.valueOf(this.strategy))).withException((Throwable)e).create(), this.strategy);
            return new BrokerStatus[0];
        }
    }

    protected final BigDecimal getPositionAsOf(Date inDate, String inSymbol) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return null;
        }
        if (inDate == null || inSymbol == null || inSymbol.isEmpty()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_EQUITY_POSITION_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inDate, (Serializable)((Object)inSymbol)).create(), this.strategy);
            return null;
        }
        try {
            BigDecimal result = this.strategy.getServicesProvider().getPositionAsOf(inDate, new Equity(inSymbol));
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.RECEIVED_POSITION, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)result, (Serializable)inDate, (Serializable)((Object)inSymbol)).create(), this.strategy);
            return result;
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_RETRIEVE_EQUITY_POSITION, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)inSymbol), (Serializable)inDate).withException((Throwable)e).create(), this.strategy);
            return null;
        }
    }

    protected final Map<PositionKey<Equity>, BigDecimal> getAllPositionsAsOf(Date inDate) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return null;
        }
        if (inDate == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_POSITIONS_REQUEST, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return null;
        }
        try {
            Map<PositionKey<Equity>, BigDecimal> result = this.strategy.getServicesProvider().getAllPositionsAsOf(inDate);
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.RECEIVED_POSITIONS, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(result)), (Serializable)inDate).create(), this.strategy);
            return result;
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_RETRIEVE_POSITIONS, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inDate).withException((Throwable)e).create(), this.strategy);
            return null;
        }
    }

    protected final BigDecimal getFuturePositionAsOf(Date inDate, String inUnderlyingSymbol, FutureExpirationMonth inExpirationMonth, int inExpirationYear) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return null;
        }
        if (inDate == null || inUnderlyingSymbol == null || inUnderlyingSymbol.isEmpty()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_FUTURE_POSITION_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inDate, (Serializable)((Object)inUnderlyingSymbol)).create(), this.strategy);
            return null;
        }
        try {
            BigDecimal result = this.strategy.getServicesProvider().getFuturePositionAsOf(inDate, new Future(inUnderlyingSymbol, inExpirationMonth, inExpirationYear));
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.RECEIVED_POSITION, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)result, (Serializable)inDate, (Serializable)((Object)inUnderlyingSymbol)).create(), this.strategy);
            return result;
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_RETRIEVE_FUTURE_POSITION, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)inUnderlyingSymbol), (Serializable)inDate).withException((Throwable)e).create(), this.strategy);
            return null;
        }
    }

    protected final BigDecimal getCurrencyPositionAsOf(Date inDate, String inSymbol) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return null;
        }
        if (inDate == null || inSymbol == null || inSymbol.isEmpty()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_CURRENCY_POSITION_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inDate, (Serializable)((Object)inSymbol)).create(), this.strategy);
            return null;
        }
        try {
            BigDecimal result = this.strategy.getServicesProvider().getCurrencyPositionAsOf(inDate, new Currency(inSymbol));
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.RECEIVED_POSITION, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)result, (Serializable)inDate, (Serializable)((Object)inSymbol)).create(), this.strategy);
            return result;
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_RETRIEVE_CURRENCY_POSITION, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)inSymbol), (Serializable)inDate).withException((Throwable)e).create(), this.strategy);
            return null;
        }
    }

    protected final Map<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(Date inDate) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return null;
        }
        if (inDate == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_POSITIONS_REQUEST, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return null;
        }
        try {
            Map<PositionKey<Future>, BigDecimal> result = this.strategy.getServicesProvider().getAllFuturePositionsAsOf(inDate);
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.RECEIVED_POSITIONS, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(result)), (Serializable)inDate).create(), this.strategy);
            return result;
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_RETRIEVE_POSITIONS, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inDate).withException((Throwable)e).create(), this.strategy);
            return null;
        }
    }

    protected final Map<PositionKey<Currency>, BigDecimal> getAllCurrencyPositionsAsOf(Date inDate) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return null;
        }
        if (inDate == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_POSITIONS_REQUEST, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return null;
        }
        try {
            Map<PositionKey<Currency>, BigDecimal> result = this.strategy.getServicesProvider().getAllCurrencyPositionsAsOf(inDate);
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.RECEIVED_POSITIONS, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(result)), (Serializable)inDate).create(), this.strategy);
            return result;
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_RETRIEVE_POSITIONS, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inDate).withException((Throwable)e).create(), this.strategy);
            return null;
        }
    }

    protected final BigDecimal getOptionPositionAsOf(Date inDate, String inOptionRoot, String inExpiry, BigDecimal inStrikePrice, OptionType inType) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return null;
        }
        if (inDate == null || inOptionRoot == null || inOptionRoot.isEmpty() || inExpiry == null || inExpiry.isEmpty() || inStrikePrice == null || inType == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_OPTION_POSITION_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inDate, (Serializable)((Object)inOptionRoot), (Serializable)((Object)inExpiry), (Serializable)inStrikePrice, (Serializable)inType).create(), this.strategy);
            return null;
        }
        try {
            Option option = new Option(inOptionRoot, inExpiry, inStrikePrice, inType);
            BigDecimal result = this.strategy.getServicesProvider().getOptionPositionAsOf(inDate, option);
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.RECEIVED_POSITION, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)result, (Serializable)inDate, (Serializable)option).create(), this.strategy);
            return result;
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_RETRIEVE_OPTION_POSITION, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)inOptionRoot), (Serializable)((Object)inExpiry), (Serializable)inStrikePrice, (Serializable)inType, (Serializable)inDate).withException((Throwable)e).create(), this.strategy);
            return null;
        }
    }

    protected final Map<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(Date inDate) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return null;
        }
        if (inDate == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_POSITIONS_REQUEST, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return null;
        }
        try {
            Map<PositionKey<Option>, BigDecimal> result = this.strategy.getServicesProvider().getAllOptionPositionsAsOf(inDate);
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.RECEIVED_POSITIONS, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(result)), (Serializable)inDate).create(), this.strategy);
            return result;
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_RETRIEVE_POSITIONS, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inDate).withException((Throwable)e).create(), this.strategy);
            return null;
        }
    }

    protected final Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(Date inDate, String ... inOptionRoots) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return null;
        }
        if (inDate == null || inOptionRoots == null || inOptionRoots.length == 0) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_POSITIONS_BY_OPTION_ROOTS_REQUEST, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return null;
        }
        for (String optionRoot : inOptionRoots) {
            if (optionRoot != null && !optionRoot.isEmpty()) continue;
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_POSITIONS_BY_OPTION_ROOTS_REQUEST, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return null;
        }
        try {
            Map<PositionKey<Option>, BigDecimal> result = this.strategy.getServicesProvider().getOptionPositionsAsOf(inDate, inOptionRoots);
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.RECEIVED_POSITIONS, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(result)), (Serializable)inDate).create(), this.strategy);
            return result;
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_RETRIEVE_POSITIONS_BY_OPTION_ROOTS, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)Arrays.toString(inOptionRoots)), (Serializable)inDate).withException((Throwable)e).create(), this.strategy);
            return null;
        }
    }

    protected final String getUnderlying(String inOptionRoot) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return null;
        }
        if (inOptionRoot == null || inOptionRoot.isEmpty()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_UNDERLYING_REQUEST, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)inOptionRoot)).create(), this.strategy);
            return null;
        }
        try {
            String result = this.strategy.getServicesProvider().getUnderlying(inOptionRoot);
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.RECEIVED_UNDERLYING, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)result), (Serializable)((Object)inOptionRoot)).create(), this.strategy);
            return result;
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_RETRIEVE_UNDERLYING, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)inOptionRoot)).withException((Throwable)e).create(), this.strategy);
            return null;
        }
    }

    protected final Collection<String> getOptionRoots(String inUnderlying) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return null;
        }
        if (inUnderlying == null || inUnderlying.isEmpty()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_OPTION_ROOTS_REQUEST, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return null;
        }
        try {
            Collection<String> result = this.strategy.getServicesProvider().getOptionRoots(inUnderlying);
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.RECEIVED_OPTION_ROOTS, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)String.valueOf(result)), (Serializable)((Object)inUnderlying)).create(), this.strategy);
            return result;
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_RETRIEVE_OPTION_ROOTS, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)inUnderlying)).withException((Throwable)e).create(), this.strategy);
            return null;
        }
    }

    protected final DataFlowID createDataFlow(boolean inAppendDataSink, DataRequest ... inRequests) {
        if (!this.canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CANNOT_REQUEST_DATA, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getStatus())).create(), this.strategy);
            return null;
        }
        if (inRequests == null || inRequests.length == 0) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_DATA_REQUEST, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return null;
        }
        try {
            return this.strategy.getServicesProvider().createDataFlow(inRequests, inAppendDataSink);
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.DATA_REQUEST_FAILED, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)Arrays.toString(inRequests))).withException((Throwable)e).create(), this.strategy);
            return null;
        }
    }

    protected final void cancelDataFlow(DataFlowID inDataFlowID) {
        if (inDataFlowID == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_DATA_REQUEST_CANCEL, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        try {
            this.strategy.getServicesProvider().cancelDataFlow(inDataFlowID);
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.DATA_REQUEST_CANCEL_FAILED, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)inDataFlowID).withException((Throwable)e).create(), this.strategy);
        }
    }

    protected final ModuleURN getURN() {
        return this.strategy.getServicesProvider().getURN();
    }

    protected final Properties getUserData() {
        try {
            return this.strategy.getServicesProvider().getUserData();
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.FAILED_TO_RETRIEVE_USER_DATA, (Serializable)((Object)String.valueOf(this.strategy))).withException((Throwable)e).create(), this.strategy);
            return null;
        }
    }

    protected final void setUserData(Properties inUserData) {
        try {
            this.strategy.getServicesProvider().setUserData(inUserData);
        }
        catch (Exception e) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.FAILED_TO_SET_USER_DATA, (Serializable)((Object)String.valueOf(this.strategy))).withException((Throwable)e).create(), this.strategy);
        }
    }

    protected void debug(String inMessage) {
        if (inMessage == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_LOG, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        this.strategy.getServicesProvider().log((LogEvent)LogEventBuilder.debug().withMessage(Messages.MESSAGE_1P, (Serializable)((Object)inMessage)).create());
    }

    protected void info(String inMessage) {
        if (inMessage == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_LOG, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        this.strategy.getServicesProvider().log((LogEvent)LogEventBuilder.info().withMessage(Messages.MESSAGE_1P, (Serializable)((Object)inMessage)).create());
    }

    protected void warn(String inMessage) {
        if (inMessage == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_LOG, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        this.strategy.getServicesProvider().log((LogEvent)LogEventBuilder.warn().withMessage(Messages.MESSAGE_1P, (Serializable)((Object)inMessage)).create());
    }

    protected void error(String inMessage) {
        if (inMessage == null) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.INVALID_LOG, (Serializable)((Object)String.valueOf(this.strategy))).create(), this.strategy);
            return;
        }
        this.strategy.getServicesProvider().log((LogEvent)LogEventBuilder.error().withMessage(Messages.MESSAGE_1P, (Serializable)((Object)inMessage)).create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initializeReportHistoryManager() {
        Class<AbstractRunningStrategy> clazz = AbstractRunningStrategy.class;
        synchronized (AbstractRunningStrategy.class) {
            Date origin = this.getReportHistoryOriginDate();
            Messages.USING_ORDER_HISTORY_ORIGIN.info(AbstractRunningStrategy.class, (Object)origin);
            try {
                if (orderHistoryManager != null) {
                    orderHistoryManager.stop();
                }
                orderHistoryManager = new LiveOrderHistoryManager(origin);
                orderHistoryManager.start();
            }
            catch (ClientInitException e) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    private boolean canReceiveData() {
        return this.strategy.getStatus().canReceiveData();
    }

    static {
        EMPTY_REPORTS = new UnmodifiableDeque(new LinkedList());
    }

    @ClassVersion(value="$Id$")
    private static final class Callback
    implements Runnable {
        private final Strategy strategy;
        private final RunningStrategy runningStrategy;
        private final Object data;

        private Callback(RunningStrategy inRunningStrategy, Strategy inStrategy, Object inData) {
            this.runningStrategy = inRunningStrategy;
            this.strategy = inStrategy;
            this.data = inData;
        }

        @Override
        public void run() {
            StrategyModule.log((LogEvent)LogEventBuilder.debug().withMessage(Messages.EXECUTING_CALLBACK, (Serializable)((Object)String.valueOf(this.runningStrategy)), (Serializable)new Date()).create(), this.strategy);
            try {
                this.runningStrategy.onCallback(this.data);
            }
            catch (Exception e) {
                if (this.strategy.getExecutor() != null) {
                    StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CALLBACK_ERROR, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)this.strategy.getExecutor().interpretRuntimeException(e))).withException((Throwable)e).create(), this.strategy);
                }
                StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(Messages.CALLBACK_ERROR, (Serializable)((Object)String.valueOf(this.strategy)), (Serializable)((Object)e.getLocalizedMessage())).withException((Throwable)e).create(), this.strategy);
            }
        }
    }
}

