/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.event.AskEvent;
import org.marketcetera.event.BidEvent;
import org.marketcetera.event.DividendEvent;
import org.marketcetera.event.LogEvent;
import org.marketcetera.event.MarketstatEvent;
import org.marketcetera.event.TradeEvent;
import org.marketcetera.event.impl.LogEventBuilder;
import org.marketcetera.strategy.AbstractRunningStrategy;
import org.marketcetera.strategy.Executor;
import org.marketcetera.strategy.Language;
import org.marketcetera.strategy.Messages;
import org.marketcetera.strategy.RunningStrategy;
import org.marketcetera.strategy.ServicesProvider;
import org.marketcetera.strategy.Status;
import org.marketcetera.strategy.Strategy;
import org.marketcetera.strategy.StrategyException;
import org.marketcetera.strategy.StrategyModule;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.OrderCancelReject;

@ClassVersion(value="$Id$")
class StrategyImpl
implements Strategy,
Messages {
    private static final Set<StrategyImpl> runningStrategies = new HashSet<StrategyImpl>();
    final String name;
    private final Language language;
    private final File source;
    private final String code;
    private final Properties parameters;
    private final ServicesProvider servicesProvider;
    private final String defaultNamespace;
    private final String uniqueIdentifier;
    private Executor executor;
    private RunningStrategy runningStrategy;
    private Status status = Status.UNSTARTED;
    private String description;

    @Override
    public final void start() throws StrategyException {
        try {
            this.setExecutor(this.getLanguage().getExecutor(this));
            this.setStatus(Status.COMPILING);
            this.getExecutor().start();
        }
        catch (Exception e) {
            this.setStatus(Status.FAILED);
            throw new StrategyException(e);
        }
    }

    @Override
    public final void stop() throws Exception {
        if (this.getStatus().equals((Object)Status.FAILED) || this.getStatus().equals((Object)Status.STOPPED)) {
            return;
        }
        try {
            this.setStatus(Status.STOPPING);
            this.getExecutor().stop();
        }
        catch (Exception e) {
            this.setStatus(Status.FAILED);
            throw e;
        }
    }

    @Override
    public final void dataReceived(Object inData) {
        if (!this.getStatus().canReceiveData()) {
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(INVALID_STATUS_TO_RECEIVE_DATA, (Serializable)((Object)String.valueOf(this)), (Serializable)((Object)String.valueOf(inData)), (Serializable)((Object)this.getStatus())).create(), this);
            return;
        }
        String method = "onOther";
        try {
            RunningStrategy runningStrategy = this.getRunningStrategy();
            if (runningStrategy == null) {
                StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(STRATEGY_NOT_READY_TO_RECEIVE_DATA, (Serializable)((Object)String.valueOf(this)), (Serializable)((Object)String.valueOf(inData))).create(), this);
                return;
            }
            if (inData instanceof AskEvent) {
                method = "onAsk";
                runningStrategy.onAsk((AskEvent)inData);
                return;
            }
            if (inData instanceof BidEvent) {
                method = "onBid";
                runningStrategy.onBid((BidEvent)inData);
                return;
            }
            if (inData instanceof MarketstatEvent) {
                method = "onMarketstat";
                runningStrategy.onMarketstat((MarketstatEvent)inData);
                return;
            }
            if (inData instanceof DividendEvent) {
                method = "onDividend";
                runningStrategy.onDividend((DividendEvent)inData);
                return;
            }
            if (inData instanceof OrderCancelReject) {
                method = "onCancelReject";
                if (runningStrategy instanceof AbstractRunningStrategy) {
                    ((AbstractRunningStrategy)runningStrategy).onCancelRejectRedirected((OrderCancelReject)inData);
                } else {
                    runningStrategy.onCancelReject((OrderCancelReject)inData);
                }
                return;
            }
            if (inData instanceof ExecutionReport) {
                method = "onExecutionReport";
                if (runningStrategy instanceof AbstractRunningStrategy) {
                    ((AbstractRunningStrategy)runningStrategy).onExecutionReportRedirected((ExecutionReport)inData);
                } else {
                    runningStrategy.onExecutionReport((ExecutionReport)inData);
                }
                return;
            }
            if (inData instanceof TradeEvent) {
                method = "onTrade";
                runningStrategy.onTrade((TradeEvent)inData);
                return;
            }
            runningStrategy.onOther(inData);
        }
        catch (Exception e) {
            Executor executor = this.getExecutor();
            String methodName = method;
            String exceptionTranslation = e.toString();
            if (executor != null) {
                methodName = this.getExecutor().translateMethodName(method);
                exceptionTranslation = this.getExecutor().interpretRuntimeException(e);
            }
            StrategyModule.log((LogEvent)LogEventBuilder.warn().withMessage(RUNTIME_ERROR, (Serializable)((Object)String.valueOf(this)), (Serializable)((Object)methodName), (Serializable)((Object)exceptionTranslation)).withException((Throwable)e).create(), this);
        }
    }

    @Override
    public final String getScript() {
        return this.code;
    }

    @Override
    public final Language getLanguage() {
        return this.language;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Properties getParameters() {
        return this.parameters;
    }

    @Override
    public final Status getStatus() {
        return this.status;
    }

    @Override
    public final ServicesProvider getServicesProvider() {
        return this.servicesProvider;
    }

    @Override
    public final String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    public final Executor getExecutor() {
        return this.executor;
    }

    public final String toString() {
        if (this.description == null) {
            this.description = String.format("%s Strategy %s(%s)", this.getLanguage().toString(), this.getName(), this.getUniqueIdentifier());
        }
        return this.description;
    }

    StrategyImpl(String inName, String inUniqueIdentifier, Language inType, File inSource, Properties inParameters, String inNamespace, ServicesProvider inServicesProvider) throws IOException {
        this.name = inName;
        this.uniqueIdentifier = inUniqueIdentifier;
        this.language = inType;
        this.source = inSource;
        this.parameters = inParameters == null ? new Properties() : new Properties(inParameters);
        this.servicesProvider = inServicesProvider;
        this.code = this.source == null ? null : this.fileToString(this.getSource());
        this.defaultNamespace = inNamespace;
    }

    final String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    final File getSource() {
        return this.source;
    }

    final RunningStrategy getRunningStrategy() {
        return this.runningStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<StrategyImpl> getRunningStrategies() {
        Set<StrategyImpl> set = runningStrategies;
        synchronized (set) {
            return new HashSet<StrategyImpl>(runningStrategies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setStatus(Status inStatus) {
        assert (this.status.canChangeStatusTo(inStatus));
        Status oldStatus = this.status;
        this.status = inStatus;
        if (this.status.isRunning()) {
            Set<StrategyImpl> set = runningStrategies;
            synchronized (set) {
                runningStrategies.add(this);
            }
        }
        Set<StrategyImpl> set = runningStrategies;
        synchronized (set) {
            runningStrategies.remove(this);
        }
        this.getServicesProvider().statusChanged(oldStatus, inStatus);
    }

    final void setRunningStrategy(RunningStrategy inRunningStrategy) {
        this.runningStrategy = inRunningStrategy;
    }

    private void setExecutor(Executor inExecutor) {
        this.executor = inExecutor;
    }

    private String fileToString(File inFile) throws IOException {
        return FileUtils.readFileToString((File)inFile);
    }
}

