/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.SystemUtils;
import org.marketcetera.core.Pair;
import org.marketcetera.event.AskEvent;
import org.marketcetera.event.BidEvent;
import org.marketcetera.event.DividendEvent;
import org.marketcetera.event.EquityEvent;
import org.marketcetera.event.Event;
import org.marketcetera.event.MarketstatEvent;
import org.marketcetera.event.OptionEvent;
import org.marketcetera.event.TradeEvent;
import org.marketcetera.event.util.MarketstatEventCache;
import org.marketcetera.strategy.Messages;
import org.marketcetera.strategy.util.OptionContract;
import org.marketcetera.strategy.util.OptionContractPair;
import org.marketcetera.trade.Instrument;
import org.marketcetera.util.misc.ClassVersion;
import org.nocrala.tools.texttablefmt.BorderStyle;
import org.nocrala.tools.texttablefmt.CellStyle;
import org.nocrala.tools.texttablefmt.ShownBorders;
import org.nocrala.tools.texttablefmt.Table;

@ClassVersion(value="$Id$")
@ThreadSafe
public final class OptionChain {
    private final Map<OptionContractPair.OptionContractPairKey, OptionContractPair> optionChain = new ConcurrentSkipListMap<OptionContractPair.OptionContractPairKey, OptionContractPair>();
    private final List<DividendEvent> dividends = new CopyOnWriteArrayList<DividendEvent>();
    private final Instrument instrument;
    private volatile AskEvent latestAsk = null;
    private volatile BidEvent latestBid = null;
    private final MarketstatEventCache latestMarketstat;
    private volatile TradeEvent latestTrade = null;
    private static final String nl = SystemUtils.LINE_SEPARATOR;
    private static final String none = "---";
    private static final CellStyle headerStyle = new CellStyle(CellStyle.HorizontalAlign.center);
    private static final String[] dividendHeaders = new String[]{"Type", "Amount", "Execution Date", "Declare Date", "Payment Date", "Record Date", "Status", "Frequency"};
    private static final List<Pair<String, Integer>> chainHeaders = new ArrayList<Pair<String, Integer>>();
    private static final String BID = "Bid:  ";
    private static final String ASK = "Ask:  ";
    private static final String LAST = "Last: ";
    private static final String HIGH = "High: ";
    private static final String LOW = "Low:  ";
    private static final String DIVIDEND_HEADER = "Dividends";
    private static final String OPTION_CHAIN_HEADER = "Option Chain";

    public OptionChain(Instrument inUnderlyingInstrument) {
        if (inUnderlyingInstrument == null) {
            throw new NullPointerException();
        }
        this.instrument = inUnderlyingInstrument;
        this.latestMarketstat = new MarketstatEventCache(this.instrument);
    }

    public Collection<OptionContractPair> getOptionChain() {
        return Collections.unmodifiableCollection(this.optionChain.values());
    }

    public List<DividendEvent> getDividends() {
        return Collections.unmodifiableList(this.dividends);
    }

    public Instrument getUnderlyingInstrument() {
        return this.instrument;
    }

    public AskEvent getLatestUnderlyingAsk() {
        return this.latestAsk;
    }

    public BidEvent getLatestUnderlyingBid() {
        return this.latestBid;
    }

    public TradeEvent getLatestUnderlyingTrade() {
        return this.latestTrade;
    }

    public MarketstatEvent getLatestUnderlyingMarketstat() {
        return this.latestMarketstat.get();
    }

    public boolean process(Event inEvent) {
        if (inEvent == null) {
            throw new NullPointerException();
        }
        if (inEvent instanceof AskEvent) {
            return this.processAskEvent((AskEvent)inEvent);
        }
        if (inEvent instanceof BidEvent) {
            return this.processBidEvent((BidEvent)inEvent);
        }
        if (inEvent instanceof DividendEvent) {
            return this.processDividendEvent((DividendEvent)inEvent);
        }
        if (inEvent instanceof MarketstatEvent) {
            return this.processMarketstatEvent((MarketstatEvent)inEvent);
        }
        if (inEvent instanceof TradeEvent) {
            return this.processTradeEvent((TradeEvent)inEvent);
        }
        return false;
    }

    public String toString() {
        Collection<OptionContractPair> chain;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getUnderlyingInstrument().getSymbol()).append(nl);
        builder.append(BID).append(this.getLatestUnderlyingBid() == null ? none : String.format("%s %s %s", this.getLatestUnderlyingBid().getSize(), this.getLatestUnderlyingBid().getPrice(), this.getLatestUnderlyingBid().getExchange())).append(nl);
        builder.append(ASK).append(this.getLatestUnderlyingAsk() == null ? none : String.format("%s %s %s", this.getLatestUnderlyingAsk().getSize(), this.getLatestUnderlyingAsk().getPrice(), this.getLatestUnderlyingAsk().getExchange())).append(nl);
        builder.append(LAST).append(this.getLatestUnderlyingTrade() == null ? none : String.format("%s %s %s", this.getLatestUnderlyingTrade().getSize(), this.getLatestUnderlyingTrade().getPrice(), this.getLatestUnderlyingTrade().getExchange())).append(nl);
        MarketstatEvent latestUnderlyingStats = this.getLatestUnderlyingMarketstat();
        builder.append(HIGH).append(latestUnderlyingStats == null || latestUnderlyingStats.getHigh() == null ? none : latestUnderlyingStats.getHigh().toPlainString()).append(nl);
        builder.append(LOW).append(latestUnderlyingStats == null || latestUnderlyingStats.getLow() == null ? none : latestUnderlyingStats.getLow().toPlainString()).append(nl);
        if (!this.dividends.isEmpty()) {
            builder.append(DIVIDEND_HEADER).append(nl);
            Table table = new Table(dividendHeaders.length, BorderStyle.CLASSIC_COMPATIBLE_WIDE, ShownBorders.ALL, false);
            for (String header : dividendHeaders) {
                table.addCell(header, headerStyle);
            }
            for (DividendEvent dividend : this.dividends) {
                table.addCell(dividend.getType() == null ? none : dividend.getType().toString());
                table.addCell(dividend.getAmount() == null ? none : String.format("%s (%s)", dividend.getAmount().toPlainString(), dividend.getCurrency()));
                table.addCell(dividend.getExecutionDate() == null ? none : dividend.getExecutionDate());
                table.addCell(dividend.getDeclareDate() == null ? none : dividend.getDeclareDate());
                table.addCell(dividend.getPaymentDate() == null ? none : dividend.getPaymentDate());
                table.addCell(dividend.getRecordDate() == null ? none : dividend.getRecordDate());
                table.addCell(dividend.getStatus() == null ? none : dividend.getStatus().toString());
                table.addCell(dividend.getFrequency() == null ? none : dividend.getFrequency().toString());
            }
            builder.append(table.render());
            builder.append(nl);
        }
        if ((chain = this.getOptionChain()).isEmpty()) {
            return builder.toString();
        }
        builder.append(OPTION_CHAIN_HEADER).append(nl);
        Table table = new Table(13, BorderStyle.CLASSIC_COMPATIBLE_WIDE, ShownBorders.ALL, false);
        for (Pair<String, Integer> header : chainHeaders) {
            table.addCell((String)header.getFirstMember(), headerStyle, ((Integer)header.getSecondMember()).intValue());
        }
        for (OptionContractPair pair : chain) {
            TradeEvent trade;
            AskEvent ask;
            BidEvent bid;
            String strike;
            String expiry;
            String symbol;
            OptionContract put = pair.getPut();
            OptionContract call = pair.getCall();
            String providerSymbol = null;
            if (put != null) {
                symbol = put.getInstrument().getSymbol();
                expiry = put.getInstrument().getExpiry();
                strike = put.getInstrument().getStrikePrice().toPlainString();
                if (put.getProviderSymbol() != null) {
                    providerSymbol = put.getProviderSymbol();
                }
            } else {
                if (call == null) continue;
                symbol = call.getInstrument().getSymbol();
                expiry = call.getInstrument().getExpiry();
                strike = call.getInstrument().getStrikePrice().toPlainString();
                if (call.getProviderSymbol() != null) {
                    providerSymbol = call.getProviderSymbol();
                }
            }
            StringBuilder cell = new StringBuilder();
            cell.append(symbol).append(" ").append(expiry).append(" ").append(strike);
            if (providerSymbol != null) {
                cell.append(" (").append(providerSymbol).append(")");
            }
            table.addCell(cell.toString());
            if (put != null && put.getLatestBid() != null) {
                bid = put.getLatestBid();
                table.addCell(bid.getSize().toPlainString());
                table.addCell(String.format("%s %s", bid.getPrice().toPlainString(), bid.getExchange()));
            } else {
                table.addCell(none);
                table.addCell(none);
            }
            if (put != null && put.getLatestAsk() != null) {
                ask = put.getLatestAsk();
                table.addCell(ask.getSize().toPlainString());
                table.addCell(String.format("%s %s", ask.getPrice().toPlainString(), ask.getExchange()));
            } else {
                table.addCell(none);
                table.addCell(none);
            }
            if (put != null && put.getLatestTrade() != null) {
                trade = put.getLatestTrade();
                table.addCell(trade.getSize().toPlainString());
                table.addCell(String.format("%s %s", trade.getPrice().toPlainString(), trade.getExchange()));
            } else {
                table.addCell(none);
                table.addCell(none);
            }
            if (call != null && call.getLatestBid() != null) {
                bid = call.getLatestBid();
                table.addCell(bid.getSize().toPlainString());
                table.addCell(String.format("%s %s", bid.getPrice().toPlainString(), bid.getExchange()));
            } else {
                table.addCell(none);
                table.addCell(none);
            }
            if (call != null && call.getLatestAsk() != null) {
                ask = call.getLatestAsk();
                table.addCell(ask.getSize().toPlainString());
                table.addCell(String.format("%s %s", ask.getPrice().toPlainString(), ask.getExchange()));
            } else {
                table.addCell(none);
                table.addCell(none);
            }
            if (call != null && call.getLatestTrade() != null) {
                trade = call.getLatestTrade();
                table.addCell(trade.getSize().toPlainString());
                table.addCell(String.format("%s %s", trade.getPrice().toPlainString(), trade.getExchange()));
                continue;
            }
            table.addCell(none);
            table.addCell(none);
        }
        builder.append(table.render());
        return builder.toString();
    }

    private boolean processAskEvent(AskEvent inAsk) {
        if (!this.validate((Event)inAsk)) {
            return false;
        }
        if (inAsk instanceof EquityEvent) {
            this.latestAsk = inAsk;
            return true;
        }
        if (inAsk instanceof OptionEvent) {
            return this.processEventForOptionChain((OptionEvent)inAsk);
        }
        return false;
    }

    private boolean processBidEvent(BidEvent inBid) {
        if (!this.validate((Event)inBid)) {
            return false;
        }
        if (inBid instanceof EquityEvent) {
            this.latestBid = inBid;
            return true;
        }
        if (inBid instanceof OptionEvent) {
            return this.processEventForOptionChain((OptionEvent)inBid);
        }
        return false;
    }

    private boolean processDividendEvent(DividendEvent inDividend) {
        if (!this.validate((Event)inDividend)) {
            return false;
        }
        this.dividends.add(inDividend);
        return true;
    }

    private boolean processMarketstatEvent(MarketstatEvent inMarketstat) {
        if (!this.validate((Event)inMarketstat)) {
            return false;
        }
        if (inMarketstat instanceof EquityEvent) {
            this.latestMarketstat.cache(inMarketstat);
            return true;
        }
        if (inMarketstat instanceof OptionEvent) {
            return this.processEventForOptionChain((OptionEvent)inMarketstat);
        }
        return false;
    }

    private boolean processTradeEvent(TradeEvent inTrade) {
        if (!this.validate((Event)inTrade)) {
            return false;
        }
        if (inTrade instanceof EquityEvent) {
            this.latestTrade = inTrade;
            return true;
        }
        if (inTrade instanceof OptionEvent) {
            return this.processEventForOptionChain((OptionEvent)inTrade);
        }
        return false;
    }

    private synchronized boolean processEventForOptionChain(OptionEvent inOptionEvent) {
        OptionContractPair.OptionContractPairKey key = OptionContractPair.getOptionContractPairKey(inOptionEvent.getInstrument());
        OptionContractPair contractPair = this.optionChain.get(key);
        if (contractPair == null) {
            contractPair = new OptionContractPair(inOptionEvent);
            this.optionChain.put(key, contractPair);
        }
        return contractPair.process(inOptionEvent);
    }

    private boolean validate(Event inEvent) {
        EquityEvent equityEvent;
        DividendEvent dividendEvent;
        OptionEvent optionEvent;
        if (inEvent instanceof OptionEvent && !(optionEvent = (OptionEvent)inEvent).getUnderlyingInstrument().equals(this.getUnderlyingInstrument())) {
            Messages.WRONG_UNDERLYING_FOR_OPTION_CHAIN.warn(OptionChain.class, (Object)optionEvent.getUnderlyingInstrument(), (Object)this.getUnderlyingInstrument());
            return false;
        }
        if (inEvent instanceof DividendEvent && !(dividendEvent = (DividendEvent)inEvent).getInstrument().equals((Object)this.getUnderlyingInstrument())) {
            Messages.WRONG_DIVIDEND_EQUITY_FOR_OPTION_CHAIN.warn(OptionChain.class, (Object)dividendEvent.getInstrument(), (Object)this.getUnderlyingInstrument());
            return false;
        }
        if (inEvent instanceof EquityEvent && !(equityEvent = (EquityEvent)inEvent).getInstrument().equals((Object)this.getUnderlyingInstrument())) {
            Messages.WRONG_EQUITY_FOR_OPTION_CHAIN.warn(OptionChain.class, (Object)equityEvent.getInstrument(), (Object)this.getUnderlyingInstrument());
            return false;
        }
        return true;
    }

    static {
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"", (Object)1));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Put", (Object)6));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Call", (Object)6));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"", (Object)1));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Bid", (Object)2));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Ask", (Object)2));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Latest", (Object)2));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Bid", (Object)2));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Ask", (Object)2));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Latest", (Object)2));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Symbol/Expiry/Strike", (Object)1));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Size", (Object)1));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Price X", (Object)1));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Size", (Object)1));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Price X", (Object)1));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Size", (Object)1));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Price X", (Object)1));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Size", (Object)1));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Price X", (Object)1));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Size", (Object)1));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Price X", (Object)1));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Size", (Object)1));
        chainHeaders.add((Pair<String, Integer>)new Pair((Object)"Price X", (Object)1));
    }
}

