/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.trade;

import java.math.BigDecimal;
import java.util.Date;
import org.marketcetera.admin.User;
import org.marketcetera.trade.ExecutionType;
import org.marketcetera.trade.MutableExecutionReportSummary;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.Report;
import org.marketcetera.trade.SecurityType;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.TimeInForce;
import org.marketcetera.trade.UserID;

public interface ExecutionReportSummary {
    public OrderID getOrderID();

    public OrderID getOriginalOrderID();

    public SecurityType getSecurityType();

    public String getSymbol();

    public String getExpiry();

    public BigDecimal getStrikePrice();

    public OptionType getOptionType();

    public String getAccount();

    public OrderID getRootOrderID();

    public Side getSide();

    public BigDecimal getCumulativeQuantity();

    public BigDecimal getEffectiveCumulativeQuantity();

    public BigDecimal getAveragePrice();

    public BigDecimal getLastQuantity();

    public BigDecimal getLastPrice();

    public OrderStatus getOrderStatus();

    public ExecutionType getExecutionType();

    public Date getSendingTime();

    public User getViewer();

    public User getActor();

    public Report getReport();

    public UserID getViewerID();

    public OrderID getBrokerOrderId();

    public String getExecutionId();

    public BigDecimal getLeavesQuantity();

    public BigDecimal getOrderQuantity();

    public OrderType getOrderType();

    public BigDecimal getPrice();

    public TimeInForce getTimeInForce();

    default public MutableExecutionReportSummary getMutableVersion() {
        throw new UnsupportedOperationException();
    }
}

