/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.trade.client;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.marketcetera.core.BaseClient;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.event.HasFIXMessage;
import org.marketcetera.fix.ActiveFixSession;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.trade.AverageFillPrice;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.ExecutionReportSummary;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.Order;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderSummary;
import org.marketcetera.trade.Report;
import org.marketcetera.trade.ReportID;
import org.marketcetera.trade.Suggestion;
import org.marketcetera.trade.SuggestionListener;
import org.marketcetera.trade.TradeMessagePublisher;
import org.marketcetera.trade.client.SendOrderResponse;

public interface TradeClient
extends BaseClient,
TradeMessagePublisher {
    public List<ActiveFixSession> readAvailableFixInitiatorSessions();

    public Collection<OrderSummary> getOpenOrders();

    public CollectionPageResponse<OrderSummary> getOpenOrders(PageRequest var1);

    public List<SendOrderResponse> sendOrders(List<Order> var1);

    public void sendOrderSuggestion(Suggestion var1);

    public SendOrderResponse sendOrder(Order var1);

    public BigDecimal getPositionAsOf(Date var1, Instrument var2);

    public Map<PositionKey<? extends Instrument>, BigDecimal> getAllPositionsAsOf(Date var1);

    public Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(Date var1, String ... var2);

    public void addReport(HasFIXMessage var1, BrokerID var2);

    public void deleteReport(ReportID var1);

    public Instrument resolveSymbol(String var1);

    public OrderID findRootOrderIdFor(OrderID var1);

    public Collection<String> getOptionRoots(String var1);

    public String getUnderlying(String var1);

    public ExecutionReport getLatestExecutionReportForOrderChain(OrderID var1);

    public CollectionPageResponse<Report> getReports(PageRequest var1);

    public CollectionPageResponse<ExecutionReportSummary> getFills(PageRequest var1);

    public CollectionPageResponse<AverageFillPrice> getAveragePriceFills(PageRequest var1);

    public void addSuggestionListener(SuggestionListener var1);

    public void removeSuggestionListener(SuggestionListener var1);
}

