/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.trade.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.marketcetera.admin.User;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.event.HasFIXMessage;
import org.marketcetera.fix.IncomingMessage;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.trade.AverageFillPrice;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.ConvertibleBond;
import org.marketcetera.trade.Currency;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.ExecutionReportSummary;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.HasMutableReportID;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.Report;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.trade.ReportID;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.data.domain.Page;
import quickfix.SessionID;

@ClassVersion(value="$Id$")
public interface ReportService {
    public Report save(Report var1);

    public Report getReportFor(ReportID var1);

    public OrderStatus getOrderStatusForOrderChain(OrderID var1);

    public CollectionPageResponse<Report> getReports(PageRequest var1);

    public CollectionPageResponse<ExecutionReportSummary> getFills(PageRequest var1);

    public Optional<ExecutionReport> getLatestExecutionReportForOrderChain(OrderID var1);

    public int purgeReportsBefore(Date var1);

    public List<ReportBase> getReportsSince(User var1, Date var2);

    public BigDecimal getPositionAsOf(User var1, Date var2, Instrument var3);

    public BigDecimal getEquityPositionAsOf(User var1, Date var2, Equity var3);

    public List<ReportBaseImpl> getOpenOrders(User var1);

    public Map<PositionKey<Equity>, BigDecimal> getAllEquityPositionsAsOf(User var1, Date var2);

    public BigDecimal getCurrencyPositionAsOf(User var1, Date var2, Currency var3);

    public Map<PositionKey<? extends Instrument>, BigDecimal> getAllPositionsAsOf(User var1, Date var2);

    public Map<PositionKey<Currency>, BigDecimal> getAllCurrencyPositionsAsOf(User var1, Date var2);

    public Map<PositionKey<ConvertibleBond>, BigDecimal> getAllConvertibleBondPositionsAsOf(User var1, Date var2);

    public Map<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(User var1, Date var2);

    public BigDecimal getFuturePositionAsOf(User var1, Date var2, Future var3);

    public BigDecimal getConvertibleBondPositionAsOf(User var1, Date var2, ConvertibleBond var3);

    public BigDecimal getOptionPositionAsOf(User var1, Date var2, Option var3);

    public Map<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(User var1, Date var2);

    public Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(User var1, Date var2, String[] var3);

    public Report save(ReportBase var1);

    public void delete(ReportID var1);

    public OrderID getRootOrderIdFor(OrderID var1);

    public int findLastSequenceNumberFor(SessionID var1, Date var2);

    public List<Long> findUnhandledIncomingMessageIds(SessionID var1, Set<String> var2, Date var3);

    public List<IncomingMessage> findIncomingMessagesForIdIn(Set<Long> var1);

    public Page<? extends ExecutionReportSummary> getExecutions(int var1, int var2);

    public void assignReportId(HasMutableReportID var1);

    public void addReport(HasFIXMessage var1, BrokerID var2, UserID var3);

    public CollectionPageResponse<AverageFillPrice> getAverageFillPrices(PageRequest var1);
}

