/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.trading.rpc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Timestamp;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.marketcetera.admin.UserFactory;
import org.marketcetera.cluster.ClusterDataFactory;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.core.Util;
import org.marketcetera.core.VersionInfo;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.event.HasFIXMessage;
import org.marketcetera.fix.ActiveFixSession;
import org.marketcetera.fix.FixAdminRpc;
import org.marketcetera.fix.FixRpcUtil;
import org.marketcetera.fix.MutableActiveFixSessionFactory;
import org.marketcetera.fix.MutableFixSessionFactory;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.rpc.base.BaseRpc;
import org.marketcetera.rpc.base.BaseRpcUtil;
import org.marketcetera.rpc.client.AbstractRpcClient;
import org.marketcetera.rpc.client.RpcClientParameters;
import org.marketcetera.rpc.paging.PagingRpc;
import org.marketcetera.rpc.paging.PagingRpcUtil;
import org.marketcetera.trade.AverageFillPrice;
import org.marketcetera.trade.AverageFillPriceFactory;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.ExecutionReportSummary;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.MutableExecutionReportSummaryFactory;
import org.marketcetera.trade.MutableOrderSummaryFactory;
import org.marketcetera.trade.MutableReportFactory;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.Order;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderSummary;
import org.marketcetera.trade.Report;
import org.marketcetera.trade.ReportID;
import org.marketcetera.trade.Suggestion;
import org.marketcetera.trade.SuggestionListener;
import org.marketcetera.trade.TradeMessage;
import org.marketcetera.trade.TradeMessageListener;
import org.marketcetera.trade.client.SendOrderResponse;
import org.marketcetera.trade.client.TradeClient;
import org.marketcetera.trade.rpc.TradeRpc;
import org.marketcetera.trade.rpc.TradeRpcServiceGrpc;
import org.marketcetera.trade.rpc.TradeTypesRpc;
import org.marketcetera.trading.rpc.TradeRpcClientParameters;
import org.marketcetera.trading.rpc.TradeRpcUtil;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.ws.tags.AppId;
import quickfix.Message;

public class TradeRpcClient
extends AbstractRpcClient<TradeRpcServiceGrpc.TradeRpcServiceBlockingStub, TradeRpcServiceGrpc.TradeRpcServiceStub, TradeRpcClientParameters>
implements TradeClient {
    private AverageFillPriceFactory averageFillPriceFactory;
    private MutableExecutionReportSummaryFactory executionReportSummaryFactory;
    private MutableOrderSummaryFactory orderSummaryFactory;
    private UserFactory userFactory;
    private MutableReportFactory reportFactory;
    private ClusterDataFactory clusterDataFactory;
    private MutableActiveFixSessionFactory activeFixSessionFactory;
    private MutableFixSessionFactory fixSessionFactory;
    private static final String APP_ID_NAME = TradeRpcClient.class.getSimpleName();
    private static final VersionInfo APP_ID_VERSION = new VersionInfo("4.1.0");
    private static final AppId APP_ID = Util.getAppId((String)APP_ID_NAME, (String)APP_ID_VERSION.getVersionInfo());
    private final Cache<String, Instrument> symbolCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private final Cache<OrderID, OrderID> rootOrderIdCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private final Cache<String, BaseRpcUtil.AbstractClientListenerProxy<?, ?, ?>> listenerProxiesById = CacheBuilder.newBuilder().build();
    private final LoadingCache<Object, BaseRpcUtil.AbstractClientListenerProxy<?, ?, ?>> listenerProxies = CacheBuilder.newBuilder().build(new CacheLoader<Object, BaseRpcUtil.AbstractClientListenerProxy<?, ?, ?>>(){

        public BaseRpcUtil.AbstractClientListenerProxy<?, ?, ?> load(Object inKey) throws Exception {
            BaseRpcUtil.AbstractClientListenerProxy<?, ?, ?> proxy = TradeRpcClient.getListenerFor(inKey);
            TradeRpcClient.this.listenerProxiesById.put((Object)proxy.getId(), proxy);
            return proxy;
        }
    });

    public void addTradeMessageListener(TradeMessageListener inTradeMessageListener) {
        if (this.listenerProxies.asMap().containsKey(inTradeMessageListener)) {
            return;
        }
        final BaseRpcUtil.AbstractClientListenerProxy listener = (BaseRpcUtil.AbstractClientListenerProxy)this.listenerProxies.getUnchecked((Object)inTradeMessageListener);
        if (listener == null) {
            return;
        }
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} adding report listener", (Object[])new Object[]{TradeRpcClient.this.getSessionId()});
                TradeRpc.AddTradeMessageListenerRequest.Builder requestBuilder = TradeRpc.AddTradeMessageListenerRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                requestBuilder.setListenerId(listener.getId());
                TradeRpc.AddTradeMessageListenerRequest addTradeMessageListenerRequest = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), addTradeMessageListenerRequest});
                ((TradeRpcServiceGrpc.TradeRpcServiceStub)TradeRpcClient.this.getAsyncStub()).addTradeMessageListener(addTradeMessageListenerRequest, (StreamObserver)((TradeMessageListenerProxy)listener));
                return null;
            }
        });
    }

    public void removeTradeMessageListener(TradeMessageListener inTradeMessageListener) {
        final BaseRpcUtil.AbstractClientListenerProxy proxy = (BaseRpcUtil.AbstractClientListenerProxy)this.listenerProxies.getIfPresent((Object)inTradeMessageListener);
        this.listenerProxies.invalidate((Object)inTradeMessageListener);
        if (proxy == null) {
            return;
        }
        this.listenerProxiesById.invalidate((Object)proxy.getId());
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} removing report listener", (Object[])new Object[]{TradeRpcClient.this.getSessionId()});
                TradeRpc.RemoveTradeMessageListenerRequest.Builder requestBuilder = TradeRpc.RemoveTradeMessageListenerRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                requestBuilder.setListenerId(proxy.getId());
                TradeRpc.RemoveTradeMessageListenerRequest removeTradeMessageListenerRequest = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), removeTradeMessageListenerRequest});
                TradeRpc.RemoveTradeMessageListenerResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).removeTradeMessageListener(removeTradeMessageListenerRequest);
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} received {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), response});
                return null;
            }
        });
    }

    public void addSuggestionListener(SuggestionListener inSuggestionListener) {
        if (this.listenerProxies.asMap().containsKey(inSuggestionListener)) {
            return;
        }
        final BaseRpcUtil.AbstractClientListenerProxy listener = (BaseRpcUtil.AbstractClientListenerProxy)this.listenerProxies.getUnchecked((Object)inSuggestionListener);
        if (listener == null) {
            return;
        }
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} adding suggestion listener", (Object[])new Object[]{TradeRpcClient.this.getSessionId()});
                TradeRpc.AddSuggestionListenerRequest.Builder requestBuilder = TradeRpc.AddSuggestionListenerRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                requestBuilder.setListenerId(listener.getId());
                TradeRpc.AddSuggestionListenerRequest addSuggestionListenerRequest = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), addSuggestionListenerRequest});
                ((TradeRpcServiceGrpc.TradeRpcServiceStub)TradeRpcClient.this.getAsyncStub()).addSuggestionListener(addSuggestionListenerRequest, (StreamObserver)((SuggestionListenerProxy)listener));
                return null;
            }
        });
    }

    public void removeSuggestionListener(SuggestionListener inSuggestionListener) {
        final BaseRpcUtil.AbstractClientListenerProxy proxy = (BaseRpcUtil.AbstractClientListenerProxy)this.listenerProxies.getIfPresent((Object)inSuggestionListener);
        this.listenerProxies.invalidate((Object)inSuggestionListener);
        if (proxy == null) {
            return;
        }
        this.listenerProxiesById.invalidate((Object)proxy.getId());
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} removing report listener", (Object[])new Object[]{TradeRpcClient.this.getSessionId()});
                TradeRpc.RemoveSuggestionListenerRequest.Builder requestBuilder = TradeRpc.RemoveSuggestionListenerRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                requestBuilder.setListenerId(proxy.getId());
                TradeRpc.RemoveSuggestionListenerRequest removeSuggestionListenerRequest = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), removeSuggestionListenerRequest});
                TradeRpc.RemoveSuggestionListenerResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).removeSuggestionListener(removeSuggestionListenerRequest);
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} received {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), response});
                return null;
            }
        });
    }

    public OrderID findRootOrderIdFor(final OrderID inOrderId) {
        OrderID result = (OrderID)this.rootOrderIdCache.getIfPresent((Object)inOrderId);
        if (result != null) {
            return result;
        }
        result = (OrderID)this.executeCall(new Callable<OrderID>(){

            @Override
            public OrderID call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} finding root order ID for: {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), inOrderId});
                TradeRpc.FindRootOrderIdRequest.Builder requestBuilder = TradeRpc.FindRootOrderIdRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                requestBuilder.setOrderId(inOrderId.getValue());
                TradeRpc.FindRootOrderIdResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).findRootOrderId(requestBuilder.build());
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} received {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), response});
                OrderID result = null;
                if (response.getRootOrderId() != null) {
                    result = new OrderID(response.getRootOrderId());
                }
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} returning {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), result});
                return result;
            }
        });
        if (result != null) {
            this.rootOrderIdCache.put((Object)inOrderId, (Object)result);
        }
        return result;
    }

    public BigDecimal getPositionAsOf(final Date inDate, final Instrument inInstrument) {
        return (BigDecimal)this.executeCall(new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} getting position of {} as of {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), inInstrument, inDate});
                TradeRpc.GetPositionAsOfRequest.Builder requestBuilder = TradeRpc.GetPositionAsOfRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                TradeRpcUtil.getRpcInstrument((Instrument)inInstrument).ifPresent(instrument -> requestBuilder.setInstrument(instrument));
                Instant time = inDate.toInstant();
                requestBuilder.setTimestamp(Timestamp.newBuilder().setSeconds(time.getEpochSecond()).setNanos(time.getNano()).build());
                TradeRpc.GetPositionAsOfResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).getPositionAsOf(requestBuilder.build());
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} received {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), response});
                BigDecimal result = BaseRpcUtil.getScaledQuantity((BaseRpc.Qty)response.getPosition()).orElse(BigDecimal.ZERO);
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} returning {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), result});
                return result;
            }
        });
    }

    public Map<PositionKey<? extends Instrument>, BigDecimal> getAllPositionsAsOf(final Date inDate) {
        return (Map)this.executeCall(new Callable<Map<PositionKey<? extends Instrument>, BigDecimal>>(){

            @Override
            public Map<PositionKey<? extends Instrument>, BigDecimal> call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} getting all positions as of {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), inDate});
                TradeRpc.GetAllPositionsAsOfRequest.Builder requestBuilder = TradeRpc.GetAllPositionsAsOfRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                Instant time = inDate.toInstant();
                requestBuilder.setTimestamp(Timestamp.newBuilder().setSeconds(time.getEpochSecond()).setNanos(time.getNano()).build());
                TradeRpc.GetAllPositionsAsOfResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).getAllPositionsAsOf(requestBuilder.build());
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} received {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), response});
                HashMap result = Maps.newHashMap();
                for (TradeTypesRpc.Position rpcPosition : response.getPositionList()) {
                    PositionKey positionKey = null;
                    if (rpcPosition.hasPositionKey()) {
                        positionKey = TradeRpcUtil.getPositionKey((TradeTypesRpc.PositionKey)rpcPosition.getPositionKey());
                    }
                    BigDecimal position = BaseRpcUtil.getScaledQuantity((BaseRpc.Qty)rpcPosition.getPosition()).orElse(BigDecimal.ZERO);
                    if (positionKey == null) continue;
                    result.put(positionKey, position);
                }
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} returning {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), result});
                return result;
            }
        });
    }

    public Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(final Date inDate, String ... inRootSymbols) {
        return (Map)this.executeCall(new Callable<Map<PositionKey<Option>, BigDecimal>>(){

            @Override
            public Map<PositionKey<Option>, BigDecimal> call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} getting all option positions as of {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), inDate});
                TradeRpc.GetAllPositionsByRootAsOfRequest.Builder requestBuilder = TradeRpc.GetAllPositionsByRootAsOfRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                Instant time = inDate.toInstant();
                requestBuilder.setTimestamp(Timestamp.newBuilder().setSeconds(time.getEpochSecond()).setNanos(time.getNano()).build());
                TradeRpc.GetAllPositionsByRootAsOfResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).getAllPositionsByRootAsOf(requestBuilder.build());
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} received {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), response});
                HashMap result = Maps.newHashMap();
                for (TradeTypesRpc.Position rpcPosition : response.getPositionList()) {
                    PositionKey positionKey = null;
                    if (rpcPosition.hasPositionKey()) {
                        positionKey = TradeRpcUtil.getPositionKey((TradeTypesRpc.PositionKey)rpcPosition.getPositionKey());
                    }
                    BigDecimal position = BaseRpcUtil.getScaledQuantity((BaseRpc.Qty)rpcPosition.getPosition()).orElse(BigDecimal.ZERO);
                    if (positionKey == null) continue;
                    result.put(positionKey, position);
                }
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} returning {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), result});
                return result;
            }
        });
    }

    public Instrument resolveSymbol(final String inSymbol) {
        Instrument result = (Instrument)this.symbolCache.getIfPresent((Object)inSymbol);
        if (result != null) {
            return result;
        }
        result = (Instrument)this.executeCall(new Callable<Instrument>(){

            @Override
            public Instrument call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} resolving symbol: {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), inSymbol});
                TradeRpc.ResolveSymbolRequest.Builder requestBuilder = TradeRpc.ResolveSymbolRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                requestBuilder.setSymbol(inSymbol);
                TradeRpc.ResolveSymbolResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).resolveSymbol(requestBuilder.build());
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} received {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), response});
                Instrument result = TradeRpcUtil.getInstrument((TradeTypesRpc.Instrument)response.getInstrument()).orElse(null);
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} returning {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), result});
                return result;
            }
        });
        if (result != null) {
            this.symbolCache.put((Object)inSymbol, (Object)result);
        }
        return result;
    }

    public CollectionPageResponse<OrderSummary> getOpenOrders(final PageRequest inPageRequest) {
        return (CollectionPageResponse)this.executeCall(new Callable<CollectionPageResponse<OrderSummary>>(){

            @Override
            public CollectionPageResponse<OrderSummary> call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} requesting open orders", (Object[])new Object[]{TradeRpcClient.this.getSessionId()});
                TradeRpc.OpenOrdersRequest.Builder requestBuilder = TradeRpc.OpenOrdersRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                requestBuilder.setPageRequest(PagingRpcUtil.buildPageRequest((PageRequest)inPageRequest));
                TradeRpc.OpenOrdersResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).getOpenOrders(requestBuilder.build());
                CollectionPageResponse results = new CollectionPageResponse();
                for (TradeTypesRpc.OrderSummary rpcOrderSummary : response.getOrdersList()) {
                    Optional value = TradeRpcUtil.getOrderSummary((TradeTypesRpc.OrderSummary)rpcOrderSummary, (MutableOrderSummaryFactory)TradeRpcClient.this.orderSummaryFactory, (UserFactory)TradeRpcClient.this.userFactory, (MutableReportFactory)TradeRpcClient.this.reportFactory);
                    if (!value.isPresent()) continue;
                    results.getElements().add((OrderSummary)value.get());
                }
                PagingRpcUtil.setPageResponse((PageRequest)inPageRequest, (PagingRpc.PageResponse)response.getPageResponse(), (CollectionPageResponse)results);
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} returning {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), results});
                return results;
            }
        });
    }

    public CollectionPageResponse<Report> getReports(final PageRequest inPageRequest) {
        return (CollectionPageResponse)this.executeCall(new Callable<CollectionPageResponse<Report>>(){

            @Override
            public CollectionPageResponse<Report> call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} requesting reports: {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), inPageRequest});
                TradeRpc.GetReportsRequest.Builder requestBuilder = TradeRpc.GetReportsRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                requestBuilder.setPageRequest(PagingRpcUtil.buildPageRequest((PageRequest)inPageRequest));
                TradeRpc.GetReportsResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).getReports(requestBuilder.build());
                CollectionPageResponse results = new CollectionPageResponse();
                response.getReportsList().forEach(rpcReport -> results.getElements().add(TradeRpcUtil.getReport((TradeTypesRpc.Report)rpcReport, (MutableReportFactory)TradeRpcClient.this.reportFactory, (UserFactory)TradeRpcClient.this.userFactory)));
                PagingRpcUtil.setPageResponse((PageRequest)inPageRequest, (PagingRpc.PageResponse)response.getPageResponse(), (CollectionPageResponse)results);
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} returning {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), results});
                return results;
            }
        });
    }

    public CollectionPageResponse<ExecutionReportSummary> getFills(final PageRequest inPageRequest) {
        return (CollectionPageResponse)this.executeCall(new Callable<CollectionPageResponse<ExecutionReportSummary>>(){

            @Override
            public CollectionPageResponse<ExecutionReportSummary> call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} requesting fills: {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), inPageRequest});
                TradeRpc.GetFillsRequest.Builder requestBuilder = TradeRpc.GetFillsRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                requestBuilder.setPageRequest(PagingRpcUtil.buildPageRequest((PageRequest)inPageRequest));
                TradeRpc.GetFillsResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).getFills(requestBuilder.build());
                CollectionPageResponse results = new CollectionPageResponse();
                response.getFillsList().forEach(rpcExecutionReport -> results.getElements().add(TradeRpcUtil.getExecutionReportSummary((TradeTypesRpc.ExecutionReportSummary)rpcExecutionReport, (MutableExecutionReportSummaryFactory)TradeRpcClient.this.executionReportSummaryFactory, (MutableReportFactory)TradeRpcClient.this.reportFactory, (UserFactory)TradeRpcClient.this.userFactory)));
                PagingRpcUtil.setPageResponse((PageRequest)inPageRequest, (PagingRpc.PageResponse)response.getPageResponse(), (CollectionPageResponse)results);
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} returning {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), results});
                return results;
            }
        });
    }

    public CollectionPageResponse<AverageFillPrice> getAveragePriceFills(final PageRequest inPageRequest) {
        return (CollectionPageResponse)this.executeCall(new Callable<CollectionPageResponse<AverageFillPrice>>(){

            @Override
            public CollectionPageResponse<AverageFillPrice> call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{}: {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), inPageRequest});
                TradeRpc.GetAverageFillPricesRequest.Builder requestBuilder = TradeRpc.GetAverageFillPricesRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                requestBuilder.setPageRequest(PagingRpcUtil.buildPageRequest((PageRequest)inPageRequest));
                TradeRpc.GetAverageFillPricesResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).getAverageFillPrices(requestBuilder.build());
                CollectionPageResponse results = new CollectionPageResponse();
                response.getAverageFillPricesList().forEach(rpcAverageFillPrice -> results.getElements().add(TradeRpcUtil.getAverageFillPrice((TradeTypesRpc.AverageFillPrice)rpcAverageFillPrice, (AverageFillPriceFactory)TradeRpcClient.this.averageFillPriceFactory)));
                PagingRpcUtil.setPageResponse((PageRequest)inPageRequest, (PagingRpc.PageResponse)response.getPageResponse(), (CollectionPageResponse)results);
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} returning {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), results});
                return results;
            }
        });
    }

    public Collection<OrderSummary> getOpenOrders() {
        return this.getOpenOrders(PageRequest.ALL).getElements();
    }

    public SendOrderResponse sendOrder(Order inOrder) {
        return this.sendOrders(Lists.newArrayList((Object[])new Order[]{inOrder})).get(0);
    }

    public ExecutionReport getLatestExecutionReportForOrderChain(final OrderID inOrderId) {
        return (ExecutionReport)this.executeCall(new Callable<ExecutionReport>(){

            @Override
            public ExecutionReport call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} retrieving latest execution report for order chain {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), inOrderId});
                TradeRpc.GetLatestExecutionReportForOrderChainRequest.Builder requestBuilder = TradeRpc.GetLatestExecutionReportForOrderChainRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                requestBuilder.setOrderId(inOrderId.getValue());
                TradeRpc.GetLatestExecutionReportForOrderChainRequest getExecutionReportRequest = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), getExecutionReportRequest});
                TradeRpc.GetLatestExecutionReportForOrderChainResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).getLatestExecutionReportForOrderChain(getExecutionReportRequest);
                ExecutionReport executionReport = (ExecutionReport)TradeRpcUtil.getTradeMessage((TradeTypesRpc.TradeMessage)response.getExecutionReport());
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} received {}: {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), response, executionReport});
                return executionReport;
            }
        });
    }

    public void sendOrderSuggestion(final Suggestion inSuggestion) {
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), inSuggestion});
                TradeRpc.SendSuggestionRequest.Builder requestBuilder = TradeRpc.SendSuggestionRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                TradeRpcUtil.getSuggestion((Suggestion)inSuggestion).ifPresent(rpcSuggestion -> requestBuilder.addSuggestion(rpcSuggestion));
                TradeRpc.SendSuggestionRequest sendSuggestionRequest = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), sendSuggestionRequest});
                TradeRpc.SendSuggestionResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).sendSuggestion(sendSuggestionRequest);
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} returning {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), response});
                return null;
            }
        });
    }

    public List<SendOrderResponse> sendOrders(final List<Order> inOrders) {
        return (List)this.executeCall(new Callable<List<SendOrderResponse>>(){

            @Override
            public List<SendOrderResponse> call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} sending {} order(s)", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), inOrders.size()});
                TradeRpc.SendOrderRequest.Builder requestBuilder = TradeRpc.SendOrderRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                for (Order order : inOrders) {
                    try {
                        TradeRpcUtil.getOrder((Order)order).ifPresent(rpcOrder -> requestBuilder.addOrder(rpcOrder));
                    }
                    catch (Exception e) {
                        PlatformServices.handleException((Object)((Object)TradeRpcClient.this), (String)("Unable to send " + order), (Throwable)e);
                    }
                }
                TradeRpc.SendOrderRequest sendOrderRequest = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), sendOrderRequest});
                TradeRpc.SendOrderResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).sendOrders(sendOrderRequest);
                ArrayList<SendOrderResponse> results = new ArrayList<SendOrderResponse>();
                for (TradeRpc.OrderResponse rpcResponse : response.getOrderResponseList()) {
                    SendOrderResponse orderResponse = new SendOrderResponse();
                    orderResponse.setOrderId(rpcResponse.getOrderid() == null ? null : new OrderID(rpcResponse.getOrderid()));
                    results.add(orderResponse);
                }
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} returning {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), results});
                return results;
            }
        });
    }

    public void addReport(final HasFIXMessage inReport, final BrokerID inBrokerID) {
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TradeRpc.AddReportRequest.Builder requestBuilder = TradeRpc.AddReportRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                requestBuilder.setBrokerId(inBrokerID.getValue());
                requestBuilder.setMessage(TradeRpcUtil.getRpcFixMessage((Message)inReport.getMessage()));
                TradeRpc.AddReportRequest request = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), request});
                TradeRpc.AddReportResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).addReport(request);
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} received {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), response});
                return null;
            }
        });
    }

    public void deleteReport(final ReportID inReportId) {
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TradeRpc.DeleteReportRequest.Builder requestBuilder = TradeRpc.DeleteReportRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                requestBuilder.setReportId(String.valueOf(inReportId.longValue()));
                TradeRpc.DeleteReportRequest request = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), request});
                TradeRpc.DeleteReportResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).deleteReport(request);
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} received {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), response});
                return null;
            }
        });
    }

    public List<ActiveFixSession> readAvailableFixInitiatorSessions() {
        return (List)this.executeCall(new Callable<List<ActiveFixSession>>(){

            @Override
            public List<ActiveFixSession> call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} read available FIX initiator sessions", (Object[])new Object[]{TradeRpcClient.this.getSessionId()});
                TradeRpc.ReadAvailableFixInitiatorSessionsRequest.Builder requestBuilder = TradeRpc.ReadAvailableFixInitiatorSessionsRequest.newBuilder();
                requestBuilder.setSessionId(TradeRpcClient.this.getSessionId().getValue());
                TradeRpc.ReadAvailableFixInitiatorSessionsRequest request = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), request});
                TradeRpc.ReadAvailableFixInitiatorSessionsResponse response = ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)TradeRpcClient.this.getBlockingStub()).readAvailableFixInitiatorSessions(request);
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} received {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), response});
                ArrayList results = Lists.newArrayList();
                for (FixAdminRpc.ActiveFixSession rpcFixSession : response.getFixSessionList()) {
                    FixRpcUtil.getActiveFixSession((FixAdminRpc.ActiveFixSession)rpcFixSession, (MutableActiveFixSessionFactory)TradeRpcClient.this.activeFixSessionFactory, (MutableFixSessionFactory)TradeRpcClient.this.fixSessionFactory, (ClusterDataFactory)TradeRpcClient.this.clusterDataFactory).ifPresent(activeFixSession -> results.add(activeFixSession));
                }
                SLF4JLoggerProxy.trace((Object)((Object)TradeRpcClient.this), (String)"{} returning {}", (Object[])new Object[]{TradeRpcClient.this.getSessionId(), results});
                return results;
            }
        });
    }

    public Collection<String> getOptionRoots(String inUnderlying) {
        throw new UnsupportedOperationException();
    }

    public String getUnderlying(String inOptionRoot) {
        throw new UnsupportedOperationException();
    }

    public ClusterDataFactory getClusterDataFactory() {
        return this.clusterDataFactory;
    }

    public void setClusterDataFactory(ClusterDataFactory inClusterDataFactory) {
        this.clusterDataFactory = inClusterDataFactory;
    }

    public MutableActiveFixSessionFactory getActiveFixSessionFactory() {
        return this.activeFixSessionFactory;
    }

    public void setActiveFixSessionFactory(MutableActiveFixSessionFactory inActiveFixSessionFactory) {
        this.activeFixSessionFactory = inActiveFixSessionFactory;
    }

    public MutableFixSessionFactory getFixSessionFactory() {
        return this.fixSessionFactory;
    }

    public void setFixSessionFactory(MutableFixSessionFactory inFixSessionFactory) {
        this.fixSessionFactory = inFixSessionFactory;
    }

    public MutableOrderSummaryFactory getOrderSummaryFactory() {
        return this.orderSummaryFactory;
    }

    public void setOrderSummaryFactory(MutableOrderSummaryFactory inOrderSummaryFactory) {
        this.orderSummaryFactory = inOrderSummaryFactory;
    }

    public UserFactory getUserFactory() {
        return this.userFactory;
    }

    public void setUserFactory(UserFactory inUserFactory) {
        this.userFactory = inUserFactory;
    }

    public MutableReportFactory getReportFactory() {
        return this.reportFactory;
    }

    public void setReportFactory(MutableReportFactory inReportFactory) {
        this.reportFactory = inReportFactory;
    }

    public MutableExecutionReportSummaryFactory getExecutionReportSummaryFactory() {
        return this.executionReportSummaryFactory;
    }

    public void setExecutionReportSummaryFactory(MutableExecutionReportSummaryFactory inExecutionReportSummaryFactory) {
        this.executionReportSummaryFactory = inExecutionReportSummaryFactory;
    }

    public AverageFillPriceFactory getAverageFillPriceFactory() {
        return this.averageFillPriceFactory;
    }

    public void setAverageFillPriceFactory(AverageFillPriceFactory inAverageFillPriceFactory) {
        this.averageFillPriceFactory = inAverageFillPriceFactory;
    }

    public TradeRpcClient(TradeRpcClientParameters inParameters) {
        super((RpcClientParameters)inParameters);
    }

    protected TradeRpcServiceGrpc.TradeRpcServiceBlockingStub getBlockingStub(Channel inChannel) {
        return TradeRpcServiceGrpc.newBlockingStub((Channel)inChannel);
    }

    protected TradeRpcServiceGrpc.TradeRpcServiceStub getAsyncStub(Channel inChannel) {
        return TradeRpcServiceGrpc.newStub((Channel)inChannel);
    }

    protected BaseRpc.LoginResponse executeLogin(BaseRpc.LoginRequest inRequest) {
        return ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)this.getBlockingStub()).login(inRequest);
    }

    protected BaseRpc.LogoutResponse executeLogout(BaseRpc.LogoutRequest inRequest) {
        return ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)this.getBlockingStub()).logout(inRequest);
    }

    protected BaseRpc.HeartbeatResponse executeHeartbeat(BaseRpc.HeartbeatRequest inRequest) {
        return ((TradeRpcServiceGrpc.TradeRpcServiceBlockingStub)this.getBlockingStub()).heartbeat(inRequest);
    }

    protected AppId getAppId() {
        return APP_ID;
    }

    protected VersionInfo getVersionInfo() {
        return APP_ID_VERSION;
    }

    private static BaseRpcUtil.AbstractClientListenerProxy<?, ?, ?> getListenerFor(Object inListener) {
        if (inListener instanceof TradeMessageListener) {
            return new TradeMessageListenerProxy((TradeMessageListener)inListener);
        }
        if (inListener instanceof SuggestionListener) {
            return new SuggestionListenerProxy((SuggestionListener)inListener);
        }
        throw new UnsupportedOperationException();
    }

    private static class SuggestionListenerProxy
    extends BaseRpcUtil.AbstractClientListenerProxy<TradeRpc.SuggestionListenerResponse, Suggestion, SuggestionListener> {
        protected Suggestion translateMessage(TradeRpc.SuggestionListenerResponse inResponse) {
            return TradeRpcUtil.getSuggestion((TradeRpc.SuggestionListenerResponse)inResponse);
        }

        protected void sendMessage(SuggestionListener inMessageListener, Suggestion inMessage) {
            inMessageListener.receiveSuggestion(inMessage);
        }

        protected SuggestionListenerProxy(SuggestionListener inSuggestionListener) {
            super((Object)inSuggestionListener);
        }
    }

    private static class TradeMessageListenerProxy
    extends BaseRpcUtil.AbstractClientListenerProxy<TradeRpc.TradeMessageListenerResponse, TradeMessage, TradeMessageListener> {
        protected TradeMessage translateMessage(TradeRpc.TradeMessageListenerResponse inResponse) {
            return TradeRpcUtil.getTradeMessage((TradeRpc.TradeMessageListenerResponse)inResponse);
        }

        protected void sendMessage(TradeMessageListener inMessageListener, TradeMessage inMessage) {
            inMessageListener.receiveTradeMessage(inMessage);
        }

        protected TradeMessageListenerProxy(TradeMessageListener inTradeMessageListener) {
            super((Object)inTradeMessageListener);
        }
    }
}

