/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.test;

import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.util.test.LogTestAssist;
import org.marketcetera.util.test.LogTestBase;
import org.marketcetera.util.test.MemoryAppender;

public class LogTestAssistTest
extends LogTestBase {
    private static final String TEST_LOCATION = LogTestAssistTest.class.getName();
    private LogTestAssist mAssist;

    @Override
    protected void setDefaultLevel(Level level) {
        LogTestAssist.setDefaultLevel((Level)level);
    }

    @Override
    protected void setLevel(String name, Level level) {
        LogTestAssist.setLevel((String)name, (Level)level);
    }

    @Override
    protected void assertEvent(LoggingEvent event, Level level, String logger, String message, String location) {
        LogTestAssist.assertEvent((LoggingEvent)event, (Level)level, (String)logger, (String)message, (String)location);
    }

    @Override
    protected MemoryAppender getAppender() {
        return this.getAssist().getAppender();
    }

    @Override
    protected void assertEventCount(int count) {
        this.getAssist().assertEventCount(count);
    }

    @Override
    protected void assertNoEvents() {
        this.getAssist().assertNoEvents();
    }

    @Override
    protected void assertLastEvent(Level level, String category, String message, String location) {
        this.getAssist().assertLastEvent(level, category, message, location);
    }

    @Override
    protected void assertSomeEvent(Level level, String category, String message, String location) {
        this.getAssist().assertSomeEvent(level, category, message, location);
    }

    @Override
    protected void assertSingleEvent(Level level, String category, String message, String location) {
        this.getAssist().assertSingleEvent(level, category, message, location);
    }

    private LogTestAssist getAssist() {
        return this.mAssist;
    }

    private void trackLogger(String name, Level level) {
        this.getAssist().trackLogger(name, level);
    }

    private void trackLogger(String name) {
        this.getAssist().trackLogger(name);
    }

    private void resetAppender() {
        this.getAssist().resetAppender();
    }

    private String getEventsAsString() {
        return this.getAssist().getEventsAsString();
    }

    @Before
    public void setupLogTestAssistTest() {
        this.mAssist = new LogTestAssist();
        BasicConfigurator.configure((Appender)this.getAppender());
    }

    @Test
    public void normalConstructor() {
        String c1 = LogTestAssistTest.getNextTestCategory();
        String c2 = LogTestAssistTest.getNextTestCategory();
        this.mAssist = new LogTestAssist(c1, Level.ERROR);
        Logger.getLogger((String)c1).warn((Object)"Test message (expected)");
        Assert.assertEquals((long)0L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c1).error((Object)"Test message (expected)");
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c2).error((Object)"Test message (expected)");
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
    }

    @Test
    public void noLevelConstructor() {
        String c1 = LogTestAssistTest.getNextTestCategory();
        String c2 = LogTestAssistTest.getNextTestCategory();
        this.mAssist = new LogTestAssist(c1);
        Logger.getLogger((String)c1).warn((Object)"Test message (expected)");
        Assert.assertEquals((long)0L, (long)this.getAppender().getEvents().size());
        this.setDefaultLevel(Level.WARN);
        Logger.getLogger((String)c1).warn((Object)"Test message (expected)");
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c1).info((Object)"Test message (expected)");
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        this.setLevel(c1, Level.ERROR);
        Logger.getLogger((String)c1).error((Object)"Test message (expected)");
        Assert.assertEquals((long)2L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c1).warn((Object)"Test message (expected)");
        Assert.assertEquals((long)2L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c2).error((Object)"Test message (expected)");
        Assert.assertEquals((long)2L, (long)this.getAppender().getEvents().size());
    }

    @Test
    public void defaultConstructor() {
        String c1 = LogTestAssistTest.getNextTestCategory();
        String c2 = LogTestAssistTest.getNextTestCategory();
        Logger.getLogger((String)c1).error((Object)"Test message (expected)");
        Assert.assertEquals((long)0L, (long)this.getAppender().getEvents().size());
        this.setLevel(c1, Level.ERROR);
        Logger.getLogger((String)c1).error((Object)"Test message (expected)");
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c1).warn((Object)"Test message (expected)");
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c2).error((Object)"Test message (expected)");
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
    }

    @Test
    public void untrackedCategory() {
        String c = LogTestAssistTest.getNextTestCategory();
        Logger.getRootLogger().removeAppender((Appender)this.getAppender());
        Logger.getLogger((String)c).error((Object)"Test message (expected)");
        Assert.assertEquals((long)0L, (long)this.getAppender().getEvents().size());
    }

    @Test
    public void categoryTrack() {
        String c1 = LogTestAssistTest.getNextTestCategory();
        String c2 = LogTestAssistTest.getNextTestCategory();
        String c3 = LogTestAssistTest.getNextTestCategory();
        String c4 = LogTestAssistTest.getNextTestCategory();
        Logger.getRootLogger().removeAppender((Appender)this.getAppender());
        Logger.getLogger((String)c1).error((Object)"Test message (expected)");
        Logger.getLogger((String)c2).info((Object)"Test message (expected)");
        Assert.assertEquals((long)0L, (long)this.getAppender().getEvents().size());
        this.trackLogger(c2, Level.ERROR);
        Logger.getLogger((String)c2).error((Object)"Test message (expected)");
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c1).info((Object)"Test message (expected)");
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c3).warn((Object)"Test message (expected)");
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        this.trackLogger(c3, Level.WARN);
        Logger.getLogger((String)c2).error((Object)"Test message (expected)");
        Assert.assertEquals((long)2L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c3).error((Object)"Test message (expected)");
        Assert.assertEquals((long)3L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c1).warn((Object)"Test message (expected)");
        Assert.assertEquals((long)3L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c3).info((Object)"Test message (expected)");
        Assert.assertEquals((long)3L, (long)this.getAppender().getEvents().size());
        this.setDefaultLevel(Level.INFO);
        this.trackLogger(c4);
        Logger.getLogger((String)c2).error((Object)"Test message (expected)");
        Assert.assertEquals((long)4L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c3).warn((Object)"Test message (expected)");
        Assert.assertEquals((long)5L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c3).info((Object)"Test message (expected)");
        Assert.assertEquals((long)5L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c4).info((Object)"Test message (expected)");
        Assert.assertEquals((long)6L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c4).debug((Object)"Test message (expected)");
        Assert.assertEquals((long)6L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c1).warn((Object)"Test message (expected)");
        Assert.assertEquals((long)6L, (long)this.getAppender().getEvents().size());
    }

    @Test
    public void appenderReset() {
        String c = LogTestAssistTest.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)"Test message (expected)");
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        this.resetAppender();
        Assert.assertEquals((long)0L, (long)this.getAppender().getEvents().size());
    }

    @Test
    public void noEventsAsString() {
        Assert.assertEquals((Object)"Event count: 0", (Object)this.getEventsAsString());
    }

    @Test
    public void twoEventsAsString() {
        String c = LogTestAssistTest.getNextTestCategory();
        this.setLevel(c, Level.INFO);
        Logger.getLogger((String)c).info((Object)"Test message (expected)");
        Logger.getLogger((String)c).warn((Object)"Test message (expected)");
        Assert.assertEquals((Object)("Event count: 2" + SystemUtils.LINE_SEPARATOR + "Event 0: level: INFO" + "; logger: " + c + "; message: " + "Test message (expected)" + "; location: " + TEST_LOCATION + SystemUtils.LINE_SEPARATOR + "Event 1: level: WARN" + "; logger: " + c + "; message: " + "Test message (expected)" + "; location: " + TEST_LOCATION), (Object)this.getEventsAsString());
    }
}

