/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.test;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.util.test.MemoryAppender;

public abstract class LogTestBase {
    protected static final String TEST_MESSAGE = "Test message (expected)";
    private static final String TEST_CATEGORY_PREFIX = "TestCategory";
    private static final String TEST_LOCATION = LogTestBase.class.getName();
    private static int sNexttTextCategory = 0;

    protected abstract void setDefaultLevel(Level var1);

    protected abstract void setLevel(String var1, Level var2);

    protected abstract void assertEvent(LoggingEvent var1, Level var2, String var3, String var4, String var5);

    protected abstract MemoryAppender getAppender();

    protected abstract void assertEventCount(int var1);

    protected abstract void assertNoEvents();

    protected abstract void assertLastEvent(Level var1, String var2, String var3, String var4);

    protected abstract void assertSomeEvent(Level var1, String var2, String var3, String var4);

    protected abstract void assertSingleEvent(Level var1, String var2, String var3, String var4);

    protected static String getNextTestCategory() {
        return TEST_CATEGORY_PREFIX + sNexttTextCategory++;
    }

    @Before
    public void setupLogTestBase() {
        Logger.getRootLogger().setLevel(Level.OFF);
    }

    @Test
    public void defaultLevelSetting() {
        String c = LogTestBase.getNextTestCategory();
        Assert.assertEquals((Object)Level.OFF, (Object)Logger.getRootLogger().getLevel());
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        Assert.assertEquals((long)0L, (long)this.getAppender().getEvents().size());
        this.setDefaultLevel(Level.WARN);
        Assert.assertEquals((Object)Level.WARN, (Object)Logger.getRootLogger().getLevel());
        Logger.getLogger((String)c).info((Object)TEST_MESSAGE);
        Assert.assertEquals((long)0L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c).warn((Object)TEST_MESSAGE);
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        Assert.assertEquals((long)2L, (long)this.getAppender().getEvents().size());
        this.setDefaultLevel(Level.OFF);
        Assert.assertEquals((Object)Level.OFF, (Object)Logger.getRootLogger().getLevel());
        Logger.getLogger((String)c).warn((Object)TEST_MESSAGE);
        Assert.assertEquals((long)2L, (long)this.getAppender().getEvents().size());
    }

    @Test
    public void levelSetting() {
        String c = LogTestBase.getNextTestCategory();
        Logger.getLogger((String)c).warn((Object)TEST_MESSAGE);
        Assert.assertEquals((long)0L, (long)this.getAppender().getEvents().size());
        this.setLevel(c, Level.WARN);
        Logger.getLogger((String)c).info((Object)TEST_MESSAGE);
        Assert.assertEquals((long)0L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c).warn((Object)TEST_MESSAGE);
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
    }

    @Test
    public void eventCorrect() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        LoggingEvent event = (LoggingEvent)this.getAppender().getEvents().getLast();
        this.assertEvent(event, Level.ERROR, c, TEST_MESSAGE, TEST_LOCATION);
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        this.assertEvent(event, null, c, TEST_MESSAGE, TEST_LOCATION);
        this.assertEvent(event, Level.ERROR, null, TEST_MESSAGE, TEST_LOCATION);
        this.assertEvent(event, Level.ERROR, c, null, TEST_LOCATION);
        this.assertEvent(event, Level.ERROR, c, TEST_MESSAGE, null);
    }

    @Test(expected=AssertionError.class)
    public void eventIncorrectLevel() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertEvent((LoggingEvent)this.getAppender().getEvents().getLast(), Level.WARN, c, TEST_MESSAGE, TEST_LOCATION);
    }

    @Test(expected=AssertionError.class)
    public void eventIncorrectName() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertEvent((LoggingEvent)this.getAppender().getEvents().getLast(), Level.ERROR, "", TEST_MESSAGE, TEST_LOCATION);
    }

    @Test(expected=AssertionError.class)
    public void eventIncorrectMessage() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertEvent((LoggingEvent)this.getAppender().getEvents().getLast(), Level.ERROR, c, "", TEST_LOCATION);
    }

    @Test(expected=AssertionError.class)
    public void eventIncorrectLocation() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertEvent((LoggingEvent)this.getAppender().getEvents().getLast(), Level.ERROR, c, TEST_MESSAGE, "");
    }

    @Test
    public void appenderIsValid() {
        Assert.assertNotNull((Object)this.getAppender());
    }

    @Test
    public void twoEvents() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.INFO);
        Logger.getLogger((String)c).debug((Object)TEST_MESSAGE);
        Logger.getLogger((String)c).info((Object)TEST_MESSAGE);
        Logger.getLogger((String)c).warn((Object)TEST_MESSAGE);
        this.assertEventCount(2);
    }

    @Test(expected=AssertionError.class)
    public void miscountedEvents() {
        this.assertEventCount(1);
    }

    @Test
    public void noEvents() {
        String c = LogTestBase.getNextTestCategory();
        this.assertNoEvents();
        Logger.getLogger((String)c).info((Object)TEST_MESSAGE);
        this.assertNoEvents();
    }

    @Test(expected=AssertionError.class)
    public void someEvents() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertNoEvents();
    }

    @Test
    public void lastEventCorrect() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertLastEvent(Level.ERROR, c, TEST_MESSAGE, TEST_LOCATION);
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        this.setLevel(c, Level.INFO);
        Logger.getLogger((String)c).info((Object)TEST_MESSAGE);
        this.assertLastEvent(Level.INFO, c, TEST_MESSAGE, TEST_LOCATION);
        Assert.assertEquals((long)2L, (long)this.getAppender().getEvents().size());
        this.assertLastEvent(null, c, TEST_MESSAGE, TEST_LOCATION);
        this.assertLastEvent(Level.INFO, null, TEST_MESSAGE, TEST_LOCATION);
        this.assertLastEvent(Level.INFO, c, null, TEST_LOCATION);
        this.assertLastEvent(Level.INFO, c, TEST_MESSAGE, null);
    }

    @Test(expected=AssertionError.class)
    public void noLastMatchingIncorrectLevel() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertLastEvent(Level.WARN, c, TEST_MESSAGE, TEST_LOCATION);
    }

    @Test(expected=AssertionError.class)
    public void noLastMatchingIncorrectName() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertLastEvent(Level.ERROR, "", TEST_MESSAGE, TEST_LOCATION);
    }

    @Test(expected=AssertionError.class)
    public void noLastMatchingIncorrectMessage() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertLastEvent(Level.ERROR, c, "", TEST_LOCATION);
    }

    @Test(expected=AssertionError.class)
    public void noLastMatchingIncorrectLocation() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertLastEvent(Level.ERROR, c, TEST_MESSAGE, "");
    }

    @Test(expected=AssertionError.class)
    public void noLastEvent() {
        String c = LogTestBase.getNextTestCategory();
        this.assertLastEvent(Level.ERROR, c, TEST_MESSAGE, TEST_LOCATION);
    }

    @Test
    public void someEventCorrect() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertSomeEvent(Level.ERROR, c, TEST_MESSAGE, TEST_LOCATION);
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        this.setLevel(c, Level.INFO);
        Logger.getLogger((String)c).info((Object)TEST_MESSAGE);
        this.assertSomeEvent(Level.ERROR, c, TEST_MESSAGE, TEST_LOCATION);
        this.assertSomeEvent(Level.INFO, c, TEST_MESSAGE, TEST_LOCATION);
        Assert.assertEquals((long)2L, (long)this.getAppender().getEvents().size());
        this.assertSomeEvent(null, c, TEST_MESSAGE, TEST_LOCATION);
        this.assertSomeEvent(Level.INFO, null, TEST_MESSAGE, TEST_LOCATION);
        this.assertSomeEvent(Level.INFO, c, null, TEST_LOCATION);
        this.assertSomeEvent(Level.INFO, c, TEST_MESSAGE, null);
    }

    @Test(expected=AssertionError.class)
    public void noSomeMatchingIncorrectLevel() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertSomeEvent(Level.WARN, c, TEST_MESSAGE, TEST_LOCATION);
    }

    @Test(expected=AssertionError.class)
    public void noSomeMatchingIncorrectName() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertSomeEvent(Level.ERROR, "", TEST_MESSAGE, TEST_LOCATION);
    }

    @Test(expected=AssertionError.class)
    public void noSomeMatchingIncorrectMessage() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertSomeEvent(Level.ERROR, c, "", TEST_LOCATION);
    }

    @Test(expected=AssertionError.class)
    public void noSomeMatchingIncorrectLocation() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertSomeEvent(Level.ERROR, c, TEST_MESSAGE, "");
    }

    @Test(expected=AssertionError.class)
    public void noSomeEvent() {
        this.assertSomeEvent(null, null, null, null);
    }

    @Test
    public void singleEventCorrect() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.WARN);
        Logger.getLogger((String)c).warn((Object)TEST_MESSAGE);
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        this.assertSingleEvent(Level.WARN, c, TEST_MESSAGE, TEST_LOCATION);
        Assert.assertEquals((long)0L, (long)this.getAppender().getEvents().size());
        this.setLevel(c, Level.INFO);
        Logger.getLogger((String)c).info((Object)TEST_MESSAGE);
        Assert.assertEquals((long)1L, (long)this.getAppender().getEvents().size());
        this.assertSingleEvent(Level.INFO, c, TEST_MESSAGE, TEST_LOCATION);
        Assert.assertEquals((long)0L, (long)this.getAppender().getEvents().size());
        Logger.getLogger((String)c).info((Object)TEST_MESSAGE);
        this.assertSingleEvent(null, c, TEST_MESSAGE, TEST_LOCATION);
        Logger.getLogger((String)c).info((Object)TEST_MESSAGE);
        this.assertSingleEvent(Level.INFO, null, TEST_MESSAGE, TEST_LOCATION);
        Logger.getLogger((String)c).info((Object)TEST_MESSAGE);
        this.assertSingleEvent(Level.INFO, c, null, TEST_LOCATION);
        Logger.getLogger((String)c).info((Object)TEST_MESSAGE);
        this.assertSingleEvent(Level.INFO, c, TEST_MESSAGE, null);
    }

    @Test(expected=AssertionError.class)
    public void noSingleMatchingIncorrectLevel() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertSingleEvent(Level.WARN, c, TEST_MESSAGE, TEST_LOCATION);
    }

    @Test(expected=AssertionError.class)
    public void noSingleMatchingIncorrectName() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertSingleEvent(Level.ERROR, "", TEST_MESSAGE, TEST_LOCATION);
    }

    @Test(expected=AssertionError.class)
    public void noSingleMatchingIncorrectMessage() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertSingleEvent(Level.ERROR, c, "", TEST_LOCATION);
    }

    @Test(expected=AssertionError.class)
    public void noSingleMatchingIncorrectLocation() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.ERROR);
        Logger.getLogger((String)c).error((Object)TEST_MESSAGE);
        this.assertSingleEvent(Level.ERROR, c, TEST_MESSAGE, "");
    }

    @Test(expected=AssertionError.class)
    public void noSingleEvent() {
        String c = LogTestBase.getNextTestCategory();
        this.assertSingleEvent(Level.ERROR, c, TEST_MESSAGE, TEST_LOCATION);
    }

    @Test(expected=AssertionError.class)
    public void tooManyEvents() {
        String c = LogTestBase.getNextTestCategory();
        this.setLevel(c, Level.INFO);
        Logger.getLogger((String)c).warn((Object)TEST_MESSAGE);
        Logger.getLogger((String)c).info((Object)TEST_MESSAGE);
        this.assertSingleEvent(Level.INFO, c, TEST_MESSAGE, TEST_LOCATION);
    }
}

