/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.test;

import java.util.LinkedList;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.MemoryAppender;

public class MemoryAppenderTest {
    private static final String TEST_CATEGORY = "TestCategory";
    private static final String TEST_MESSAGE = "Test message (expected)";
    private static final String TEST_LOCATION = MemoryAppenderTest.class.getName();

    @Test
    public void appenderStoresMessages() {
        MemoryAppender appender = new MemoryAppender();
        BasicConfigurator.configure((Appender)appender);
        Logger logger = Logger.getLogger((String)TEST_CATEGORY);
        logger.setLevel(Level.ERROR);
        logger.error((Object)TEST_MESSAGE);
        LinkedList events = appender.getEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        LoggingEvent event = (LoggingEvent)events.getFirst();
        Assert.assertEquals((Object)Level.ERROR, (Object)event.getLevel());
        Assert.assertEquals((Object)TEST_CATEGORY, (Object)event.getLoggerName());
        Assert.assertEquals((Object)TEST_MESSAGE, (Object)event.getMessage());
        Assert.assertEquals((Object)TEST_LOCATION, (Object)event.getLocationInformation().getClassName());
        appender.clear();
        Assert.assertEquals((long)0L, (long)events.size());
        logger.error((Object)TEST_MESSAGE);
        Assert.assertEquals((long)1L, (long)appender.getEvents().size());
    }
}

