/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.test;

import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.RegExAssert;

public class RegExAssertTest {
    @Test
    public void match() {
        RegExAssert.assertMatches((String)".*ab.*", (String)"zabc");
        RegExAssert.assertMatches((String)"(?s).*ab.*", (String)"zabc\n");
        RegExAssert.assertMatches(null, null);
    }

    @Test
    public void patternNull() {
        try {
            RegExAssert.assertMatches(null, (String)"a");
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"pattern is null and does not match 'a'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void actualNull() {
        try {
            RegExAssert.assertMatches((String)"a", null);
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"pattern 'a' does not match null", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void mismatch() {
        try {
            RegExAssert.assertMatches((String)"a", (String)"b");
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"pattern 'a' does not match 'b'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void message() {
        try {
            RegExAssert.assertMatches((String)"Right now,", (String)"a", (String)"b");
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"Right now, pattern 'a' does not match 'b'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }
}

