/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.test;

import java.util.Arrays;
import org.apache.commons.collections.bag.HashBag;
import org.junit.Assert;

public final class CollectionAssert {
    public static <T> void assertArrayPermutation(String message, T[] expected, T[] actual) {
        if (expected == null && actual == null) {
            return;
        }
        String content = null;
        if (expected == null) {
            content = "expected array is null but actual is not";
        } else if (actual == null) {
            content = "actual array is null but expected is not";
        } else if (expected.getClass() != actual.getClass()) {
            content = "expected array class is " + expected.getClass().getName() + " but actual array class is " + actual.getClass().getName();
        } else {
            HashBag expectedBag = new HashBag(Arrays.asList(expected));
            HashBag actualBag = new HashBag(Arrays.asList(actual));
            for (Object e : expectedBag) {
                if (actualBag.remove(e, 1)) continue;
                content = "actual is missing '" + e + "'";
                break;
            }
            if (content == null) {
                if (actualBag.size() == 0) {
                    return;
                }
                content = "actual contains extra elements such as " + actualBag.iterator().next();
            }
        }
        if (message != null) {
            content = message + " " + content;
        }
        Assert.fail((String)content);
    }

    public static <T> void assertArrayPermutation(T[] expected, T[] actual) {
        CollectionAssert.assertArrayPermutation(null, expected, actual);
    }

    private CollectionAssert() {
    }
}

