/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.test;

import java.util.NoSuchElementException;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.marketcetera.util.test.MemoryAppender;

public class LogTestAssist {
    private final MemoryAppender mAppender = new MemoryAppender();

    public LogTestAssist(String name, Level level) {
        this.trackLogger(name, level);
    }

    public LogTestAssist(String name) {
        this(name, null);
    }

    public LogTestAssist() {
    }

    public static void setDefaultLevel(Level level) {
        Logger.getRootLogger().setLevel(level);
    }

    public static void setLevel(String name, Level level) {
        Logger.getLogger((String)name).setLevel(level);
    }

    public static void assertEvent(LoggingEvent event, Level level, String logger, String message, String location) {
        if (level != null) {
            Assert.assertEquals((Object)level, (Object)event.getLevel());
        }
        if (logger != null) {
            Assert.assertEquals((Object)logger, (Object)event.getLoggerName());
        }
        if (message != null) {
            Assert.assertEquals((Object)message, (Object)event.getMessage());
        }
        if (location != null) {
            Assert.assertEquals((Object)location, (Object)event.getLocationInformation().getClassName());
        }
    }

    public void trackLogger(String name, Level level) {
        Logger logger = Logger.getLogger((String)name);
        logger.addAppender((Appender)this.getAppender());
        if (level != null) {
            logger.setLevel(level);
        }
    }

    public void trackLogger(String name) {
        this.trackLogger(name, null);
    }

    public void resetAppender() {
        this.getAppender().clear();
    }

    public String getEventsAsString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Event count: ");
        builder.append(this.getAppender().getEvents().size());
        int i = 0;
        for (LoggingEvent event : this.getAppender().getEvents()) {
            builder.append(SystemUtils.LINE_SEPARATOR);
            builder.append("Event ");
            builder.append(i++);
            builder.append(": level: ");
            builder.append(event.getLevel());
            builder.append("; logger: ");
            builder.append(event.getLoggerName());
            builder.append("; message: ");
            builder.append(event.getMessage());
            builder.append("; location: ");
            builder.append(event.getLocationInformation().getClassName());
        }
        return builder.toString();
    }

    public MemoryAppender getAppender() {
        return this.mAppender;
    }

    public void assertEventCount(int count) {
        if (this.getAppender().getEvents().size() == count) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Incorrect event count; expected ");
        builder.append(count);
        builder.append(" actual ");
        builder.append(SystemUtils.LINE_SEPARATOR);
        builder.append(this.getEventsAsString());
        Assert.fail((String)builder.toString());
    }

    public void assertNoEvents() {
        this.assertEventCount(0);
    }

    public void assertLastEvent(Level level, String logger, String message, String location) {
        LoggingEvent event = null;
        try {
            event = this.getAppender().getEvents().getLast();
        }
        catch (NoSuchElementException ex) {
            Assert.fail((String)"List is empty");
        }
        LogTestAssist.assertEvent(event, level, logger, message, location);
    }

    public void assertSomeEvent(Level level, String logger, String message, String location) {
        for (LoggingEvent event : this.getAppender().getEvents()) {
            if (level != null && !level.equals((Object)event.getLevel()) || logger != null && !logger.equals(event.getLoggerName()) || message != null && !message.equals(event.getMessage()) || location != null && !location.equals(event.getLocationInformation().getClassName())) continue;
            return;
        }
        Assert.fail((String)("No matches against given event. Events are:" + SystemUtils.LINE_SEPARATOR + this.getEventsAsString()));
    }

    public void assertSingleEvent(Level level, String logger, String message, String location) {
        this.assertEventCount(1);
        this.assertLastEvent(level, logger, message, location);
        this.resetAppender();
    }
}

