/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.test;

import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Before;
import org.marketcetera.util.test.LogTestAssist;
import org.marketcetera.util.test.MemoryAppender;

public class TestCaseBase {
    protected static final String DIR_ROOT = "src" + File.separator + "test" + File.separator + "sample_data";
    protected static final String DIR_TARGET = "target";
    protected static final String DIR_CLASSES = "target" + File.separator + "classes";
    protected static final String DIR_TEST_CLASSES = "target" + File.separator + "test-classes";
    private LogTestAssist mLogAssist;

    protected static void setDefaultLevel(Level level) {
        LogTestAssist.setDefaultLevel(level);
    }

    protected static void setLevel(String name, Level level) {
        LogTestAssist.setLevel(name, level);
    }

    protected static void assertEvent(LoggingEvent event, Level level, String logger, String message, String location) {
        LogTestAssist.assertEvent(event, level, logger, message, location);
    }

    @Before
    public void setupTestCaseBase() {
        this.mLogAssist = new LogTestAssist();
        BasicConfigurator.configure((Appender)this.getAppender());
    }

    protected LogTestAssist getLogAssist() {
        return this.mLogAssist;
    }

    protected MemoryAppender getAppender() {
        return this.getLogAssist().getAppender();
    }

    protected void assertEventCount(int count) {
        this.getLogAssist().assertEventCount(count);
    }

    protected void assertNoEvents() {
        this.getLogAssist().assertNoEvents();
    }

    protected void assertLastEvent(Level level, String logger, String message, String location) {
        this.getLogAssist().assertLastEvent(level, logger, message, location);
    }

    protected void assertSomeEvent(Level level, String logger, String message, String location) {
        this.getLogAssist().assertSomeEvent(level, logger, message, location);
    }

    protected void assertSingleEvent(Level level, String logger, String message, String location) {
        this.getLogAssist().assertSingleEvent(level, logger, message, location);
    }
}

