/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.test;

import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.CollectionAssert;

public class CollectionAssertTest {
    @Test
    public void equal() {
        CollectionAssert.assertArrayPermutation(null, null);
        CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])ArrayUtils.EMPTY_STRING_ARRAY);
        CollectionAssert.assertArrayPermutation((Object[])new Integer[]{1}, (Object[])new Integer[]{1});
        CollectionAssert.assertArrayPermutation((Object[])new Integer[]{1, null}, (Object[])new Integer[]{null, 1});
        CollectionAssert.assertArrayPermutation((Object[])new Integer[]{null, null}, (Object[])new Integer[]{null, null});
        CollectionAssert.assertArrayPermutation((Object[])new Long[]{1L, 2L, 1L}, (Object[])new Long[]{1L, 1L, 2L});
    }

    @Test
    public void expectedNull() {
        try {
            CollectionAssert.assertArrayPermutation(null, (Object[])ArrayUtils.EMPTY_STRING_ARRAY);
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"expected array is null but actual is not", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void actualNull() {
        try {
            CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.EMPTY_STRING_ARRAY, null);
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"actual array is null but expected is not", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void differentClass() {
        try {
            CollectionAssert.assertArrayPermutation((Object[])new Number[0], (Object[])new Integer[0]);
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)("expected array class is " + Number[].class.getName() + " but actual array class is " + Integer[].class.getName()), (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void sameLengthDifferentElements() {
        try {
            CollectionAssert.assertArrayPermutation((Object[])new Integer[]{null}, (Object[])new Integer[]{2});
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"actual is missing 'null'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void expectedShorter() {
        try {
            CollectionAssert.assertArrayPermutation((Object[])new Integer[]{1}, (Object[])new Integer[]{1, 1});
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"actual contains extra elements such as 1", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void actualShorter() {
        try {
            CollectionAssert.assertArrayPermutation((Object[])new Integer[]{null, null}, (Object[])new Integer[]{null});
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"actual is missing 'null'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void message() {
        try {
            CollectionAssert.assertArrayPermutation((String)"Right now,", (Object[])new Integer[]{1}, (Object[])new Integer[]{2});
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"Right now, actual is missing '1'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }
}

