/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.test;

import org.apache.commons.lang.math.NumberUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.EqualityAssert;

public class EqualityAssertTest {
    @Test
    public void correct() {
        EqualityAssert.assertEquality((Object)new Correct(0), (Object)new Correct(0), (Object[])new Object[]{new Correct(1), new Correct(2), null});
        EqualityAssert.assertEquality((Object)new Correct(0), (Object)new Correct(0), (Object[])null);
        EqualityAssert.assertEquality((Object)new Correct(0), (int)1, (Object[])new Object[]{new Correct(1), new Correct(0), new Correct(2)});
    }

    @Test
    public void selfUnequals() {
        try {
            EqualityAssert.assertEquality((Object)new SelfUnequals(), (Object)new SelfUnequals(), (Object[])new Object[0]);
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am self' unequal to self", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void copyUnequals() {
        try {
            EqualityAssert.assertEquality((Object)new CopyUnequals(), (Object)new CopyUnequals(), (Object[])new Object[0]);
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am copy' unequal to 'I am copy'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void same() {
        Correct c = new Correct(0);
        try {
            EqualityAssert.assertEquality((Object)c, (Object)c, (Object[])new Object[0]);
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 0' same as 'I am 0'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void noDiff() {
        try {
            EqualityAssert.assertEquality((Object)new Correct(0), (Object)new Correct(0), (Object[])new Object[]{new Correct(0)});
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 0' equal to 'I am 0'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void nullInList() {
        try {
            EqualityAssert.assertEquality((Object)new EqualsNull(0), (Object)new EqualsNull(0), (Object[])new Object[]{null});
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 0' equal to 'null'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void nullIsolated() {
        try {
            EqualityAssert.assertEquality((Object)new EqualsNull(0), (Object)new EqualsNull(0), (Object[])new Object[0]);
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 0' equal to null", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void zero() {
        try {
            EqualityAssert.assertEquality((Object)new EqualsZero(0), (Object)new EqualsZero(0), (Object[])new Object[0]);
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 0' equal to zero", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void badHashCode() {
        try {
            EqualityAssert.assertEquality((Object)new BadHashCode(0), (Object)new BadHashCode(0), (Object[])new Object[0]);
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 0' hash code unequal to copy's 'I am 0'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void arrayIncorrect() {
        try {
            EqualityAssert.assertEquality((Object)new Correct(0), (int)0, (Object[])new Object[]{new Correct(1), new Correct(0), new Correct(2)});
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 0' unequal to 'I am 1'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void message() {
        try {
            EqualityAssert.assertEquality((String)"Right now,", (Object)new SelfUnequals(), (Object)new SelfUnequals(), (Object[])new Object[0]);
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"Right now, 'I am self' unequal to self", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void arrayMessage() {
        try {
            EqualityAssert.assertEquality((String)"Right now,", (Object)new Correct(0), (int)0, (Object[])new Object[]{new Correct(1), new Correct(0), new Correct(2)});
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"Right now, 'I am 0' unequal to 'I am 1'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    private static final class CopyUnequals {
        private CopyUnequals() {
        }

        public String toString() {
            return "I am copy";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object other) {
            return this == other;
        }
    }

    private static final class SelfUnequals {
        private SelfUnequals() {
        }

        public String toString() {
            return "I am self";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object other) {
            return false;
        }
    }

    private static final class EqualsZero
    extends Correct {
        public EqualsZero(int value) {
            super(value);
        }

        @Override
        public boolean equals(Object other) {
            return other == NumberUtils.INTEGER_ZERO || super.equals(other);
        }
    }

    private static final class EqualsNull
    extends Correct {
        public EqualsNull(int value) {
            super(value);
        }

        @Override
        public boolean equals(Object other) {
            return other == null || super.equals(other);
        }
    }

    private static final class BadHashCode
    extends Correct {
        private static int sNextCode = 0;

        public BadHashCode(int value) {
            super(value);
        }

        @Override
        public int hashCode() {
            return sNextCode++;
        }
    }

    private static class Correct {
        private int mValue;

        public Correct(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public String toString() {
            return "I am " + this.getValue();
        }

        public int hashCode() {
            return this.getValue();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !this.getClass().equals(other.getClass())) {
                return false;
            }
            Correct o = (Correct)other;
            return this.getValue() == o.getValue();
        }
    }
}

