/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.test;

import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.ComparableAssert;

public class ComparableAssertTest {
    private static final String TEST_MESSAGE = "testMessage";

    @Test
    public void correct() {
        ComparableAssert.assertComparable((Comparable)new Correct(0), (Comparable)new Correct(0), (Comparable)new Correct(1), (String)TEST_MESSAGE);
        ComparableAssert.assertComparable((Comparable)new Correct(0), (Comparable)new Correct(0), (Comparable)new Correct(1));
    }

    @Test
    public void selfUnequals0() {
        try {
            ComparableAssert.assertComparable((Comparable)new SelfUnequals(0), (Comparable)new Correct(1), (Comparable)new Correct(2));
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 0' unequal to self", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void selfUnequals1() {
        try {
            ComparableAssert.assertComparable((Comparable)new Correct(0), (Comparable)new SelfUnequals(1), (Comparable)new Correct(2));
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 1' unequal to self", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void selfUnequals2() {
        try {
            ComparableAssert.assertComparable((Comparable)new Correct(0), (Comparable)new Correct(1), (Comparable)new SelfUnequals(2));
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 2' unequal to self", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void copyUnequals0() {
        try {
            ComparableAssert.assertComparable((Comparable)new Correct(0), (Comparable)new Correct(1), (Comparable)new Correct(2));
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 0' unequal to 'I am 1'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void copyUnequals1() {
        try {
            ComparableAssert.assertComparable((Comparable)new Correct(0), (Comparable)new CopyUnequals(0), (Comparable)new Correct(2));
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 0' unequal to 'I am 0'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void same() {
        Correct c = new Correct(0);
        try {
            ComparableAssert.assertComparable((Comparable)c, (Comparable)c, (Comparable)c);
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 0' same as 'I am 0'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void noGreater1() {
        try {
            ComparableAssert.assertComparable((Comparable)new Correct(0), (Comparable)new Correct(0), (Comparable)new Correct(0));
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 0' no less than 'I am 0'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void noGreater2() {
        try {
            ComparableAssert.assertComparable((Comparable)new Correct(0), (Comparable)new ReverseIncorrect(0), (Comparable)new Correct(1));
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 0' no less than 'I am 1'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void noLesser1() {
        try {
            ComparableAssert.assertComparable((Comparable)new Correct(0), (Comparable)new Correct(0), (Comparable)new ReverseIncorrect(1));
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 1' no more than 'I am 0'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void noLesser2() {
        try {
            ComparableAssert.assertComparable((Comparable)new ReverseIncorrect(0), (Comparable)new Correct(0), (Comparable)new ReverseIncorrect(1));
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"'I am 1' no more than 'I am 0'", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void badMessage() {
        String expected = "testMessagex";
        try {
            ComparableAssert.assertComparable((Comparable)new Correct(0), (Comparable)new Correct(0), (Comparable)new Correct(1), (String)expected);
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)("expected message '" + expected + "' does not match actual '" + TEST_MESSAGE + "'"), (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void prefix() {
        try {
            ComparableAssert.assertComparable((String)"Right now,", (Comparable)new SelfUnequals(0), (Comparable)new Correct(1), (Comparable)new Correct(2));
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"Right now, 'I am 0' unequal to self", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void prefixBadMessage() {
        String expected = "testMessagex";
        try {
            ComparableAssert.assertComparable((String)"Right now,", (Comparable)new Correct(0), (Comparable)new Correct(0), (Comparable)new Correct(1), (String)expected);
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)("Right now, expected message '" + expected + "' does not match actual '" + TEST_MESSAGE + "'"), (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        Assert.fail();
    }

    private static final class ReverseIncorrect
    extends Correct {
        public ReverseIncorrect(int value) {
            super(value);
        }

        @Override
        public int compareTo(Correct other) {
            if (other == null) {
                throw new NullPointerException(ComparableAssertTest.TEST_MESSAGE);
            }
            if (other instanceof ReverseIncorrect) {
                return this.getValue() - other.getValue();
            }
            return other.getValue() - this.getValue();
        }
    }

    private static final class CopyUnequals
    extends Correct {
        public CopyUnequals(int value) {
            super(value);
        }

        @Override
        public int compareTo(Correct other) {
            return this == other ? 0 : 1;
        }
    }

    private static final class SelfUnequals
    extends Correct {
        public SelfUnequals(int value) {
            super(value);
        }

        @Override
        public int compareTo(Correct other) {
            return 1;
        }
    }

    private static class Correct
    implements Comparable<Correct> {
        private int mValue;

        public Correct(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        @Override
        public int compareTo(Correct other) {
            if (other == null) {
                throw new NullPointerException(ComparableAssertTest.TEST_MESSAGE);
            }
            return this.getValue() - other.getValue();
        }

        public String toString() {
            return "I am " + this.getValue();
        }
    }
}

