/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.test;

import java.io.Serializable;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.SerializationException;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.SerializableAssert;

public class SerializableAssertTest {
    @Test
    public void serializable() {
        SerializableAssert.assertSerializable((Serializable)Integer.valueOf(0));
    }

    @Test
    public void transientData() {
        try {
            SerializableAssert.assertSerializable((Serializable)new TransientData(1));
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"expected object is 'I am 1' actual is 'I am 0'", (Object)((Throwable)((Object)ex)).getMessage());
            Assert.assertNull((Object)((Throwable)((Object)ex)).getCause());
            return;
        }
        Assert.fail();
    }

    @Test
    public void nonSerializable() {
        try {
            SerializableAssert.assertSerializable((Serializable)new NonSerializableClass(new NonSerializableMember(1)));
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"de/serialization failed", (Object)((Throwable)((Object)ex)).getMessage());
            Assert.assertEquals(SerializationException.class, ((Throwable)((Object)ex)).getCause().getClass());
            return;
        }
        Assert.fail();
    }

    @Test
    public void message() {
        try {
            SerializableAssert.assertSerializable((String)"Right now,", (Serializable)new TransientData(1));
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"Right now, expected object is 'I am 1' actual is 'I am 0'", (Object)((Throwable)((Object)ex)).getMessage());
            Assert.assertNull((Object)((Throwable)((Object)ex)).getCause());
            return;
        }
        Assert.fail();
    }

    private static final class NonSerializableClass
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private NonSerializableMember mValue;

        public NonSerializableClass(NonSerializableMember value) {
            this.mValue = value;
        }

        public NonSerializableMember getValue() {
            return this.mValue;
        }

        public String toString() {
            return ObjectUtils.toString((Object)this.getValue());
        }

        public int hashCode() {
            return ObjectUtils.hashCode((Object)this.getValue());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !this.getClass().equals(other.getClass())) {
                return false;
            }
            NonSerializableClass o = (NonSerializableClass)other;
            return ObjectUtils.equals((Object)this.getValue(), (Object)o.getValue());
        }
    }

    private static final class NonSerializableMember {
        private int mValue;

        public NonSerializableMember(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public String toString() {
            return "I am " + this.getValue();
        }

        public int hashCode() {
            return this.getValue();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !this.getClass().equals(other.getClass())) {
                return false;
            }
            NonSerializableMember o = (NonSerializableMember)other;
            return this.getValue() == o.getValue();
        }
    }

    private static final class TransientData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient int mValue;

        public TransientData(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public String toString() {
            return "I am " + this.getValue();
        }

        public int hashCode() {
            return this.getValue();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !this.getClass().equals(other.getClass())) {
                return false;
            }
            TransientData o = (TransientData)other;
            return this.getValue() == o.getValue();
        }
    }
}

