/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.test;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.test.UnicodeData;

public class UnicodeDataTest
extends TestCaseBase {
    private static final Charset NAT = Charset.defaultCharset();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Charset UTF16BE = Charset.forName("UTF-16BE");
    private static final Charset UTF16LE = Charset.forName("UTF-16LE");
    private static final Charset UTF32BE = Charset.forName("UTF-32BE");
    private static final Charset UTF32LE = Charset.forName("UTF-32LE");
    private static final String TEST_FILE_PREFIX = "target" + File.separator + "unicode_";

    private static void singleValid(String str, char[] chars, int[] ucps, byte[] nat, byte[] utf8, byte[] utf16be, byte[] utf16le, byte[] utf32be, byte[] utf32le) {
        int ucp;
        Assert.assertArrayEquals((char[])str.toCharArray(), (char[])chars);
        int j = 0;
        for (int i = 0; i < str.length(); i += Character.charCount(ucp)) {
            ucp = str.codePointAt(i);
            Assert.assertEquals((String)("At code point position " + j), (long)ucp, (long)ucps[j++]);
        }
        Assert.assertArrayEquals((byte[])str.getBytes(), (byte[])nat);
        Assert.assertArrayEquals((byte[])str.getBytes(UTF8), (byte[])utf8);
        Assert.assertArrayEquals((byte[])str.getBytes(UTF16BE), (byte[])utf16be);
        Assert.assertArrayEquals((byte[])str.getBytes(UTF16LE), (byte[])utf16le);
        Assert.assertArrayEquals((byte[])str.getBytes(UTF32BE), (byte[])utf32be);
        Assert.assertArrayEquals((byte[])str.getBytes(UTF32LE), (byte[])utf32le);
    }

    private static void singleInvalid(Charset cs, byte[] encoded) {
        CharsetDecoder dec = cs.newDecoder();
        dec.onMalformedInput(CodingErrorAction.REPORT);
        try {
            dec.decode(ByteBuffer.wrap(encoded));
            Assert.fail();
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
    }

    private static void writeFile(Charset charset, String fileName, byte[] data) throws Exception {
        FileOutputStream out = new FileOutputStream(TEST_FILE_PREFIX + fileName + ".xml");
        out.write(("<?xml version=\"1.0\" encoding=\"" + charset.name() + "\"?><root>").getBytes(charset));
        out.write(data);
        out.write("</root>".getBytes(charset));
        out.close();
    }

    @Test
    public void valid() {
        UnicodeDataTest.singleValid(" ", UnicodeData.SPACE_CHARS, UnicodeData.SPACE_UCPS, UnicodeData.SPACE_NAT, UnicodeData.SPACE_UTF8, UnicodeData.SPACE_UTF16BE, UnicodeData.SPACE_UTF16LE, UnicodeData.SPACE_UTF32BE, UnicodeData.SPACE_UTF32LE);
        UnicodeDataTest.singleValid("Hello", UnicodeData.HELLO_EN_CHARS, UnicodeData.HELLO_EN_UCPS, UnicodeData.HELLO_EN_NAT, UnicodeData.HELLO_EN_UTF8, UnicodeData.HELLO_EN_UTF16BE, UnicodeData.HELLO_EN_UTF16LE, UnicodeData.HELLO_EN_UTF32BE, UnicodeData.HELLO_EN_UTF32LE);
        UnicodeDataTest.singleValid("Spr\u00e5k", UnicodeData.LANGUAGE_NO_CHARS, UnicodeData.LANGUAGE_NO_UCPS, UnicodeData.LANGUAGE_NO_NAT, UnicodeData.LANGUAGE_NO_UTF8, UnicodeData.LANGUAGE_NO_UTF16BE, UnicodeData.LANGUAGE_NO_UTF16LE, UnicodeData.LANGUAGE_NO_UTF32BE, UnicodeData.LANGUAGE_NO_UTF32LE);
        UnicodeDataTest.singleValid("\u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5", UnicodeData.HELLO_GR_CHARS, UnicodeData.HELLO_GR_UCPS, UnicodeData.HELLO_GR_NAT, UnicodeData.HELLO_GR_UTF8, UnicodeData.HELLO_GR_UTF16BE, UnicodeData.HELLO_GR_UTF16LE, UnicodeData.HELLO_GR_UTF32BE, UnicodeData.HELLO_GR_UTF32LE);
        UnicodeDataTest.singleValid("\u0645\u0646\u0632\u0644", UnicodeData.HOUSE_AR_CHARS, UnicodeData.HOUSE_AR_UCPS, UnicodeData.HOUSE_AR_NAT, UnicodeData.HOUSE_AR_UTF8, UnicodeData.HOUSE_AR_UTF16BE, UnicodeData.HOUSE_AR_UTF16LE, UnicodeData.HOUSE_AR_UTF32BE, UnicodeData.HOUSE_AR_UTF32LE);
        UnicodeDataTest.singleValid("\u3055\u3088\u3046\u306a\u3089", UnicodeData.GOODBYE_JA_CHARS, UnicodeData.GOODBYE_JA_UCPS, UnicodeData.GOODBYE_JA_NAT, UnicodeData.GOODBYE_JA_UTF8, UnicodeData.GOODBYE_JA_UTF16BE, UnicodeData.GOODBYE_JA_UTF16LE, UnicodeData.GOODBYE_JA_UTF32BE, UnicodeData.GOODBYE_JA_UTF32LE);
        UnicodeDataTest.singleValid("\ud800\udc88 \ud800\udc89", UnicodeData.GOATS_LNB_CHARS, UnicodeData.GOATS_LNB_UCPS, UnicodeData.GOATS_LNB_NAT, UnicodeData.GOATS_LNB_UTF8, UnicodeData.GOATS_LNB_UTF16BE, UnicodeData.GOATS_LNB_UTF16LE, UnicodeData.GOATS_LNB_UTF32BE, UnicodeData.GOATS_LNB_UTF32LE);
        UnicodeDataTest.singleValid("\ud834\udd1e", UnicodeData.G_CLEF_MSC_CHARS, UnicodeData.G_CLEF_MSC_UCPS, UnicodeData.G_CLEF_MSC_NAT, UnicodeData.G_CLEF_MSC_UTF8, UnicodeData.G_CLEF_MSC_UTF16BE, UnicodeData.G_CLEF_MSC_UTF16LE, UnicodeData.G_CLEF_MSC_UTF32BE, UnicodeData.G_CLEF_MSC_UTF32LE);
        UnicodeDataTest.singleValid("Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", UnicodeData.COMBO_CHARS, UnicodeData.COMBO_UCPS, UnicodeData.COMBO_NAT, UnicodeData.COMBO_UTF8, UnicodeData.COMBO_UTF16BE, UnicodeData.COMBO_UTF16LE, UnicodeData.COMBO_UTF32BE, UnicodeData.COMBO_UTF32LE);
    }

    @Test
    public void invalid() {
        CharsetEncoder enc = UTF8.newEncoder();
        Assert.assertFalse((boolean)enc.canEncode("\ud800"));
        Assert.assertFalse((boolean)enc.canEncode(new String(UnicodeData.INVALID_CHARS)));
        Assert.assertFalse((boolean)enc.canEncode(new String(UnicodeData.INVALID_UCPS, 0, UnicodeData.INVALID_UCPS.length)));
        UnicodeDataTest.singleInvalid(UTF8, UnicodeData.INVALID_UTF8);
        UnicodeDataTest.singleInvalid(UTF16BE, UnicodeData.INVALID_UTF16BE);
        UnicodeDataTest.singleInvalid(UTF16LE, UnicodeData.INVALID_UTF16LE);
        UnicodeDataTest.singleInvalid(UTF32BE, UnicodeData.INVALID_UTF32BE);
        UnicodeDataTest.singleInvalid(UTF32LE, UnicodeData.INVALID_UTF32LE);
    }

    @Test
    public void writeFiles() throws Exception {
        UnicodeDataTest.writeFile(NAT, "native", UnicodeData.COMBO_NAT);
        UnicodeDataTest.writeFile(UTF8, "utf8", UnicodeData.COMBO_UTF8);
        UnicodeDataTest.writeFile(UTF16BE, "utf16be", UnicodeData.COMBO_UTF16BE);
        UnicodeDataTest.writeFile(UTF16LE, "utf16le", UnicodeData.COMBO_UTF16LE);
        UnicodeDataTest.writeFile(UTF32BE, "utf32be", UnicodeData.COMBO_UTF32BE);
        UnicodeDataTest.writeFile(UTF32LE, "utf32le", UnicodeData.COMBO_UTF32LE);
    }
}

