/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.auth;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.PrintStream;
import java.util.Locale;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.util.auth.AuthenticationSystem;
import org.marketcetera.util.auth.Context;
import org.marketcetera.util.auth.Holder;
import org.marketcetera.util.auth.Setter;
import org.marketcetera.util.auth.TestMessages;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.test.TestCaseBase;

public class AuthenticationSystemTest
extends TestCaseBase {
    private static final String TEST_CATEGORY;
    private static final String TEST_VALUE = "x";
    private static final String TEST_MESSAGE = "Test message";
    private static final String TEST_LOCATION;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void usage(AuthenticationSystem system, String usage) {
        ByteArrayOutputStream outputStream;
        CloseableRegistry r = new CloseableRegistry();
        try {
            outputStream = new ByteArrayOutputStream();
            r.register((Closeable)outputStream);
            PrintStream printStream = new PrintStream(outputStream);
            r.register((Closeable)printStream);
            system.printUsage(printStream);
        }
        finally {
            r.close();
        }
        Assert.assertEquals((Object)usage, (Object)new String(outputStream.toByteArray()));
    }

    @Before
    public void setupAuthenticationSystemTest() {
        AuthenticationSystemTest.setLevel((String)TEST_CATEGORY, (Level)Level.ERROR);
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
    }

    @Test
    public void oneContext() throws Exception {
        MyHolder holder1 = new MyHolder(1);
        Assert.assertFalse((boolean)holder1.isSet());
        MyHolder holder2 = new MyHolder(2, (I18NBoundMessage)TestMessages.TEST_MESSAGE);
        Assert.assertFalse((boolean)holder2.isSet());
        MyContext context1 = new MyContext(false, "1");
        MySetter setter11 = new MySetter(holder1);
        context1.add(setter11);
        MySetter setter12 = new MySetter(holder2);
        context1.add(setter12);
        AuthenticationSystem system = new AuthenticationSystem();
        system.add((Context)context1);
        AuthenticationSystemTest.usage(system, "1" + SystemUtils.LINE_SEPARATOR);
        system.setValues();
        Assert.assertEquals((long)1L, (long)context1.getCalledCount());
        Assert.assertEquals((long)1L, (long)setter11.getCalledCount());
        Assert.assertEquals((long)1L, (long)setter12.getCalledCount());
        Assert.assertTrue((boolean)holder1.isSet());
        Assert.assertFalse((boolean)holder2.isSet());
        Assert.assertEquals((Object)TEST_VALUE, (Object)holder1.getValue());
        this.assertSingleEvent(Level.ERROR, TEST_CATEGORY, TEST_MESSAGE, TEST_LOCATION);
    }

    @Test
    public void twoContexts() throws Exception {
        MyHolder holder1 = new MyHolder(1);
        Assert.assertFalse((boolean)holder1.isSet());
        MyHolder holder2 = new MyHolder(2, (I18NBoundMessage)TestMessages.TEST_MESSAGE);
        Assert.assertFalse((boolean)holder2.isSet());
        MyContext context1 = new MyContext(false, "1");
        MySetter setter11 = new MySetter(holder1);
        context1.add(setter11);
        MySetter setter12 = new MySetter(holder2);
        context1.add(setter12);
        MyContext context2 = new MyContext(false, "2");
        MySetter setter21 = new MySetter(holder1);
        context2.add(setter21);
        MySetter setter22 = new MySetter(holder2);
        context2.add(setter22);
        AuthenticationSystem system = new AuthenticationSystem();
        system.add((Context)context1);
        system.add((Context)context2);
        AuthenticationSystemTest.usage(system, "1" + SystemUtils.LINE_SEPARATOR + "2" + SystemUtils.LINE_SEPARATOR);
        system.setValues();
        Assert.assertEquals((long)1L, (long)context1.getCalledCount());
        Assert.assertEquals((long)1L, (long)setter11.getCalledCount());
        Assert.assertEquals((long)1L, (long)setter12.getCalledCount());
        Assert.assertEquals((long)1L, (long)context2.getCalledCount());
        Assert.assertEquals((long)0L, (long)setter21.getCalledCount());
        Assert.assertEquals((long)1L, (long)setter22.getCalledCount());
        Assert.assertTrue((boolean)holder1.isSet());
        Assert.assertTrue((boolean)holder2.isSet());
        Assert.assertEquals((Object)TEST_VALUE, (Object)holder1.getValue());
        Assert.assertEquals((Object)TEST_VALUE, (Object)holder2.getValue());
        this.assertNoEvents();
    }

    @Test
    public void threeContexts() throws Exception {
        MyHolder holder1 = new MyHolder(1);
        Assert.assertFalse((boolean)holder1.isSet());
        MyHolder holder2 = new MyHolder(2, (I18NBoundMessage)TestMessages.TEST_MESSAGE);
        Assert.assertFalse((boolean)holder2.isSet());
        MyContext context1 = new MyContext(false, "1");
        MySetter setter11 = new MySetter(holder1);
        context1.add(setter11);
        MySetter setter12 = new MySetter(holder2);
        context1.add(setter12);
        MyContext context2 = new MyContext(false, "2");
        MySetter setter21 = new MySetter(holder1);
        context2.add(setter21);
        MySetter setter22 = new MySetter(holder2);
        context2.add(setter22);
        MyContext context3 = new MyContext(false, "3");
        MySetter setter31 = new MySetter(holder1);
        context3.add(setter31);
        MySetter setter32 = new MySetter(holder2);
        context3.add(setter32);
        AuthenticationSystem system = new AuthenticationSystem();
        system.add((Context)context1);
        system.add((Context)context2);
        system.add((Context)context3);
        AuthenticationSystemTest.usage(system, "1" + SystemUtils.LINE_SEPARATOR + "2" + SystemUtils.LINE_SEPARATOR + "3" + SystemUtils.LINE_SEPARATOR);
        system.setValues();
        Assert.assertEquals((long)1L, (long)context1.getCalledCount());
        Assert.assertEquals((long)1L, (long)setter11.getCalledCount());
        Assert.assertEquals((long)1L, (long)setter12.getCalledCount());
        Assert.assertEquals((long)1L, (long)context2.getCalledCount());
        Assert.assertEquals((long)0L, (long)setter21.getCalledCount());
        Assert.assertEquals((long)1L, (long)setter22.getCalledCount());
        Assert.assertEquals((long)0L, (long)context3.getCalledCount());
        Assert.assertEquals((long)0L, (long)setter31.getCalledCount());
        Assert.assertEquals((long)0L, (long)setter32.getCalledCount());
        Assert.assertTrue((boolean)holder1.isSet());
        Assert.assertTrue((boolean)holder2.isSet());
        Assert.assertEquals((Object)TEST_VALUE, (Object)holder1.getValue());
        Assert.assertEquals((Object)TEST_VALUE, (Object)holder2.getValue());
        this.assertNoEvents();
    }

    static {
        TEST_LOCATION = TEST_CATEGORY = AuthenticationSystem.class.getName();
    }

    private static class MyContext
    extends Context<MySetter> {
        private String mUsage;
        private int mCalledCount;

        public MyContext(boolean overrides, String usage) {
            super(overrides);
            this.mUsage = usage;
        }

        int getCalledCount() {
            return this.mCalledCount;
        }

        public void printUsage(PrintStream stream) {
            stream.print(this.mUsage);
        }

        public void setValues() {
            ++this.mCalledCount;
            for (MySetter setter : this.getSetters()) {
                if (((MyHolder)setter.getHolder()).isSet()) continue;
                setter.setValue();
            }
        }
    }

    private static class MySetter
    extends Setter<MyHolder> {
        private int mCalledCount;

        MySetter(MyHolder holder) {
            super((Holder)holder, null);
        }

        int getCalledCount() {
            return this.mCalledCount;
        }

        void setValue() {
            ++this.mCalledCount;
            ((MyHolder)this.getHolder()).increaseAndSet();
        }
    }

    private static class MyHolder
    extends Holder<String> {
        private int mTipCount;
        private int mCount;

        MyHolder(int tipCount) {
            this.mTipCount = tipCount;
            this.mCount = 0;
        }

        MyHolder(int tipCount, I18NBoundMessage message) {
            super(message);
            this.mTipCount = tipCount;
            this.mCount = 0;
        }

        void increaseAndSet() {
            ++this.mCount;
            if (this.mCount >= this.mTipCount) {
                this.setValue(AuthenticationSystemTest.TEST_VALUE);
            }
        }
    }
}

