/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.auth;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.auth.HolderCharArray;
import org.marketcetera.util.auth.HolderTestBase;
import org.marketcetera.util.auth.TestMessages;
import org.marketcetera.util.log.I18NBoundMessage;

public class HolderCharArrayTest
extends HolderTestBase {
    private static final String TEST_VALUE_STR = "abc";
    private static final char[] TEST_VALUE = "abc".toCharArray();
    private static final char[] NUL_VALUE = StringUtils.repeat((String)"\u0000", (int)TEST_VALUE.length).toCharArray();

    private static void getAsString(HolderCharArray holder) {
        Assert.assertNull((Object)holder.getValueAsString());
        holder.setValue((char[])TEST_VALUE.clone());
        Assert.assertEquals((Object)TEST_VALUE_STR, (Object)holder.getValueAsString());
        holder.setValue(null);
        Assert.assertNull((Object)holder.getValueAsString());
    }

    private static void clear(HolderCharArray holder) {
        char[] valueCopy = (char[])TEST_VALUE.clone();
        holder.setValue(valueCopy);
        holder.clear();
        Assert.assertNull((Object)holder.getValue());
        Assert.assertNull((Object)holder.getValueAsString());
        Assert.assertArrayEquals((char[])NUL_VALUE, (char[])valueCopy);
        holder.clear();
        Assert.assertNull((Object)holder.getValue());
        Assert.assertNull((Object)holder.getValueAsString());
        valueCopy = (char[])TEST_VALUE.clone();
        holder.setValue(valueCopy);
        holder.setValue(null);
        Assert.assertArrayEquals((char[])NUL_VALUE, (char[])valueCopy);
        holder.clear();
        Assert.assertNull((Object)holder.getValue());
        Assert.assertNull((Object)holder.getValueAsString());
        valueCopy = (char[])TEST_VALUE.clone();
        holder.setValue(valueCopy);
        holder.setValue(ArrayUtils.EMPTY_CHAR_ARRAY);
        Assert.assertArrayEquals((char[])NUL_VALUE, (char[])valueCopy);
        holder.clear();
        Assert.assertNull((Object)holder.getValue());
        Assert.assertNull((Object)holder.getValueAsString());
    }

    @Test
    public void basics() {
        char[] testValueClone = (char[])TEST_VALUE.clone();
        HolderCharArray holder = new HolderCharArray();
        HolderCharArrayTest.simpleNoMessage(holder, TEST_VALUE.clone());
        HolderCharArrayTest.clear(holder);
        HolderCharArrayTest.getAsString(new HolderCharArray());
        holder = new HolderCharArray((I18NBoundMessage)TestMessages.TEST_MESSAGE);
        HolderCharArrayTest.simpleWithMessage(holder, TEST_VALUE.clone());
        HolderCharArrayTest.clear(holder);
        HolderCharArrayTest.getAsString(new HolderCharArray((I18NBoundMessage)TestMessages.TEST_MESSAGE));
        Assert.assertArrayEquals((char[])testValueClone, (char[])TEST_VALUE);
    }
}

