/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.auth;

import java.io.Serializable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.auth.CliContext;
import org.marketcetera.util.auth.CliSetter;
import org.marketcetera.util.auth.CliSetterCharArray;
import org.marketcetera.util.auth.CliSetterString;
import org.marketcetera.util.auth.Holder;
import org.marketcetera.util.auth.HolderCharArray;
import org.marketcetera.util.auth.Messages;
import org.marketcetera.util.auth.Setter;
import org.marketcetera.util.auth.SetterContextTestBase;
import org.marketcetera.util.auth.TestMessages;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage2P;

public class SetterContextCliTest
extends SetterContextTestBase {
    private static final String TEST_CLI = "Command-line options";
    private static final String TEST_SHORT_FORM = "short";
    private static final String TEST_LONG_FORM = "long";
    private static final String[] TEST_ARGS = new String[]{"a", "b", "c"};

    private static <T> void setter(CliSetter<Holder<T>> setter, Holder<T> holder) {
        SetterContextCliTest.simpleSetter(setter, holder);
        Assert.assertEquals((Object)TEST_SHORT_FORM, (Object)setter.getShortForm());
        Assert.assertEquals((Object)TEST_LONG_FORM, (Object)setter.getLongForm());
        Assert.assertEquals((Object)TestMessages.TEST_DESCRIPTION, (Object)setter.getDescription());
    }

    @Test
    public void setterBasics() throws Exception {
        SetterContextCliTest.setter(new TestSetter(TEST_STRING_HOLDER, (I18NBoundMessage)TestMessages.TEST_USAGE, TEST_SHORT_FORM, TEST_LONG_FORM, (I18NBoundMessage)TestMessages.TEST_DESCRIPTION), TEST_STRING_HOLDER);
        SetterContextCliTest.setter(new CliSetterString(TEST_STRING_HOLDER, (I18NBoundMessage)TestMessages.TEST_USAGE, TEST_SHORT_FORM, TEST_LONG_FORM, (I18NBoundMessage)TestMessages.TEST_DESCRIPTION), TEST_STRING_HOLDER);
        SetterContextCliTest.setter(new CliSetterCharArray(TEST_CHAR_ARRAY_HOLDER, (I18NBoundMessage)TestMessages.TEST_USAGE, TEST_SHORT_FORM, TEST_LONG_FORM, (I18NBoundMessage)TestMessages.TEST_DESCRIPTION), TEST_CHAR_ARRAY_HOLDER);
    }

    @Test
    public void contextBasics() throws Exception {
        Holder holder = new Holder();
        TestSetter<Holder> setter = new TestSetter<Holder>(holder, (I18NBoundMessage)TestMessages.TEST_USAGE, TEST_SHORT_FORM, TEST_LONG_FORM, (I18NBoundMessage)TestMessages.TEST_DESCRIPTION);
        SetterContextCliTest.simpleContextWithName(new CliContext(true, ArrayUtils.EMPTY_STRING_ARRAY), setter, true, true, (I18NBoundMessage)Messages.CLI_NAME, TEST_CLI);
        SetterContextCliTest.simpleContextWithName(new CliContext(false, ArrayUtils.EMPTY_STRING_ARRAY), setter, false, true, (I18NBoundMessage)Messages.CLI_NAME, TEST_CLI);
        SetterContextCliTest.simpleContextWithName(new CliContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, true, ArrayUtils.EMPTY_STRING_ARRAY), setter, true, true, (I18NBoundMessage)TestMessages.TEST_CONTEXT, "Test context");
        SetterContextCliTest.simpleContextWithName(new CliContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, false, ArrayUtils.EMPTY_STRING_ARRAY), setter, false, true, (I18NBoundMessage)TestMessages.TEST_CONTEXT, "Test context");
        holder.setValue((Object)"x");
        SetterContextCliTest.simpleContextWithName(new CliContext(true, ArrayUtils.EMPTY_STRING_ARRAY), setter, true, true, (I18NBoundMessage)Messages.CLI_NAME, TEST_CLI);
        SetterContextCliTest.simpleContextWithName(new CliContext(false, ArrayUtils.EMPTY_STRING_ARRAY), setter, false, false, (I18NBoundMessage)Messages.CLI_NAME, TEST_CLI);
        SetterContextCliTest.simpleContextWithName(new CliContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, true, ArrayUtils.EMPTY_STRING_ARRAY), setter, true, true, (I18NBoundMessage)TestMessages.TEST_CONTEXT, "Test context");
        SetterContextCliTest.simpleContextWithName(new CliContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, false, ArrayUtils.EMPTY_STRING_ARRAY), setter, false, false, (I18NBoundMessage)TestMessages.TEST_CONTEXT, "Test context");
        CliContext context = new CliContext(true, TEST_ARGS);
        Assert.assertArrayEquals((Object[])TEST_ARGS, (Object[])context.getArgs());
    }

    @Test
    public void setValues() throws Exception {
        Holder userHolder = new Holder((I18NBoundMessage)Messages.NO_USER);
        HolderCharArray passwordHolder = new HolderCharArray((I18NBoundMessage)Messages.NO_PASSWORD);
        CliSetterString userSetter = new CliSetterString(userHolder, (I18NBoundMessage)new I18NBoundMessage2P(Messages.USER_CLI_USAGE, (Serializable)((Object)"u"), (Serializable)((Object)"username")), "u", "username", (I18NBoundMessage)Messages.USER_DESCRIPTION);
        CliSetterCharArray passwordSetter = new CliSetterCharArray((Holder)passwordHolder, (I18NBoundMessage)new I18NBoundMessage2P(Messages.PASSWORD_CLI_USAGE, (Serializable)((Object)"p"), (Serializable)((Object)"password")), "p", "password", (I18NBoundMessage)Messages.PASSWORD_DESCRIPTION);
        CliContext context = new CliContext(false, ArrayUtils.EMPTY_STRING_ARRAY);
        context.add((Setter)userSetter);
        context.add((Setter)passwordSetter);
        context.setValues();
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])context.getCommandLine().getArgs());
        Assert.assertNull((Object)userHolder.getValue());
        Assert.assertNull((Object)passwordHolder.getValueAsString());
        context = new CliContext(false, new String[]{"-p", "firstp"});
        context.add((Setter)userSetter);
        context.add((Setter)passwordSetter);
        context.setValues();
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])context.getCommandLine().getArgs());
        Assert.assertNull((Object)userHolder.getValue());
        Assert.assertEquals((Object)"firstp", (Object)passwordHolder.getValueAsString());
        context = new CliContext(false, new String[]{"-u", "firstu", "-p", "secondp"});
        context.add((Setter)userSetter);
        context.add((Setter)passwordSetter);
        context.setValues();
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])context.getCommandLine().getArgs());
        Assert.assertEquals((Object)"firstu", (Object)userHolder.getValue());
        Assert.assertEquals((Object)"firstp", (Object)passwordHolder.getValueAsString());
        context = new CliContext(false, new String[]{"-u", "secondu"});
        context.add((Setter)userSetter);
        context.add((Setter)passwordSetter);
        context.setValues();
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])context.getCommandLine().getArgs());
        Assert.assertEquals((Object)"firstu", (Object)userHolder.getValue());
        Assert.assertEquals((Object)"firstp", (Object)passwordHolder.getValueAsString());
        context = new CliContext(true, new String[]{"-u", "", "-p", ""});
        context.add((Setter)userSetter);
        context.add((Setter)passwordSetter);
        context.setValues();
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])context.getCommandLine().getArgs());
        Assert.assertEquals((Object)"firstu", (Object)userHolder.getValue());
        Assert.assertEquals((Object)"firstp", (Object)passwordHolder.getValueAsString());
        context = new CliContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, true, new String[]{"-u", "thirdu", "-p", "thirdp", "extra"});
        context.add((Setter)userSetter);
        context.add((Setter)passwordSetter);
        context.setValues();
        Assert.assertArrayEquals((Object[])new String[]{"extra"}, (Object[])context.getCommandLine().getArgs());
        Assert.assertEquals((Object)"thirdu", (Object)userHolder.getValue());
        Assert.assertEquals((Object)"thirdp", (Object)passwordHolder.getValueAsString());
    }

    @Test
    public void parsingError() throws Exception {
        CliContext context = new CliContext(true, new String[]{"-x"});
        try {
            context.setValues();
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)Messages.PARSING_FAILED, (Object)ex.getI18NBoundMessage().getMessage());
        }
    }

    private static class TestSetter<T extends Holder<?>>
    extends CliSetter<T> {
        public TestSetter(T holder, I18NBoundMessage usage, String shortForm, String longForm, I18NBoundMessage description) {
            super(holder, usage, shortForm, longForm, description);
        }

        public void setValue(CommandLine commandLine) {
        }
    }
}

