/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.auth;

import java.io.Console;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.auth.ConsoleContext;
import org.marketcetera.util.auth.ConsoleSetter;
import org.marketcetera.util.auth.ConsoleSetterCharArray;
import org.marketcetera.util.auth.ConsoleSetterString;
import org.marketcetera.util.auth.Holder;
import org.marketcetera.util.auth.HolderCharArray;
import org.marketcetera.util.auth.Messages;
import org.marketcetera.util.auth.Setter;
import org.marketcetera.util.auth.SetterContextTestBase;
import org.marketcetera.util.auth.TestMessages;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage;

public class SetterContextConsoleTest
extends SetterContextTestBase {
    private static final String TEST_CONSOLE = "Console terminal";

    private static <T> void setter(ConsoleSetter<Holder<T>> setter, Holder<T> holder) {
        SetterContextConsoleTest.simpleSetter(setter, holder);
        Assert.assertEquals((Object)TestMessages.TEST_PROMPT, (Object)setter.getPrompt());
    }

    @Test
    public void setterBasics() throws Exception {
        SetterContextConsoleTest.setter(new TestSetter(TEST_STRING_HOLDER, (I18NBoundMessage)TestMessages.TEST_USAGE, (I18NBoundMessage)TestMessages.TEST_PROMPT), TEST_STRING_HOLDER);
        SetterContextConsoleTest.setter(new ConsoleSetterString(TEST_STRING_HOLDER, (I18NBoundMessage)TestMessages.TEST_USAGE, (I18NBoundMessage)TestMessages.TEST_PROMPT), TEST_STRING_HOLDER);
        SetterContextConsoleTest.setter(new ConsoleSetterCharArray(TEST_CHAR_ARRAY_HOLDER, (I18NBoundMessage)TestMessages.TEST_USAGE, (I18NBoundMessage)TestMessages.TEST_PROMPT), TEST_CHAR_ARRAY_HOLDER);
    }

    @Test
    public void contextBasics() throws Exception {
        Holder holder = new Holder();
        TestSetter<Holder> setter = new TestSetter<Holder>(holder, (I18NBoundMessage)TestMessages.TEST_USAGE, (I18NBoundMessage)TestMessages.TEST_PROMPT);
        SetterContextConsoleTest.simpleContextWithName(new ConsoleContext(true), setter, true, true, (I18NBoundMessage)Messages.CONSOLE_NAME, TEST_CONSOLE);
        SetterContextConsoleTest.simpleContextWithName(new ConsoleContext(false), setter, false, true, (I18NBoundMessage)Messages.CONSOLE_NAME, TEST_CONSOLE);
        SetterContextConsoleTest.simpleContextWithName(new ConsoleContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, true), setter, true, true, (I18NBoundMessage)TestMessages.TEST_CONTEXT, "Test context");
        SetterContextConsoleTest.simpleContextWithName(new ConsoleContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, false), setter, false, true, (I18NBoundMessage)TestMessages.TEST_CONTEXT, "Test context");
        holder.setValue((Object)"x");
        SetterContextConsoleTest.simpleContextWithName(new ConsoleContext(true), setter, true, true, (I18NBoundMessage)Messages.CONSOLE_NAME, TEST_CONSOLE);
        SetterContextConsoleTest.simpleContextWithName(new ConsoleContext(false), setter, false, false, (I18NBoundMessage)Messages.CONSOLE_NAME, TEST_CONSOLE);
        SetterContextConsoleTest.simpleContextWithName(new ConsoleContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, true), setter, true, true, (I18NBoundMessage)TestMessages.TEST_CONTEXT, "Test context");
        SetterContextConsoleTest.simpleContextWithName(new ConsoleContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, false), setter, false, false, (I18NBoundMessage)TestMessages.TEST_CONTEXT, "Test context");
    }

    @Test
    public void noConsole() throws Exception {
        ConsoleContext context = new ConsoleContext(true);
        try {
            context.setValues();
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)Messages.CONSOLE_UNAVAILABLE, (Object)ex.getI18NBoundMessage().getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        Holder userHolder = new Holder((I18NBoundMessage)Messages.NO_USER);
        HolderCharArray passwordHolder = new HolderCharArray((I18NBoundMessage)Messages.NO_PASSWORD);
        ConsoleSetterString userSetter = new ConsoleSetterString(userHolder, (I18NBoundMessage)Messages.USER_CONSOLE_USAGE, (I18NBoundMessage)Messages.USER_PROMPT);
        ConsoleSetterCharArray passwordSetter = new ConsoleSetterCharArray((Holder)passwordHolder, (I18NBoundMessage)Messages.PASSWORD_CONSOLE_USAGE, (I18NBoundMessage)Messages.PASSWORD_PROMPT);
        ConsoleContext context = new ConsoleContext(false);
        context.add((Setter)userSetter);
        context.add((Setter)passwordSetter);
        context.printUsage(System.err);
        System.err.println("First pass");
        context.setValues();
        System.err.println((String)userHolder.getValue());
        System.err.println(passwordHolder.getValueAsString());
        System.err.println("Second pass");
        context.setValues();
        System.err.println((String)userHolder.getValue());
        System.err.println(passwordHolder.getValueAsString());
        context = new ConsoleContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, true);
        context.add((Setter)userSetter);
        context.add((Setter)passwordSetter);
        System.err.println("Third pass");
        context.setValues();
        System.err.println((String)userHolder.getValue());
        System.err.println(passwordHolder.getValueAsString());
    }

    private static class TestSetter<T extends Holder<?>>
    extends ConsoleSetter<T> {
        public TestSetter(T holder, I18NBoundMessage usage, I18NBoundMessage prompt) {
            super(holder, usage, prompt);
        }

        public void setValue(Console console) {
        }
    }
}

