/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.auth;

import java.io.File;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.auth.Holder;
import org.marketcetera.util.auth.HolderCharArray;
import org.marketcetera.util.auth.Messages;
import org.marketcetera.util.auth.Setter;
import org.marketcetera.util.auth.SetterContextTestBase;
import org.marketcetera.util.auth.SpringContext;
import org.marketcetera.util.auth.SpringSetter;
import org.marketcetera.util.auth.SpringSetterCharArray;
import org.marketcetera.util.auth.SpringSetterString;
import org.marketcetera.util.auth.TestMessages;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.springframework.context.support.GenericApplicationContext;

public class SetterContextSpringTest
extends SetterContextTestBase {
    private static final String TEST_ROOT = DIR_ROOT + File.separator + "auth" + File.separator;
    private static final String TEST_SPRING = "Spring framework";
    private static final String TEST_PROPERTY_NAME = "propertyName";
    private static final String TEST_CONFIG_LOCATION = "configLocation";
    private static final String TEST_PROPERTIES_FILES = "propertiesFiles";

    private static <T> void setter(SpringSetter<Holder<T>> setter, Holder<T> holder) {
        SetterContextSpringTest.simpleSetter(setter, holder);
        Assert.assertEquals((Object)TEST_PROPERTY_NAME, (Object)setter.getPropertyName());
    }

    @Test
    public void setterBasics() throws Exception {
        SetterContextSpringTest.setter(new TestSetter(TEST_STRING_HOLDER, (I18NBoundMessage)TestMessages.TEST_USAGE, TEST_PROPERTY_NAME), TEST_STRING_HOLDER);
        SetterContextSpringTest.setter(new SpringSetterString(TEST_STRING_HOLDER, (I18NBoundMessage)TestMessages.TEST_USAGE, TEST_PROPERTY_NAME), TEST_STRING_HOLDER);
        SetterContextSpringTest.setter(new SpringSetterCharArray(TEST_CHAR_ARRAY_HOLDER, (I18NBoundMessage)TestMessages.TEST_USAGE, TEST_PROPERTY_NAME), TEST_CHAR_ARRAY_HOLDER);
    }

    @Test
    public void contextBasics() throws Exception {
        Holder holder = new Holder();
        TestSetter<Holder> setter = new TestSetter<Holder>(holder, (I18NBoundMessage)TestMessages.TEST_USAGE, TEST_PROPERTY_NAME);
        SetterContextSpringTest.simpleContextWithName(new SpringContext(true, null, null), setter, true, true, (I18NBoundMessage)Messages.SPRING_NAME, TEST_SPRING);
        SetterContextSpringTest.simpleContextWithName(new SpringContext(false, null, null), setter, false, true, (I18NBoundMessage)Messages.SPRING_NAME, TEST_SPRING);
        SetterContextSpringTest.simpleContextWithName(new SpringContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, true, null, null), setter, true, true, (I18NBoundMessage)TestMessages.TEST_CONTEXT, "Test context");
        SetterContextSpringTest.simpleContextWithName(new SpringContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, false, null, null), setter, false, true, (I18NBoundMessage)TestMessages.TEST_CONTEXT, "Test context");
        holder.setValue((Object)"x");
        SetterContextSpringTest.simpleContextWithName(new SpringContext(true, null, null), setter, true, true, (I18NBoundMessage)Messages.SPRING_NAME, TEST_SPRING);
        SetterContextSpringTest.simpleContextWithName(new SpringContext(false, null, null), setter, false, false, (I18NBoundMessage)Messages.SPRING_NAME, TEST_SPRING);
        SetterContextSpringTest.simpleContextWithName(new SpringContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, true, null, null), setter, true, true, (I18NBoundMessage)TestMessages.TEST_CONTEXT, "Test context");
        SetterContextSpringTest.simpleContextWithName(new SpringContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, false, null, null), setter, false, false, (I18NBoundMessage)TestMessages.TEST_CONTEXT, "Test context");
        SpringContext context = new SpringContext(true, TEST_CONFIG_LOCATION, TEST_PROPERTIES_FILES);
        Assert.assertEquals((Object)TEST_CONFIG_LOCATION, (Object)context.getConfigLocation());
        Assert.assertEquals((Object)TEST_PROPERTIES_FILES, (Object)context.getPropertiesFilesBean());
    }

    @Test
    public void setValues() throws Exception {
        Holder userHolder = new Holder((I18NBoundMessage)Messages.NO_USER);
        HolderCharArray passwordHolder = new HolderCharArray((I18NBoundMessage)Messages.NO_PASSWORD);
        SpringSetterString userSetter = new SpringSetterString(userHolder, (I18NBoundMessage)new I18NBoundMessage1P(Messages.USER_SPRING_USAGE, (Serializable)((Object)"metc.amq.user")), "metc.amq.user");
        SpringSetterCharArray passwordSetter = new SpringSetterCharArray((Holder)passwordHolder, (I18NBoundMessage)new I18NBoundMessage1P(Messages.PASSWORD_SPRING_USAGE, (Serializable)((Object)"metc.amq.password")), "metc.amq.password");
        SpringContext context = new SpringContext(false, TEST_ROOT + "auth_none.xml", TEST_PROPERTIES_FILES);
        context.add((Setter)userSetter);
        context.add((Setter)passwordSetter);
        context.setValues();
        Assert.assertNull((Object)userHolder.getValue());
        Assert.assertNull((Object)passwordHolder.getValueAsString());
        context = new SpringContext(false, TEST_ROOT + "auth_pwd.xml", TEST_PROPERTIES_FILES);
        context.add((Setter)userSetter);
        context.add((Setter)passwordSetter);
        context.setValues();
        Assert.assertNull((Object)userHolder.getValue());
        Assert.assertEquals((Object)"tp2", (Object)passwordHolder.getValueAsString());
        context = new SpringContext(false, TEST_ROOT + "auth_both.xml", TEST_PROPERTIES_FILES);
        context.add((Setter)userSetter);
        context.add((Setter)passwordSetter);
        context.setValues();
        Assert.assertEquals((Object)"tu3", (Object)userHolder.getValue());
        Assert.assertEquals((Object)"tp2", (Object)passwordHolder.getValueAsString());
        context = new SpringContext(false, TEST_ROOT + "auth_user.xml", TEST_PROPERTIES_FILES);
        context.add((Setter)userSetter);
        context.add((Setter)passwordSetter);
        context.setValues();
        Assert.assertEquals((Object)"tu3", (Object)userHolder.getValue());
        Assert.assertEquals((Object)"tp2", (Object)passwordHolder.getValueAsString());
        context = new SpringContext(true, TEST_ROOT + "auth_blank.xml", TEST_PROPERTIES_FILES);
        context.add((Setter)userSetter);
        context.add((Setter)passwordSetter);
        context.setValues();
        Assert.assertEquals((Object)"tu3", (Object)userHolder.getValue());
        Assert.assertEquals((Object)"tp2", (Object)passwordHolder.getValueAsString());
        context = new SpringContext((I18NBoundMessage)TestMessages.TEST_CONTEXT, true, TEST_ROOT + "auth_both.xml", TEST_PROPERTIES_FILES);
        context.add((Setter)userSetter);
        context.add((Setter)passwordSetter);
        context.setValues();
        Assert.assertEquals((Object)"tu3", (Object)userHolder.getValue());
        Assert.assertEquals((Object)"tp3", (Object)passwordHolder.getValueAsString());
    }

    private static class TestSetter<T extends Holder<?>>
    extends SpringSetter<T> {
        public TestSetter(T holder, I18NBoundMessage usage, String propertyName) {
            super(holder, usage, propertyName);
        }

        public void setValue(GenericApplicationContext context) {
        }
    }
}

