/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.auth;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.PrintStream;
import java.util.Locale;
import org.apache.commons.lang.SystemUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.marketcetera.util.auth.Context;
import org.marketcetera.util.auth.Holder;
import org.marketcetera.util.auth.Setter;
import org.marketcetera.util.auth.TestMessages;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.IterableUtils;
import org.marketcetera.util.test.TestCaseBase;

@Ignore
public class SetterContextTestBase
extends TestCaseBase {
    protected static final Holder<String> TEST_STRING_HOLDER = new Holder();
    protected static final Holder<char[]> TEST_CHAR_ARRAY_HOLDER = new Holder();
    protected static final String TEST_CONTEXT = "Test context";
    protected static final String TEST_USAGE = "Test usage";
    protected static final String TEST_ANONYMOUS = "(anonymous context)";
    protected static final String TEST_OVERRIDES = "(overriding context)";

    protected static <T extends Holder<?>> void simpleSetter(Setter<T> setter, T holder) {
        Assert.assertEquals(holder, (Object)setter.getHolder());
        Assert.assertEquals((Object)TestMessages.TEST_USAGE, (Object)setter.getUsage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Setter<?>> void setContext(Context<T> context, T setter, boolean override, boolean shouldProcess, String name) {
        PrintStream printStream;
        ByteArrayOutputStream outputStream;
        String usage = name;
        if (override) {
            usage = usage + " (overriding context)";
        }
        usage = usage + SystemUtils.LINE_SEPARATOR;
        Assert.assertArrayEquals((Object[])new Object[0], (Object[])IterableUtils.toArray((Iterable)context.getSetters()));
        CloseableRegistry r = new CloseableRegistry();
        try {
            outputStream = new ByteArrayOutputStream();
            r.register((Closeable)outputStream);
            printStream = new PrintStream(outputStream);
            r.register((Closeable)printStream);
            context.printUsage(printStream);
        }
        finally {
            r.close();
        }
        Assert.assertEquals((Object)usage, (Object)new String(outputStream.toByteArray()));
        context.add(setter);
        Assert.assertArrayEquals((Object[])new Object[]{setter}, (Object[])IterableUtils.toArray((Iterable)context.getSetters()));
        r = new CloseableRegistry();
        try {
            outputStream = new ByteArrayOutputStream();
            r.register((Closeable)outputStream);
            printStream = new PrintStream(outputStream);
            r.register((Closeable)printStream);
            context.printUsage(printStream);
        }
        finally {
            r.close();
        }
        usage = usage + " Test usage" + SystemUtils.LINE_SEPARATOR;
        Assert.assertEquals((Object)usage, (Object)new String(outputStream.toByteArray()));
        Assert.assertEquals((Object)override, (Object)context.getOverride());
        Assert.assertEquals((Object)shouldProcess, (Object)context.shouldProcess(setter));
    }

    protected static <T extends Setter<?>> void simpleContextNoName(Context<T> context, T setter, boolean override, boolean shouldProcess) {
        Assert.assertNull((Object)context.getName());
        SetterContextTestBase.setContext(context, setter, override, shouldProcess, TEST_ANONYMOUS);
    }

    protected static <T extends Setter<?>> void simpleContextWithName(Context<T> context, T setter, boolean override, boolean shouldProcess, I18NBoundMessage nameBound, String nameStr) {
        Assert.assertEquals((Object)nameBound, (Object)context.getName());
        SetterContextTestBase.setContext(context, setter, override, shouldProcess, nameStr);
    }

    @Before
    public void setupSetterContextTestBase() {
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
    }
}

