/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.auth;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.util.Locale;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.SystemUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.util.auth.StandardAuthentication;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.test.TestCaseBase;

public class StandardAuthenticationTest
extends TestCaseBase {
    private static final String TEST_ROOT = DIR_ROOT + File.separator + "auth" + File.separator;

    private static void authenticate(String configFile, String[] args, boolean process, String user, String password) {
        StandardAuthentication sa = new StandardAuthentication(configFile, args);
        Assert.assertEquals((Object)process, (Object)sa.setValues());
        Assert.assertEquals((Object)user, (Object)sa.getUser());
        Assert.assertEquals((Object)password, (Object)sa.getPasswordAsString());
        if (password == null) {
            Assert.assertNull((Object)sa.getPassword());
        } else {
            Assert.assertArrayEquals((char[])password.toCharArray(), (char[])sa.getPassword());
        }
        sa.clearPassword();
        Assert.assertNull((Object)sa.getPassword());
        Assert.assertNull((Object)sa.getPasswordAsString());
    }

    @Before
    public void setupSetterContextTestBase() {
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
    }

    @Test
    public void all() {
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_user.xml", ArrayUtils.EMPTY_STRING_ARRAY, false, "tu1", null);
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_user.xml", new String[]{"--p", "tp1"}, true, "tu1", "tp1");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_user.xml", new String[]{"-p", "tp1"}, true, "tu1", "tp1");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_user.xml", new String[]{"-u", "", "-p", "tp1"}, true, "tu1", "tp1");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_user.xml", new String[]{"--password", "tp1"}, true, "tu1", "tp1");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_user.xml", new String[]{"-password", "tp1"}, true, "tu1", "tp1");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_user.xml", new String[]{"-u", "tux", "-p", "tpx"}, true, "tux", "tpx");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_pwd.xml", ArrayUtils.EMPTY_STRING_ARRAY, false, null, "tp2");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_pwd.xml", new String[]{"-u", "tu2"}, true, "tu2", "tp2");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_pwd.xml", new String[]{"-u", "tu2", "-p", ""}, true, "tu2", "tp2");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_pwd.xml", new String[]{"-u", "tux", "-p", "tpx"}, true, "tux", "tpx");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_both.xml", ArrayUtils.EMPTY_STRING_ARRAY, true, "tu3", "tp3");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_both.xml", new String[]{"-u", "tux", "-p", "tpx"}, true, "tux", "tpx");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_none.xml", ArrayUtils.EMPTY_STRING_ARRAY, false, null, null);
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_none.xml", new String[]{"-u", "tux"}, false, "tux", null);
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_none.xml", new String[]{"-p", "tpx"}, false, null, "tpx");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_none.xml", new String[]{"-u", "tu3", "-p", "tp3"}, true, "tu3", "tp3");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_blank.xml", ArrayUtils.EMPTY_STRING_ARRAY, false, null, null);
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_blank.xml", new String[]{"-u", "tux"}, false, "tux", null);
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_blank.xml", new String[]{"-p", "tpx"}, false, null, "tpx");
        StandardAuthenticationTest.authenticate(TEST_ROOT + "auth_blank.xml", new String[]{"-u", "tu3", "-p", "tp3"}, true, "tu3", "tp3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void usage() {
        ByteArrayOutputStream outputStream;
        StandardAuthentication sa = new StandardAuthentication(TEST_ROOT + "auth_none.xml", ArrayUtils.EMPTY_STRING_ARRAY);
        CloseableRegistry r = new CloseableRegistry();
        try {
            outputStream = new ByteArrayOutputStream();
            r.register((Closeable)outputStream);
            PrintStream printStream = new PrintStream(outputStream);
            r.register((Closeable)printStream);
            sa.printUsage(printStream);
        }
        finally {
            r.close();
        }
        Assert.assertEquals((Object)("Spring framework (overriding context)" + SystemUtils.LINE_SEPARATOR + " Set 'metc.amq.user' to username in properties file" + SystemUtils.LINE_SEPARATOR + " Set 'metc.amq.password' to password in properties file" + SystemUtils.LINE_SEPARATOR + SystemUtils.LINE_SEPARATOR + "Command-line options (overriding context)" + SystemUtils.LINE_SEPARATOR + " -u or -user followed by username" + SystemUtils.LINE_SEPARATOR + " -p or -password followed by password" + SystemUtils.LINE_SEPARATOR + SystemUtils.LINE_SEPARATOR + "Console terminal" + SystemUtils.LINE_SEPARATOR + " Type username when prompted" + SystemUtils.LINE_SEPARATOR + " Type password when prompted (password won't echo)" + SystemUtils.LINE_SEPARATOR + SystemUtils.LINE_SEPARATOR), (Object)new String(outputStream.toByteArray()));
    }

    public static void main(String[] args) {
        StandardAuthentication sa = new StandardAuthentication(TEST_ROOT + "auth_user.xml", args);
        System.err.println(sa.setValues());
        System.err.println(sa.getUser());
        System.err.println(sa.getPasswordAsString());
    }
}

