/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.CopyBytesUtils;
import org.marketcetera.util.file.CopyUtilsTestBase;
import org.marketcetera.util.file.Deleter;
import org.marketcetera.util.file.InputStreamWrapper;
import org.marketcetera.util.file.Messages;
import org.marketcetera.util.file.OutputStreamWrapper;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.test.UnicodeData;

public class CopyBytesUtilsTest
extends CopyUtilsTestBase {
    private static final byte[] VALUE = UnicodeData.HELLO_EN_NAT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyIStream(String out) throws Exception {
        CloseableRegistry r = new CloseableRegistry();
        try {
            InputStreamWrapper in = new InputStreamWrapper(TEST_INPUT_FILE);
            r.register((Closeable)in);
            Assert.assertEquals((long)VALUE.length, (long)CopyBytesUtils.copy((InputStream)in.getStream(), (boolean)true, (String)out));
        }
        finally {
            r.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyOStream(String in) throws Exception {
        CloseableRegistry r = new CloseableRegistry();
        try {
            OutputStreamWrapper out = new OutputStreamWrapper(TEST_OUTPUT_FILE);
            r.register((Closeable)out);
            Assert.assertEquals((long)VALUE.length, (long)CopyBytesUtils.copy((String)in, (OutputStream)out.getStream(), (boolean)true));
        }
        finally {
            r.close();
        }
    }

    @Before
    @After
    public void setupTearDownCopyBytesUtilsTest() throws Exception {
        Deleter.apply((String)TEST_INPUT_FILE);
        Deleter.apply((String)TEST_OUTPUT_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void copyStreams() throws Exception {
        CopyBytesUtils.copy((byte[])VALUE, (String)TEST_INPUT_FILE);
        CloseableRegistry r = new CloseableRegistry();
        try {
            InputStreamWrapper in = new InputStreamWrapper(TEST_INPUT_FILE);
            r.register((Closeable)in);
            OutputStreamWrapper out = new OutputStreamWrapper(TEST_OUTPUT_FILE);
            r.register((Closeable)out);
            Assert.assertEquals((long)VALUE.length, (long)CopyBytesUtils.copy((InputStream)in.getStream(), (boolean)true, (OutputStream)out.getStream(), (boolean)true));
        }
        finally {
            r.close();
        }
        Assert.assertArrayEquals((byte[])VALUE, (byte[])CopyBytesUtils.copy((String)TEST_OUTPUT_FILE));
    }

    @Test
    public void copyMemory() throws Exception {
        CopyBytesUtils.copy((byte[])VALUE, (String)TEST_INPUT_FILE);
        Assert.assertArrayEquals((byte[])VALUE, (byte[])CopyBytesUtils.copy((String)TEST_INPUT_FILE));
    }

    @Test
    public void copyInputStream() throws Exception {
        CopyBytesUtils.copy((byte[])VALUE, (String)TEST_INPUT_FILE);
        CopyBytesUtilsTest.copyIStream(TEST_OUTPUT_FILE);
        Assert.assertArrayEquals((byte[])VALUE, (byte[])CopyBytesUtils.copy((String)TEST_OUTPUT_FILE));
    }

    @Test
    public void copyOutputStream() throws Exception {
        CopyBytesUtils.copy((byte[])VALUE, (String)TEST_INPUT_FILE);
        CopyBytesUtilsTest.copyOStream(TEST_INPUT_FILE);
        Assert.assertArrayEquals((byte[])VALUE, (byte[])CopyBytesUtils.copy((String)TEST_OUTPUT_FILE));
    }

    @Test
    public void copyFiles() throws Exception {
        CopyBytesUtils.copy((byte[])VALUE, (String)TEST_INPUT_FILE);
        Assert.assertEquals((long)VALUE.length, (long)CopyBytesUtils.copy((String)TEST_INPUT_FILE, (String)TEST_OUTPUT_FILE));
        Assert.assertArrayEquals((byte[])VALUE, (byte[])CopyBytesUtils.copy((String)TEST_OUTPUT_FILE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failStreams() throws Exception {
        CopyBytesUtils.copy((byte[])VALUE, (String)TEST_INPUT_FILE);
        CloseableRegistry r = new CloseableRegistry();
        try {
            InputStreamWrapper in = new InputStreamWrapper(TEST_INPUT_FILE);
            r.register((Closeable)in);
            OutputStreamWrapper out = new OutputStreamWrapper(TEST_OUTPUT_FILE);
            r.register((Closeable)out);
            out.getStream().close();
            CopyBytesUtils.copy((InputStream)in.getStream(), (boolean)true, (OutputStream)out.getStream(), (boolean)true);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)Messages.CANNOT_COPY_STREAMS, (Object)ex.getI18NBoundMessage());
        }
        finally {
            r.close();
        }
    }

    @Test
    public void failFileInput() {
        try {
            CopyBytesUtils.copy((String)TEST_NONEXISTENT_FILE, (String)TEST_OUTPUT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage2P(Messages.CANNOT_COPY_FILES, (Serializable)((Object)TEST_NONEXISTENT_FILE), (Serializable)((Object)TEST_OUTPUT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failFileOutput() throws Exception {
        CopyBytesUtils.copy((byte[])VALUE, (String)TEST_INPUT_FILE);
        try {
            CopyBytesUtils.copy((String)TEST_INPUT_FILE, (String)TEST_NONEXISTENT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage2P(Messages.CANNOT_COPY_FILES, (Serializable)((Object)TEST_INPUT_FILE), (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failIStream() throws Exception {
        CopyBytesUtils.copy((byte[])VALUE, (String)TEST_INPUT_FILE);
        try {
            CopyBytesUtilsTest.copyIStream(TEST_NONEXISTENT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.CANNOT_COPY_ISTREAM, (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failOStream() throws Exception {
        try {
            CopyBytesUtilsTest.copyOStream(TEST_NONEXISTENT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.CANNOT_COPY_OSTREAM, (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failMemoryDst() {
        try {
            CopyBytesUtils.copy((String)TEST_NONEXISTENT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.CANNOT_COPY_MEMORY_DST, (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failMemorySrc() {
        try {
            CopyBytesUtils.copy((byte[])VALUE, (String)TEST_NONEXISTENT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.CANNOT_COPY_MEMORY_SRC, (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void closeCalled() throws Exception {
        CopyUtilsTestBase.CloseSetInputStream in = new CopyUtilsTestBase.CloseSetInputStream();
        CopyUtilsTestBase.CloseSetOutputStream out = new CopyUtilsTestBase.CloseSetOutputStream();
        CopyBytesUtils.copy((InputStream)in, (boolean)true, (OutputStream)out, (boolean)true);
        Assert.assertFalse((boolean)in.getClosed());
        Assert.assertFalse((boolean)out.getClosed());
        in = new CopyUtilsTestBase.CloseSetInputStream();
        out = new CopyUtilsTestBase.CloseSetOutputStream();
        CopyBytesUtils.copy((InputStream)in, (boolean)true, (OutputStream)out, (boolean)false);
        Assert.assertFalse((boolean)in.getClosed());
        Assert.assertTrue((boolean)out.getClosed());
        in = new CopyUtilsTestBase.CloseSetInputStream();
        out = new CopyUtilsTestBase.CloseSetOutputStream();
        CopyBytesUtils.copy((InputStream)in, (boolean)false, (OutputStream)out, (boolean)true);
        Assert.assertTrue((boolean)in.getClosed());
        Assert.assertFalse((boolean)out.getClosed());
        in = new CopyUtilsTestBase.CloseSetInputStream();
        out = new CopyUtilsTestBase.CloseSetOutputStream();
        CopyBytesUtils.copy((InputStream)in, (boolean)false, (OutputStream)out, (boolean)false);
        Assert.assertTrue((boolean)in.getClosed());
        Assert.assertTrue((boolean)out.getClosed());
        in = new CopyUtilsTestBase.CloseSetInputStream();
        CopyBytesUtils.copy((InputStream)in, (boolean)true, (String)TEST_INPUT_FILE);
        Assert.assertFalse((boolean)in.getClosed());
        in = new CopyUtilsTestBase.CloseSetInputStream();
        CopyBytesUtils.copy((InputStream)in, (boolean)false, (String)TEST_INPUT_FILE);
        Assert.assertTrue((boolean)in.getClosed());
        out = new CopyUtilsTestBase.CloseSetOutputStream();
        CopyBytesUtils.copy((String)TEST_INPUT_FILE, (OutputStream)out, (boolean)true);
        Assert.assertFalse((boolean)out.getClosed());
        out = new CopyUtilsTestBase.CloseSetOutputStream();
        CopyBytesUtils.copy((String)TEST_INPUT_FILE, (OutputStream)out, (boolean)false);
        Assert.assertTrue((boolean)out.getClosed());
    }
}

