/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.Closeable;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.CopyCharsUnicodeUtils;
import org.marketcetera.util.file.CopyUtilsTestBase;
import org.marketcetera.util.file.Deleter;
import org.marketcetera.util.file.Messages;
import org.marketcetera.util.file.ReaderWrapper;
import org.marketcetera.util.file.WriterWrapper;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.test.UnicodeData;
import org.marketcetera.util.unicode.DecodingStrategy;
import org.marketcetera.util.unicode.SignatureCharset;

public class CopyCharsUnicodeUtilsTest
extends CopyUtilsTestBase {
    private static final char[] VALUE = UnicodeData.COMBO_CHARS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyReader(String out) throws Exception {
        CloseableRegistry r = new CloseableRegistry();
        try {
            ReaderWrapper in = new ReaderWrapper(TEST_INPUT_FILE, DecodingStrategy.SIG_REQ);
            r.register((Closeable)in);
            Assert.assertEquals((long)VALUE.length, (long)CopyCharsUnicodeUtils.copy((Reader)in.getReader(), (boolean)true, (String)out));
        }
        finally {
            r.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyWriter(String in) throws Exception {
        CloseableRegistry r = new CloseableRegistry();
        try {
            WriterWrapper out = new WriterWrapper(TEST_OUTPUT_FILE, SignatureCharset.UTF8_UTF8);
            r.register((Closeable)out);
            Assert.assertEquals((long)VALUE.length, (long)CopyCharsUnicodeUtils.copy((String)in, (DecodingStrategy)DecodingStrategy.SIG_REQ, (Writer)out.getWriter(), (boolean)true));
        }
        finally {
            r.close();
        }
    }

    @Before
    @After
    public void setupTearDownCopyCharsUnicodeUtilsTest() throws Exception {
        Deleter.apply((String)TEST_INPUT_FILE);
        Deleter.apply((String)TEST_OUTPUT_FILE);
    }

    @Test
    public void copyMemory() throws Exception {
        CopyCharsUnicodeUtils.copy((char[])VALUE, (String)TEST_INPUT_FILE, (SignatureCharset)SignatureCharset.UTF8_UTF8);
        Assert.assertArrayEquals((char[])VALUE, (char[])CopyCharsUnicodeUtils.copy((String)TEST_INPUT_FILE, (DecodingStrategy)DecodingStrategy.SIG_REQ));
    }

    @Test
    public void copyReader() throws Exception {
        CopyCharsUnicodeUtils.copy((char[])VALUE, (String)TEST_INPUT_FILE, (SignatureCharset)SignatureCharset.UTF8_UTF8);
        CopyCharsUnicodeUtilsTest.copyReader(TEST_OUTPUT_FILE);
        Assert.assertArrayEquals((char[])VALUE, (char[])CopyCharsUnicodeUtils.copy((String)TEST_OUTPUT_FILE, (DecodingStrategy)DecodingStrategy.SIG_REQ));
    }

    @Test
    public void copyWriter() throws Exception {
        CopyCharsUnicodeUtils.copy((char[])VALUE, (String)TEST_INPUT_FILE, (SignatureCharset)SignatureCharset.UTF8_UTF8);
        CopyCharsUnicodeUtilsTest.copyWriter(TEST_INPUT_FILE);
        Assert.assertArrayEquals((char[])VALUE, (char[])CopyCharsUnicodeUtils.copy((String)TEST_OUTPUT_FILE, (DecodingStrategy)DecodingStrategy.SIG_REQ));
    }

    @Test
    public void copyFiles() throws Exception {
        CopyCharsUnicodeUtils.copy((char[])VALUE, (String)TEST_INPUT_FILE, (SignatureCharset)SignatureCharset.UTF8_UTF8);
        Assert.assertEquals((long)VALUE.length, (long)CopyCharsUnicodeUtils.copy((String)TEST_INPUT_FILE, (DecodingStrategy)DecodingStrategy.SIG_REQ, (String)TEST_OUTPUT_FILE));
        Assert.assertArrayEquals((char[])VALUE, (char[])CopyCharsUnicodeUtils.copy((String)TEST_OUTPUT_FILE, (DecodingStrategy)DecodingStrategy.SIG_REQ));
    }

    @Test
    public void failFileInput() {
        try {
            CopyCharsUnicodeUtils.copy((String)TEST_NONEXISTENT_FILE, (DecodingStrategy)DecodingStrategy.SIG_REQ, (String)TEST_OUTPUT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage2P(Messages.CANNOT_COPY_FILES, (Serializable)((Object)TEST_NONEXISTENT_FILE), (Serializable)((Object)TEST_OUTPUT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failFileOutput() throws Exception {
        CopyCharsUnicodeUtils.copy((char[])VALUE, (String)TEST_INPUT_FILE, (SignatureCharset)SignatureCharset.UTF8_UTF8);
        try {
            CopyCharsUnicodeUtils.copy((String)TEST_INPUT_FILE, (DecodingStrategy)DecodingStrategy.SIG_REQ, (String)TEST_NONEXISTENT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage2P(Messages.CANNOT_COPY_FILES, (Serializable)((Object)TEST_INPUT_FILE), (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failReader() throws Exception {
        CopyCharsUnicodeUtils.copy((char[])VALUE, (String)TEST_INPUT_FILE, (SignatureCharset)SignatureCharset.UTF8_UTF8);
        try {
            CopyCharsUnicodeUtilsTest.copyReader(TEST_NONEXISTENT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.CANNOT_COPY_READER, (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failWriter() throws Exception {
        try {
            CopyCharsUnicodeUtilsTest.copyWriter(TEST_NONEXISTENT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.CANNOT_COPY_WRITER, (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failMemoryDst() {
        try {
            CopyCharsUnicodeUtils.copy((String)TEST_NONEXISTENT_FILE, (DecodingStrategy)DecodingStrategy.SIG_REQ);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.CANNOT_COPY_MEMORY_DST, (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failMemorySrc() {
        try {
            CopyCharsUnicodeUtils.copy((char[])VALUE, (String)TEST_NONEXISTENT_FILE, (SignatureCharset)SignatureCharset.UTF8_UTF8);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.CANNOT_COPY_MEMORY_SRC, (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void closeCalled() throws Exception {
        CopyUtilsTestBase.CloseSetReader in = new CopyUtilsTestBase.CloseSetReader();
        CopyCharsUnicodeUtils.copy((Reader)in, (boolean)true, (String)TEST_INPUT_FILE);
        Assert.assertFalse((boolean)in.getClosed());
        in = new CopyUtilsTestBase.CloseSetReader();
        CopyCharsUnicodeUtils.copy((Reader)in, (boolean)false, (String)TEST_INPUT_FILE);
        Assert.assertTrue((boolean)in.getClosed());
        CopyUtilsTestBase.CloseSetWriter out = new CopyUtilsTestBase.CloseSetWriter();
        CopyCharsUnicodeUtils.copy((String)TEST_INPUT_FILE, (DecodingStrategy)DecodingStrategy.SIG_REQ, (Writer)out, (boolean)true);
        Assert.assertFalse((boolean)out.getClosed());
        out = new CopyUtilsTestBase.CloseSetWriter();
        CopyCharsUnicodeUtils.copy((String)TEST_INPUT_FILE, (DecodingStrategy)DecodingStrategy.SIG_REQ, (Writer)out, (boolean)false);
        Assert.assertTrue((boolean)out.getClosed());
    }
}

