/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.Closeable;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.CopyCharsUtils;
import org.marketcetera.util.file.CopyUtilsTestBase;
import org.marketcetera.util.file.Deleter;
import org.marketcetera.util.file.Messages;
import org.marketcetera.util.file.ReaderWrapper;
import org.marketcetera.util.file.WriterWrapper;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.test.UnicodeData;

public class CopyCharsUtilsTest
extends CopyUtilsTestBase {
    private static final char[] VALUE = UnicodeData.HELLO_EN_CHARS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyReader(String out) throws Exception {
        CloseableRegistry r = new CloseableRegistry();
        try {
            ReaderWrapper in = new ReaderWrapper(TEST_INPUT_FILE);
            r.register((Closeable)in);
            Assert.assertEquals((long)VALUE.length, (long)CopyCharsUtils.copy((Reader)in.getReader(), (boolean)true, (String)out));
        }
        finally {
            r.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyWriter(String in) throws Exception {
        CloseableRegistry r = new CloseableRegistry();
        try {
            WriterWrapper out = new WriterWrapper(TEST_OUTPUT_FILE);
            r.register((Closeable)out);
            Assert.assertEquals((long)VALUE.length, (long)CopyCharsUtils.copy((String)in, (Writer)out.getWriter(), (boolean)true));
        }
        finally {
            r.close();
        }
    }

    @Before
    @After
    public void setupTearDownCopyCharsUtilsTest() throws Exception {
        Deleter.apply((String)TEST_INPUT_FILE);
        Deleter.apply((String)TEST_OUTPUT_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void copyReaderWriter() throws Exception {
        CopyCharsUtils.copy((char[])VALUE, (String)TEST_INPUT_FILE);
        CloseableRegistry r = new CloseableRegistry();
        try {
            ReaderWrapper in = new ReaderWrapper(TEST_INPUT_FILE);
            r.register((Closeable)in);
            WriterWrapper out = new WriterWrapper(TEST_OUTPUT_FILE);
            r.register((Closeable)out);
            Assert.assertEquals((long)VALUE.length, (long)CopyCharsUtils.copy((Reader)in.getReader(), (boolean)true, (Writer)out.getWriter(), (boolean)true));
        }
        finally {
            r.close();
        }
        Assert.assertArrayEquals((char[])VALUE, (char[])CopyCharsUtils.copy((String)TEST_OUTPUT_FILE));
    }

    @Test
    public void copyMemory() throws Exception {
        CopyCharsUtils.copy((char[])VALUE, (String)TEST_INPUT_FILE);
        Assert.assertArrayEquals((char[])VALUE, (char[])CopyCharsUtils.copy((String)TEST_INPUT_FILE));
    }

    @Test
    public void copyReader() throws Exception {
        CopyCharsUtils.copy((char[])VALUE, (String)TEST_INPUT_FILE);
        CopyCharsUtilsTest.copyReader(TEST_OUTPUT_FILE);
        Assert.assertArrayEquals((char[])VALUE, (char[])CopyCharsUtils.copy((String)TEST_OUTPUT_FILE));
    }

    @Test
    public void copyWriter() throws Exception {
        CopyCharsUtils.copy((char[])VALUE, (String)TEST_INPUT_FILE);
        CopyCharsUtilsTest.copyWriter(TEST_INPUT_FILE);
        Assert.assertArrayEquals((char[])VALUE, (char[])CopyCharsUtils.copy((String)TEST_OUTPUT_FILE));
    }

    @Test
    public void copyFiles() throws Exception {
        CopyCharsUtils.copy((char[])VALUE, (String)TEST_INPUT_FILE);
        Assert.assertEquals((long)VALUE.length, (long)CopyCharsUtils.copy((String)TEST_INPUT_FILE, (String)TEST_OUTPUT_FILE));
        Assert.assertArrayEquals((char[])VALUE, (char[])CopyCharsUtils.copy((String)TEST_OUTPUT_FILE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failReaderWriter() throws Exception {
        CopyCharsUtils.copy((char[])VALUE, (String)TEST_INPUT_FILE);
        CloseableRegistry r = new CloseableRegistry();
        try {
            ReaderWrapper in = new ReaderWrapper(TEST_INPUT_FILE);
            r.register((Closeable)in);
            WriterWrapper out = new WriterWrapper(TEST_OUTPUT_FILE);
            r.register((Closeable)out);
            out.getWriter().close();
            CopyCharsUtils.copy((Reader)in.getReader(), (boolean)true, (Writer)out.getWriter(), (boolean)true);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)Messages.CANNOT_COPY_CSTREAMS, (Object)ex.getI18NBoundMessage());
        }
        finally {
            r.close();
        }
    }

    @Test
    public void failFileInput() {
        try {
            CopyCharsUtils.copy((String)TEST_NONEXISTENT_FILE, (String)TEST_OUTPUT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage2P(Messages.CANNOT_COPY_FILES, (Serializable)((Object)TEST_NONEXISTENT_FILE), (Serializable)((Object)TEST_OUTPUT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failFileOutput() throws Exception {
        CopyCharsUtils.copy((char[])VALUE, (String)TEST_INPUT_FILE);
        try {
            CopyCharsUtils.copy((String)TEST_INPUT_FILE, (String)TEST_NONEXISTENT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage2P(Messages.CANNOT_COPY_FILES, (Serializable)((Object)TEST_INPUT_FILE), (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failReader() throws Exception {
        CopyCharsUtils.copy((char[])VALUE, (String)TEST_INPUT_FILE);
        try {
            CopyCharsUtilsTest.copyReader(TEST_NONEXISTENT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.CANNOT_COPY_READER, (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failWriter() throws Exception {
        try {
            CopyCharsUtilsTest.copyWriter(TEST_NONEXISTENT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.CANNOT_COPY_WRITER, (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failMemoryDst() {
        try {
            CopyCharsUtils.copy((String)TEST_NONEXISTENT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.CANNOT_COPY_MEMORY_DST, (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void failMemorySrc() {
        try {
            CopyCharsUtils.copy((char[])VALUE, (String)TEST_NONEXISTENT_FILE);
            Assert.fail();
        }
        catch (I18NException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)new I18NBoundMessage1P(Messages.CANNOT_COPY_MEMORY_SRC, (Serializable)((Object)TEST_NONEXISTENT_FILE)), (Object)ex.getI18NBoundMessage());
        }
    }

    @Test
    public void closeCalled() throws Exception {
        CopyUtilsTestBase.CloseSetReader in = new CopyUtilsTestBase.CloseSetReader();
        CopyUtilsTestBase.CloseSetWriter out = new CopyUtilsTestBase.CloseSetWriter();
        CopyCharsUtils.copy((Reader)in, (boolean)true, (Writer)out, (boolean)true);
        Assert.assertFalse((boolean)in.getClosed());
        Assert.assertFalse((boolean)out.getClosed());
        in = new CopyUtilsTestBase.CloseSetReader();
        out = new CopyUtilsTestBase.CloseSetWriter();
        CopyCharsUtils.copy((Reader)in, (boolean)true, (Writer)out, (boolean)false);
        Assert.assertFalse((boolean)in.getClosed());
        Assert.assertTrue((boolean)out.getClosed());
        in = new CopyUtilsTestBase.CloseSetReader();
        out = new CopyUtilsTestBase.CloseSetWriter();
        CopyCharsUtils.copy((Reader)in, (boolean)false, (Writer)out, (boolean)true);
        Assert.assertTrue((boolean)in.getClosed());
        Assert.assertFalse((boolean)out.getClosed());
        in = new CopyUtilsTestBase.CloseSetReader();
        out = new CopyUtilsTestBase.CloseSetWriter();
        CopyCharsUtils.copy((Reader)in, (boolean)false, (Writer)out, (boolean)false);
        Assert.assertTrue((boolean)in.getClosed());
        Assert.assertTrue((boolean)out.getClosed());
        in = new CopyUtilsTestBase.CloseSetReader();
        CopyCharsUtils.copy((Reader)in, (boolean)true, (String)TEST_INPUT_FILE);
        Assert.assertFalse((boolean)in.getClosed());
        in = new CopyUtilsTestBase.CloseSetReader();
        CopyCharsUtils.copy((Reader)in, (boolean)false, (String)TEST_INPUT_FILE);
        Assert.assertTrue((boolean)in.getClosed());
        out = new CopyUtilsTestBase.CloseSetWriter();
        CopyCharsUtils.copy((String)TEST_INPUT_FILE, (Writer)out, (boolean)true);
        Assert.assertFalse((boolean)out.getClosed());
        out = new CopyUtilsTestBase.CloseSetWriter();
        CopyCharsUtils.copy((String)TEST_INPUT_FILE, (Writer)out, (boolean)false);
        Assert.assertTrue((boolean)out.getClosed());
    }
}

